/* board.h        drawing, board setup */

/*
 * xcheckers:     a point and click checkerboard
 * (C):           1999, 2000 Peter Chiocchetti <girbal@tacheles.de>
 */


#define NORTH 0
#define SOUTH 1

#define INTERNL 20
#define ENGLISH 21
#define ITALIAN 22
#define RUSSIAN 25
#define MAFIERZ 32

#define MAXCELLS 10		/* Maximum number of nodes in the square. */


typedef enum {
  o, n, b, w, B, W
} node;

typedef struct {
  node            colour;
  int             number;
} square;

square          board[MAXCELLS][MAXCELLS];
square          saved[MAXCELLS][MAXCELLS];

int             direction;	/* Black plays North, white plays South */
Pixmap          fpix;		/* full board copy                      */


void            drawCell(int x, int y);
void            repaint(void);
void            paint(XExposeEvent * e);
void            saveBoard(void);
void            initBoard(int gametype);
void            freshenBoard(void);
void            swapBoard(int orientation);
void            changeBoard(int gametype);
void            drawNumbers(void);
void            drawHelp(void);
