/* events.c       buttons, event loop */

/*
 * xcheckers:     a point and click checkerboard
 * (C):           1999, 2000 Peter Chiocchetti <girbal@tacheles.de>
 */


#include <string.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include "xcheckers.h"
#include "board.h"
#include "sprite.h"
#include "help.h"
#include "status.h"


static int      lockdrag;
static int      start;

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                             Process Keytaps
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */


/* process keys typed into the window */
static int
lookupKey(XKeyEvent * e, char *move)
{
  static char     kbuf[80];
  KeySym          keysym;
  int             moved = 0;
  int             ctrl;

  ctrl = (e->state & ControlMask);
  if (XLookupString(e, &kbuf[0], sizeof(&kbuf[0]), &keysym, NULL)) {
    if (ctrl) {
      switch (keysym) {
      case XK_q:
	sprintf(move, "quit\n");
	moved = 1;
	break;
      case XK_n:
	drawNumbers();
	break;
      case XK_h:
	showHelp();
	break;
      case XK_c:
	sprintf(move, "exit");
	moved = 1;
	break;
      default:
	break;
      }
    } else {
      if (strcmp(kbuf, "\r") == 0)
	sprintf(move, "\n");
      /* else if (strcmp (kbuf, "\b") == 0) */
      /* sprintf (move, "\177"); */
      else
	sprintf(move, "%s", kbuf);
      moved = 1;
    }
  } else {
    switch (keysym) {
    case XK_Help:
      showHelp();
    default:
      break;
    }
  }
  return (moved);
}


/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                    a Horror
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */


/* lock the board, while reading in a new state */
void
draglock(int lock)
{
  lockdrag = lock;
  if (lock)
    cancelSprite();
  else
    start = 0;
}


/* process X Server Events */
int
events(char *move)
{
  int             x, y;
  int             moved = 0;
  int             end;
  static int      first;

  while (XPending(dpy)) {
    XEvent          event;
    XClientMessageEvent *cmsg;

    XNextEvent(dpy, &event);
    switch (event.type) {
    case MappingNotify:
      XRefreshKeyboardMapping((XMappingEvent *) & event);
      break;
    case Expose:
      if (event.xexpose.window == win)
	paint((XExposeEvent *) & event);
      else if (event.xexpose.window == swin)
	paintStatus((XExposeEvent *) & event);
      else if (event.xexpose.window == hwin
	       && event.xexpose.count == 0)
	drawHelp();
      break;
    case ClientMessage:
      cmsg = &event.xclient;
      if (cmsg->message_type == wm_protocols
	  && cmsg->data.l[0] == wm_delete_window) {
	sprintf(move, "exit");
	moved = 1;
      }
      break;
    case KeyPress:
      moved = lookupKey((XKeyEvent *) & event, move);
      break;
    case EnterNotify:
      if (event.xcrossing.window == hwin)
	helpSel(event.xcrossing.x, event.xcrossing.y);
      break;
    case LeaveNotify:
      if (event.xcrossing.window == win) {
	cancelSprite();
	start = 0;
      } else if (event.xcrossing.window == hwin)
	helpSel(0, 0);
      break;
    case MotionNotify:
      if (event.xmotion.window == win)
	drawSprite((XMotionEvent *) & event);
      else if (event.xmotion.window == hwin)
	helpSel(event.xmotion.x, event.xmotion.y);
      break;
    case ButtonPress:
      if (event.xbutton.button == 1) {
	if (event.xbutton.window == win)
	  first = 1;
	else
	  break;
      } else if (event.xbutton.button > 1) {
	showHelp();
	break;
      }
    case ButtonRelease:
      if (event.xbutton.button == 1) {
	if (event.xbutton.window == win) {
	  x = event.xbutton.x;
	  y = event.xbutton.y;
	  if (x <= width * cells && x >= 0
	      && y <= height * cells && y >= 0) {
	    x = x / width;
	    y = y / height;
	    end = board[x][y].number;
	    if (first) {
	      if (board[x][y].colour > n && !lockdrag) {
		start = end;
		pickSprite((XButtonEvent *) & event);
	      }
	      first = 0;
	    } else {
	      if (start && end && start != end
		  && board[x][y].colour == n) {
		sprintf(move, "%d-%d\n", start, end);
		moved = 1;
		dropSprite((XButtonEvent *) & event);
	      } else
		cancelSprite();
	      start = 0;
	    }
	  } else {
	    first = 0;
	    cancelSprite();
	    start = 0;
	  }
	}
	if (event.xbutton.window == hwin)
	  if (event.xbutton.button == 1)
	    helpBut(event.xbutton.x, event.xbutton.y);
      }
    default:
      break;
    }
  }

  return (moved);
}
