/* resource.c     resources, command line */

/*
 * xcheckers:     a point and click checkerboard
 * (C):           1999, 2000 Peter Chiocchetti <girbal@tacheles.de>
 */


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include "xcheckers.h"
#include "resource.h"
#include "board.h"


#define numOptions (sizeof options / sizeof (XrmOptionDescRec))


XrmDatabase     resources = NULL;

static char     Banner[] =
"\nxcheckers version " VERSION
"\nCopyright (C) 1999, 2000 Peter Chiocchetti."
"\nxcheckers comes with ABSOLUTELY NO WARRANTY; for details"
"\nsee the file \"COPYING\" in the distribution directory.\n";


static XrmOptionDescRec options[] = {
  {"-icds", ".icds", XrmoptionNoArg, (XPointer) "true"},
  {"-host", ".host", XrmoptionSepArg, (XPointer) NULL},
  {"-port", ".port", XrmoptionSepArg, (XPointer) NULL},
  {"-local", ".icds", XrmoptionNoArg, (XPointer) "false"},
  {"-engine", ".engine", XrmoptionSepArg, (XPointer) NULL},
  {"-scene", ".scene", XrmoptionSepArg, (XPointer) NULL},
  {"-font", ".font", XrmoptionSepArg, (XPointer) NULL},
  {"-geometry", ".geometry", XrmoptionSepArg, (XPointer) NULL},
  {"-display", ".display", XrmoptionSepArg, (XPointer) NULL},
};


/* write command line switches summary to stdout */
static void
usage(void)
{
  static char     Usage[] =
  "\nusage: %s <options>\n"
  "\t-icds\t\t\t\tconnect to an icds\n"
  "\t-host\t\thostname\taddress named host\n"
  "\t-port\t\tportnum\t\tat specified port\n"
  "\n"
  "\t-local\t\t\t\tconnect locally\n"
  "\t-engine\t\tprogram\t\tstart named engine\n"
  "\n"
  "\t-scene\t\tpixmap\t\tpath to an appropriate pixmap\n"
  "\t-font\t\tfont\t\tused in status line\n"
  "\n"
  "\t-geometry\tgeometry\twindow geometry\n"
  "\t-display\tstring\t\tX server to connect\n"
  "\n"
  "all of these options default to resources set e.g. in your ~/.Xdefaults\n"
  "\n";

  fprintf(stdout, Usage, progname);
  exit(1);
}


/* get a resource from the database */
char           *
resGet(const char *id)
{
  char           *type;
  XrmValue        value;
  char            name[128], class[128];

  snprintf(name, 128, "%s.%s", progname, id);
  snprintf(class, 128, "XCheckers.%s", id);

  XrmGetResource(resources, name, class, &type, &value);
  return (value.addr);
}


/* fill resource database, get player name and programm name */
int
resInit(int *argc, char **argv, char **hostname, char **portnum)
{
  int             icds = 0;
  char           *tmp;
  char            defaults[100];

  fprintf(stdout, Banner);

  /* set some globals */
  if ((myname = getenv("LOGNAME")) == NULL)
    myname = strdup("it's me");
  else if (strlen(myname) > 20)
    myname[20] = '\0';
  direction = NORTH;
  cells = 8;

  /* set default program name for diagnostics */
  if ((progname = strrchr(argv[0], '/')) == NULL)
    progname = argv[0];
  else
    progname++;

  /* make up the resources database: sequence matters */
  XrmInitialize();
  resources = XrmGetFileDatabase(APPDEFS);
  XrmCombineFileDatabase("xcheckersrc", &resources, True);
  strcpy(defaults, getenv("HOME"));
  strcat(defaults, "/.xcheckersrc");
  XrmCombineFileDatabase(defaults, &resources, True);
  strcpy(defaults, getenv("HOME"));
  strcat(defaults, "/.Xdefaults");
  XrmCombineFileDatabase(defaults, &resources, True);
  XrmParseCommand(&resources, options, numOptions, progname, argc, argv);

  if (*argc != 1)
    usage();

  if ((tmp = resGet("icds")) != NULL && (!strcmp(tmp, "true"))) {
    if ((*hostname = resGet("host")) == NULL) {
      fprintf(stderr, "%s: Error, no hostname specified\n", progname);
      exit(1);
    }
    if ((*portnum = resGet("port")) == NULL) {
      fprintf(stderr, "%s: Error, no portnumber specified\n", progname);
      exit(1);
    }
    icds = 1;
  } else {
    if ((*hostname = resGet("engine")) == NULL) {
      fprintf(stderr, "%s: Error, no engine specified\n", progname);
      exit(1);
    }
    *portnum = NULL;
  }
  return (icds);
}
