/* read_5.c       read board from icds style 5 */

/*
 * xcheckers:     a point and click checkerboard
 * (C):           1999, 2000, 2003 Peter Chiocchetti <girbal@tacheles.de>
 */


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <X11/Xlib.h>
#include "xcheckers.h"
#include "read.h"
#include "board.h"
#include "child.h"
#include "status.h"
#include "events.h"

#define TOP 0
#define BOT 1

int             currPlayer;


/* read in a board state from ICDS */
void
readPos5(char *line)
{
  /* parses argument looking for a board (style 5) */

  int             x, y, k;
  int             iclock;
  char            templine[32];
  char            tempname[32];

  /*
   * ICDS board style 5 description:
   *
   * offset     string   no
   *      0     <5>       3    Style Info
   *      3     001       3    Game Number
   *      6     p         1    Match style (p = polish 10x10)
   *      7     B         1    Point of view (B = black, W = white)
   *      8     B         1    Player to move (B = black, W = white)
   *      9     ...      17    Black Player Name
   *     26     ...      17    White Player Name
   *     43     ...      ..    Board itself
   */

  if (strneq(line, "Game", 4)) {
    /*
     * this is a board style 1, change to style 5 better check
     * for something not an english word ? e.g. "          a   b
     * c   d   e   f   g   h"
     */
    message(strdup("set style 5\n"));
    message(strdup("refresh\n"));
    return;
  }
  if ((strneq(line, "icds% It is not your move.", 26))
      || (strneq(line, "icds% Game clock is paused,", 27))
      || (strneq(line, "icds% Illegal move.", 19))
      || (strneq(line, "icds% Ambigous move.", 20))
      || (strneq(line, "icds% It isn't your turn,", 25))) {
    /* we made an illegal move and messed up the board */
    message(strdup("refresh\n"));
    return;
  }
  if (strneq(line, "<5>", 3)) {
    draglock(1);

    /* Board Size, Rotation */
    /* Board Direction */
    /* Player to move */
    switch (line[6]) {
      case 'p':  //polish, international
	changeBoard(INTERNL);
        swapBoard(line[7] == 'B' ? NORTH : SOUTH);
        currPlayer = (line[8] == 'B'
		  ? (direction == NORTH ? BOT : TOP)
		  : (direction == NORTH ? TOP : BOT));
	break;
      case 'i':
	changeBoard(ITALIAN);
        swapBoard(line[7] == 'B' ? NORTH : SOUTH);
        currPlayer = (line[8] == 'W'
		  ? (direction == NORTH ? BOT : TOP)
		  : (direction == NORTH ? TOP : BOT));
	break;
       case 'm':
	changeBoard(MAFIERZ);
        swapBoard(line[7] == 'B' ? NORTH : SOUTH);
        currPlayer = (line[8] == 'B'
		  ? (direction == NORTH ? BOT : TOP)
		  : (direction == NORTH ? TOP : BOT));
	break;
      case 'r':
	changeBoard(RUSSIAN);
        swapBoard(line[7] == 'B' ? NORTH : SOUTH);
        currPlayer = (line[8] == 'W'
		  ? (direction == NORTH ? BOT : TOP)
		  : (direction == NORTH ? TOP : BOT));
	break;
     default:
	changeBoard(ENGLISH);
        swapBoard(line[7] == 'B' ? NORTH : SOUTH);
        currPlayer = (line[8] == 'B'
		  ? (direction == NORTH ? BOT : TOP)
		  : (direction == NORTH ? TOP : BOT));
    }

    /* Status Line */
    /* Black Player Name */
    strncpy(templine, &line[9], 17);
    templine[17] = '\0';
    sscanf(templine, "%s", tempname);
    strcpy(&statusline[direction == NORTH ? 1 : 0][0], tempname);
    strcat(&statusline[direction == NORTH ? 1 : 0][0],
	   line[8] == 'B' ? "*" : "");

    /* White Player Name */
    strncpy(templine, &line[26], 17);
    templine[17] = '\0';
    sscanf(templine, "%s", tempname);
    strcpy(&statusline[direction == SOUTH ? 1 : 0][0], tempname);
    strcat(&statusline[direction == SOUTH ? 1 : 0][0],
	   line[8] == 'W' ? "*" : "");

    k = 43;
    // xcheckers grid has the origin top left
    if (direction == NORTH) {
      for (y = cells - 1; y >= 0; y--) {
	for (x = 0; x < cells; x++) {
	  switch (line[k]) {
	  case ' ':
	    board[x][y].colour = o;
	    break;
	  case '-':
	    board[x][y].colour = n;
	    break;
	  case 'b':
	    board[x][y].colour = b;
	    break;
	  case 'w':
	    board[x][y].colour = w;
	    break;
	  case 'B':
	    board[x][y].colour = B;
	    break;
	  case 'W':
	    board[x][y].colour = W;
	    break;
	  default:
	    break;
	  }
	  k++;
	}
      }
    } else
      /* direction == SOUTH */
      /* flip the board */
    {
      for (y = 0; y < cells; y++) {
	for (x = cells - 1; x >= 0; x--) {
	  switch (line[k]) {
	  case ' ':
	    board[x][y].colour = o;
	    break;
	  case '-':
	    board[x][y].colour = n;
	    break;
	  case 'b':
	    board[x][y].colour = b;
	    break;
	  case 'w':
	    board[x][y].colour = w;
	    break;
	  case 'B':
	    board[x][y].colour = B;
	    break;
	  case 'W':
	    board[x][y].colour = W;
	    break;
	  default:
	    break;
	  }
	  k++;
	}
     }
    }
    /* Clock Line */
    /* Black Clock */
    strncpy(templine, &line[cells == 8 ? 107 : 143], 3);
    templine[3] = '\0';
    sscanf(templine, "%d", &iclock);
    if (iclock < 0)
      sprintf(&clockline[direction == NORTH ? 1 : 0][0], "-%d : %02d",
	      abs((int) (iclock / 60)), abs((int) (iclock % 60)));
    else
      sprintf(&clockline[direction == NORTH ? 1 : 0][0], " %d : %02d",
	      abs((int) (iclock / 60)), abs((int) (iclock % 60)));
    if (line[8] == 'B') {
      currTime = time(NULL);
      currClock = iclock;
    }
    /* White Clock */
    strncpy(templine, &line[cells == 8 ? 111 : 147], 3);
    templine[3] = '\0';
    sscanf(templine, "%d", &iclock);
    if (iclock < 0)
      sprintf(&clockline[direction == SOUTH ? 1 : 0][0], "-%d : %02d",
	      abs((int) (iclock / 60)), abs((int) (iclock % 60)));
    else
      sprintf(&clockline[direction == SOUTH ? 1 : 0][0], " %d : %02d",
	      abs((int) (iclock / 60)), abs((int) (iclock % 60)));
    if (line[8] == 'W') {
      currTime = time(NULL);
      currClock = iclock;
    }
    draglock(0);
    freshenBoard();
    showStatus();
  }
}
