/* read_s.c        read board from simplech and cake */

/*
 * xcheckers:     a point and click checkerboard
 * (C):           1999, 2000 Peter Chiocchetti <girbal@tacheles.de>
 */


#include <string.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include "xcheckers.h"
#include "read.h"
#include "board.h"
#include "resource.h"
#include "events.h"
#include "status.h"


/* parses argument looking for a board (simplech/cake) */
void
readPosS(char *line)
{
  int             x;
  static int      y = 0;
  static int      got_board = 0;

  if (!got_board) {
    if (strneq(&line[0], "   --------------- ", 19)) {
      /* now got a board */
      got_board = 1;
      sprintf(&statusline[0][0], "simplech");
      sprintf(&statusline[1][0], "%s*", myname);
      swapBoard(NORTH);
      draglock(1);
      return;
    } else if (strneq(&line[0], "   ~~~~~~~~~~~~~~~ ", 19)) {
      /* now got a board */
      got_board = 1;
      sprintf(&statusline[0][0], "cake");
      sprintf(&statusline[1][0], "%s*", myname);
      swapBoard(NORTH);
      draglock(1);
      return;
    } else if (strneq(&line[0], ".  --------------- ", 19)) {
      /* now got a board */
      got_board = 1;
      sprintf(&statusline[0][0], "simplech*");
      sprintf(&statusline[1][0], "%s", myname);
      swapBoard(NORTH);
      draglock(1);
      return;
    } else if (strneq(&line[0], ".  ~~~~~~~~~~~~~~~ ", 19)) {
      /* now got a board */
      got_board = 1;
      sprintf(&statusline[0][0], "cake*");
      sprintf(&statusline[1][0], "%s", myname);
      swapBoard(NORTH);
      draglock(1);
      return;
    } else if (strneq(&line[0], "*  --------------- ", 19)) {
      /* now got a board */
      got_board = 1;
      sprintf(&statusline[0][0], "simplech");
      sprintf(&statusline[1][0], "%s*", myname);
      swapBoard(SOUTH);
      draglock(1);
      return;
    } else if (strneq(&line[0], "*  ~~~~~~~~~~~~~~~ ", 19)) {
      /* now got a board */
      got_board = 1;
      sprintf(&statusline[0][0], "cake");
      sprintf(&statusline[1][0], "%s*", myname);
      swapBoard(SOUTH);
      draglock(1);
      return;
    } else if (strneq(&line[0], "-  --------------- ", 19)) {
      /* now got a board */
      got_board = 1;
      sprintf(&statusline[0][0], "simplech*");
      sprintf(&statusline[1][0], "%s", myname);
      swapBoard(SOUTH);
      draglock(1);
      return;
    } else if (strneq(&line[0], "-  ~~~~~~~~~~~~~~~ ", 19)) {
      /* now got a board */
      got_board = 1;
      sprintf(&statusline[0][0], "cake*");
      sprintf(&statusline[1][0], "%s", myname);
      swapBoard(SOUTH);
      draglock(1);
      return;
    }
  } else {
    if (y == 8) {
      /* show the position */
      freshenBoard();
      showStatus();
      got_board = 0;
      y = 0;
      draglock(0);
      return;
    }
    for (x = 3; x < 18; x += 2) {
      if (strneq(&line[x], "  ", 2))
	board[(x - 3) / 2][y].colour = o;
      if (strneq(&line[x], "- ", 2))
	board[(x - 3) / 2][y].colour = n;
      if (strneq(&line[x], "b ", 2))
	board[(x - 3) / 2][y].colour = b;
      if (strneq(&line[x], "w ", 2))
	board[(x - 3) / 2][y].colour = w;
      if (strneq(&line[x], "B ", 2))
	board[(x - 3) / 2][y].colour = B;
      if (strneq(&line[x], "W ", 2))
	board[(x - 3) / 2][y].colour = W;
    }
    y++;
  }
}
