/*
 * $Id: xcmd.h,v 1.4 1997/08/11 05:19:33 jmknoble Exp $
 * 
 * xcmd.h
 * by Jim Knoble <jmknoble@pobox.com>
 * Copyright  1997 Jim Knoble
 * 
 * Disclaimer:
 * 
 * The software is provided "as is", without warranty of any kind,
 * express or implied, including but not limited to the warranties of
 * merchantability, fitness for a particular purpose and
 * noninfringement. In no event shall the author(s) be liable for any
 * claim, damages or other liability, whether in an action of
 * contract, tort or otherwise, arising from, out of or in connection
 * with the software or the use or other dealings in the software.
 */
/**********************************************************************/
/*
 * $Log: xcmd.h,v $
 * Revision 1.4  1997/08/11 05:19:33  jmknoble
 * added environment variable for choosing whether to iconify-and-raise
 * or raise-only at runtime; added possible values for environment variable.
 *
 * Revision 1.3  1997/05/30 04:27:44  jmknoble
 * added geometry option to terminal window info;
 * changed environment variable to use all upper case.
 *
 * Revision 1.1  1997/05/30 04:19:43  jmknoble
 * Initial revision
 *
 */
/**********************************************************************/

#ifndef _XCMD_H
#define _XCMD_H

/* unset value for any flag */
#define FLG_NONSET -1

/* file handle to use for help and error messages */
#define HLPMSGFILHND stdout
#define ERRMSGFILHND stderr

/* exit code to return for help message */
#define HLPRTNCOD 2

/* interval to wait for X events to finish */
#define WATIVL 10000L

/* shell command used to exec */
#define SHL_NAM    "/bin/sh"    /* name of shell to exec */
#define SHL_CMDOPT "-c"         /* option to read command from cmdline */
#define SHL_EXECMD "exec "      /* command to replace shell with program */

/* The kind of function used to manipulate a window */
typedef void WDWFNC_RTN_TYP;
typedef WDWFNC_RTN_TYP WDWFNC_TYP(Window);

/* The various kinds of property to use to find a window */
typedef enum
{
   WDWPPY_NON,      /* none */
   WDWPPY_CLS,      /* class */
   WDWPPY_RSC,      /* resource */
   WDWPPY_TTL,      /* title */
   WDWPPY_SUBSTR    /* substring of title */
}  WDWPPY_TYP;

/* The various information we need to know
 * in order to run a command in a terminal window
 */
typedef struct
{
   char *trmpgm;    /* terminal program */
   char *ttl;       /* optional title */
   char *icnnam;    /* optional icon name */
   char *rscnam;    /* optional resource name */
   char *geo;       /* terminal geometry */
   char *opt;       /* additional options */
   int srlflg;      /* T=>use scrollbar */
} TRMWDWINF_TYP;

/* commands to execute for rxvt and xterm windows, respectively */
#ifndef TRMPGM_RXVT
# define TRMPGM_RXVT "rxvt"
#endif /* ndef TRMPGM_RXVT */
#ifndef TRMPGM_XTERM
# define TRMPGM_XTERM "xterm"
#endif /* ndef TRMPGM_XTERM */

/* default terminal program to use */
#ifndef TRMPGM_DEF
# define TRMPGM_DEF TRMPGM_XTERM
#endif /* ndef TRMPGM_DEF */

/* environment variable to check for terminal program to use */
#ifndef TRMPGM_ENVVAR
# define TRMPGM_ENVVAR "XCMD_TERM"
#endif /* ndef TRMPGM_ENVVAR */

/* various options for terminal programs */
#define TRMCMD_SRLOPT    " -sb "            /* use scrollbar */
#define TRMCMD_NONSRLOPT " +sb -sl 0 "      /* don't use scrollbar */
#define TRMCMD_TTLOPT    " -title '"        /* set title */
#define TRMCMD_ICNNAMOPT " -n '"            /* set icon name */
#define TRMCMD_RSCNAMOPT " -name '"         /* set resource name */
#define TRMCMD_GEOOPT    " -geometry "      /* set geometry */
#define TRMCMD_EXEOPT    " -e "             /* exectute command */
#define TRMCMD_QUO       "' "               /* quote to end some args with */

/* environment variable to check for raise method */
#ifndef FNDWDW_ENVVAR
# define FNDWDW_ENVVAR "XCMD_ICONIFY"
#endif /* ndef FNDWDW_ENVVAR */

#define ENVVAR_ZROVLU "0"
#define ENVVAR_NONVLU "no"
#define ENVVAR_FLSVLU "false"

#define ENVVAR_ONEVLU "1"
#define ENVVAR_YESVLU "yes"
#define ENVVAR_TRUVLU "true"

#endif /* ndef _XCMD_H */
