.\" -*- nroff -*-
.\" $Id: xcmd.man,v 1.9 1998/03/27 03:55:21 jmknoble Exp $
.\" 
.\" xcmd.man
.\" by Jim Knoble <jmknoble@pobox.com>
.\" Copyright  1997 Jim Knoble
.\" 
.\" Disclaimer:
.\" 
.\" The software is provided "as is", without warranty of any kind,
.\" express or implied, including but not limited to the warranties of
.\" merchantability, fitness for a particular purpose and
.\" noninfringement. In no event shall the author(s) be liable for any
.\" claim, damages or other liability, whether in an action of
.\" contract, tort or otherwise, arising from, out of or in connection
.\" with the software or the use or other dealings in the software.
.\"
.de TQ
.br
.ns
.TP \\$1
..
.\" ----------------------------------------------------------------
.TH xcmd 1x "1998-Jan-03" "Version 1.8"
.\" ----------------------------------------------------------------
.SH NAME
.PP
xcmd \- front-end for starting programs under X11
.\" ----------------------------------------------------------------
.SH SYNOPSIS
.PP
(1) \fBxcmd\fP \-\-help 
.PP
(2) \fBxcmd\fP [\-\-display \fIdisplay\fP] [\fIfind-options\fP]
\-\-xcmd \fIcommand\fP
.PP
(3) \fBxcmd\fP [\-\-display \fIdisplay\fP] [\fIfind-options\fP]
[\fIterm-options\fP] \-\-cmd \fIcommand\fP
.SS Find Options
.TQ
\-\-find\-class \fIwindow-class\fP
.TQ
\-\-find\-resource \fIwindow-resource\fP
.TQ
\-\-find\-substr \fItitle-substring\fP
.TQ
\-\-find\-title \fIwindow-title\fP
.TQ
{\-\-iconify\-and\-raise | \-\-only\-raise}
.SS Terminal Window Options
.TQ
\-\-title \fIwindow-title\fP
.TQ
\-\-icon \fIicon-title\fP
.TQ
\-\-name \fIwindow-resource\fP
.TQ
\-\-geometry \fIwindow-geometry\fP
.TQ
\-\-opt \fIadditional-options\fP
.TQ
{\-\-scroll | +scroll}
.TQ
{\-\-rxvt | \-\-xterm}
.\" ----------------------------------------------------------------
.SH DESCRIPTION
.PP
.B Xcmd
is a front-end for starting programs under X11.  You can tell
.B xcmd
to look for a window with a specific class, resource name, or title
string (using the 
.BI \-\-find\- property
options); if it finds one or more, 
.B xcmd
will `raise' them, otherwise it will run the command you specify.  You
can tell
.B xcmd
to run commands that create their own windows (using
.BR \-\-xcmd ),
or to run commands inside a terminal window (using
.BR \-\-cmd )
with various options.
.\" ----------------------------------------------------------------
.SH OPTIONS
.TP
\fB\-h\fP or \fB\-\-help\fP
Display version information and a summary of command syntax.
.TP
\fB\-d\fP or \fB\-\-display\fP \fIdisplay\fP
This option allows you to specify the server to connect to; see 
.BR X (3x).
.TP
\fB\-c\fP or \fB\-\-cmd\fP \fIcommand\fP
Run
.I command
in a terminal window (see
.B Terminal Window Options
below).  If you use one of the 
.BI \-\-find\- property
options,
.B xcmd
only runs
.I command
if it can't find a window with that property.
.TP
\fB\-x\fP or \fB\-\-xcmd\fP \fIcommand\fP
Run
.IR command ,
with the expectation that it will create its own window.  If you use
one of the
.BI \-\-find\- property
options,
.B xcmd
only runs
.I command
if it can't find a window with that property.
.SS Find Options
.PP
The following options tell
.B xcmd
to search the display for a window that has the specified property.  If
.B xcmd
finds one or more such windows, it raises them to the top of the
display.  These options are mutually exclusive.
.TP
\fB\-fc\fP or \fB\-\-find\-class\fP \fIwindow-class\fP
Find windows whose class matches
.I window-class
exactly.
.TP
\fB\-fr\fP or \fB\-\-find\-resource\fP \fIwindow-resource\fP
Find windows whose resource name matches
.I window-resource
exactly.
.TP
\fB\-fs\fP or \fB\-\-find\-substr\fP \fItitle-substring\fP
Find windows whose title contains the string
.IR title-substring .
.TP
\fB\-ft\fP or \fB\-\-find\-title\fP \fIwindow-title\fP
Find windows whose title matches
.I window-title
exactly.
.TP
\fB\-ir\fP or \fB\-\-iconify\-and\-raise\fP
When
.B xcmd
finds a window, first iconify it, then raise it; this `flashes' a
little, but it works reliably under FVWM with different X server loads.
It doesn't work reliably with WindowMaker.
.TP
\fB\-or\fP or \fB\-\-only\-raise\fP
When
.B xcmd
finds a window, just raise it.  This doesn't `flash', but it also
doesn't always work with FVWM.  It does work reliably with WindowMaker,
as long as the window is in the current workspace.  This is the
default.
.SS Terminal Window Options
.PP
The following options control the appearance of the terminal window
created when you run a command with
.BR \-\-cmd .
.B Xcmd
gives an error if you use any of these options without using
.BR \-\-cmd .
.TP
\fB\-t\fP or \fB\-\-title\fP \fIwindow-title\fP
The title to give the terminal window.  If you don't specify this
option, the title reverts to the resource name (see
.BR \-\-name )
if one is specified, otherwise it reverts to
.IR command .
.TP 
\fB\-i\fP or \fB\-\-icon\fP \fIicon-title\fP
The title to give to the terminal window when it's iconified.  If you
don't specify this option, the icon title reverts to the window title.
.TP
\fB\-n\fP or \fB\-\-name\fP \fIwindow-resource\fP
The resource name to give the terminal window.  If you don't specify
this option, it reverts to the default resource name for the terminal
program (e.g., `xterm' for
.BR xterm (1x)).
.TP
\fB\-g\fP or \fB\-\-geometry\fP \fIwindow-geometry\fP
The geometry to use for the terminal window.  If you don't specify this
option, it reverts to the default for the terminal program.
.TP
\fB\-o\fP or \fB\-\-opt\fP \fIadditional-options\fP
Additional options to pass to the terminal program; 
.I additional-options
should be one argument\-\--you may need to quote it using your favorite
shell's regular syntax.
.TP
\fB\-s\fP/\fB+s\fP or \fB\-\-scroll\fP/\fB+scroll\fP
Use 
.RB ( \-\-scroll )
or don't use 
.RB ( +scroll )
a scrollbar in the terminal window.  If you don't specify either of
these options, whether the terminal uses a scrollbar depends on its
defaults and its X resource settings.
.TP
\fB\-rt\fP/\fB\-xt\fP or \fB\-\-rxvt\fP/\fB\-\-xterm\fP
Use
.BR rxvt (1x)
or
.BR xterm (1x)
as the terminal program to run
.I command
in.  Normally,
.B xcmd 
uses the terminal program specified in the 
.B XCMD_TERM
environment variable (see
.B ENVIRONMENT
below), or
.BR xterm (1x)
if that variable is not set.  These options override the default
setting.
.\" ----------------------------------------------------------------
.SH EXAMPLES
.PP
Here are some examples of how to use
.BR xcmd :
.TP
.B xcmd \-\-cmd vi
Run 
.B vi 
in a terminal window.
.TP
.B xcmd \-\-cmd 'vi ~/.Xdefaults'
Run 
.B vi
in a terminal window and edit 
.BR ~/.Xdefaults .
.TP
.B xcmd \-\-find\-resource 'Navigator' \-\-xcmd netscape
Look for a Netscape window, or start one if none found.
.TP
.B xcmd \-\-find\-title 'Network Configurator' \-\-xcmd 'sudo netcfg'
Look for a window titled
.BR "Network Configurator" ;
if none found, use
.B sudo
to start
.BR netcfg .
.TP
.B xcmd \-\-find\-title Mail \-\-cmd pine \-\-title Mail \-\-name xMail +scroll
Look for a window titled
.BR Mail ;
if none found, start
.B pine
in a terminal window titled
.BR Mail ,
with a resource name of 
.B xMail 
and no scrollbar.  If the X resource
.RB ` "*xMail*vt100.geometry: 80x40" '
is set, for instance, the resulting window will be 80 columns wide
by 40 lines high.
.\" ----------------------------------------------------------------
.SH NOTES
.PP
.B Xcmd
uses an
.BR execl (3)
call to run 
.B /bin/sh -c exec
.IR command ,
so that
.I command
inherits 
.BR xcmd 's
process ID.
.B Xcmd
runs in the foreground by default; use your favorite shell's regular
syntax to start
.B xcmd
in the background (e.g.,
.RB ` "xcmd \-\-find\-title vi \-\-cmd vi &" '
for Bourne-compatible shells).
.\" ----------------------------------------------------------------
.SH ENVIRONMENT
.TP
.B DISPLAY
To get the default host and display number.
.TP
.B XCMD_TERM
To set the default terminal program to use with
.BR \-\-cmd .
Overridden by the command line.
.TP
.B XCMD_ICONIFY
If set to `0', `no', or `false', act as if the command-line option
.B \-\-only\-raise
was specified (this is the default if not set).  If set to `1', `yes',
or `true', act as if the command-line option
.B \-\-iconify\-and\-raise
was specified.  Any other value
produces an error message.  XCMD_ICONIFY is overridden by the command
line.
.\" ----------------------------------------------------------------
.SH SEE ALSO
.PP
X(3x), rxvt(1x), xterm(1x), xwininfo(1x)
.SH AUTHOR
.PP
Jim Knoble <jmknoble@pobox.com>
.PP
.B Xcmd
is very loosely derived from portions of 
.B xwit
by Mark Martin and David DiGiacomo and
.B xwininfo
by Mark Lillibridge.  Almost none of the original code remains.
