#include <stdio.h>
#include <string.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <sys/time.h>
#include "rotated.h"

#ifndef NO_XPM
#include <X11/xpm.h>
#include "mapixmap.h"
#else
#include "mabitmap.h"
#endif

#define min(A, B) ((A) < (B) ? (A) : (B))
/*#define max(A, B) ((A) > (B) ? (A) : (B))*/

#define MAXCOURT 0xFFFF

#define X_POS 0
#define Y_POS 0

#ifndef F77_NO_UNDER_SCORE
#define drawarc drawarc_
#define drawfilledarc drawfilledarc_
#define getbuttonrelease getbuttonrelease_
#define getxycx11 getxycx11_
#define getxycx11b getxycx11b_
#define getxycx11c getxycx11c_
#define getxycx11d getxycx11d_
#define getxycx11e getxycx11e_
#define mybackingput mybackingput_
#define mybackingput2 mybackingput2_
#define mybackingsave mybackingsave_
#define mybackingsave2 mybackingsave2_
#define mybackingsaveloc mybackingsaveloc_
#define myusleep myusleep_
#define myusleep2 myusleep2_
#define seldialog seldialog_
#define selgraphix11 selgraphix11_
#define viderbuff viderbuff_
#define viderbuff2 viderbuff2_
#define viderbuff3 viderbuff3_
#define x11ColormapRVB x11ColormapRVB_
#define x11allevents x11allevents_
#define x11alleventsvraiment x11alleventsvraiment_
#define x11askbacking x11askbacking_
#define x11blackwhite x11blackwhite_
#define x11bord x11bord_
#define x11changecolormap x11changecolormap_
#define x11changecurseur x11changecurseur_
#define x11clean x11clean_
#define x11clearrect x11clearrect_
#define x11clip x11clip_
#define x11cloche x11cloche_
#define x11detruitpop x11detruitpop_
#define x11device x11device_
#define x11draw3 x11draw3_
#define x11ecran x11ecran_
#define x11effacepix x11effacepix_
#define x11enddev x11enddev_
#define x11etoudessin x11etoudessin_
#define x11facette x11facette_
#define x11facette2 x11facette2_
#define x11garderect x11garderect_
#define x11garderect2 x11garderect2_
#define x11key x11key_
#define x11linsrn x11linsrn_
#define x11loadcolor x11loadcolor_
#define x11loadcolorback x11loadcolorback_
#define x11loadcolorbackold x11loadcolorbackold_
#define x11loadcolorold x11loadcolorold_
#define x11loadfont x11loadfont_
#define x11loadfont2 x11loadfont2_
#define x11magfont x11magfont_
#define x11makecolormap x11makecolormap_
#define x11makecolors x11makecolors_
#define x11mark x11mark_
#define x11meticone x11meticone_
#define x11metrect x11metrect_
#define x11metrect2 x11metrect2_
#define x11nomfenetre x11nomfenetre_
#define x11nomicone x11nomicone_
#define x11opendisplay x11opendisplay_
#define x11polyconvex x11polyconvex_
#define x11polyligne x11polyligne_
#define x11pop x11pop_
#define x11popup x11popup_
#define x11press x11press_
#define x11progressif x11progressif_
#define x11release x11release_
#define x11sauvecolormap x11sauvecolormap_
#define x11sauvepix x11sauvepix_
#define x11sauvexpm x11sauvexpm_
#define x11setcurs x11setcurs_
#define x11szscrn x11szscrn_
#define x11szwin x11szwin_
#define x11taillefen x11taillefen_
#define x11textextend x11textextend_
#define x11textextendall x11textextendall_
#define x11thermoini x11thermoini_
#define x11thick x11thick_
#define x11trouvecouleur x11trouvecouleur_
#define x11txtsrn x11txtsrn_
#define x11txtsrn2 x11txtsrn2_
#define x11txtsrnrot x11txtsrnrot_
#define x11txtsrnrot2 x11txtsrnrot2_
#define x11txtsrnrot3 x11txtsrnrot3_
#define x11unclip x11unclip_
#define x11videqueue x11videqueue_
#define zcolor zcolor_
#endif

Drawable drawable;
Pixmap pixsauve, pixbacking, pixbacking2;
Pixmap pixpoursauvegarde;
unsigned int largeursauvegarde=0;
unsigned int hauteursauvegarde=0;

int dest_x, dest_y;
int xmaxpixsize, ymaxpixsize;
int Shape_to_Fill, Does_it_backing_store;
unsigned int largeur_fenetre, hauteur_fenetre;
unsigned int largeur_popup, hauteur_popup;

GC gc;
Window window, window2, windowcour;
XSetWindowAttributes attributes;
Region region_de_clip;

float red[256], green[256], blue[256];
float redsauve[256], greensauve[256], bluesauve[256];
unsigned long foreground, background;
int tabledirect[45000];

Display *dpy;
Colormap color_map;
Visual *visual, *visualdef;

int nbpolices;
char **listfonts;   /* pointe sur une liste de noms de fonts */
/*Font font_id;*/
XID font_id;
XFontStruct *font_cour;

int ishiftcoul, ipseudo;

int cap_style=CapProjecting;
int join_style=JoinRound;
int line_style=LineSolid;
unsigned int line_width=1;
int profond;
int yaunpopup=0;
int yaunclip=0;

Time timeclick0=0, timeclick1=0;

/*------------------------------------------------------------------*/
void x11opendisplay(char *string)
{
  int ii = 0;

  ishiftcoul = 16;
  while (string[ii++] != ' ') ;
  string[ii-1]='\0';

  dpy = 0;
  if ( (dpy = XOpenDisplay(string)) == NULL)
    {
      /*    printf("Impossible d'ouvrir le display ! \n");*/
      printf("*** I cannot open the display ! \n");
      printf("   XOpenDisplay (\"%s\") \n",string);
      exit(1);
    }
  Does_it_backing_store = DoesBackingStore(XDefaultScreenOfDisplay(dpy));
}
/*------------------------------------------------------------------*/
void x11ecran(int *xmm, int *ymm, int *xp, int *yp, int *xp2, int *yp2)
{
  *ymm = XDisplayHeightMM(dpy,DefaultScreen(dpy));
  *xmm = XDisplayWidthMM (dpy,DefaultScreen(dpy));
  xmaxpixsize = XDisplayWidth(dpy,DefaultScreen(dpy));
  ymaxpixsize = XDisplayHeight(dpy,DefaultScreen(dpy));
  *xp  = xmaxpixsize;
  *yp  = ymaxpixsize;
  /* Un peu gros non  ? (FJ 1/2003)
  xmaxpixsize = 2*xmaxpixsize;
  ymaxpixsize = 3*ymaxpixsize;
  */
  xmaxpixsize = (int)(1.4*xmaxpixsize);
  ymaxpixsize = (int)(1.4*ymaxpixsize);
  *xp2 = xmaxpixsize;
  *yp2 = ymaxpixsize;
}
/*------------------------------------------------------------------*/
void x11changecurseur(int *icurs)
{
  Cursor curseur;
  XColor curseurf,curseurb;

  if (*icurs == 2 || *icurs == 12)
    {
      if (*icurs == 2)
	{
	  curseur = XCreateFontCursor(dpy,XC_hand2);
	  XDefineCursor(dpy,windowcour,curseur);
	  curseurf.red   = (unsigned short) 0;
	  curseurf.green = (unsigned short) 0;
	  curseurf.blue  = (unsigned short) ( MAXCOURT );
	}
      else
	{
	  curseur = XCreateFontCursor(dpy,XC_crosshair);
	  XDefineCursor(dpy,windowcour,curseur);
	  curseurf.red   = (unsigned short) ( MAXCOURT );
	  curseurf.green = (unsigned short) 0;
	  curseurf.blue  = (unsigned short) 0;
	}
      curseurf.pixel = (unsigned long) 7;
      curseurf.flags = DoRed | DoGreen | DoBlue;
      curseurb.pixel = (unsigned long) 7;
      curseurb.red   = (unsigned short) ( MAXCOURT*0.74509804 );
      curseurb.green = (unsigned short) ( MAXCOURT*0.74509804 );
      curseurb.blue  = (unsigned short) ( MAXCOURT*0.74509804 );
      curseurb.flags = DoRed | DoGreen | DoBlue;
    }
  else
    {
      if (*icurs == 1)
	curseur = XCreateFontCursor(dpy,XC_crosshair);
      else
	if (*icurs == 3)
	  curseur = XCreateFontCursor(dpy,XC_exchange);
	else
	  if (*icurs == 4)
	    curseur = XCreateFontCursor(dpy,XC_fleur);
	  else
	    if (*icurs == 5)
	      curseur = XCreateFontCursor(dpy,XC_watch);
	    else
	      if (*icurs == 6)
		curseur = XCreateFontCursor(dpy,XC_dotbox);
	      else
		if (*icurs == 7)
		  curseur = XCreateFontCursor(dpy,XC_xterm);
		else
		  if (*icurs == 8)
		    curseur = XCreateFontCursor(dpy,XC_pirate);
		  else
		    if (*icurs == 9)
		      curseur = XCreateFontCursor(dpy,XC_hand1);
		    else
		      if (*icurs == 10)
			curseur = XCreateFontCursor(dpy,XC_sb_v_double_arrow);
		      else
			curseur = XCreateFontCursor(dpy,XC_draft_small);
      XDefineCursor(dpy,windowcour,curseur);
      curseurf.pixel = (unsigned long) 7;
      curseurf.red   = (unsigned short) ( MAXCOURT );
      if (*icurs == 6 || *icurs == 8)
	curseurf.green = (unsigned short) 0;
      else
	curseurf.green = (unsigned short) ( MAXCOURT );

      curseurf.blue  = (unsigned short) 0;
      curseurf.flags = DoRed | DoGreen | DoBlue;
      curseurb.pixel = (unsigned long) 0;
      curseurb.red   = (unsigned short) 0;
      curseurb.green = (unsigned short) 0;
      curseurb.blue  = (unsigned short) 0;
      curseurb.flags = DoRed | DoGreen | DoBlue;
    }
  XRecolorCursor(dpy,curseur,&curseurf,&curseurb);
}
/*------------------------------------------------------------------*/
void x11device(int *inbc, int *ix, int *iy, int *nbcolo, char *prog)
{
  XSizeHints sizehints;
  int x, y, i, profondef;

  unsigned int width,height,widthpop,heightpop,border_width;

  XColor curseurf,curseurb;

  XGCValues gcvalues;
  /*    char **MyXListFonts();*/

  XVisualInfo vessai;
  XVisualInfo *visualList;
  int visualok, nbcolormap;
  int ecran;
  XStandardColormap **stdcolormap=0;
  VisualID visualid;

  Cursor curseur;

  x = (int) X_POS;
  y = (int) Y_POS;

  largeur_fenetre = (unsigned int) *ix;
  hauteur_fenetre = (unsigned int) *iy;
  border_width = (unsigned int) 0  ;
  ipseudo = 0;
  Shape_to_Fill = Complex;

  ecran = DefaultScreen(dpy);
  visualdef = DefaultVisual(dpy, ecran);
  profondef = DefaultDepth(dpy, ecran);

  vessai.screen = ecran;
  vessai.depth = 24;
  visualList = XGetVisualInfo(dpy, VisualScreenMask |
                                   VisualDepthMask, &vessai, &visualok);
  if (visualok == 0)
    {
      vessai.depth = 16;
      visualList = XGetVisualInfo(dpy, VisualScreenMask |
                                       VisualDepthMask, &vessai, &visualok);
      if (visualok == 0)
	visual = visualdef;
      else
	{
	  visualid = visualList[0].visualid;
	  visual = visualList[0].visual;
	  ecran  = visualList[0].screen;
	  /*	  printf(" Number of depth16 visuals found = %d\n",visualok);*/
	}
    }
  else
    {
      visualid = visualList[0].visualid;
      visual = visualList[0].visual;
      ecran  = visualList[0].screen;
      /*      printf(" Number of depth24 visuals found = %d \n",visualok);*/
    }

  *inbc = visual->class;
  /*    printf(" map_entries= %d  nbcolo= %d classe= %d\n",visual->map_entries,*nbcolo,visual->class);*/

 retry:
  switch (visual->class)
    {
    case GrayScale:
      {
	/*                          color_map  = DefaultColormap (dpy, ecran);
				    foreground = WhitePixel (dpy, ecran );
				    background = BlackPixel (dpy, ecran );
				    *nbcolo = 2;
				    break;                */
	visual->class=PseudoColor;
	goto retry;
      }
    case PseudoColor:
      {
	/* rajout fj */
	color_map = DefaultColormap (dpy, ecran);
	*nbcolo = visual->map_entries;
	x11ColormapRVB(color_map, red, green, blue, *nbcolo);
	/* fin fj */
	color_map = XCreateColormap(dpy, RootWindow (dpy, ecran)
				   ,visual,AllocAll);
	foreground = WhitePixel (dpy, ecran);
	background = BlackPixel (dpy, ecran);
	*nbcolo = min (*nbcolo, visual->map_entries);
	x11makecolors(red, green, blue);
	x11makecolormap(red, green, blue, color_map, *nbcolo);
	break;
      }
    case DirectColor:
      {
	if (visual == visualdef)
	  color_map = DefaultColormap (dpy, ecran);
	else
	  {
	    if (XGetRGBColormaps(dpy, RootWindow (dpy, ecran),
				 stdcolormap, &nbcolormap, XA_RGB_DEFAULT_MAP) == 0)
	      {
		/*		   printf("erreur XGetRGBColormaps
				   %d\n",nbcolormap);*/

		visual = visualdef;
		ecran = DefaultScreen(dpy);
		visualok = 0;
		*inbc = visual->class;
		goto retry;
	      }
	    /*			     printf("nb color maps %d\n",nbcolormap);*/
	    color_map = stdcolormap[0]->colormap;
	  }
	printf(" DirectColor: may be still buggy...\n");
	foreground = WhitePixel (dpy, ecran);
	background = BlackPixel (dpy, ecran);
	ipseudo = 1;
	x11makecolors(red, green, blue);
	*nbcolo = 256;
	break;
      }
    case StaticGray:
      {
	color_map  = DefaultColormap (dpy, ecran);
	foreground = WhitePixel (dpy, ecran);
	background = BlackPixel (dpy, ecran);
	*nbcolo = 2;
	break;
      }
    case StaticColor:
      {
	printf(" StaticColor: may be still buggy...\n");
	color_map = DefaultColormap (dpy, ecran);
	foreground = WhitePixel (dpy, ecran);
	background = BlackPixel (dpy, ecran);
	*nbcolo = visual->map_entries;
	ipseudo = 1;
	x11makecolors(red, green, blue);
	break;
      }
    case TrueColor:
      {
	if (visual == visualdef)
	  color_map = DefaultColormap (dpy, ecran);
	else
	  /*
Attention ici a XGetRGBColormaps. Sur Silicon (machines avec visalok=5 > 1)
ca plante la. On supprime le plantage en supprimant l'appel a XGetRGBColormaps
et en passant dans le test comme si il y avait une erreur (7/2001)
	   */
	  {
	    if (XGetRGBColormaps(dpy, RootWindow (dpy, ecran),
                                 stdcolormap, &nbcolormap, XA_RGB_DEFAULT_MAP) == 0)
	      {
		/*	 printf("erreur XGetRGBColormaps\n");*/

		visual = visualdef;
		ecran = DefaultScreen(dpy);
		visualok = 0;
		*inbc = visual->class;
		goto retry;
	      }
	    /*			     printf("nb color maps %d\n",nbcolormap);*/
	    color_map = stdcolormap[0]->colormap;
	  }
	/*           printf(" TrueColor: may be still buggy...\n");*/
	foreground = WhitePixel (dpy, ecran);
	background = BlackPixel (dpy, ecran);
	*nbcolo = 256;
	ipseudo = 1;
	x11makecolors(red, green, blue);
	break;
      }
    }
  curseur = XCreateFontCursor(dpy,XC_crosshair);

  curseurf.pixel = (unsigned long) 7;
  curseurf.red   = (unsigned short) ( MAXCOURT );
  curseurf.green = (unsigned short) ( MAXCOURT );
  curseurf.blue  = (unsigned short) 0;
  curseurf.flags = DoRed | DoGreen | DoBlue;

  curseurb.pixel = (unsigned long) 0;
  curseurb.red   = (unsigned short) 0;
  curseurb.green = (unsigned short) 0;
  curseurb.blue  = (unsigned short) 0;
  curseurb.flags = DoRed | DoGreen | DoBlue;

  XRecolorCursor(dpy,curseur,&curseurf,&curseurb);

  attributes.background_pixel = background;
  attributes.bit_gravity      = NorthWestGravity;
  attributes.border_pixel     = foreground;
  attributes.backing_store    = Always;
  attributes.colormap         = color_map;
  attributes.cursor           = curseur;
  attributes.save_under       = True;

  if (visualok == 0)
    profond = profondef;
  else
    profond = visualList[0].depth;

  window = XCreateWindow(dpy, RootWindow(dpy, ecran),
			 x, y, largeur_fenetre, hauteur_fenetre, border_width,
			 profond, InputOutput, visual,
                         CWSaveUnder |
                         CWBitGravity |
                         CWCursor |
                         CWBackPixel |
                         CWBorderPixel |
                         CWBackingStore |
                         CWColormap,
			 &attributes);
  drawable = window;
  windowcour = window;
  x11meticone();

  XChangeProperty(dpy, window, XA_WM_NAME, XA_STRING, 8
		 ,PropModeReplace, prog, strlen(prog));
  sizehints.x = X_POS;
  sizehints.y = Y_POS;
  sizehints.width  = largeur_fenetre;
  sizehints.height = hauteur_fenetre;
/*
  sizehints.min_width  = largeur_fenetre/5;
  sizehints.min_height = hauteur_fenetre/5;
*/
/*
  sizehints.min_aspect.x = largeur_fenetre-largeur_fenetre/10;
  sizehints.min_aspect.y = hauteur_fenetre+hauteur_fenetre/10;
  sizehints.max_aspect.x = largeur_fenetre+largeur_fenetre/10;
  sizehints.max_aspect.y = hauteur_fenetre-hauteur_fenetre/10;
  sizehints.flags = PPosition|PSize|PMinSize|PMaxSize|PAspect;
*/
  sizehints.flags = PPosition|PSize;
/*printf("taille %d %d %d %d \n",largeur_fenetre,hauteur_fenetre,sizehints.min_aspect.x,sizehints.min_aspect.y);
*/
  XSetWMSizeHints(dpy,window, &sizehints, XA_WM_NORMAL_HINTS);
  XSetWindowBorderWidth(dpy, window, border_width);

  x11allevents();

  XMapWindow(dpy, window);
  /*  if (visualok == 0)
      profond = 8;*/
  width  = xmaxpixsize;
  height = ymaxpixsize;
  widthpop  = xmaxpixsize/2;
  heightpop = ymaxpixsize/2;
  pixsauve = XCreatePixmap(dpy, window, width, height, profond);
  /* pixmap pour faux backing store, bidon si serveur ok */
  if (Does_it_backing_store != 0)
    {
      width = 10;
      height = 10;
      widthpop = 10;
      heightpop = 10;
    }
  pixbacking = XCreatePixmap(dpy, window, width, height, profond);
  pixbacking2 = XCreatePixmap(dpy, window, widthpop, heightpop, profond);
  listfonts = XListFonts(dpy, "*", 1, &i);
  if ( i != 0 )
    font_id = XLoadFont(dpy, *listfonts);
  else
    {
      printf ("No fonts found !\n");
      exit(1);
    }

  XFreeFontNames(listfonts);
  gcvalues.foreground = foreground;
  gcvalues.background = background;
  gcvalues.function   = GXcopy    ;
  gcvalues.font       = font_id   ;
  gcvalues.cap_style  = cap_style;
  gcvalues.join_style = join_style;
  gc = XCreateGC(dpy, window, GCCapStyle |
                              GCJoinStyle |
                              GCForeground |
                              GCBackground |
                              GCFunction |
                              GCFont, &gcvalues);

  XSetFillRule(dpy,gc,WindingRule);

  /*    listfonts = MyXListFonts (*maxfonts, nbfonts);
	nbpolices = *nbfonts;
	printf(" %d fonts\n", nbpolices);*/

  /*  l'analyse des noms est faite en fortran  */
  /*    for ( k = 0; k < nbpolices; k++ )
	{ * (nbchar    + k) = strlen ( *(listfonts + k) );
	strcpy(namefont[k],listfonts[k]);
	}
	printf("On attend la synchro \n"); */
  XSync(dpy,False);
  /*   printf("Ca y est \n");*/
}
/*------------------------------------------------------------------*/
void x11askbacking(int *ibacking)
{
  *ibacking = Does_it_backing_store;
  /*  if (*ibacking == 0)
    printf("*** No backing store on this X server \n");
  else
  printf("*** Backing store enabled \n");*/
}
/*------------------------------------------------------------------*/
void x11popup(int *ix, int *iy, int *xpos, int *ypos, char *nompopup)
{
  XSizeHints sizehints;
  XGCValues gcvalues;
  int x, y, ecran;
  unsigned int width, height, border_width;

  if (Does_it_backing_store == 0) mybackingsave();

  x = (int) *xpos;
  y = (int) *ypos;

  width        = (unsigned int) *ix;
  height       = (unsigned int) *iy;
  border_width = (unsigned int) 0;
  ecran = DefaultScreen(dpy);
  largeur_popup = (unsigned int) *ix;
  hauteur_popup = (unsigned int) *iy;

  attributes.background_pixel = background;
  attributes.bit_gravity      = NorthWestGravity;
  attributes.border_pixel     = foreground;
  attributes.backing_store    = Always;
  attributes.colormap         = color_map;
  /*  attributes.cursor           = curseur;*/

  window2 = XCreateWindow(dpy, RootWindow(dpy, ecran),
			 x, y, width, height, border_width,
			 profond, InputOutput, visual,
                         CWBitGravity |
                         CWCursor |
                         CWBackPixel |
                         CWBorderPixel |
                         CWBackingStore |
                         CWColormap,
			 &attributes);
  drawable = window2;
  windowcour = window2;
  x11meticone();

  XChangeProperty(dpy, window2, XA_WM_NAME, XA_STRING, 8
		 ,PropModeReplace, nompopup, strlen(nompopup));
  XChangeProperty(dpy, window2, XA_WM_ICON_NAME, XA_STRING, 8
		 ,PropModeReplace, nompopup, strlen(nompopup));
  sizehints.x = *xpos;
  sizehints.y = *ypos;
  sizehints.width  = width;
  sizehints.height = height;
  sizehints.min_width  = width;
  sizehints.max_width  = width;
  sizehints.min_height = height;
  sizehints.max_height = height;
  sizehints.flags  = PPosition|PSize|PMinSize|PMaxSize;

  /*  XSetWMSizeHints(dpy,window2, &sizehints, XA_WM_NORMAL_HINTS);*/
  XSetWMNormalHints(dpy,window2,&sizehints);
  XSetWindowBorderWidth(dpy, window2, border_width);

  XMapWindow(dpy, window2);
  XRaiseWindow(dpy, window2);

  MyXSelectInput(dpy, window, NULL);
  MyXSelectInput(dpy, window2, ExposureMask |
                               KeyPressMask |
                               ButtonPressMask |
                               ButtonReleaseMask |
                               PointerMotionMask |
                               ButtonMotionMask |
                               StructureNotifyMask);
  gcvalues.foreground = foreground;
  gcvalues.background = background;
  gcvalues.function   = GXcopy    ;
  gcvalues.font       = font_id   ;
  gcvalues.cap_style  = cap_style;
  gcvalues.join_style = join_style;
  gc = XCreateGC(dpy, window2, GCCapStyle |
                               GCJoinStyle |
                               GCForeground |
                               GCBackground |
                               GCFunction |
                               GCFont, &gcvalues);
  XSync(dpy,False);
  yaunpopup=1;
}
/*------------------------------------------------------------------*/
void x11detruitpop(int *iopt)
{
  int microsecond=100000;

  drawable = window;
  windowcour = window;
  XDestroyWindow(dpy,window2);
  XMapWindow(dpy, window);
  if (*iopt == 0)
    {
      XRaiseWindow(dpy, window);
      XSync(dpy,True);
      if (Does_it_backing_store == 0)
	{
	  myusleep(&microsecond);
	  mybackingput();
	}
      XSync(dpy,True);
      x11allevents();
    }
  yaunpopup=0;
}
/*------------------------------------------------------------------*/
void x11etoudessin(int *iopt)
{
  XGCValues gcvalues;

  if (*iopt == 0)
    gcvalues.function = GXcopy;
  else
    gcvalues.function = GXxor;
  /*gcvalues.function = GXinvert; */
  XChangeGC(dpy, gc, GCFunction, &gcvalues);
}
/*------------------------------------------------------------------*/
void x11nomfenetre(char *nouveaunom, int *lonlon)
{
  XChangeProperty(dpy, window, XA_WM_NAME, XA_STRING, 8,
		  PropModeReplace, nouveaunom, *lonlon);
}
/*------------------------------------------------------------------*/
void x11nomicone(char *nouveaunom, int *lonlon)
{
  XChangeProperty(dpy, window, XA_WM_ICON_NAME, XA_STRING, 8
		 ,PropModeReplace, nouveaunom, *lonlon);
}
/*------------------------------------------------------------------*/
int x11meticone()
{
  int argc;
  char **argv=NULL;
  Pixmap icon_pixmap;
  /*  Pixmap icon_mask_pixmap;*/
  XSizeHints size_hints;
  XWMHints wm_hints;
  XClassHint class_hints;
  XTextProperty windowName,iconName;
  char *window_name = "Basic Worksheet";
  char *icon_name = "basicsheet";

  if (XStringListToTextProperty(&window_name,1,&windowName)==0)
    {
      fprintf( stderr,"structure allocation for windowName failed.\n");
      exit(-1);
    }
  if (XStringListToTextProperty(&icon_name,1,&iconName)==0)
    {
      fprintf( stderr,"structure allocation for iconName failed.\n");
      exit(-1);
    }
  argc = 0;

#ifndef NO_XPM
  XpmCreatePixmapFromData(dpy,windowcour,default_pixmap,&icon_pixmap,NULL,NULL);
#else
  icon_pixmap = XCreateBitmapFromData(dpy,windowcour,icon_bitmap_bits,icon_bitmap_width,icon_bitmap_height);
  icon_mask_pixmap= XCreateBitmapFromData(dpy,windowcour,icon_bitmap_bits,icon_bitmap_width,icon_bitmap_height);
#endif

 /*  size_hints.flags = PPosition | PSize | PMinSize;
  size_hints.min_width=56;
  size_hints.min_height=46;*/
  size_hints.flags = PPosition | PSize;
  wm_hints.initial_state = NormalState;
  wm_hints.input = True;
  wm_hints.icon_pixmap = icon_pixmap;
  /*   wm_hints.icon_mask = icon_mask_pixmap;*/
  wm_hints.flags = StateHint | IconPixmapHint | InputHint | IconMaskHint ;
  /*  wm_hints.flags = StateHint | IconPixmapHint | InputHint;*/
  class_hints.res_name  = "Monprog";
  class_hints.res_class = "Basicsheet";

  XSetWMProperties(dpy,windowcour,&windowName,&iconName,argv,argc,&size_hints,&wm_hints,&class_hints);
}
/*------------------------------------------------------------------*/
void x11sauvecolormap(rrr, ggg, bbb, nbcolcol)
float rrr[], ggg[], bbb[];
int *nbcolcol;
{
  XColor rgb_def, hardware_def, colorcell_defs;
  unsigned short maxvalue;
  int i,ii;

  XLookupColor (dpy, color_map, "white", &rgb_def, &hardware_def);
  maxvalue = hardware_def.red;
  /*  ii = *nbcolcol-16;*/
  if (visual->map_entries > 2)
    { ii = 16;
    for ( i = 0 ; i < ii ; i++ )
      {
	colorcell_defs.pixel = (unsigned long) i+ishiftcoul;
	XQueryColor(dpy, color_map, &colorcell_defs);

	rrr[i] = ((float) colorcell_defs.red   / (float) maxvalue);
	ggg[i] = ((float) colorcell_defs.green / (float) maxvalue);
	bbb[i] = ((float) colorcell_defs.blue  / (float) maxvalue);
      }
    }
}
/*------------------------------------------------------------------*/
int x11ColormapRVB(color_maploc, redloc, greenloc, blueloc, nbcolor)
Colormap color_maploc;
float redloc[], greenloc[], blueloc[];
int nbcolor;
{
  XColor rgb_def, hardware_def, colorcell_defs;
  unsigned short maxvalue;
  int i;

  XLookupColor (dpy, color_maploc, "white", &rgb_def, &hardware_def);
  maxvalue = hardware_def.red;

  for ( i = 0 ; i < nbcolor ; i++ )
  {
    colorcell_defs.pixel = (unsigned long) i;
    XQueryColor(dpy, color_maploc, &colorcell_defs);

    redloc[i]   = ((float) colorcell_defs.red   / (float) maxvalue);
    greenloc[i] = ((float) colorcell_defs.green / (float) maxvalue);
    blueloc[i]  = ((float) colorcell_defs.blue  / (float) maxvalue);
  }
}
/*------------------------------------------------------------------*/
int x11makecolors(redloc, greenloc, blueloc)
float redloc[], greenloc[], blueloc[];
{
  int index, size=16;
  int i,jtable;
  XColor coulproche;

  /*   size=nbcolors;*/
  index = size;
  zcolor(redloc, greenloc, blueloc, &index);
  ishiftcoul = index;
  for (i = 0; i < size; i++)
    {
      jtable = i+ishiftcoul;
      redsauve[jtable]   = redloc[jtable];
      greensauve[jtable] = greenloc[jtable];
      bluesauve[jtable]  = blueloc[jtable];
      if (ipseudo == 0)
	{
	  tabledirect[jtable]   = jtable;
	}
      else
	{
	  coulproche.red   = (unsigned short) ( redsauve[jtable] * (float) MAXCOURT );
	  coulproche.green = (unsigned short) ( greensauve[jtable] * (float) MAXCOURT );
	  coulproche.blue  = (unsigned short) ( bluesauve[jtable] * (float) MAXCOURT );
	  XAllocColor(dpy,color_map,&coulproche);
	  tabledirect[jtable] = coulproche.pixel;
	}
    }
  tabledirect[ishiftcoul]   = background;
  tabledirect[ishiftcoul+7] = foreground;
}
/*------------------------------------------------------------------*/
void x11trouvecouleur(float *redloc, float *greenloc, float *blueloc, int *index)
{
  int jtable;
  XColor coulproche;

  jtable = ishiftcoul + *index;
  coulproche.red   = (unsigned short) ( *redloc   * (float) MAXCOURT );
  coulproche.green = (unsigned short) ( *greenloc * (float) MAXCOURT );
  coulproche.blue  = (unsigned short) ( *blueloc  * (float) MAXCOURT );
  XAllocColor(dpy,color_map,&coulproche);
  tabledirect[jtable] = coulproche.pixel;
}
/*------------------------------------------------------------------*/
int x11makecolormap(redloc, greenloc, blueloc, color_maploc, nbcells)
Colormap color_maploc;
float redloc[], greenloc[], blueloc[];
int nbcells;
{
  int index;
  XColor colorcell_defs[256];

  for ( index = 0 ; index < nbcells ; index++ )
  {
    colorcell_defs[index].pixel = (unsigned long) index;

    colorcell_defs[index].red   = (unsigned short) ( redloc[index]   * (float) MAXCOURT );
    colorcell_defs[index].green = (unsigned short) ( greenloc[index] * (float) MAXCOURT );
    colorcell_defs[index].blue  = (unsigned short) ( blueloc[index]  * (float) MAXCOURT );

    colorcell_defs[index].flags = DoRed | DoGreen | DoBlue;
  }
  XStoreColors(dpy, color_maploc, colorcell_defs, nbcells);
}
/*------------------------------------------------------------------*/
void x11changecolormap(r1, g1, b1, r, g, b, i1, i2, i3)
float r1[], g1[], b1[];
float r[],  g[],  b[];
int *i1, *i2, *i3;
{
  int itab, i;
  XColor colorcell_defs[256], coulproche;

  ishiftcoul = *i1;
  if (visual->class == PseudoColor)
    {
      *i3 = 0;
      for ( i = 0 ; i < (*i2) - (*i1) + 1 ; i++ )
	{
	  itab = i + *i1;

	  r[itab] = r1[i];
	  g[itab] = g1[i];
	  b[itab] = b1[i];

	  red[itab]   = r1[i];
	  green[itab] = g1[i];
	  blue[itab]  = b1[i];

	  colorcell_defs[itab].pixel = (unsigned long) itab;
	  colorcell_defs[itab].red   = (unsigned short) ( r1[i] * (float) MAXCOURT );
	  colorcell_defs[itab].green = (unsigned short) ( g1[i] * (float) MAXCOURT );
	  colorcell_defs[itab].blue  = (unsigned short) ( b1[i] * (float) MAXCOURT );
	  colorcell_defs[itab].flags = DoRed | DoGreen | DoBlue;
	}
      for ( i = 0 ; i < *i1 ; i++ )
	{
	  colorcell_defs[i].pixel = (unsigned long) i;
	  colorcell_defs[i].red   = (unsigned short) ( red[i] * (float) MAXCOURT );
	  colorcell_defs[i].green = (unsigned short) ( green[i] * (float) MAXCOURT );
	  colorcell_defs[i].blue  = (unsigned short) ( blue[i] * (float) MAXCOURT );
	  colorcell_defs[i].flags = DoRed | DoGreen | DoBlue;
	}
      /*    XStoreColors( dpy, color_map, colorcell_defs, (*i2) - (*i1) + 1 );*/
      XStoreColors ( dpy, color_map, colorcell_defs, *i2 );
      /*viderbuf)();*/
    }
  for ( i = 0 ; i < (*i2) - (*i1) + 1 ; i++ )
    {
      itab = i + ishiftcoul;
      redsauve[itab]   = r1[i];
      greensauve[itab] = g1[i];
      bluesauve[itab]  = b1[i];
      if (ipseudo == 0)
	tabledirect[itab] = itab;
      else
	{
	  coulproche.red   = (unsigned short) ( redsauve[itab] * (float) MAXCOURT );
	  coulproche.green = (unsigned short) ( greensauve[itab] * (float) MAXCOURT );
	  coulproche.blue  = (unsigned short) ( bluesauve[itab] * (float) MAXCOURT );
	  XAllocColor(dpy,color_map,&coulproche);
	  tabledirect[itab] = coulproche.pixel;
	}
    }
  tabledirect[ishiftcoul]   = background;
  tabledirect[ishiftcoul+7] = foreground;
}
/*------------------------------------------------------------------*/
/*
x11loadcolorold(icolor)
int *icolor;
{
int jtable;

if ((*icolor) == 7)
  XSetForeground(dpy, gc, foreground);
else
  {
    if (*(icolor) == 0)
      XSetForeground(dpy, gc, background);
    else
      {
	if (ipseudo == 0)
	  XSetForeground(dpy, gc, (*icolor)+ishiftcoul);
	else
	  {
	    jtable = (*icolor)+ishiftcoul;
	    XSetForeground(dpy, gc, tabledirect[jtable]);
	  }
      }
  }
}
*/
/*------------------------------------------------------------------*/
/*
x11loadcolorbackold(icolor)
int *icolor;
{
int jtable;

if ((*icolor) == 7)
  XSetBackground(dpy, gc, foreground);
else
  {
    if (*(icolor) == 0)
      XSetBackground(dpy, gc, background);
    else
      {
	if (ipseudo == 0)
	  XSetBackground(dpy, gc, (*icolor)+ishiftcoul);
	else
	  {
	    jtable = (*icolor)+ishiftcoul;
	    XSetBackground(dpy, gc, tabledirect[jtable]);
	  }
      }
  }
}
*/
/*------------------------------------------------------------------*/
void x11loadcolor(int *icolor)
{
  int jtable;

  jtable = (*icolor)+ishiftcoul;
  XSetForeground(dpy, gc, tabledirect[jtable]);
}
/*------------------------------------------------------------------*/
void x11loadcolorback(int *icolor)
{
  int jtable;

  jtable = (*icolor)+ishiftcoul;
  XSetBackground(dpy, gc, tabledirect[jtable]);
}
/*------------------------------------------------------------------*/
/* rajout FJ */
void x11clip(XPoint *pts, int *n, int *ixclip, int *iyclip)
{
  int npts, ixc, iyc ;

  ixc = *ixclip;
  iyc = *iyclip;
  XSetClipOrigin(dpy,gc,ixc,iyc);
  npts = *n;
  region_de_clip = XPolygonRegion(pts,npts,WindingRule);
  XSetRegion(dpy,gc,region_de_clip);
  yaunclip = 1;
}
/*------------------------------------------------------------------*/
void x11unclip()
{
  XPoint pts[4];
  int z=0, npts=4;

  if (yaunclip != 0)
    {
      /*      printf("declip full\n");*/
      XSetClipOrigin(dpy,gc,z,z);
      pts[0].x = z;
      pts[0].y = z;
      pts[1].x = z;
      pts[1].y = hauteur_fenetre;
      pts[2].x = largeur_fenetre;
      pts[2].y = hauteur_fenetre;
      pts[3].x = largeur_fenetre;
      pts[3].y = z;
      /*      region_de_clip = XPolygonRegion(&pts,npts,WindingRule);*/
      region_de_clip = XPolygonRegion(pts,npts,WindingRule);
      XSetRegion(dpy,gc,region_de_clip);
      yaunclip = 0;
      /*     XFlush(dpy);*/
    }
}
/* fin FJ ... */
/*------------------------------------------------------------------*/
/*x11loadfont(i,namefonts)
int *i;
char *namefonts;
{
  char *font;

  if ( ( 0 <= *i ) && (*i <= nbpolices - 1 ) )
  {
    font = *(listfonts + *i);
    memmove(font, namefonts, (int)strlen(font));

    font_cour = XLoadQueryFont(dpy,namefonts);
    font_id = XLoadFont(dpy,font);
    XSetFont (dpy, gc, font_id);
  }
  else
  {
    printf("x11loadfont: requested font not found, font unchanged\n");
  }
}*/
/*------------------------------------------------------------------*/
/*FJ */
void x11loadfont2(char *namefont, int  *iopt, int  *ireturn)
{
  int i,ijouve=1;
  static int ipremierefonte = 0;

  listfonts = XListFonts (dpy, namefont, ijouve, &i);
  *ireturn = i;
  if ( i != 0 )
  {
      if (*iopt > 1)
	  printf(" On a pris  la place : %s\n", *listfonts);
      else
	if (*iopt == 0)
	  {
	    if (ipremierefonte == 0)
	      ipremierefonte = 1;
	    else
	      XFreeFont(dpy,font_cour);

	    font_cour = XLoadQueryFont(dpy,namefont);
/*           font_id = XLoadFont (dpy, *listfonts);*/
	    font_id = font_cour->fid;
	    XSetFont (dpy, gc, font_id);
	  }
  }
  XFreeFontNames(listfonts);
}
/* fin FJ */
/*------------------------------------------------------------------*/
void x11textextend(char *string, int *nbcar, int *extend)
{
  int dir,asc,desc;
  XCharStruct overall;

  /*
  k = XPending(dpy);
  printf("   Bien recu (\"%s\") %d %d\n", string,*nbcar,k);
  fflush(stdout);
  */
  XFlush(dpy);
  XSync(dpy,False);

  XTextExtents(font_cour,string,*nbcar,&dir,&asc,&desc,&overall);
  /*  XQueryTextExtents(dpy,font_id,string,*nbcar,&dir,&asc,&desc,&overall);*/
  /*
  printf("   Bien sorti \n");
  fflush(stdout);
  */
  *extend= overall.width;
}
/*------------------------------------------------------------------*/
void x11textextendall(char *string, int *nbcar, int *extend, int *hauteur, int *base)
{
  int dir,asc,desc;
  XCharStruct overall;

  XTextExtents(font_cour,string,*nbcar,&dir,&asc,&desc,&overall);
  /*  XQueryTextExtents(dpy,font_id,string,*nbcar,&dir,&asc,&desc,&overall); */
  *extend  = overall.width;
  *base    = overall.descent;
  *hauteur = overall.ascent + overall.descent;
}
/*------------------------------------------------------------------*/
void x11thermoini(int *iorigx, int *iorigy, int *ilarg, int *ihaut, int *ibord, int *icol1, int *icol2, int *icol3)
{
  int i,ii,x1,x2,y1,y2;

  x11loadcolor(icol3);
  XFillRectangle(dpy, drawable, gc, *iorigx, *iorigy, *ilarg, *ihaut);
  if ( *ibord > 0 )
    {
      x11loadcolor(icol1);
      for ( ii = 0 ; ii < *ibord ; ii++ )
	{
	  i = ii+1 ;
	  x1 = *iorigx - i ;
	  x2 = *iorigx + *ilarg + i ;
	  y1 = *iorigy - i ;
	  y2 = y1;
	  XDrawLine(dpy, drawable, gc, x1, y1, x2, y2);
	  x2 = x1;
	  y2 = *iorigy + *ihaut + i ;
	  XDrawLine(dpy, drawable, gc, x1, y1, x2, y2);
	}
      x11loadcolor(icol2);
      for ( ii = 0 ; ii < *ibord ; ii++ )
	{
	  i = ii+1 ;
	  x1 = *iorigx + *ilarg + i ;
	  x2 = x1;
	  y1 = *iorigy + *ihaut + i ;
	  y2 = *iorigy - i ;
	  XDrawLine(dpy, drawable, gc, x1, y1, x2, y2);
	  x1 = *iorigx - i ;
	  y2 = y1;
	  XDrawLine(dpy, drawable, gc, x1, y1, x2, y2);
	}
    }
}
/*------------------------------------------------------------------*/
void x11bord(int *ix0, int *iy0, int *ix1, int *iy1, char *string, int *lstr, int *ibord, int *icol1, int *icol2, int *icoulfond, int *icoultexte)
{
  int i,x1,x2,y1,y2;
  float ang=0;

  if ( *lstr > 0 )
    {
      x11loadcolorback(icoulfond);
      x11loadcolor(icoultexte);
      x1 = (*ix0+*ix1)/2;
      y1 = (*iy0+*iy1)/2;
      XRotDrawAlignedImageString(dpy,font_cour,ang,drawable,gc,x1,y1,string,MCENTRE);
    }
  if ( *ibord > 0 )
    {
      x11loadcolor(icol1);
      for ( i = 0 ; i < *ibord ; i++ )
	{
	  x1 = *ix0 + i ;
	  x2 = *ix1 - i ;
	  y1 = *iy1 + i ;
	  y2 = y1;
	  XDrawLine(dpy, drawable, gc, x1, y1, x2, y2);
	  x2 = x1;
	  y2 = *iy0 - i ;
	  XDrawLine(dpy, drawable, gc, x1, y1, x2, y2);
	}
      x11loadcolor(icol2);
      for ( i = 0 ; i < *ibord ; i++ )
	{
	  x1 = *ix1 - i ;
	  x2 = x1;
	  y1 = *iy0 - i ;
	  y2 = *iy1 + i ;
	  XDrawLine(dpy, drawable, gc, x1, y1, x2, y2);
	  x1 = *ix0 + i ;
	  y2 = y1;
	  XDrawLine(dpy, drawable, gc, x1, y1, x2, y2);
	}
    }
}
/*------------------------------------------------------------------*/
void x11key()
{
  MyXSelectInput(dpy, window, KeyPressMask);
}
/*------------------------------------------------------------------*/
void x11press()
{
  MyXSelectInput(dpy, window, ButtonPressMask);
}
/*------------------------------------------------------------------*/
void x11release()
{
  MyXSelectInput(dpy, window, ButtonReleaseMask);
}
/*------------------------------------------------------------------*/
int x11allevents()
{
MyXSelectInput(dpy, window, ExposureMask |
                            KeyPressMask |
                            ButtonPressMask |
                            ButtonReleaseMask |
                            PointerMotionMask |
                            ButtonMotionMask |
                            VisibilityChangeMask |
                            StructureNotifyMask |
                            FocusChangeMask );
}
/*------------------------------------------------------------------*/
void x11alleventsvraiment()
{
MyXSelectInput(dpy, window,
	       KeyPressMask	       	|
	       KeyReleaseMask  		|
	       ButtonPressMask	       	|
	       ButtonReleaseMask       	|
	       EnterWindowMask	       	|
	       LeaveWindowMask	       	|
	       PointerMotionMask       	|
	       PointerMotionHintMask   	|
	       Button1MotionMask       	|
	       Button2MotionMask       	|
	       Button3MotionMask       	|
	       Button4MotionMask       	|
	       Button5MotionMask       	|
	       ButtonMotionMask		|
	       KeymapStateMask	       	|
	       ExposureMask	       	|
	       VisibilityChangeMask    	|
	       StructureNotifyMask     	|
	       ResizeRedirectMask      	|
	       SubstructureNotifyMask  	|
	       SubstructureRedirectMask	|
	       FocusChangeMask	       	|
	       PropertyChangeMask      	|
	       ColormapChangeMask      	|
	       OwnerGrabButtonMask     	);
}
/*------------------------------------------------------------------*/
void x11enddev()
{
  XDestroyWindow(dpy,window);
  XFreePixmap(dpy,pixsauve);
  XCloseDisplay(dpy);
}
/*------------------------------------------------------------------*/
void x11clean()
{
  XClearWindow(dpy, window);
  XFlush(dpy);
}
/*------------------------------------------------------------------*/
/*
void x11szscrn0(x,y)
int *x , *y ;
{
  XWindowAttributes wattrib;

  XGetWindowAttributes(dpy, window, &wattrib);

  *x = wattrib.width;
  *y = wattrib.height;
}
*/
/*------------------------------------------------------------------*/
void x11szwin(int *x0, int *y0, int *x, int *y, int *border)
{
  Window root;
  int xulcorn,yulcorn;
  unsigned int wid,hei;
  unsigned int bor;
  unsigned int dep;
  XWindowAttributes wattrib;
             XSizeHints hints;
             long supplied_return;

  XGetWindowAttributes(dpy, window2, &wattrib);
  supplied_return = USPosition|PPosition|USSize|PSize;
  XGetWMNormalHints(dpy, window2, &hints, &supplied_return);

  printf("pop %d %d %d\n",hints.x,hints.y,wattrib.border_width);
  printf("popp %d %d %d %d\n",hints.width,hints.height,hints.width_inc,hints.height_inc);
  XGetWMSizeHints(dpy, window2, &hints, &supplied_return,USPosition);
  if (yaunpopup == 0)
    XGetGeometry(dpy,windowcour,&root,&xulcorn,&yulcorn,&wid,&hei,&bor,&dep);
  else
    XGetGeometry(dpy,window2,&root,&xulcorn,&yulcorn,&wid,&hei,&bor,&dep);

  printf("poppop %d %d %d %d\n",hints.x,hints.y,xulcorn,yulcorn);
  *x0 = hints.x;
  *y0 = hints.y;
  *x = wid;
  *y = hei;
}
/*------------------------------------------------------------------*/
void x11szscrn(int *x, int *y)
{
  Window root;
  int xulcorn,yulcorn;
  unsigned int wid,hei;
  unsigned int bor;
  unsigned int dep;

  XGetGeometry(dpy,window,&root,&xulcorn,&yulcorn,&wid,&hei,&bor,&dep);
  *x = wid;
  *y = hei;
}
/*------------------------------------------------------------------*/
void x11magfont(float *fact)
{
  XRotSetMagnification(*fact);
}
/*------------------------------------------------------------------*/
void x11txtsrnrot(char *string, int *lstr, int *x1, int *y1, float *angtext)
{
  XRotDrawAlignedString(dpy,font_cour,*angtext,drawable, gc, *x1,*y1,string,MLEFT);
  viderbuff2();
}
/*------------------------------------------------------------------*/
void x11txtsrnrot2(char *string, int *lstr, int *x1, int *y1, int *icoulfond, float *angtext)
{
  x11loadcolorback(icoulfond);
  XRotDrawAlignedImageString(dpy,font_cour,*angtext,drawable, gc, *x1,*y1,string,MLEFT);
  viderbuff2();
}
/*------------------------------------------------------------------*/
void x11txtsrnrot3(char *string, int *lstr, int *x1, int *y1, int *icoulfond, float *angtext, int *icentre, int *image)
{
  if (*image < 0)
    XRotDrawAlignedString(dpy,font_cour,*angtext,drawable
			 ,gc,*x1,*y1,string,*icentre);
  else
    {
      x11loadcolorback(icoulfond);
      XRotDrawAlignedImageString(dpy,font_cour,*angtext,drawable
				,gc,*x1,*y1,string,*icentre);
    }
}
/*------------------------------------------------------------------*/
void x11txtsrn(char *string, int *lstr, int *x1, int *y1)
{
  XDrawString(dpy, drawable, gc, *x1, *y1, string, *lstr);
  viderbuff2();
}
/*------------------------------------------------------------------*/
void x11txtsrn2(char *string, int *lstr, int *x1, int *y1, int *icoulfond)
{
  x11loadcolorback(icoulfond);
  XDrawImageString(dpy, drawable, gc, *x1, *y1, string, *lstr);
}
/*------------------------------------------------------------------*/
/*
void x11mark(string,x1,y1)
char string[];
int *x1,*y1;
{
  XDrawString(dpy, drawable, gc, *x1, *y1, string, 1);
}
*/
/*------------------------------------------------------------------*/
void x11setcurs(int *x1, int *y1)
{
  XWarpPointer(dpy, None, windowcour, None, None, None, None, *x1, *y1);
  viderbuff3();
}
/*------------------------------------------------------------------*/
/*
void x11blackwhite(i)
int *i;
{
  if ( *i > 0 )
  {
    XSetForeground(dpy,gc,foreground);
    XSetBackground(dpy,gc,background);
    XSetWindowBackground(dpy,window,background);}
  else
  {
    XSetForeground(dpy,gc,background);
    XSetBackground(dpy,gc,foreground);
    XSetWindowBackground(dpy,window,foreground);
  }
}
*/
/*------------------------------------------------------------------*/
void x11facette(XPoint *pts, int *n)
{
  int npts;

  npts = *n;
  XFillPolygon(dpy, drawable, gc, pts, npts, Shape_to_Fill, CoordModeOrigin);
}
/*------------------------------------------------------------------*/
void x11facette2(int *xxx, int *yyy, int *larg, int *haut)
{
  XFillRectangle(dpy, drawable, gc, *xxx, *yyy, *larg, *haut);
}
/* rajout FJ */
/*------------------------------------------------------------------*/
void x11polyligne(XPoint *pts, int *n)
{
  int npts;

  npts = *n;
  XDrawLines(dpy, drawable, gc, pts, npts, CoordModeOrigin);
  /*viderbuff();*/
}
/* fin rajout FJ */
/*------------------------------------------------------------------*/
void x11draw3(int *ptype)
{
  static int londash[] = {2,2,4,2,4,6,2};

/*  static unsigned char dash1[2] = {2,3};
  static unsigned char dash2[2] = {4,4};
  static unsigned char dash3[4] = {3,3,8,3};
  static unsigned char dash4[2] = {7,3};
  static unsigned char dash5[4] = {2,2,2,5};
  static unsigned char dash6[6] = {2,3,2,3,7,3};
  static unsigned char dash7[2] = {9,3};
  static unsigned char *listdash[] = {dash1,dash2,dash3,dash4,dash5,dash6,dash7};
  */
  static char dash1[2] = {2,3};
  static char dash2[2] = {4,4};
  static char dash3[4] = {3,3,8,3};
  static char dash4[2] = {7,3};
  static char dash5[4] = {2,2,2,5};
  static char dash6[6] = {2,3,2,3,7,3};
  static char dash7[2] = {9,3};
  static char *listdash[] = {dash1,dash2,dash3,dash4,dash5,dash6,dash7};

  /*  XGCValues gcvalues;*/
  int type,i,doffset=0;
/*  unsigned char temporaire[6];*/
  char temporaire[6];

  type=  *ptype;
  /*  switch (type)
    {
    case 0  : {gcvalues.line_style = LineSolid;     break;}
    default : {gcvalues.line_style = LineOnOffDash; break;}
    }*/
  /*  XChangeGC(dpy, gc, GCLineStyle, &gcvalues);*/
  if (type == 0)
    line_style = LineSolid;
  else
    {
      line_style = LineOnOffDash;
      if (line_width > 1)
	{for ( i = 0 ; i < londash[type-1] ; i++ )
	  temporaire[i] = listdash[type-1][i]*line_width;
	XSetDashes(dpy,gc,doffset,temporaire,londash[type-1]);
	}
      else
	XSetDashes(dpy,gc,doffset,listdash[type-1],londash[type-1]);
    }
  XSetLineAttributes(dpy, gc, line_width, line_style, cap_style, join_style);
}
/*------------------------------------------------------------------*/
void x11thick(int *epais)
{
  /*  XGCValues gcvalues;*/

  /*  gcvalues.line_width = *pepais;
  XChangeGC(dpy, gc, GCLineWidth, &gcvalues);*/
  line_width = (unsigned int)*epais;
  XSetLineAttributes(dpy, gc, line_width, line_style, cap_style, join_style);
}
/*------------------------------------------------------------------*/
void x11linsrn(int *x1, int *y1, int *x2, int *y2)
{
  XDrawLine(dpy, drawable, gc, *x1, *y1, *x2, *y2);
}
/*------------------------------------------------------------------*/
void getxycx11(int *ibutton, int *x1, int *y1, int *xroot, int *yroot)
{
  XEvent event;
  XEvent event2;
  int flag, flag2;
  int nb;
  XComposeStatus status;
  char buffer[3];
  static int taille_buf_maxi=2 ;
  KeySym *keysym;   /*  incidence */
  Window root;
  int xulcorn,yulcorn,doubleclick=200;
  unsigned int wid,hei,wid2,hei2;
  unsigned int bor;
  unsigned int dep;

  XGetGeometry(dpy,drawable,&root,&xulcorn,&yulcorn,&wid,&hei,&bor,&dep);

  flag=0;
  flag2=0;
  viderbuff2();
  /*
  x11allevents();
  */
  while (!flag)
    {
      /*      printf(" attend event. Events valides = %d %d %d %d\n",ButtonPress,KeyPress,MotionNotify,ConfigureNotify);
       */
      if (flag2 == 0)
	{
        XNextEvent(dpy, &event);
	if (Does_it_backing_store == 0 && yaunpopup != 0)
	  {
	    if (XCheckWindowEvent(dpy, window, ExposureMask |
                                               StructureNotifyMask |
                                               FocusChangeMask |
                                               EnterWindowMask |
                                               LeaveWindowMask |
                                               VisibilityChangeMask, &event2) )
	      {
		/*	      printf(" ca passe %d \n",yaunpopup);*/
	      mybackingput();
	      }
	  }
	}
      else
        flag2 = 0;
      /*      printf(" event type %d motionnotify %d\n", event.type,MotionNotify);*/
      if (event.type == ButtonPress)
	{
	  *x1 = event.xbutton.x;
	  *y1 = event.xbutton.y;
	  *xroot = event.xbutton.x_root;
	  *yroot = event.xbutton.y_root;
	  timeclick0 = timeclick1;
	  timeclick1 = event.xbutton.time;
	  /*	  printf(" temps %d\n",timeclick1-timeclick0);*/
	  if (event.xbutton.button == Button1)
	    *ibutton=251;
	  else if (event.xbutton.button == Button2)
	    *ibutton=252;
	  else if (event.xbutton.button == Button3)
	    *ibutton=253;
	  else if (event.xbutton.button == Button4)
	    *ibutton=254;
	  else
	    *ibutton=255;
	  /* double click :*/
	  if ( (timeclick1-timeclick0) < doubleclick )
            *ibutton=*ibutton+10;
	  flag=1;
	}
      else
	{
	  if (event.type == KeyPress)
	    {
	      *x1 = event.xkey.x;
	      *y1 = event.xkey.y;
	      *xroot = event.xkey.x_root;
	      *yroot = event.xkey.y_root;
	      /*  *ibutton= event.xkey.keycode;*/
	      /*printf(" keycode %d\n",*ibutton);*/
	      keysym=0;
	      nb = XLookupString(&event.xkey,buffer,taille_buf_maxi,keysym,&status);
	      if (nb == 0)
		{
/*
  ^   98
  <- 100
  -> 102
  v  104
  fin 103
  pg up    99
  pg down 105
*/
		  if (event.xkey.keycode > 97 && event.xkey.keycode < 106)
		    {
		      flag=1;
		      *ibutton = event.xkey.keycode + 1000;
		    }
		}
	      else
		{
		  flag=1;
		  *ibutton = buffer[0];
		  /*printf(" keycode OK %d %d %d\n",nb,keysym,*ibutton);*/
		}
	    }
	  else
	    {
	      if (event.type == MotionNotify)
		{
		  *ibutton=-1;
		  *x1 = event.xbutton.x;
		  *y1 = event.xbutton.y;
		  *xroot = event.xbutton.x_root;
		  *yroot = event.xbutton.y_root;
		  flag=1;
		}
	      else
		if (event.type == ConfigureNotify)
		  {
		    flag=1;
		    while (flag == 1)
		      {
			XNextEvent(dpy, &event);
			if (event.type == ConfigureNotify)
			  {
			    if (yaunpopup != 0 && Does_it_backing_store == 0)
			      mybackingput();
			  }
			else
			  {
			    if (event.type != Expose && event.type != NoExpose)
			      {
				flag=2;
			      }
			  }
		      }
		    XGetGeometry(dpy,drawable,&root,&xulcorn,&yulcorn,&wid2,&hei2,&bor,&dep);
		    if (wid != wid2 || hei != hei2)
		      {
			*ibutton=-2;
			*x1 = event.xbutton.x;
			*y1 = event.xbutton.y;
			*xroot = event.xbutton.x_root;
			*yroot = event.xbutton.y_root;
		      }
		    else
		      {
			flag=0;
			flag2=1;
		      }
		  }
		else
		  {
		    /*
		  if (event.type == Expose && Does_it_backing_store == 0 && yaunpopup == 0)
		    */
		    /*
		  if (event.type == Expose && Does_it_backing_store == 0)
		    */
		    /*printf(" ca passe %d %d\n",yaunpopup,event.type);*/
		  if ((event.type == Expose ||
                       event.type == EnterNotify ||
                       event.type == LeaveNotify ||
                       event.type == MotionNotify ||
                       event.type == FocusIn ||
                       event.type == FocusOut ||
                       event.type == GraphicsExpose ||
                       event.type == VisibilityNotify) && Does_it_backing_store == 0)
		    {
		      /* printf(" expose %d %d\n",yaunpopup,event.type);*/
		      if (yaunpopup != 0)
			{
			mybackingput2();
			}
		      mybackingput();
		      /*		  flag=1;
		       *ibutton=-2;*/
		    }
		  }
	      /*	else
			printf(" event.type %d %d\n",event.type,ButtonRelease);*/
	    }
	}
    }
}
/*------------------------------------------------------------------*/
void getxycx11b(int *ibutton, int *x1, int *y1, int *xroot, int *yroot)
{
  XEvent event;
  int flag;

  flag=0;
  viderbuff2();
  while (!flag)
    {
      XNextEvent(dpy, &event);
      /*    XMaskEvent(dpy,ButtonReleaseMask | PointerMotionMask, &event);*/
      if (event.type == MotionNotify)
	{
	  *ibutton=0;
	  *x1 = event.xbutton.x;
	  *y1 = event.xbutton.y;
	  *xroot = event.xbutton.x_root;
	  *yroot = event.xbutton.y_root;
	  flag=1;
	}
      else
	if (event.type == ButtonRelease)
	  {
	    *x1 = event.xbutton.x;
	    *y1 = event.xbutton.y;
	    if (event.xbutton.button == Button1)
	      *ibutton=251;
	    else if (event.xbutton.button == Button2)
	      *ibutton=252;
	    else if (event.xbutton.button == Button3)
	      *ibutton=253;
	    else if (event.xbutton.button == Button4)
	      *ibutton=254;
	    else
	      *ibutton=255;
	    flag=1;
	  }
    }
}
/*------------------------------------------------------------------*/
void getxycx11c(int *ibutton, int *x1, int *y1, int *xroot, int *yroot)
{
  XEvent event;
  Bool vraifaux;

  vraifaux = XCheckTypedEvent(dpy, ButtonPressMask , &event);
  if (vraifaux)
    {
      *x1 = event.xbutton.x;
      *y1 = event.xbutton.y;
      *xroot = event.xbutton.x_root;
      *yroot = event.xbutton.y_root;
      if (event.xbutton.button == Button1)
	*ibutton=251;
      else if (event.xbutton.button == Button2)
	*ibutton=252;
      else if (event.xbutton.button == Button3)
	*ibutton=253;
      else if (event.xbutton.button == Button4)
	*ibutton=254;
      else
	*ibutton=255;
    }
  else
    *ibutton = 0;
}
/*------------------------------------------------------------------*/
void getxycx11e(int *ibutton, int *x1, int *y1, int *xroot, int *yroot)
{
  XEvent event;
  int flag;

  flag=0;
  viderbuff2();
  while (!flag)
    {
      XNextEvent(dpy, &event);
      if (event.type == ButtonPress)
	{
	  *ibutton=0;
	  *x1 = event.xbutton.x;
	  *y1 = event.xbutton.y;
	  *xroot = event.xbutton.x_root;
	  *yroot = event.xbutton.y_root;
	  if (event.xbutton.button == Button1)
	    *ibutton=251;
	  else if (event.xbutton.button == Button2)
	    *ibutton=252;
	  else if (event.xbutton.button == Button3)
	    *ibutton=253;
	  else if (event.xbutton.button == Button4)
	    *ibutton=254;
	  else
	    *ibutton=255;
	  flag=1;
	}
    }
}
/*------------------------------------------------------------------*/
void getxycx11d(int *ikey)
{
  XEvent event;
  Bool vraifaux;

  vraifaux = XCheckTypedEvent(dpy, ButtonPressMask, &event);
  if (vraifaux)
    *ikey = 0;
  else
    *ikey = -9999;
}
/*------------------------------------------------------------------*/
void getbuttonrelease(int *iretour)
{
  XEvent event;
  Bool vraifaux;

  vraifaux = XCheckMaskEvent(dpy, ButtonReleaseMask, &event);
  if (vraifaux)
    *iretour = 1;
  else
    {
    vraifaux = XCheckMaskEvent(dpy, ButtonReleaseMask, &event);
    if (vraifaux)
      *iretour = 2;
    else
      {
	vraifaux = XCheckMaskEvent(dpy, ButtonReleaseMask, &event);
	if (vraifaux)
	  *iretour = 2;
	else
	  *iretour = 0;
      }
    }
}
/*------------------------------------------------------------------*/
void viderbuff()
{
/*  XRaiseWindow (dpy,window);*/
/*  XFlush(dpy);*/
}
/*------------------------------------------------------------------*/
int viderbuff2()
{
  XFlush(dpy);
}
/*------------------------------------------------------------------*/
int viderbuff3()
{
  XRaiseWindow(dpy, windowcour);
  XFlush(dpy);
}
/*------------------------------------------------------------------*/
void drawarc(int *x, int *y, int *width, int *height, int *angle1, int *angle2)
{
  unsigned int wid,hei;

  wid=(unsigned int)*width;
  hei=(unsigned int)*height;
  XDrawArc(dpy, drawable, gc, *x, *y, wid, hei, *angle1, *angle2);
  /*viderbuff();*/
}
/*------------------------------------------------------------------*/
void drawfilledarc(int *x, int *y, int *width, int *height, int *angle1, int *angle2)
{
  unsigned int wid,hei;

  wid=(unsigned int)*width;
  hei=(unsigned int)*height;
  XFillArc(dpy, drawable, gc, *x, *y, wid, hei, *angle1, *angle2);
  /*viderbuff();*/
}
/*------------------------------------------------------------------*/
int MyXSelectInput(Display *dpyloc, Window w, int mask)
{
  XSetWindowAttributes attributes2;
  attributes2.event_mask = mask;
  XChangeWindowAttributes(dpyloc, w, CWEventMask, &attributes2);
}
/*------------------------------------------------------------------*/
void selgraphix11()
{
  XRaiseWindow(dpy, windowcour);
/*XCirculateSubwindowsUp(dpy,window);*/
}
/*------------------------------------------------------------------*/
void seldialog()
{
  XLowerWindow(dpy,windowcour);
  XFlush(dpy);
/*XCirculateSubwindowsDown(dpy,window);
  viderbuff();*/
}
/*------------------------------------------------------------------*/
void x11taillefen(int *idx, int *idy)
{
  largeur_fenetre = (unsigned int) *idx;
  hauteur_fenetre = (unsigned int) *idy;
  XResizeWindow(dpy,windowcour,largeur_fenetre,hauteur_fenetre);
  XSync(dpy,False);
}
/*------------------------------------------------------------------*/
/*
char **MyXListFonts(nbmax, nbreel)
int nbmax;
int *nbreel;
{
  char **list;
    list = XListFonts (dpy, "*-iso88*", nbmax, nbreel);
    if (*nbreel == 0) list = XListFonts (dpy, "*", nbmax, nbreel);
    return (list) ;
}
*/
/*------------------------------------------------------------------*/
void x11cloche()
{
  static int volume=100;
  XBell(dpy,volume);
}
/*------------------------------------------------------------------*/
int mybackingsave()
{
  int z=0;
  /*
  printf("mybackingsave %d %d \n", largeur_fenetre, hauteur_fenetre);
  */
  XRaiseWindow(dpy, window);
  x11unclip();
  XCopyArea(dpy, window, pixbacking, gc, z, z, largeur_fenetre, hauteur_fenetre, z, z);
}
/*------------------------------------------------------------------*/
void mybackingsave2()
{
  int z=0;

  x11unclip();
  XCopyArea(dpy, window2, pixbacking2, gc, z, z, largeur_popup, hauteur_popup, z, z);
}
/*------------------------------------------------------------------*/
void mybackingsaveloc(int *ix0, int *iy0, int *ilar, int *ihau)
{
  XCopyArea(dpy, window, pixbacking, gc, *ix0, *iy0, *ilar, *ihau, *ix0, *iy0);
}
/*------------------------------------------------------------------*/
int mybackingput()
{
  int z=0;

  /*
  printf("on redessine %d %d \n", largeur_fenetre, hauteur_fenetre);
  */
  x11unclip();
  XCopyArea(dpy, pixbacking, window, gc, z, z, largeur_fenetre, hauteur_fenetre, z, z);
}
/*------------------------------------------------------------------*/
int mybackingput2()
{
  int z=0;

  x11unclip();
  XCopyArea(dpy, pixbacking2, window2, gc, z, z, largeur_popup, hauteur_popup, z, z);
}
/*------------------------------------------------------------------*/
void x11garderect(int *ix, int *iy, int *iw, int *ih)
{
  unsigned int width,height;

  width  = *iw;
  height = *ih;
  dest_x = *ix;
  dest_y = *iy;
  XCopyArea(dpy, windowcour, pixsauve, gc, *ix, *iy, width, height, dest_x, dest_y);
}
/*------------------------------------------------------------------*/
void x11garderect2(int *ix, int *iy, int *iw, int *ih, int *ixx, int *iyy)
{
  unsigned int width,height;

  width  = *iw;
  height = *ih;
  XCopyArea(dpy, windowcour, pixsauve, gc, *ix, *iy, width, height, *ixx, *iyy);
}
/*------------------------------------------------------------------*/
void x11metrect(int *ix, int *iy, int *iw, int *ih)
{
  unsigned int width,height;

  width  = *iw;
  height = *ih;
  XCopyArea(dpy, pixsauve, windowcour, gc, dest_x, dest_y, width, height, *ix, *iy);
}
/*------------------------------------------------------------------*/
void x11metrect2(int *ix, int *iy, int *iw, int *ih, int *ixx, int *iyy)
{
  unsigned int width,height;

  width  = *iw;
  height = *ih;
  XCopyArea(dpy, pixsauve, windowcour, gc, *ix, *iy, width, height, *ixx, *iyy);
}
/*------------------------------------------------------------------*/
void x11sauvexpm(char *filename, int *iw, int *ih)
{
  int origine=0;
  unsigned int width,height;

  XFlush(dpy);
  XMapWindow(dpy, windowcour);
  XSync(dpy,False);
  /*
  if (Does_it_backing_store == 0)
    XRaiseWindow(dpy, windowcour);
  */
  width  = *iw;
  height = *ih;

  if (largeursauvegarde == 0)
    {
      pixpoursauvegarde = XCreatePixmap(dpy, windowcour, width, height, profond);
    }
  else
    if (largeursauvegarde != width || hauteursauvegarde != height)
      {
	XFreePixmap(dpy,pixpoursauvegarde);
	pixpoursauvegarde = XCreatePixmap(dpy, windowcour, width, height, profond);
      }

  largeursauvegarde = width;
  hauteursauvegarde = height;
  XCopyArea(dpy, windowcour, pixpoursauvegarde, gc, origine, origine, width, height, origine, origine);
  /*
  XCopyArea(dpy, pixsauve, pixpoursauvegarde, gc, origine, origine, width, height, origine, origine);
  */
  XpmWriteFileFromPixmap(dpy, filename, pixpoursauvegarde, None, NULL);
}
/*------------------------------------------------------------------*/
/*
void x11sauvepix(filename,iw,ih)
int *iw,*ih;
char filename[];
{
  unsigned int width,height;
  int x_hot,y_hot;

  width  = *iw;
  height = *ih;
  x_hot = 0;
  y_hot = 0;
XWriteBitmapFile(dpy, filename, pixsauve, width, height, x_hot, y_hot);
}
*/
/*------------------------------------------------------------------*/
void x11clearrect(int *ix, int *iy, int *iw, int *ih)
{
  unsigned int debx,deby,width,height;
  Bool exposures=False;

  debx = *ix;
  deby = *iy;
  width = *iw;
  height = *ih;
  XClearArea(dpy,windowcour,debx,deby,width,height,exposures);
}
/*------------------------------------------------------------------*/
void x11effacepix()
{
  int zero=0;
  XSetForeground(dpy, gc, tabledirect[ishiftcoul]);
  XFillRectangle(dpy, pixsauve, gc, zero, zero, xmaxpixsize,ymaxpixsize);
  /*  XSetForeground (dpy, gc, tabledirect[ishiftcoul+2]);
  XDrawLine(dpy, pixsauve, gc, zero, zero, xmaxpixsize,ymaxpixsize);
  XDrawLine(dpy, pixsauve, gc, zero, ymaxpixsize, xmaxpixsize,zero);*/
}
/*------------------------------------------------------------------*/
void x11pop(int *iopt)
{
  XUnmapWindow(dpy,windowcour);
  XSync(dpy,False);
  if (yaunpopup != 0)
    if (*iopt == 0)
      {
	drawable = window;
	windowcour = window;
      }
    else
      {
	drawable = window2;
	windowcour = window2;
      }
  XMapWindow(dpy,windowcour);
  XSync(dpy,False);
}
/*------------------------------------------------------------------*/
void x11videqueue()
{
  XSync(dpy,True);
}
/*------------------------------------------------------------------*/
void x11progressif(int *iopt)
{
if (*iopt == 0)
  if (yaunpopup == 0)
    {
      drawable = window;
      windowcour = window;
    }
  else
    {
      drawable = window2;
      windowcour = window2;
    }
else
  drawable = pixsauve;
}
/*------------------------------------------------------------------*/
void x11polyconvex(int *iopt)
{
  if (*iopt == 0)
    Shape_to_Fill = Convex;
  else
    Shape_to_Fill = Complex;
}
/*------------------------------------------------------------------*/
int myusleep(int *microsecond)
/*
{
  usleep(*microsecond);
}
*/
{
  struct timeval timeout;

  if (*microsecond>0)
    {
      timeout.tv_usec = *microsecond % (unsigned long) 1000000;
      timeout.tv_sec = *microsecond / (unsigned long) 1000000;
      select(0, NULL, NULL, NULL, &timeout);
    }
}
/*------------------------------------------------------------------*/
void myusleep2()
/*
{
  usleep(1000);
}
*/
{
  struct timeval timeout;

  timeout.tv_usec = (unsigned long) 1000;
  timeout.tv_sec = (unsigned long) 0;
  select(0, NULL, NULL, NULL, &timeout);
}
