      PROGRAM GRAPH
C
C Main program of xgraphic.
C xgraphic was born in 1988 on IBM mainframe computers.
C It has been freely distributed in various binary versions since 1995.
C It is a free software under the Gnu Public License since July 2003
C (as part of the xd3d package).
C Its main author is Francois Jouve <francois.jouve@polytechnique.fr>
C http://www.cmap.polytechnique.fr/~jouve/xd3d
C
      INCLUDE 'param.f'
C
      REAL*8  XX(NTMAX),YY(NTMAX)
      INTEGER SAUVTABCO(256),NMARK1(NCMAX),NINTER(NCMAX)
      LOGICAL*4 LXX(NTMAX),LYY(NTMAX),WILD,SIGN,TROUVE,TRUE,FALSE
      CHARACTER*1   LEG(132,NCMAX)
      CHARACTER*4   CHIFFRE
      CHARACTER*80  PROG
      CHARACTER*29  CCOOR
      CHARACTER*130 BLANC
      CHARACTER*512 CBID
      CHARACTER DATE*6,MOI*8,KINFO*80
      EQUIVALENCE (LEGEND,LEG)
C
      PARAMETER (LWORK=5000)
      DIMENSION WORK(LWORK),XBID(2),YBID(2)
      CHARACTER*20 CEXP
      CHARACTER*3  CC
C
      CHARACTER*256 MOELLE
      COMMON / SOUTERRAIN / MOELLE,LMOELLE,INOMBRE_VAR
C
      INCLUDE 'Version.f'
C
      CALL perfide(ILANG,IDEBUG)
      CALL BERLITZ(ILANG)
      LANGDEF = ILANG.EQ.0
C
      FRANCAIS = LANGDEF
      CALL ENLEVE_TOUS_BLANCS(PROBIG,LPROB,64)
C
      DO I=1,130
        BLANC(I:I) = ' '
      ENDDO
      DO I=1,NCMAX
        DO J=1,132
          LEG(J,I) = ' '
        ENDDO
        NPREG(1,I) = 0
        NPREG(2,I) = 0
      ENDDO
      TRUE  = .TRUE.
      FALSE = .FALSE.
      NABS = 0
      NORD = 0
      NGEN = 0
      NBCOL0 = 16
      NPTOT  = 0
      ISPEED = 0
C
      ICLIC  = 0
      IENG   = 1
      ITOUCX = 0
      ITOUCY = 0
      FACWIN = 1.
      FACMS  = 0.
      HXA4   = 27.7
      HXA4B  = 23.7
      HYA4   = 19.
      INTERP = 0
      INOMBRE_VAR = 1
      IAHELP = 1
      IARON  = 0
      IAXES  = 0
      IBAR   = 1
      IBATCH = 0
      ICADLEG = 0
cc      ICOLM  = 2
      IDEB   = 0
      IDEBU  = 0
      IDEFT  = 1
      IDISC  = 1
      IECHANGE = 1
      IFILM  = 0
      IGROS  = 0
      IFLAGEC= 0
      IFONT0 = 0
      IFONT1 = 1
      IFONT2 = 2
      IFONT3 = 3
      ILATEX = 0
      ILISS  = 1
      ILOGXOK = 0
      ILOGYOK = 0
      ILOGX  = 1
      ILOGY  = 1
      IMARK  = 1
      IMONO0 = 0
      IMONO  = 1
      INEWGR = 0
      IOPT   = 1
      IORTHO = 0
      IPOST  = 1
      IPROX  = 98
      IPROY  = 68
      IPROXINI = IPROX
      IPROYINI = IPROY
      IPTILEG = 0
      IQUADR = 1
      IREGRE = 1
      ISAFE  = 0
      ISTDOUT= 0
      ITIMEX = 0
      ITIMEY = 0
      MINMAX = 0
      NEWFON = 0
      NLEG2  = 0
      NSEG   = 1
      PROG   = 'xgr'
      LPROG  = 3
      LPSUTIL = 0
      LONPS  = 0
      PROP   = HXA4/HYA4
      BIG    = 1.E30
      XMINBA = BIG
      XMAXBA = -BIG
      YMINBA = BIG
      YMAXBA = -BIG
C 2^1/4
      ZOOM   = 1.189207115
      NPPM   = 0
      DO I=1,NCMAX
        ILT(I)   = ILT0(I)
        ICOL(I)  = ICOL0(I)
        IEPL(I)  = IEPL0(I)
        NMARK(I) = 0
        NMARK1(I)= NMARK0(I)
        ICOLM(I) = ICOLM0(I)
        TM(I)    = TM0(I)
      ENDDO
      CALL MA_SOURIS('0','H','/','I','J')
      IPFGAUCHE = 0
      IPFMILIEU = 17
      IPFDROITE = -1
C
C Pas portable
C
      NCOURB = IARGC()
      CALL GETARG(0,PROGEFF)
      CALL ENLEVE_TOUS_BLANCS(PROGEFF,LPROGEFF,80)
 3232 IF (NCOURB.EQ.0) THEN
        PRINT*,' '
        IF (FRANCAIS) THEN
          CALL LIENTIER('Nombre de courbes  tracer ?',0,NCOURB)
        ELSE
          CALL LIENTIER('Number of files to plot?',0,NCOURB)
        ENDIF
        IF (NCOURB.GT.NCMAX) THEN
          IF (FRANCAIS) THEN
            PRINT*,'Le maximum est',NCMAX
          ELSE
            PRINT*,'The maximum is',NCMAX
          ENDIF
          NCOURB = NCMAX
        ENDIF
        NCOURB = MAX(1,NCOURB)
        IRESERVE = 0
        IPASLEG = 0
      ELSE
C
C Pas portable
C
        IRESERVE = MIN(NCOURB,NCMAX+50)
        NBOPT = 0
        DO I=1,NCOURB
          CALL GETARG(I,FICHIER(I))
          CALL ENLEVE_TOUS_BLANCS(FICHIER(I),LONG(I),128)
          IF (FICHIER(I)(1:1).EQ.'-') NBOPT = NBOPT+1
          IF (FICHIER(I)(1:4).EQ.'-tit') NBOPT = NBOPT+1
        ENDDO
        IF (NBOPT.GT.0) THEN
          NLEG = 0
          CALL LIOP(NBOPT,NBOPT2,NMARK1,XMINBA,XMAXBA,YMINBA,YMAXBA)
          IF (IECHANGE.EQ.-1) IFLAGEC = 1
          NBOPT = NBOPT-NBOPT2
          NCOURB = MIN(NCOURB-NBOPT,NCMAX)
          IRESERVE = NCOURB
          DO I=1,NCOURB
            LONG(I) = LONG(I+NBOPT)
            FICHIER(I) = FICHIER(I+NBOPT)
          ENDDO
          IF (IABS(IOPT).GE.10.AND.NLEG.EQ.0) THEN
            DO I=1,NCOURB
              LEGEND(I) = FICHIER(I)(1:LONG(I))
              NLEG = MAX(NLEG,LONG(I))
            ENDDO
            IF (IPTILEG.NE.0) THEN
              IF (NCOURB.LE.15) THEN
                IPTILEG = 1
              ELSE
                IPTILEG = 2
              ENDIF
            ELSE
              IF (NCOURB.LE.15) THEN
                IPTILEG = 0
              ELSEIF(NCOURB.LE.34) THEN
                IPTILEG = 1
              ELSE
                IPTILEG = 2
              ENDIF
            ENDIF
          ENDIF
        ELSE
          NCOURB = MIN(NCOURB,NCMAX)
          IRESERVE = NCOURB
        ENDIF
C
        IF (NCOURB.LE.0) GOTO 3232
        IF (ISTDOUT.EQ.0) THEN
          IF (FRANCAIS) THEN
            IF (NCOURB.GT.1) THEN
              PRINT*,'On va tracer',NCOURB,' courbes'
            ELSEIF(NCOURB.EQ.1) THEN
              PRINT*,'On va tracer une seule courbe'
            ENDIF
            PRINT*,'Nombre de points maximal =',MEM
          ELSE
            IF (NCOURB.GT.1) THEN
              PRINT*,'I''m gonna plot',NCOURB,' files'
            ELSEIF(NCOURB.EQ.1) THEN
              PRINT*,'I''m gonna plot only one file'
            ENDIF
            PRINT*,'Maximum number of points =',MEM
          ENDIF
        ENDIF
        IPASLEG = 1
      ENDIF
C
      XMIN = BIG
      XMAX = -BIG
      YMIN = BIG
      YMAX = -BIG
    1 DO 5 I=1,NCOURB
        NDEB(I) = NPTOT
        XXMIN(I) = BIG
        XXMAX(I) = -BIG
        YYMIN(I) = BIG
        YYMAX(I) = -BIG
        IF (I.LT.10) THEN
          WRITE(CHIFFRE,'(I2)') I
          IL = 2
        ELSEIF(I.LT.100) THEN
          WRITE(CHIFFRE,'(I3)') I
          IL = 3
        ELSE
          WRITE(CHIFFRE,'(I4)') I
          IL = 4
        ENDIF
 1234   IF (IRESERVE.EQ.0.AND.IPASLEG.EQ.0) THEN
          IF (FRANCAIS) THEN
            CALL LIFICH('Fichier contenant la courbe'
     &      //CHIFFRE(1:IL)//' ? (# -> fonction interprte)'
     &               ,0,FICHIER(I),LONG(I))
          ELSE
            CALL LIFICH('File containing plot no.'
     &      //CHIFFRE(1:IL)//'? (# -> keyboard function)'
     &               ,0,FICHIER(I),LONG(I))
          ENDIF
          IF (WILD(FICHIER(I),LONG(I))) THEN
            CALL EXEC('ls '//FICHIER(I)(1:LONG(I))//'>/tmp/bidgraph')
            CALL PREMIER_LIBRE(IBID)
            OPEN(IBID,FILE='/tmp/bidgraph')
            DO K=I,NCMAX
              FICHIER(K) = '                                '
              READ(IBID,'(A)',END=4321) FICHIER(K)
              IRESERVE = IRESERVE+1
              LONG(K) = 129
 5678         LONG(K) = LONG(K)-1
              IF (FICHIER(K)(LONG(K):LONG(K)).EQ.' ') GOTO 5678
            ENDDO
 4321       CLOSE(IBID)
            CALL EXEC('\rm -f /tmp/bidgraph')
            IF (ISTDOUT.EQ.0) THEN
              LBB = LONG(I)/10
              LCC = 10*(LBB+1)
              IF (FRANCAIS) THEN
                WRITE(*,'(A,$)')
     &               '>>> Ouverture de '//FICHIER(I)(1:LONG(I))
     &               //BLANC(LONG(I)+1:LCC)
              ELSE
                WRITE(*,'(A,$)')
     &               '>>> Opening '//FICHIER(I)(1:LONG(I))
     &               //BLANC(LONG(I)+1:LCC)
              ENDIF
            ENDIF
          ENDIF
          IF (FICHIER(I)(LONG(I):LONG(I)).EQ.'@') THEN
            LONG(I) = LONG(I)-1
            IPOST = -1
            IBATCH = 1
          ENDIF
        ELSEIF(IRESERVE.EQ.0.AND.IPASLEG.NE.0) THEN
          IF (ISTDOUT.EQ.0) THEN
            IF (FRANCAIS) THEN
              IF (I.GT.2) THEN
                PRINT*,'Il n''y a en fait que',I-1
     &               ,' fichiers utilisables'
              ELSE
                PRINT*,'Il n''y a en fait que',I-1,' fichier utilisable'
              ENDIF
            ELSE
              IF (I.GT.2) THEN
                PRINT*,'Only',I-1,' files I can use'
              ELSE
                PRINT*,'Only',I-1,' file I can use'
              ENDIF
            ENDIF
          ENDIF
          NCOURB = I-1
          IF (NCOURB.LT.1) THEN
            NCOURB = 1
            IRESERVE = 0
            IPASLEG  = 0
            GOTO 1
          ENDIF
          GOTO 6
        ELSE
          IF (ISTDOUT.EQ.0) THEN
            LBB = LONG(I)/10
            LCC = 10*(LBB+1)
            IF (FRANCAIS) THEN
              WRITE(*,'(A,$)')
     &             '>>> Ouverture de '//FICHIER(I)(1:LONG(I))
     &               //BLANC(LONG(I)+1:LCC)
            ELSE
              WRITE(*,'(A,$)')
     &             '>>> Opening '//FICHIER(I)(1:LONG(I))
     &               //BLANC(LONG(I)+1:LCC)
            ENDIF
          ENDIF
        ENDIF
        IF (FICHIER(I)(1:1).EQ.'#') THEN
          IF (MEM-NPTOT.LT.2) THEN
            IF (FRANCAIS) THEN
              PRINT*,'*** Plus de mmoire'
            ELSE
              PRINT*,'*** No more memory'
            ENDIF
            STOP
          ENDIF
          INTERP = INTERP+1
          NINTER(INTERP) = I
          IF (FRANCAIS) THEN
            CALL LIENTIER('Nombre de points ?',0,NPOINT(I))
          ELSE
            CALL LIENTIER('Number of points?',0,NPOINT(I))
          ENDIF
          NPOINT(I) = MAX(2,MIN(MEM-NPTOT,NPOINT(I)))
          IF (FRANCAIS) THEN
            CALL LI2REEL1('Entrez les bornes Xmin et Xmax',0,XXMI,XXMA)
          ELSE
            CALL LI2REEL1('Enter bounds Xmin and Xmax',0,XXMI,XXMA)
          ENDIF
          IF (XXMI.GT.XXMA) CALL ECHR(XXMI,XXMA)
          IF (XXMI.LT.0.) ILOGXOK = 1
          PAS = (XXMA-XXMI)/REAL(NPOINT(I)-1)
          CALL INITIS(WORK,LWORK,0,0)
 30       IF (FRANCAIS) THEN
            WRITE(*,'(a)') '>>> Tapez '//
     &'l''expression (une seule ligne, syntaxe Fortran, variable x)'
          ELSE
            WRITE(*,'(a)')
     &'>>> Type the expression (one line, Fortran syntax, x variable)'
          ENDIF
          LFON = 400
          CALL FONINI(WORK,LFON,ICODE)
          CALL FONDEF(WORK,CEXP,IFON,ICODE)
          IF (ICODE.NE.0) GOTO 30
          YYMI = 1.
          DO K=1,NPOINT(I)
            J = NDEB(I)+K
            XPOINT(J) = XXMI + REAL(K-1)*PAS
            CALL FON1RR(WORK,IFON,XPOINT(J),YPOINT(J),ICODE)
            XMIN = MIN(XMIN,XPOINT(J))
            XMAX = MAX(XMAX,XPOINT(J))
            YMIN = MIN(YMIN,YPOINT(J))
            YMAX = MAX(YMAX,YPOINT(J))
            YYMI = MIN(YYMI,YPOINT(J))
C
            XXMIN(I) = MIN(XXMIN(I),XPOINT(J))
            XXMAX(I) = MAX(XXMAX(I),XPOINT(J))
            YYMIN(I) = MIN(YYMIN(I),YPOINT(J))
            YYMAX(I) = MAX(YYMAX(I),YPOINT(J))
          ENDDO
          IF (YYMI.LT.0.) ILOGYOK = 1
          NTROU(I) = 0
          ITROU(NDEB(I)+1) = NPOINT(I)
          FICHIER(I) = MOELLE(1:LMOELLE)
          LONG(I) = LMOELLE
          NPTOT = NPTOT+NPOINT(I)
        ELSE
          IGR = 10+I
          CALL CHERCHE_COLONNES(FICHIER(I),LONG(I),LONGEFF,ICOL1,ICOL2)
          OPEN(10,FILE=FICHIER(I)(1:LONGEFF),STATUS='OLD',IOSTAT=IERR)
          IF (IERR.NE.0) THEN
            PRINT*,' '
            IF (FRANCAIS) THEN
              PRINT*,
     &        '*** Problme avec le fichier '//FICHIER(I)(1:LONG(I))//
     &        ' - recommencez'
            ELSE
              PRINT*,
     &        '*** Trouble with the file '//FICHIER(I)(1:LONG(I))//
     &        ' - try again'
            ENDIF
            IF (IRESERVE.NE.0) CALL DECAL(IRESERVE,FICHIER(I),LONG(I))
            GOTO 1234
          ENDIF
          CALL LECTUR(IGR,NCOL,ICOL1,ICOL2)
          IF (NPOINT(I).EQ.0) THEN
            IF (IRESERVE.NE.0) CALL DECAL(IRESERVE,FICHIER(I),LONG(I))
            GOTO 1234
          ELSEIF(IRESERVE.NE.0) THEN
            IRESERVE = IRESERVE-1
            NPPM = MAX(NPPM,NPOINT(I))
          ENDIF
        ENDIF
    5 CONTINUE
C
      PRINT*,' '
      IF (NCOURB.GT.1) THEN
        IF (FRANCAIS) THEN
          PRINT*,'Nombre total de points =',NPTOT
        ELSE
          PRINT*,'Total number of points =',NPTOT
        ENDIF
        PRINT*,' '
      ENDIF
C
    6 SIZCAR = 1.
      IIABS = 1
      IORD  = 1
      DATE = KINFO('DATE')
      MOI  = KINFO('UTILISATEUR')
      WRITE(CHIFFRE,'(I4)') NCOURB
      IF (FRANCAIS) THEN
        IF (NCOURB.GT.1) THEN
          MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &    //CHIFFRE//' courbes'
        ELSE
          MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &    //CHIFFRE//' courbe '
        ENDIF
      ELSE
        IF (NCOURB.GT.1) THEN
          MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &    //CHIFFRE//' plots  '
        ELSE
          MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &    //CHIFFRE//' plot   '
        ENDIF
      ENDIF
      IF (IPASLEG.EQ.0) THEN
C
C Lecture des titre en abscisse et en ordonnee
C
 2      IF (FRANCAIS) THEN
          CALL LILIGNE('Titre en abscisse ?',0,ABSC,NABS)
          CALL LILIGNE('Titre en ordonne ?',0,ORDON,NORD)
          CALL LILIGNE('Titre gnral ?',0,GENE,NGEN)
cc          call accent(absc,nabs,nabs2)
cc          nabs = nabs2
        ELSE
          CALL LILIGNE('X axis title?',0,ABSC,NABS)
          CALL LILIGNE('Y axis title?',0,ORDON,NORD)
          CALL LILIGNE('General title?',0,GENE,NGEN)
        ENDIF
        IF (NABS.EQ.1.AND.ABSC(1:1).EQ.' ')  NABS = 0
        IF (NORD.EQ.1.AND.ORDON(1:1).EQ.' ') NORD = 0
        IF (NGEN.EQ.1.AND.GENE(1:1).EQ.' ')  NGEN = 0
      ENDIF
C
C Boucle sur les fichiers
C
 1113 IF (IDEB.NE.0) THEN
Cfj        IF (ISTDOUT.EQ.0) THEN
Cfj          IF (FRANCAIS) THEN
Cfj            PRINT*,'Nombre de points maximal =',MEM
Cfj          ELSE
Cfj            PRINT*,'Maximum number of points =',MEM
Cfj          ENDIF
Cfj        ENDIF
        XMINSAUV = XMIN
        XMAXSAUV = XMAX
        YMINSAUV = YMIN
        YMAXSAUV = YMAX
        XMIN = BIG
        XMAX = -BIG
        YMIN = BIG
        YMAX = -BIG
        DO I=1,NCOURB
          IGR = 10 + I
          XXMIN(I) = BIG
          XXMAX(I) = -BIG
          YYMIN(I) = BIG
          YYMAX(I) = -BIG
          CALL CHERCHE_COLONNES(FICHIER(I),LONG(I),LONGEFF,ICOL1,ICOL2)
          OPEN(10,FILE=FICHIER(I)(1:LONGEFF),STATUS='OLD',IOSTAT=IERR)
          CALL LECTUR(IGR,NCOL,ICOL1,ICOL2)
          NPPM = MAX(NPPM,NPOINT(I))
          IF (IGR.LT.0) GOTO 1113
        ENDDO
        XMIN00 = XMIN
        XMAX00 = XMAX
        YMIN00 = YMIN - 0.05*(YMAX-YMIN)
        YMAX00 = YMAX + 0.05*(YMAX-YMIN)
        XMIN = XMINSAUV
        XMAX = XMAXSAUV
        YMIN = YMINSAUV
        YMAX = YMAXSAUV
      ENDIF
      IF (IDEBU.EQ.0) THEN
        IF (FACMS.LE.0.) THEN
          IF (NPPM.GT.1000) THEN
            DO I=1,NCMAX
              TM(I) = TM(I)*0.4
            ENDDO
          ELSEIF(NPPM.GT.100) THEN
            DO I=1,NCMAX
              TM(I) = TM(I)*0.7
            ENDDO
          ENDIF
        ELSE
            DO I=1,NCMAX
              TM(I) = TM(I)*FACMS
            ENDDO
        ENDIF
      ENDIF
C
      IF (XMIN.EQ.XMAX) THEN
        XMIN = XMIN - 0.5*(YMAX-YMIN)
        XMAX = XMAX + 0.5*(YMAX-YMIN)
      ENDIF
      IF (YMIN.EQ.YMAX) THEN
        YMIN = YMIN - 0.5*(XMAX-XMIN)
        YMAX = YMAX + 0.5*(XMAX-XMIN)
      ENDIF
      PETIPETI = 1.E-30
      IF (((XMAX-XMIN)/(YMAX-YMIN)).LT.PETIPETI) THEN
        XMIN = XMIN - 0.5*(YMAX-YMIN)*PETIPETI
        XMAX = XMAX + 0.5*(YMAX-YMIN)*PETIPETI
      ELSEIF(((YMAX-YMIN)/(XMAX-XMIN)).LT.PETIPETI) THEN
        YMIN = YMIN - 0.5*(XMAX-XMIN)*PETIPETI
        YMAX = YMAX + 0.5*(XMAX-XMIN)*PETIPETI
      ENDIF
      IF (IDEB.EQ.0) THEN
        XMIN00 = XMIN
        XMAX00 = XMAX
        YMIN00 = YMIN - 0.05*(YMAX-YMIN)
        YMAX00 = YMAX + 0.05*(YMAX-YMIN)
        IF (XMINBA.NE.BIG .OR.YMINBA.NE.BIG
     &  .OR.XMAXBA.NE.-BIG.OR.YMAXBA.NE.-BIG) THEN
          IF (XMINBA.NE.BIG) THEN
            XMIN = XMINBA
            XMINBA = BIG
          ENDIF
          IF (YMINBA.NE.BIG) THEN
            YMIN = YMINBA
            YMINBA = BIG
          ENDIF
          IF (XMAXBA.NE.-BIG) THEN
            XMAX = XMAXBA
            XMAXBA = -BIG
          ENDIF
          IF (YMAXBA.NE.-BIG) THEN
            YMAX = YMAXBA
            YMAXBA = -BIG
          ENDIF
        ELSE
          XMIN = XMIN00
          XMAX = XMAX00
          YMIN = YMIN00
          YMAX = YMAX00
        ENDIF
      ELSE
        IDEB = 0
      ENDIF
      XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
C
      IF (ITIMEX.EQ.-2.AND.XMAX-XMIN.GE.1.) ITIMEX = -1
      IF (ITIMEY.EQ.-2.AND.YMAX-YMIN.GE.1.) ITIMEY = -1
C
      IF (IBATCH.EQ.0) THEN
        IPROXN = NINT(REAL(IPROX)*FACWIN)
        IPROYN = NINT(REAL(IPROY)*FACWIN)
        CALL FSINN(IPROXN,IPROYN,PROBIG,IDEBU,ITERMC)
        CALL x11nomicone('Xgraphic'//char(0),8)
        CALL x11askbacking(IBACKINGSTORE)
        IF ((ITERMC.EQ.3.OR.ITERMC.EQ.4).AND.IMONO0.EQ.0) THEN
          IMONO = 1
        ELSE
          IMONO = -1
        ENDIF
        IF (IDEBU.EQ.0) THEN
          CALL x11szscrn(IDXINI,IDYINI)
          FACPIX = REAL(IDXINI)/REAL(IPROXINI)
          FACPIY = REAL(IDYINI)/REAL(IPROYINI)
          IDEBU = 1
        ENDIF
      ELSE
        CALL FSINN(IPROX,IPROY,PROBIG,-99,ITERMC)
      ENDIF
      CALL PAPERCOLOR(1)
C
 99   TOTO1 = XMAX-XMIN
      TOTO2 = MAX(ABS(XMIN),ABS(XMAX))
      JHELP = 0
      IF (ILOGX.GE.0.AND.(TOTO2.GE.GRAND.OR.TOTO1.LE.PETIT)) THEN
        NDXMIN = 20
      ELSE
        NDXMIN = 50
      ENDIF
      IF (IGROS.EQ.1) THEN
        NDXMIN = NINT(REAL(NDXMIN)*0.5)
      ELSEIF(IGROS.EQ.2) THEN
        NDXMIN = NINT(REAL(NDXMIN)*0.2)
      ENDIF
      IF (INEWGR.NE.0) THEN
        XMIN = XMISAU
        XMAX = XMASAU
      ELSE
        XMISAU = XMIN
        XMASAU = XMAX
      ENDIF
      CALL ARONDI(XMIN,XMAX,XX,LXX,NDX,ILOGX,NTMAX,IARON,NDXMIN)
      IF (NDX.GT.NDXMIN*3) THEN
        ISAUTX = 1
      ELSE
        ISAUTX = 0
      ENDIF
 101  NDXMIN = 50
      IF (IGROS.EQ.1) THEN
        NDXMIN = NINT(REAL(NDXMIN)*0.5)
      ELSEIF(IGROS.EQ.2) THEN
        NDXMIN = NINT(REAL(NDXMIN)*0.2)
      ENDIF
      IF (INEWGR.NE.0) THEN
        INEWGR = 0
        YMIN = YMISAU
        YMAX = YMASAU
      ELSE
        YMISAU = YMIN
        YMASAU = YMAX
      ENDIF
      CALL ARONDI(YMIN,YMAX,YY,LYY,NDY,ILOGY,NTMAX,IARON,NDXMIN)
      IF (NDY.GT.NDXMIN*3) THEN
        ISAUTY = 1
      ELSE
        ISAUTY = 0
      ENDIF
      IARON = 0
      NLEG2 = 0
      IF (IFLAGEC.NE.0) THEN
        IECHANGE = 1
        GOTO 2020
      ENDIF
C
 102  XC = (XMIN+XMAX)*0.5
      YC = (YMIN+YMAX)*0.5
      DX = (XMAX-XMIN)*0.5
      DY = (YMAX-YMIN)*0.5
      IF (PROP.GT.1.) THEN
        PROBID = PROP
      ELSEIF(PROP.LT.1.) THEN
        PROBID = 1.7*PROP
      ELSE
        PROBID = 1.2*PROP
      ENDIF
      IF (IGROS.EQ.0) THEN
        SIZCAR = 1.
      ELSEIF(IGROS.EQ.1) THEN
        SIZCAR = SQRT(1./0.65)
      ELSE
        SIZCAR = 1./0.65
      ENDIF
      XX0 = XC-DX*(1. + (0.05 + (0.15+0.075*REAL(IORD))*SIZCAR) )
      YY0 = YC-DY*(1. + REAL(1+IIABS)*0.1*SIZCAR*PROBID)
      XHELP = XC + DX*1.05
      YY1 = YC+DY*(1. + 0.04*SIZCAR*SIZCAR*PROBID)
      IF (IBATCH.NE.0.AND.IORTHO.EQ.0) THEN
        IF (ISTDOUT.EQ.0) THEN
          IF (FRANCAIS) THEN
            PRINT*,'On travaille en batch'
          ELSE
            PRINT*,'Batch mode'
          ENDIF
        ENDIF
        IPOSTCOL = 0
        IF (IBATCH.EQ.1.OR.IBATCH.EQ.4) THEN
          ILATEX = 1
          XLARG = HYA4
          XHAUT = XLARG/PROP
          IF (IBATCH.EQ.1) THEN
            CALL INITPS(9,XLARG,XHAUT,0.,PROG(1:LPROG)//'tex',LPROG+3
     &                 ,NOMPS,LONPS,IPOSTCOL)
          ELSE
            CALL INITPS(9,XLARG,XHAUT,0.,PROG(1:LPROG)//'coltex',LPROG+6
     &                 ,NOMPS,LONPS,IPOSTCOL)
          ENDIF
          IF (LONPS.LT.0) STOP
          CALL ECOP(CBID,LBID)
          IF (IBATCH.EQ.1) THEN
            CBID(LBID+1:LBID+6) = '-pstex'
            LBID = LBID+6
          ELSE
            CBID(LBID+1:LBID+9) = '-pscoltex'
            LBID = LBID+9
            IPOSTCOL = 1
          ENDIF
          IF (ISTDOUT.EQ.0) THEN
            IFP = 9
          ELSE
            IFP = 6
          ENDIF
          IF (FRANCAIS) THEN
            WRITE(IFP,'(A)')
     &'%> Fichier PostScript pour LaTeX gnr en batch avec :'
            DO I=1,NCOURB
              WRITE(IFP,'(A)') '%>     '//FICHIER(I)(1:LONG(I))
            ENDDO
            WRITE(IFP,'(A)') '%> et les options : '//CBID(1:LBID)
          ELSE
            WRITE(IFP,'(A)')
     &'%> PostScript file for LaTeX generated with data files:'
            DO I=1,NCOURB
              WRITE(IFP,'(A)') '%>     '//FICHIER(I)(1:LONG(I))
            ENDDO
            WRITE(IFP,'(A)') '%> and options: '//CBID(1:LBID)
          ENDIF
          LBID = 0
          ZERO = 0.
          CALL INPRFD(IFP,FALSE,FALSE,FALSE,XLARG,XHAUT,ZERO
     &               ,CBID,LBID,IPOSTCOL)
          IF (IBATCH.EQ.4) THEN
            CALL LITTABLE(SAUVTABCO,NBCOL0)
            CALL METTABLE(SAUVTABCO,NBCOL0)
          ENDIF
        ELSE
          ILATEX = 0
          ANGLE = -90.
          XLARG = HXA4
          XHAUT = HYA4
          IF (IBATCH.EQ.3) THEN
            IPOSTCOL = 1
            CBID(LBID+1:LBID+6) = '-pscol'
            LBID = LBID+6
          ELSE
            CBID(LBID+1:LBID+3) = '-ps'
            LBID = LBID+3
          ENDIF
          CALL INITPS(9,XLARG,XHAUT,ANGLE,PROG(1:LPROG),LPROG
     &               ,NOMPS,LONPS,IPOSTCOL)
          IF (LONPS.LT.0) STOP
          CALL ECOP(CBID,LBID)
          IF (FRANCAIS) THEN
            WRITE(9,'(A)')
     &'%> Fichier PostScript gnr en batch avec les donnees :'
            DO I=1,NCOURB
              WRITE(9,'(A)') '%>     '//FICHIER(I)(1:LONG(I))
            ENDDO
            WRITE(9,'(A)') '%> et les options : '//CBID(1:LBID)
          ELSE
            WRITE(9,'(A)')
     &'%> PostScript file generated with data files:'
            DO I=1,NCOURB
              WRITE(9,'(A)') '%>     '//FICHIER(I)(1:LONG(I))
            ENDDO
            WRITE(9,'(A)') '%> and options: '//CBID(1:LBID)
          ENDIF
          LBID = LONG(1)+1
          CBID(1:LBID) = FICHIER(1)(1:LONG(1))//' '
          IF (NCOURB.GT.1) THEN
            IFLAG = 0
            DO I=2,NCOURB
              IF (IFLAG.EQ.0) THEN
                IF ((LBID+LONG(I)+1).GT.510) THEN
                  CBID(LBID+1:512) = '...........................'
                  LBID = MIN(512,LBID+3)
                  IFLAG = 1
                ELSE
                  LBID0 = LBID+1
                  LBID  = LBID0+LONG(I)
                  CBID(LBID0:LBID) = FICHIER(I)(1:LONG(I))//' '
                ENDIF
              ENDIF
            ENDDO
          ENDIF
cc          CALL INPRFD(9,FALSE,FALSE,TRUE,XLARG,XHAUT,ANGLE
          CALL INPRFD(9,FALSE,FALSE,FALSE,XLARG,XHAUT,ANGLE
     &               ,CBID,LBID,IPOSTCOL)
          IF (IBATCH.EQ.3) THEN
            CALL LITTABLE(SAUVTABCO,NBCOL0)
            CALL METTABLE(SAUVTABCO,NBCOL0)
          ENDIF
        ENDIF
      ENDIF
C
 999  CONTINUE
CC      CALL GSSEG(NSEG)
CC      CALL GSCLR
      CALL GSMIX(0)
      IF (IMONO.EQ.1) THEN
        ICOLTMP = 5
      ELSE
        ICOLTMP = 7
      ENDIF
      IF (IPOST.EQ.1.AND.IFILM.LE.1) THEN
        XXX1 = XHELP+0.4*(XHELP-XX0)/PROBID
      ELSE
        XXX1 = XHELP
      ENDIF
      PROPV = PROP*(XMAX-XMIN)*(YY1-YY0)/((YMAX-YMIN)*(XHELP-XX0))
      IF (IORTHO.EQ.1) THEN
        DX = (XMAX-XMIN)*0.5
        DY = (YMAX-YMIN)*0.5
        RAP = DX/DY
        XMIN000 = XMIN
        XMAX000 = XMAX
        YMIN000 = YMIN
        YMAX000 = YMAX
        IF (RAP.GT.PROPV) THEN
          DY = DX/PROPV
          YC = 0.5*(YMIN+YMAX)
          YMIN = YC - DY
          YMAX = YC + DY
          ITOUCY = -1
        ELSE
          DX = PROPV*DY
          XC = 0.5*(XMIN+XMAX)
          XMIN = XC - DX
          XMAX = XC + DX
          ITOUCX = -1
        ENDIF
        IORTHO = 0
        GOTO 99
      ENDIF
      DDDX = XXX1-XX0
      DDDY = YY1-YY0
      PROP2 = PROP*DDDX/(XHELP-XX0)
      SPROP = SQRT(PROP2)
      IF (IPOST.EQ.-1) THEN
        IF (ISTDOUT.EQ.0) THEN
          IFP = 9
        ELSE
          IFP = 6
        ENDIF
        IF (FRANCAIS) THEN
          WRITE(IFP,'(A,G13.5," x",G13.5)')
     &         '%> Dimensions reelles     : ',DDDX,DDDY
        ELSE
          WRITE(IFP,'(A,G13.5," x",G13.5)')
     &         '%> Actual dimensions      : ',DDDX,DDDY
        ENDIF
      ENDIF
      CALL GSWINEW(XX0,DDDX,YY0,DDDY,PROP2)
cc      CALL x11szscrn(IDX,IDY)
      IF (IBATCH.EQ.0) THEN
        CALL GETIDX(IDX,IDY,IECPIXX,IECPIXY)
        IF (NEWFON.EQ.0) THEN
          FACPIX = REAL(IDX)/(REAL(IPROXINI)*FACWIN)
          FACPIY = REAL(IDY)/(REAL(IPROYINI)*FACWIN)
          FACWIN = 1.
          NEWFON = 1
          IF (IGROS.NE.0) THEN
            FAFA = MIN(REAL(IDX)/(FACPIX*REAL(IPROXINI))
     &                ,REAL(IDY)/(FACPIY*REAL(IPROYINI)))
            CALL PTIFON(FAFA,IFONT0,IFONT1,IFONT2,IFONT3,IGROS)
            FACWIN = FAFA
          ENDIF
        ELSEIF((IPOST.EQ.1.OR.IGROS.NE.0).AND.IFILM.LE.1) THEN
          FAFA = MIN(REAL(IDX)/(FACPIX*REAL(IPROXINI))
     &              ,REAL(IDY)/(FACPIY*REAL(IPROYINI)))
          CALL PTIFON(FAFA,IFONT0,IFONT1,IFONT2,IFONT3,IGROS)
          FACWIN = FAFA
        ENDIF
      ELSE
        FAFA = 1.
        CALL PTIFON(FAFA,IFONT0,IFONT1,IFONT2,IFONT3,IGROS)
      ENDIF
      CALL GSLSS(IFONT2)
      CALL GSCOL(7)
      CALL GSBND(XX0,XHELP,YY0,YY1)
      IF (IPOST.LT.0) THEN
        CALL GSPATF(0)
        CALL GSPAT(16)
        CALL MY_GSAREA2B(XX0,XHELP,YY0,YY1)
      ENDIF
Cfj      CALL GSBND(XMIN,XMAX,YMIN,YMAX)
C
 9    IF (IMARK.LT.0) THEN
        IPT = I*ILISS
      ELSE
        IPT = 999*ILISS
      ENDIF
      XMARGE = 0.01*(XMAX-XMIN)
      YMARGE = 0.01*(YMAX-YMIN)*PROPV
      XZONE1 = 0.5*(XX0+XMIN)
      XZONE2 = XMIN-XMARGE
      XZONE3 = XMAX+XMARGE
      YZONE1 = 0.5*(YY0+YMIN)
      YZONE2 = YMIN-YMARGE
      YZONE3 = YMAX+YMARGE
      CALL DEF_ZONE(XZONE2,XZONE3,YZONE2,YZONE3,1)
      IF (IFILM.EQ.0) THEN
        CALL VRAIECOORD(XX0,YY1,IX0,IY0)
        CALL VRAIECOORD(XHELP,YY0,IX1,IY1)
        ILARG = IX1-IX0
        IHAUT = IY1-IY0
        IF (IBATCH.EQ.0) THEN
          CALL GSPROGRE(1)
          CALL x11effacepix()
        ENDIF
        CALL GSBND(XX0,XHELP,YY0,YY1)
        IF (IPOST.EQ.1) THEN
          CALL GSCOL(15)
          CALL GSLT(1)
          CALL GSLW(0)
          CALL GSMOVE(XX0,YZONE1)
          CALL GSLINE(XHELP,YZONE1)
          CALL GSMOVE(XZONE1,YZONE2)
          CALL GSLINE(XHELP,YZONE2)
          CALL GSMOVE(XZONE1,YY0)
          CALL GSLINE(XZONE1,YY1)
          CALL GSMOVE(XZONE2,YZONE1)
          CALL GSLINE(XZONE2,YY1)
          CALL GSMOVE(XZONE3,YZONE2)
          CALL GSLINE(XZONE3,YZONE3)
          CALL GSLINE(XZONE2,YZONE3)
          CALL GSMOVE(XX0,YZONE1)
          CALL GSLT(0)
          CALL GSCOL(7)
        ENDIF
        CALL GSBND(XMIN,XMAX,YMIN,YMAX)
        IF (IQUADR.LT.0) CALL AXES(XX,LXX,NDX,YY,LYY,NDY,0,0)
        CALL TRACE
      ELSEIF(IFILM.NE.1) THEN
        CALL GSCLR
        CALL GSBND(XX0,XHELP,YY0,YY1)
        CALL AXES(XX,LXX,NDX,YY,LYY,NDY,0,0)
        CALL GSLW(0)
        CALL GSLT(0)
        CALL GSBND(XMIN,XMAX,YMIN,YMAX)
        CALL CHANGE_CURS(5)
        CALL FILM(NRALEN,NBTOUR,IBOUNCE,IFILM,NUMPT,NUMANI
     &           ,XX,LXX,NDX,YY,LYY,NDY,XX0,YY0)
        CALL CHANGE_CURS(1)
        CALL ASFCOL(7)
        CALL GSLSS(IFONT2)
        IFILM = 0
        JHELP = 0
        IPROX = IPROXINI*FACWINS
        IPROY = IPROYINI*FACWINS
        CALL TAILLE_FEN(IPROX,IPROY,1)
        GOTO 999
      ELSE
        CALL GSBND(XX0,XHELP,YY0,YY1)
        CALL AXES(XX,LXX,NDX,YY,LYY,NDY,1,0)
        CALL HELP(XHELP,XXX1,YY0,YY1)
        CALL CHANGE_CURS(5)
        CALL FILM(NRALEN,NBTOUR,IBOUNCE,IFILM,NUMPT,NUMANI
     &           ,XX,LXX,NDX,YY,LYY,NDY,XX0,YY0)
        CALL CHANGE_CURS(1)
        CALL ASFCOL(7)
        CALL GSLSS(IFONT2)
        IFILM = 0
        JHELP = 0
        GOTO 9
      ENDIF
C
      CALL ASFCOL(7)
      CALL GSLT(0)
      CALL GSBND(XX0,XHELP,YY0,YY1)
      CALL AXES(XX,LXX,NDX,YY,LYY,NDY,1,0)
      IF (IBATCH.EQ.0.AND.IFILM.EQ.0) THEN
        CALL GSPROGRE(0)
        CALL x11metrect2(IX0,IY0,ILARG,IHAUT,IX0,IY0)
        CALL viderbuff2()
      ENDIF
C
 888  IF (IPOST.EQ.1.AND.JHELP.EQ.0) THEN
        CALL HELP(XHELP,XXX1,YY0,YY1)
        JHELP = 1
      ENDIF
 889  IF (NLEG2.NE.0) THEN
        DO I=1,NLEG2
          CALL ECRCOM(LEG2(I),LLEG2(I),XLL2(1,I),YLL2(1,I)
     &               ,XMB,YMB,YBOX,IGROS,0,FRANCAIS)
        ENDDO
      ENDIF
      IF (IBATCH.EQ.0.AND.IBACKINGSTORE.EQ.0) CALL mybackingsave
      CALL GSBND(XX0,XXX1,YY0,YY1)
C
C Affichage du curseur
C
 890  IF (IBATCH.EQ.0) THEN
        IF (ICLIC.EQ.0) THEN
          CALL METS_CURSEUR(.5*(XMIN+XMAX),.5*(YMIN+YMAX))
        ELSE
          ICLIC = 0
        ENDIF
      ENDIF
      IPREM1 = 0
      IPREM3 = 0
C//////////////////////////////////////////////////////////////
 1000 CALL ASREAD2(NSEG,IPFK,0)
C//////////////////////////////////////////////////////////////
CC      PRINT*,'Aprs ASREAD2',IIII,IPFK,ITYP,IBOUT
      IF (IPFK.EQ.-9999) THEN
        CALL GSQCUR(WIN,XXXXX,YYYYY)
        IF (XXXXX.LE.XMAX.AND.XXXXX.GE.XMIN
     & .AND.YYYYY.LE.YMAX.AND.YYYYY.GE.YMIN) THEN
          CALL ASFCOL(7)
          IF (ILOGX.LT.0) THEN
            XXXXX2 = 10.**XXXXX
          ELSE
            XXXXX2 = XXXXX
          ENDIF
          IF (ILOGY.LT.0) THEN
            YYYYY2 = 10.**YYYYY
          ELSE
            YYYYY2 = YYYYY
          ENDIF
          WRITE(CCOOR,'("("G13.5,","G13.5,")")') XXXXX2,YYYYY2
        ELSE
          CCOOR = '                             '
        ENDIF
        CALL GSLSS(IFONT0)
        CALL GSPATF(0)
        CALL GSPAT(16)
        CALL GSCHAR3(XX0,YY0,29,CCOOR,7,1)
        IF (IPREM1.NE.0) THEN
          IF (IPREM1.EQ.1) THEN
            IPREM1 = 2
          ELSE
            CALL GSMOVE(XCUR1,YCUR1)
            CALL GSLINE(XCUR2,YCUR1)
            CALL GSLINE(XCUR2,YCUR2)
            CALL GSLINE(XCUR1,YCUR2)
            CALL GSLINE(XCUR1,YCUR1)
          ENDIF
          XCUR2 = XXXXX
          YCUR2 = YYYYY
          CALL GSMOVE(XCUR1,YCUR1)
          CALL GSLINE(XCUR2,YCUR1)
          CALL GSLINE(XCUR2,YCUR2)
          CALL GSLINE(XCUR1,YCUR2)
          CALL GSLINE(XCUR1,YCUR1)
        ELSEIF(IPREM3.NE.0) THEN
          CALL GSQCUR(WIN,XCUR2,YCUR2)
          CALL GSLSS(IFONT2)
          CALL ASFCOL(ICOLTMP)
          CALL ECRCOM(LEG2(NLEG2),LLEG2(NLEG2),XLL2(1,NLEG2)
     &               ,YLL2(1,NLEG2),XMB,YMB,YBOX,IGROS,1,FRANCAIS)
          XLL2(2,NLEG2) = XCUR2
          YLL2(2,NLEG2) = YCUR2
          CALL ECRCOM(LEG2(NLEG2),LLEG2(NLEG2),XLL2(1,NLEG2)
     &               ,YLL2(1,NLEG2),XMB,YMB,YBOX,IGROS,1,FRANCAIS)
          CALL GSLSS(IFONT0)
        ENDIF
        GOTO 1000
      ENDIF
      IF (NSEG.LT.0) GOTO 99
C
C Zoom interactif annule par q
C
      IF (IPREM1.NE.0.AND.IPFK.NE.26) THEN
        CALL GSQCUR(WIN,XCUR2,YCUR2)
        DXNEW = MAX(XCUR1,XCUR2)-MIN(XCUR1,XCUR2)
        DYNEW = MAX(YCUR1,YCUR2)-MIN(YCUR1,YCUR2)
        FF = 0.005
        IF (DXNEW.GE.FF*(XMAX-XMIN).AND.DYNEW.GE.FF*(YMAX-YMIN)) THEN
          XMIN000 = XMIN
          XMAX000 = XMAX
          YMIN000 = YMIN
          YMAX000 = YMAX
          XMIN = MIN(XCUR1,XCUR2)
          XMAX = MAX(XCUR1,XCUR2)
          YMIN = MIN(YCUR1,YCUR2)
          YMAX = MAX(YCUR1,YCUR2)
          ITOUCX = 1
          ITOUCY = 1
          GOTO 99
        ELSE
          IPFK = 26
        ENDIF
      ELSEIF(IPREM3.NE.0.AND.IPFK.NE.26) THEN
        CALL GSQCUR(WIN,XCUR2,YCUR2)
        CALL GSLSS(IFONT2)
        CALL ASFCOL(ICOLTMP)
        CALL ECRCOM(LEG2(NLEG2),LLEG2(NLEG2),XLL2(1,NLEG2)
     &             ,YLL2(1,NLEG2),XMB,YMB,YBOX,IGROS,1,FRANCAIS)
        XLL2(2,NLEG2) = XCUR2
        YLL2(2,NLEG2) = YCUR2
        CALL ASFCOL(7)
        CALL GSMIX(0)
        GOTO 889
      ENDIF
      IF (IPFK.EQ.IPFGAUCHE
     &.OR.IPFK.EQ.IPFMILIEU.OR.IPFK.EQ.IPFDROITE) THEN
        CALL GSQCUR(WIN,XCURCUR,YCURCUR)
        ICLIC = 1
        IF (XCURCUR.GT.XHELP) THEN
          IAHELP = -IAHELP
          JHELP = 0
          GOTO 888
        ELSEIF(XCURCUR.GE.XZONE2.AND.XCURCUR.LE.XZONE3
     &    .AND.YCURCUR.GE.YZONE2.AND.YCURCUR.LE.YZONE3) THEN
          IF (IPFK.EQ.IPFGAUCHE) THEN
            IPREM1=1
            XCUR1 = XCURCUR
            YCUR1 = YCURCUR
            CALL GSCOL(ICOLTMP)
            CALL ASFCOL(ICOLTMP)
            CALL GSMIX(1)
            CALL GSLSS(IFONT1)
            IF (FRANCAIS) THEN
              CALL GSCHAR3
     &          (.5*(XMAX+XMIN),YMIN,19,'Abandon du zoom : q',2,-1)
            ELSE
              CALL GSCHAR3
     &          (.5*(XMAX+XMIN),YMIN,14,'Zoom cancel: q',2,-1)
            ENDIF
            CALL GSLSS(IFONT0)
            GOTO 1000
          ELSEIF(IPFK.EQ.IPFMILIEU) THEN
            GOTO 3017
          ELSE
            IF (NLEG2.GE.NLMAX) GOTO 1000
            NLEG2 = NLEG2+1
            XLL2(1,NLEG2) = XCURCUR
            YLL2(1,NLEG2) = YCURCUR
            XLL2(2,NLEG2) = XCURCUR
            YLL2(2,NLEG2) = YCURCUR
            CALL GSCOL(ICOLTMP)
            CALL ASFCOL(ICOLTMP)
            CALL FSTERM(1)
            IF (FRANCAIS) THEN
              CALL LILIGNE('Entrez un commentaire (max 132 caractres)'
     &                    ,0,LEG2(NLEG2),LLEG2(NLEG2))
            ELSE
              CALL LILIGNE('Type a commentary (max 132 characters)'
     &                    ,0,LEG2(NLEG2),LLEG2(NLEG2))
            ENDIF
            CALL FSINN(IPROX,IPROY,PROBIG,IDEBU,ITERMC)
            IF (LLEG2(NLEG2).EQ.1.AND.LEG2(NLEG2)(1:1).EQ.' ') THEN
              NLEG2 = NLEG2-1
              GOTO 1000
            ENDIF
            CALL GSLSS(IFONT2)
            CALL GSMIX(1)
            CALL ECRCOM(LEG2(NLEG2),LLEG2(NLEG2),XLL2(1,NLEG2)
     &                 ,YLL2(1,NLEG2),XMB,YMB,YBOX,IGROS,2
     &                 ,FRANCAIS)
            CALL GSLSS(IFONT0)
            IPREM3 = 1
            CALL METS_CURSEUR(XCURCUR,YCURCUR)
            GOTO 1000
          ENDIF
        ELSEIF(XCURCUR.LE.XZONE1.AND.YCURCUR.LE.YZONE1) THEN
          GOTO 2020
        ELSEIF(XCURCUR.GE.XZONE1.AND.XCURCUR.LE.XZONE2
     &    .AND.YCURCUR.GE.YZONE1.AND.YCURCUR.LE.YZONE2) THEN
          GOTO 2029
        ELSEIF(XCURCUR.LE.XZONE1.OR.YCURCUR.LE.YZONE1
     &     .OR.XCURCUR.GT.XMAX.OR.YCURCUR.GT.YMAX) THEN
          CALL GSMIX(1)
          CALL GSPAT(8)
          XBID(1) = XFMIN
          XBID(2) = XHELP
          YBID(1) = YFMIN
          YBID(2) = YFMAX
          CALL MY_GSAREA2(XBID,YBID)
          CALL ASFCOL(8)
          CALL GSLSS(IFONT1)
          IF (FRANCAIS) THEN
            CALL GSCHAR3(.5*(XMAX+XMIN),YZONE1,65,
     &"Entrez un titre en terminant par <ret> (accents possibles: "//
     &          CHAR(92)//"'e=)",8,-1)
          ELSE
            CALL GSCHAR3(.5*(XMAX+XMIN),YZONE1,54,
     &"Type a title ending by <return> (Latin accents: "//
     &          CHAR(92)//"'e=)",8,-1)
          ENDIF
          CALL ASFCOL(7)
          CALL GSMIX(0)
          CALL GSLSS(IFONT2)
          CALL CHANGE_CURS(7)
          IF (YCURCUR.LE.YZONE1) THEN
            CALL LICHAINEGRA(XCURCUR,YCURCUR,ABSC,NABS,1)
cc            GOTO 1000
            GOTO 999
          ELSEIF(XCURCUR.LE.XZONE1) THEN
            CALL LICHAINEGRA(XCURCUR,YCURCUR,ORDON,NORD,2)
cc            GOTO 1000
            GOTO 999
          ELSE
            CALL LICHAINEGRA(XCURCUR,YCURCUR,GENE,NGEN,3)
            GOTO 999
          ENDIF
        ELSEIF(XCURCUR.LT.XMIN) THEN
          IF (ILOGYOK.EQ.0) THEN
            ILOGY = -ILOGY
            CALL LOLO(YPOINT,YMIN,YMAX,ILOGY)
            YMIN = YMIN+0.01*(YMAX-YMIN)
            YMAX = YMAX-0.01*(YMAX-YMIN)
CC            ICLIC = 1
            GOTO 1113
          ELSE
            GOTO 1000
          ENDIF
        ELSE
          IF (ILOGXOK.EQ.0) THEN
            ILOGX = -ILOGX
            CALL LOLO(XPOINT,XMIN,XMAX,ILOGX)
            XMIN = XMIN+0.01*(XMAX-XMIN)
            XMAX = XMAX-0.01*(XMAX-XMIN)
CC            ICLIC = 1
            GOTO 1113
          ELSE
            GOTO 1000
          ENDIF
        ENDIF
Cfj      ELSEIF(IPFK.EQ.IPFDROITE) THEN
Cfj        CALL GSQCUR(WIN,XCURCUR,YCURCUR)
Cfj        IF (XCURCUR.GT.XHELP) THEN
Cfj          IAHELP = -IAHELP
Cfj          ICLIC = 1
Cfj          GOTO 888
Cfj        ELSEIF(XCURCUR.GE.XMIN.AND.XCURCUR.LE.XMAX
Cfj     &    .AND.YCURCUR.GE.YMIN.AND.YCURCUR.LE.YMAX) THEN
Cfj        ELSE
Cfj          IPFK = -2
Cfj          ICLIC = 1
Cfj        ENDIF
      ENDIF
      IF (IBATCH.LT.3) IPOSTCOL = 0
      NSHIFT = 10
      IF ((IPFK.GE.1-NSHIFT) .AND. (IPFK.LE.35)) THEN
      GOTO (1991,1992,1993,1994,1995,1996,1997,1998,1000,1000
     &     ,2001,2002,2026,2004,2005,2006,2007,2008,2009,2010,2011,2012
     &     ,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024
     &     ,2025,2003,2027,2028,2029,2030,2031,2032,2033,2034,2035)
     &      IPFK+NSHIFT
      ELSEIF(IPFK.EQ.9999) THEN
        IF (IBATCH.EQ.0) THEN
          IPOST = 1
          ILATEX = 0
          JHELP = 0
          GOTO 999
        ELSE
          STOP
        ENDIF
C
C Fleches du clavier
C
      ELSEIF(IPFK.GE.549.AND.IPFK.LE.552) THEN
        XMIN000 = XMIN
        XMAX000 = XMAX
        YMIN000 = YMIN
        YMAX000 = YMAX
        IF (IPFK.EQ.549) THEN
          YMAX2 = BIG
          YMIN2 = BIG
          DDDDD = (YMAX-YMIN)*0.01
          DO I=1,NDY
            IF (YY(I).GT.YMIN+DDDDD) THEN
              YMIN2 = MIN(YMIN2,YY(I))
              IF (YY(I).GT.YMAX+DDDDD) YMAX2 = MIN(YMAX2,YY(I))
            ENDIF
          ENDDO
          YMIN = YMIN2
          YMAX = YMAX2
          ITOUCY = 1
        ELSEIF(IPFK.EQ.551) THEN
          XMAX2 = BIG
          XMIN2 = BIG
          DDDDD = (XMAX-XMIN)*0.01
          DO I=1,NDX
            IF (XX(I).GT.XMIN+DDDDD) THEN
              XMIN2 = MIN(XMIN2,XX(I))
              IF (XX(I).GT.XMAX+DDDDD) XMAX2 = MIN(XMAX2,XX(I))
            ENDIF
          ENDDO
          XMIN = XMIN2
          XMAX = XMAX2
          ITOUCX = 1
        ELSEIF(IPFK.EQ.550) THEN
          XMAX2 = -BIG
          XMIN2 = -BIG
          DDDDD = (XMAX-XMIN)*0.01
          XMIN = XMIN+DDDDD
          XMAX = XMAX+DDDDD
          DO I=1,NDX
            IF (XX(I).LT.XMAX-DDDDD) THEN
              XMAX2 = MAX(XMAX2,XX(I))
              IF (XX(I).LT.XMIN-DDDDD) XMIN2 = MAX(XMIN2,XX(I))
            ENDIF
          ENDDO
          XMIN = XMIN2
          XMAX = XMAX2
          ITOUCX = 1
        ELSE
          YMAX2 = -BIG
          YMIN2 = -BIG
          DDDDD = (YMAX-YMIN)*0.01
          DO I=1,NDY
            IF (YY(I).LT.YMAX-DDDDD) THEN
              YMAX2 = MAX(YMAX2,YY(I))
              IF (YY(I).LT.YMIN-DDDDD) YMIN2 = MAX(YMIN2,YY(I))
            ENDIF
          ENDDO
          YMIN = YMIN2
          YMAX = YMAX2
          ITOUCY = 1
        ENDIF
        GOTO 99
      ELSE
        GOTO 1000
      ENDIF
C
C Sauvegarde gif (')
C
 1991 CALL QUICESTCELUILA('convert',7,TROUVE,0)
      IF (TROUVE) THEN
        CALL GSBND(XHELP,XXX1,YY0,YY1)
        XBID(1) = XHELP
        XBID(2) = XXX1
        YBID(1) = YY0
        YBID(2) = YY1
        DX = 0.1*(XXX1-XHELP)
        DY = 0.1*(YY1-YY0)
        CALL GSPAT(7)
        CALL MY_GSAREA2(XBID,YBID)
        CALL ASFCOL(0)
        CALL GSLSS(IFONT2)
        CALL GSCHAR(XHELP+DX,DY,8,'DUMP GIF')
C
        CALL GSBND(XX0,XHELP,YY0,YY1)
        CALL GSPROGRE(1)
        CALL x11effacepix()
        CALL GSBND(XMIN,XMAX,YMIN,YMAX)
        IF (IQUADR.LT.0) CALL AXES(XX,LXX,NDX,YY,LYY,NDY,0,0)
        CALL TRACE
        CALL ASFCOL(7)
        CALL GSLT(0)
        CALL GSBND(XX0,XHELP,YY0,YY1)
        CALL AXES(XX,LXX,NDX,YY,LYY,NDY,1,0)
        CALL GSPROGRE(0)
        CALL x11metrect2(IX0,IY0,ILARG,IHAUT,IX0,IY0)
        CALL viderbuff2()
Cfj        CALL GSLSS(IFONT0)
Cfj        CALL GSPATF(0)
Cfj        CALL GSPAT(16)
Cfj        CCOOR = '                             '
Cfj        CALL GSCHAR3(XX0,YY0,29,CCOOR,7,1)
        NGIF = 0
 2991   NGIF = NGIF+1
        WRITE(CHIFFRE(1:3),'(I3.3)') NGIF
        INQUIRE(FILE='xgr'//CHIFFRE(1:3)//'.gif',EXIST=TROUVE)
        IF (TROUVE.AND.NGIF.LT.999) GOTO 2991
        IF (TROUVE) THEN
          CHIFFRE(1:3) = '001'
          IF (FRANCAIS) THEN
            PRINT*,'*** On crase xgr001.gif'
          ELSE
            PRINT*,'*** Overwriting xgr001.gif'
          ENDIF
        ENDIF
        CALL GETIDX(IDX,IDY,IECPIXX,IECPIXY)
        IXIMAGE = INT(REAL(IDX)*(XHELP-XX0)/(XXX1-XX0))
        IYIMAGE = IDY
        CALL SAUVEBIT('xgr'//CHIFFRE(1:3)//CHAR(0),6
     &               ,PROBIG(1:LPROB)//CHAR(0),LPROB
     &               ,1,IXIMAGE,IYIMAGE)
        CALL HELP(XHELP,XXX1,YY0,YY1)
        GOTO 999
      ELSE
        PRINT*,' '
        IF (FRANCAIS) THEN
          PRINT*,'*** Pour utiliser cette option, vous devez installer'
          PRINT*,'*** le package ImageMagick qui se trouve ici :'
        ELSE
          PRINT*,'*** To be able to use this option, you must install'
          PRINT*,'*** the ImageMagick package, which can be found here:'
        ENDIF
        PRINT*,'http://www.imagemagick.org/'
        PRINT*,' '
        GOTO 1000
      ENDIF
C
C Reload (
C
 1992 IDEB = 1
      GOTO 1113
C
C Minima et maxima, locaux et absolus )
C minmax = 0 rien
C minmax = 1 tous (absolus + locaux)
C minmax = 2 absolus
C minmax = 3 locaux
C
 1993 MINMAX = MINMAX+1
      IF (MINMAX.GT.3) MINMAX = 0
      GOTO 999
C
C Affichage des coordonnees du curseur dans le terminal (*)
C
 1994 IF (CCOOR.NE.'                             ') THEN
        CALL GSQCOL(ICOULSAUV)
        CALL GSCOL(5)
        CALL GSMB(DDDX*0.02/SPROP,DDDY*0.02*SPROP)
        CALL GSMS(1)
        CALL GSMARK(XXXXX,YYYYY)
        CALL GSMS(4)
        CALL GSMARK(XXXXX,YYYYY)
        CALL GSCOL(ICOULSAUV)
        PRINT*,XXXXX2,YYYYY2
      ENDIF
      GOTO 1000
C
C PostScript Couleur LaTeX (+)
C
 1995 IPOSTCOL = 1
      CALL LITTABLE(SAUVTABCO,NBCOL0)
      CALL METTABLE(SAUVTABCO,NBCOL0)
      ILATEX = 1
      GOTO 2002
C
C Echelles avec 10^ si necessaire (defaut) ou non (,)
C
 1996 IENG = -IENG
      GOTO 999
Cfj 1996 call gspopup(300,500,iretour)
Cfj      print*,iretour
C
C Taille des legendes (-)
C
 1997 IF (NLEG.EQ.0) THEN
        GOTO 1000
      ELSE
        IPTILEG = IPTILEG+1
        IF (IPTILEG.GT.2) IPTILEG = 0
        INEWGR = 1
        GOTO 99
      ENDIF
C
C Gros et enorme dessin (.)
C
 1998 IGROS = IGROS+1
      IF (IGROS.GT.2) IGROS = 0
      CALL GSLW(1+IGROS)
      INEWGR = 1
      JHELP = 0
      GOTO 99
C
C Changement de titres (1)
C
 2001 CALL FSTERM(1)
      IF (FRANCAIS) THEN
        IF (NABS.GT.0) THEN
          PRINT*,'Titre en abscisse actuel :'
          WRITE(*,'(A)') ABSC(1:NABS)
          CALL LILIGNE('Nouveau titre en abscisse ?',0,ABSC,NABS)
        ELSE
          CALL LILIGNE('Titre en abscisse ?',0,ABSC,NABS)
        ENDIF
        IF (NORD.GT.0) THEN
          PRINT*,'Titre en ordonne actuel :'
          WRITE(*,'(A)') ORDON(1:NORD)
          CALL LILIGNE('Nouveau titre en ordonne ?',0,ORDON,NORD)
        ELSE
          CALL LILIGNE('Titre en ordonne ?',0,ORDON,NORD)
        ENDIF
        IF (NGEN.GT.0) THEN
          PRINT*,'Titre gnral actuel :'
          WRITE(*,'(A)') GENE(1:NGEN)
          CALL LILIGNE('Nouveau titre gnral ?',0,GENE,NGEN)
        ELSE
          CALL LILIGNE('Titre general ?',0,GENE,NGEN)
        ENDIF
      ELSE
        IF (NABS.GT.0) THEN
          PRINT*,'Previous X axis title:'
          WRITE(*,'(A)') ABSC(1:NABS)
          CALL LILIGNE('New X axis title?',0,ABSC,NABS)
        ELSE
          CALL LILIGNE('X axis title?',0,ABSC,NABS)
        ENDIF
        IF (NORD.GT.0) THEN
          PRINT*,'Previous Y axis title:'
          WRITE(*,'(A)') ORDON(1:NORD)
          CALL LILIGNE('New Y axis title?',0,ORDON,NORD)
        ELSE
          CALL LILIGNE('Y axis title?',0,ORDON,NORD)
        ENDIF
        IF (NGEN.GT.0) THEN
          PRINT*,'Previous general title:'
          WRITE(*,'(A)') GENE(1:NGEN)
          CALL LILIGNE('New general title?',0,GENE,NGEN)
        ELSE
          CALL LILIGNE('General title?',0,GENE,NGEN)
        ENDIF
      ENDIF
      IF (NABS.EQ.1.AND.ABSC(1:1).EQ.' ')  NABS = 0
      IF (NORD.EQ.1.AND.ORDON(1:1).EQ.' ') NORD = 0
      IF (NGEN.EQ.1.AND.GENE(1:1).EQ.' ')  NGEN = 0
      CALL FSINN(IPROX,IPROY,PROBIG,IDEBU,ITERMC)
      GOTO 999
C
C Sauvegarde PostScript (2)
C
 2002 CONTINUE
      IFONT0 = 0
      IFONT1 = 1
      IF (IGROS.EQ.0) THEN
        IFONT2 = 2
        IFONT3 = 3
      ELSEIF(IGROS.EQ.1) THEN
        IFONT2 = 4
        IFONT3 = 2
      ELSE
        IFONT2 = 5
        IFONT3 = 4
      ENDIF
      XCUR = XMIN*0.8 + XMAX*0.2
      YCUR = YMAX*0.8 + YMIN*0.2
      DDDYYY = 0.1*(YMAX-YMIN)
      IF (IPOSTCOL.EQ.0) THEN
        IF (ILATEX.EQ.0) THEN
          IF (FRANCAIS) THEN
            CBID = 'Sauvegarde PostScript'
            LONBID = 21
          ELSE
            CBID = 'Writing PostScript file'
            LONBID = 23
          ENDIF
        ELSE
          IF (FRANCAIS) THEN
            CBID = 'Sauvegarde PostScript pour LaTeX'
            LONBID = 32
          ELSE
            CBID = 'Writing PostScript file for LaTeX'
            LONBID = 33
          ENDIF
        ENDIF
        HXA4C = HXA4
        HYA4C = HYA4
      ELSE
        IF (FRANCAIS) THEN
          CBID = 'Sauvegarde PostScript couleur'
        ELSE
          CBID = 'Writing color PostScript file'
        ENDIF
        LONBID = 29
Cfj        HXA4C = HXA4B
Cfj        HYA4C = HYA4*HXA4C/HXA4
        HXA4C = HXA4
        HYA4C = HYA4
      ENDIF
      IF (ILATEX.EQ.0) THEN
        IF (PROP.GT.1.) THEN
          ANGLE = -90.
          XLARG = HXA4C
          XHAUT = HYA4C
        ELSE
          IF (PROP.EQ.1.) THEN
            ANGLE = 0.
          ELSE
            ANGLE = 180.
          ENDIF
          XLARG = HYA4C
          XHAUT = XLARG/PROP
        ENDIF
        PROG(LPROG+1:LPROG+3) = '   '
        LP2 = LPROG
cc        SIGN = .TRUE.
        SIGN = .FALSE.
      ELSE
        ANGLE = 0.
        XLARG = HYA4C
        XHAUT = XLARG/PROP
        PROG(LPROG+1:LPROG+3) = 'tex'
        LP2 = LPROG+3
        SIGN = .FALSE.
      ENDIF
      LONPS = 0
      CALL INITPS(9,XLARG,XHAUT,ANGLE,PROG,LP2,NOMPS,LONPS,IPOSTCOL)
      IF (LONPS.LT.0) GOTO 1000
      IPOST = -1
      CALL GSLSS(IFONT2)
CCC      CALL GSSCLS
      PRINT*,CBID(1:LONBID)
      DO I=1,6
        CALL GSCHAR(XCUR,YCUR,LONBID,CBID)
        YCUR = YCUR - DDDYYY
      ENDDO
      CALL ECOP(CBID,LBID)
      IF (FRANCAIS) THEN
        IF (ILATEX.EQ.0) THEN
          WRITE(9,'(A)')
     &'%> Fichier PostScript gnr en interactif avec les donnes :'
        ELSE
          WRITE(9,'(A)')
     &'%> Fichier PostScript pour LaTeX gnr en interactif'
     &//' avec les donnes :'
        ENDIF
        DO I=1,NCOURB
          WRITE(9,'(A)') '%>     '//FICHIER(I)(1:LONG(I))
        ENDDO
        IF (ILATEX.EQ.0) THEN
          IF (IPOSTCOL.EQ.0) THEN
            WRITE(9,'(A)')
     &           '%> et les options :'//CBID(1:LBID-1)//' -ps '
          ELSE
            WRITE(9,'(A)')
     &           '%> et les options :'//CBID(1:LBID-1)//' -pscol '
          ENDIF
        ELSE
         WRITE(9,'(A)')'%> et les options :'//CBID(1:LBID-1)//' -pstex '
        ENDIF
      ELSE
        IF (ILATEX.EQ.0) THEN
          WRITE(9,'(A)') '%> PostScript file generated with data files:'
        ELSE
          WRITE(9,'(A)')
     &         '%> PostScript file for LaTeX generated with data files:'
        ENDIF
        DO I=1,NCOURB
          WRITE(9,'(A)') '%>     '//FICHIER(I)(1:LONG(I))
        ENDDO
        IF (ILATEX.EQ.0) THEN
          IF (IPOSTCOL.EQ.0) THEN
            WRITE(9,'(A)')
     &           '%> and options:'//CBID(1:LBID-1)//' -ps '
          ELSE
            WRITE(9,'(A)')
     &           '%> and options:'//CBID(1:LBID-1)//' -pscol '
          ENDIF
        ELSE
          WRITE(9,'(A)') '%> and options:'//CBID(1:LBID)//' -pstex '
        ENDIF
      ENDIF
      IF (SIGN) THEN
        LBID = LONG(1)+1
        CBID(1:LBID) = FICHIER(1)(1:LONG(1))//' '
        IF (NCOURB.GT.1) THEN
          IFLAG = 0
          DO I=2,NCOURB
            IF (IFLAG.EQ.0) THEN
              IF ((LBID+LONG(I)+1).GT.510) THEN
                CBID(LBID+1:512) = '...........................'
                LBID = MIN(512,LBID+3)
                IFLAG = 1
              ELSE
                LBID0 = LBID+1
                LBID  = LBID0+LONG(I)
                CBID(LBID0:LBID) = FICHIER(I)(1:LONG(I))//' '
              ENDIF
            ENDIF
          ENDDO
        ENDIF
      ELSE
        LBID = 0
      ENDIF
      CALL INPRFD(9,FALSE,FALSE,SIGN,XLARG,XHAUT,ANGLE,CBID,LBID
     &           ,IPOSTCOL)
      GOTO 999
C
C Fin ou annulation du zoom interactif  (q)
C
 2003 IF (IPREM1.EQ.0.AND.IPREM3.EQ.0) THEN
        DO I=1,NCOURB
          IF (LONG(I).GE.10) THEN
            IF (FICHIER(I)(1:10).EQ.'/tmp/coupe') THEN
              CALL EXEC('\rm -f /tmp/coupe*')
              GOTO 9999
            ENDIF
          ENDIF
        ENDDO
        CALL ECOP(CBID,LBID)
        PRINT*,' '
        IF (FRANCAIS) THEN
          PRINT*,'Pour refaire le mme dessin, tapez :'
        ELSE
          PRINT*,'To replot the same graphics, type:'
        ENDIF
        PRINT*,' '
        IF (LBID.GT.0) THEN
          WRITE(*,'(A,$)') PROGEFF(1:LPROGEFF)//' '//CBID(1:LBID-1)
        ELSE
          WRITE(*,'(A,$)') PROGEFF(1:LPROGEFF)
        ENDIF
        DO I=1,NCOURB
          WRITE(*,'(A,$)') ' '//FICHIER(I)(1:LONG(I))
        ENDDO
        PRINT*,' '
        GOTO 9999
      ELSEIF(IPREM1.NE.0) THEN
        IF (IPREM1.EQ.2) THEN
          CALL GSMOVE(XCUR1,YCUR1)
          CALL GSLINE(XCUR2,YCUR1)
          CALL GSLINE(XCUR2,YCUR2)
          CALL GSLINE(XCUR1,YCUR2)
          CALL GSLINE(XCUR1,YCUR1)
        ENDIF
        CALL ASFCOL(ICOLTMP)
        CALL GSLSS(IFONT1)
        IF (FRANCAIS) THEN
          CALL GSCHAR3
     &         (.5*(XMAX+XMIN),YMIN,19,'Abandon du zoom : q',2,-1)
        ELSE
          CALL GSCHAR3
     &         (.5*(XMAX+XMIN),YMIN,14,'Zoom cancel: q',2,-1)
        ENDIF
        CALL GSLSS(IFONT0)
        CALL GSMIX(0)
        IPREM1 = 0
        GOTO 1000
      ELSE
        IPREM3 = 0
        CALL GSLSS(IFONT2)
        CALL ASFCOL(ICOLTMP)
        CALL ECRCOM(LEG2(NLEG2),LLEG2(NLEG2),XLL2(1,NLEG2)
     &             ,YLL2(1,NLEG2),XMB,YMB,YBOX,IGROS,1,FRANCAIS)
        CALL GSLSS(IFONT0)
        NLEG2 = NLEG2-1
        CALL GSMIX(0)
        GOTO 1000
      ENDIF
C
C Changement d'echelle pour Ox avec recalcul des echelles (4)
C
 2004 CONTINUE
      CALL FSTERM(1)
      XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
      PRINT*,'Xmin =',XMIN,'  Xmax =',XMAX
      IF (FRANCAIS) THEN
        CALL LI2REEL1('Nouvelles bornes sur l''axe des abscisses ?',0
     &                ,XMIN,XMAX)
      ELSE
        CALL LI2REEL1('New bounds on X axis?',0,XMIN,XMAX)
      ENDIF
      IF (XMIN.EQ.XMAX) GOTO 2004
      IF (XMIN.GT.XMAX) THEN
        XDUM = XMIN
        XMIN = XMAX
        XMAX = XDUM
      ENDIF
 2094 NSEG = NSEG + 1
      TOTO1 = XMAX-XMIN
      TOTO2 = MAX(ABS(XMIN),ABS(XMAX))
      IF (ILOGX.GE.0.AND.(TOTO2.GE.GRAND.OR.TOTO1.LE.PETIT)) THEN
        NDXMIN = 20
      ELSE
        NDXMIN = 50
      ENDIF
      CALL ARONDI(XMIN,XMAX,XX,LXX,NDX,ILOGX,NTMAX,IARON,NDXMIN)
      CALL BORNE
      IF (YMIN.EQ.YMAX) THEN
        YMIN=YMIN-0.5*(XMAX-XMIN)
        YMAX=YMAX+0.5*(XMAX-XMIN)
      ENDIF
      YMIN = YMIN - 0.05*(YMAX-YMIN)
      YMAX = YMAX + 0.05*(YMAX-YMIN)
      ITOUCX = 1
      ITOUCY = 1
      CALL FSINN(IPROX,IPROY,PROBIG,IDEBU,ITERMC)
      GOTO 101
C
C Changement d'echelle pour Ox sans recalcul des echelles sur Oy (5)
C
 2005 CONTINUE
      CALL FSTERM(1)
      XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
      PRINT*,'Xmin =',XMIN,'  Xmax =',XMAX
      IF (FRANCAIS) THEN
        CALL LI2REEL1('Nouvelles bornes sur l''axe des abscisses ?',0
     &                ,XMIN,XMAX)
      ELSE
        CALL LI2REEL1('New bounds on X axis?',0,XMIN,XMAX)
      ENDIF
      IF (XMIN.EQ.XMAX) GOTO 2005
      IF (XMIN.GT.XMAX) THEN
        XDUM = XMIN
        XMIN = XMAX
        XMAX = XDUM
      ENDIF
 2105 NSEG = NSEG + 1
      ITOUCX = 1
      CALL FSINN(IPROX,IPROY,PROBIG,IDEBU,ITERMC)
      GOTO 99
C
C Changement d'echelle pour Oy (6)
C
 2006 CONTINUE
      CALL FSTERM(1)
      XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
      PRINT*,'Ymin =',YMIN,'  Ymax =',YMAX
      IF (FRANCAIS) THEN
        CALL LI2REEL1('Nouvelles bornes sur l''axe des ordonnees ?',0
     &                ,YMIN,YMAX)
      ELSE
        CALL LI2REEL1('New bounds on Y axis?',0,YMIN,YMAX)
      ENDIF
      IF (YMIN.EQ.YMAX) GOTO 2006
      IF (YMIN.GT.YMAX) THEN
        YDUM = YMIN
        YMIN = YMAX
        YMAX = YDUM
      ENDIF
 2106 NSEG = NSEG + 1
      ITOUCY = 1
      CALL FSINN(IPROX,IPROY,PROBIG,IDEBU,ITERMC)
      GOTO 101
C
C Regression lineaire (7)
C
 2007 IF (IREGRE.EQ.1) THEN
        IREGRE = -1
      ELSE
        IREGRE = IREGRE-1
      ENDIF
      IF (IREGRE.EQ.-5) IREGRE=1
      GOTO 999
C
C Repere norme  (8)
C
 2008 DX = (XMAX-XMIN)*0.5
      DY = (YMAX-YMIN)*0.5
      RAP = DX/DY
      XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
      IF (RAP.GT.PROPV) THEN
        DY = DX/PROPV
        YC = 0.5*(YMIN+YMAX)
        YMIN = YC - DY
        YMAX = YC + DY
        ITOUCY = -1
      ELSE
        DX = PROPV*DY
        XC = 0.5*(XMIN+XMAX)
        XMIN = XC - DX
        XMAX = XC + DX
        ITOUCX = -1
      ENDIF
      IARON = 1
      GOTO 99
C
C On met des legendes, on les bouge ou on les enleve (9)
C
 2009 IOPT2 = ABS(IOPT)
      ISIGN = IOPT/IOPT2
      IF (IOPT2.GT.1) THEN
        IF (IOPT2.EQ.19) THEN
          IOPT2 = 10
        ELSE
          IOPT2 = IOPT2+1
        ENDIF
      ELSE
 2109   IOPT2 = 11
        CALL FSTERM(1)
        IAUTOLEG = 0
        PRINT*,' '
        IF (FRANCAIS) THEN
          PRINT*,'Pour prendre le nom des fichiers comme lgende'
          PRINT*,'ajouter 10  la taille des caractres voulue'
          PRINT*,'(ex: rpondre "11"  la question suivante pour'
          PRINT*,'afficher les noms de fichiers avec une petite police)'
          CALL LIENTIER(
     & 'Taille des caractres (0:normale, 1:petite, 2:minuscule) ?'
     &         ,0,IPTILEG)
          CALL LIENTIER(
     & 'Type de cadre (0:standard, 1:simple, 2:absent) ?',0,ICADLEG)
          IF (IPTILEG.GE.10.AND.IPTILEG.LE.12) THEN
            IPTILEG = IPTILEG-10
            IAUTOLEG = 1
          ELSE
            PRINT*,
     &           ' Entrez les lgendes pour chacune des',NCOURB,
     &           ' courbes (80 char maxi)'
          ENDIF
        ELSE
          PRINT*,'To use the filenames as legends, add 10 to the'
          PRINT*,'desired character size'
          PRINT*,'(ex: answer "11" to the next question to display'
          PRINT*,'the filenames with a small font)'
          CALL LIENTIER('Character size (0:normal, 1:small, 2:tiny)?'
     &         ,0,IPTILEG)
          CALL LIENTIER(
     & 'Frame style (0:standard, 1:simple, 2:none) ?',0,ICADLEG)
          IF (IPTILEG.GE.10.AND.IPTILEG.LE.12) THEN
            IPTILEG = IPTILEG-10
            IAUTOLEG = 1
          ELSE
            PRINT*,
     &           ' Type legends for each plot among',NCOURB,
     &           ' (max 80 characters)'
          ENDIF
        ENDIF
        IF (IPTILEG.LT.0.OR.IPTILEG.GT.2) IPTILEG = 0
        IF (ICADLEG.LT.0.OR.ICADLEG.GT.2) ICADLEG = 0
        NLEG = 0
        DO I=1,NCOURB
          IF (IAUTOLEG.EQ.0) THEN
            WRITE(CHIFFRE,'(I4)') I
            CALL LILIGNE(
     &           '  Courbe'//CHIFFRE//' ('//FICHIER(I)(1:LONG(I))//') :'
     &           ,0,LEGEND(I),NNN)
          ELSE
            LEGEND(I) = FICHIER(I)(1:LONG(I))
            NNN = LONG(I)
          ENDIF
          NLEG = MAX(NLEG,NNN)
        ENDDO
        CALL FSINN(IPROX,IPROY,PROBIG,IDEBU,ITERMC)
      ENDIF
      IOPT = IOPT2*ISIGN
      GOTO 999
C
C Marquage des points (a)
C
 2010 IMARK = -IMARK
      IF (IMARK.LT.0) THEN
        DO I=1,NCMAX
          NMARK(I) = NMARK1(I)
        ENDDO
      ELSE
        DO I=1,NCMAX
          NMARK(I) = 0
        ENDDO
      ENDIF
      JHELP = 0
      GOTO 999
C
C Echelles logarithmiques (b)
C
 2011 IF (ILOGXOK*ILOGYOK.NE.0) GOTO 1000
      IF (ILOGXOK.EQ.0) THEN
        CALL FSTERM(1)
        IF (FRANCAIS) THEN
          PRINT*,' L''axe des X a une chelle ',ECHLOG(ILOGX)
          CALL LIENTIER(' On change ou pas ? (oui:1 ; non:0)',0,IREP1)
        ELSE
          PRINT*,' The X axis has a ',ECHLOG(ILOGX),' scale'
          CALL LIENTIER(
     &           ' Do you want to change? (yes:1 ; no:0)',0,IREP1)
        ENDIF
        IF (IREP1.NE.0) THEN
          ILOGX=-ILOGX
          CALL LOLO(XPOINT,XMIN,XMAX,ILOGX)
        ENDIF
      ELSE
        IF (FRANCAIS) THEN
          PRINT*,'*** Echelle Log impossible sur Ox'
        ELSE
          PRINT*,'*** Log scale not allowed on X axis'
        ENDIF
        IREP1 = 0
      ENDIF
      IF (ILOGYOK.EQ.0) THEN
        PRINT*,' '
        IF (FRANCAIS) THEN
          PRINT*,' L''axe des Y a une chelle ',ECHLOG(ILOGY)
          CALL LIENTIER(' On change ou pas ? (oui:1 ; non:0)',0,IREP2)
        ELSE
          PRINT*,' The Y axis has a ',ECHLOG(ILOGY),' scale'
          CALL LIENTIER(
     &           ' Do you want to change? (yes:1 ; no:0)',0,IREP2)
        ENDIF
        IF (IREP2.NE.0) THEN
          ILOGY = -ILOGY
          CALL LOLO(YPOINT,YMIN,YMAX,ILOGY)
        ENDIF
      ELSE
        IF (FRANCAIS) THEN
          PRINT*,'*** Echelle Log impossible sur Oy'
        ELSE
          PRINT*,'*** Log scale not allowed on Y axis'
        ENDIF
        IREP2 = 0
      ENDIF
      IF (IREP1.EQ.0.AND.IREP2.EQ.0) THEN
        GOTO 890
      ELSE
        XMIN = XMIN+0.01*(XMAX-XMIN)
        XMAX = XMAX-0.01*(XMAX-XMIN)
        YMIN = YMIN+0.01*(YMAX-YMIN)
        YMAX = YMAX-0.01*(YMAX-YMIN)
cc        print*,xmin,xmax,ymin,ymax
        GOTO 1113
      ENDIF
C
C Axes ou pas (c)
C
 2012 IOPT = -IOPT
      GOTO 999
C
C Points discrets (d)
C
 2013 IDISC=-IDISC
      IF (IDISC.LT.0) THEN
        DO I=1,NCMAX
          NMARK(I) = NMARK1(I)
          ILT(I)   = -1
          ICOLM(I) = ICOL(I)
        ENDDO
      ELSE
        DO I=1,NCMAX
          NMARK(I) = 0
          ILT(I)   = ILT0(I)
          ICOLM(I) = 2
        ENDDO
      ENDIF
      JHELP = 0
      GOTO 999
C
C Anglais / Francais (E)
C
 2014 FRANCAIS = .NOT.FRANCAIS
      IF (FRANCAIS) THEN
        IF (NCOURB.GT.1) THEN
          MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &    //CHIFFRE//' courbes'
        ELSE
          MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &    //CHIFFRE//' courbe '
        ENDIF
        CALL BERLITZ(0)
      ELSE
        IF (NCOURB.GT.1) THEN
          MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &    //CHIFFRE//' plots  '
        ELSE
          MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &    //CHIFFRE//' plot   '
        ENDIF
        CALL BERLITZ(1)
      ENDIF
      DO I=1,NCMAX
        NPREG(1,I) = 0
        NPREG(2,I) = 0
      ENDDO
      JHELP = 0
      GOTO 999
C
C Echange des marqueurs (f)
C
 2015 IF (IMARK.LT.0) THEN
        DO I=1,NCMAX
          NMARK(I) =  NMARK(I)+1
          IF (NMARK(I).EQ.14) NMARK(I) = 1
        ENDDO
        JHELP = 0
        GOTO 999
      ELSE
        GOTO 1000
      ENDIF
C
C Quadrillage (g)
C
 2016 IF (IQUADR.GT.0) THEN
        IQUADR = -1
      ELSEIF(IQUADR.EQ.-1) THEN
        IQUADR = -2
      ELSE
        IQUADR = 1
      ENDIF
      GOTO 999
C
C Translation avec curseur (h)
C
 2017 CALL GSQCUR(WIN,XCURCUR,YCURCUR)
      IF (XCURCUR.GT.XHELP) THEN
        IAHELP = -IAHELP
        ICLIC = 1
        JHELP = 0
        GOTO 888
      ENDIF
 3017 XDEMI = 0.5*(XMAX-XMIN)
      XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
      XMIN = XCURCUR-XDEMI
      XMAX = XCURCUR+XDEMI
      YDEMI = 0.5*(YMAX-YMIN)
      YMIN = YCURCUR-YDEMI
      YMAX = YCURCUR+YDEMI
      ITOUCX = 1
      ITOUCY = 1
      GOTO 99
C
C Zoom avant avec curseur (i)
C
 2018 CALL GSQCUR(WIN,XXXXX,YYYYY)
      XDEMI = 0.5*(XMAX-XMIN)
      XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
      XMIN = XXXXX-XDEMI/ZOOM
      XMAX = XXXXX+XDEMI/ZOOM
      YDEMI = 0.5*(YMAX-YMIN)
      YMIN = YYYYY-YDEMI/ZOOM
      YMAX = YYYYY+YDEMI/ZOOM
      ITOUCX = 1
      ITOUCY = 1
      GOTO 99
C
C Zoom arriere avec curseur (j)
C
 2019 CALL GSQCUR(WIN,XXXXX,YYYYY)
      XDEMI = 0.5*(XMAX-XMIN)
      XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
      XMIN = XXXXX-XDEMI*ZOOM
      XMAX = XXXXX+XDEMI*ZOOM
      YDEMI = 0.5*(YMAX-YMIN)
      YMIN = YYYYY-YDEMI*ZOOM
      YMAX = YYYYY+YDEMI*ZOOM
      ITOUCX = 1
      ITOUCY = 1
      GOTO 99
C
C Echange les axes (K)
C
 2020 DO I=1,NCOURB
        DO J=1,NPOINT(I)
          K = NDEB(I)+J
          CALL ECHR(XPOINT(K),YPOINT(K))
        ENDDO
      ENDDO
      IECHANGE = -IECHANGE
      CALL ECHR(XMIN,YMIN)
      CALL ECHR(XMAX,YMAX)
      CALL ECHR(XMIN00,YMIN00)
      CALL ECHR(XMAX00,YMAX00)
      CALL ECHR(XMIN000,YMIN000)
      CALL ECHR(XMAX000,YMAX000)
      CALL ECHI(NDX,NDY)
      CALL ECHI(ILOGX,ILOGY)
      CALL ECHI(ITIMEX,ITIMEY)
      CBID(1:NABS) = ABSC(1:NABS)
      IBID = NABS
      NABS = NORD
      ABSC(1:NABS) = ORDON(1:NORD)
      NORD = IBID
      ORDON(1:NORD) = CBID(1:IBID)
      NDMX  = MAX0(NDX,NDY)
      DO I=1,NDMX
        CALL ECHD(XX(I),YY(I))
        CALL ECHL(LXX(I),LYY(I))
      ENDDO
      IF (IFLAGEC.NE.0) IFLAGEC = 0
      GOTO 102
C
C Changement de legendes (l)
C
 2021 IF (ABS(IOPT).LE.1) IOPT2 = 11
      ISIGN = IOPT/ABS(IOPT)
      GOTO 2109
C
C Couleur / Monochrome (m)
C
 2022 IMONO = -IMONO
      JHELP = 0
      GOTO 999
C
C Couleur des marqueurs (n)
C
 2023 DO I=1,NCMAX
        ICOLM(I) = ICOLM(I)+1
        IF (ICOLM(I).EQ.16) ICOLM(I) = 0
      ENDDO
      JHELP = 0
      GOTO 999
C
C Postscript couleur (o)
C
 2024 IPOSTCOL = 1
CC      NBCOL0 = 256
      CALL LITTABLE(SAUVTABCO,NBCOL0)
      CALL METTABLE(SAUVTABCO,NBCOL0)
      GOTO 2002
C
C Postscript LaTeX (p)
C
 2025 ILATEX = 1
      GOTO 2002
C
C Proportions (3)
C
 2026 IF (PROP.GT.2.) THEN
        PROP = HXA4/HYA4
        IPROX = 98
        IPROY = 68
      ELSEIF(PROP.GT.1.) THEN
        PROP = 1.
        IPROX = 85
        IPROY = 80
      ELSEIF(PROP.LT.0.5) THEN
        PROP = 2.*HXA4/HYA4
        IPROX = 98
        IPROY = 38
      ELSEIF(PROP.LT.1.) THEN
        PROP = 0.5*HYA4/HXA4
        IPROX = 42
        IPROY = 98
      ELSE
        PROP = HYA4/HXA4
        IPROX = 68
        IPROY = 95
      ENDIF
      IPROXINI = IPROX
      IPROYINI = IPROY
      IFONT0 = 0
      IFONT1 = 1
      IFONT2 = 2
      IFONT3 = 3
      CALL TAILLE_FEN(IPROX,IPROY,1)
      NEWFON = 0
      JHELP = 0
      GOTO 102
C
C Changement de fichiers (r)
C
 2027 CALL FSTERM(1)
 3027 IF (FRANCAIS) THEN
        PRINT*,'Les fichiers actuels :'
      ELSE
        PRINT*,'The files already red are:'
      ENDIF
      DO I=1,NCOURB
        WRITE(*,'(I6," : ",A)') I,FICHIER(I)(1:LONG(I))
      ENDDO
      IF (FRANCAIS) THEN
        PRINT*,'Pour en changer un, tapez son numro'
        IF (NCOURB.GT.1)  PRINT*,'Pour en enlever un, tapez -son numro'
        IF (NCOURB.LT.NCMAX) PRINT*,'Pour en ajouter un, tapez',NCOURB+1
        PRINT*,'Pour finir tapez 0'
        CALL LIENTIER('Votre choix ?',0,IREP)
      ELSE
        PRINT*,'To change one of them, type its number'
        IF (NCOURB.GT.1)
     &    PRINT*,'To suppress one of them, type -its number'
        IF (NCOURB.LT.NCMAX) PRINT*,'To add one, type',NCOURB+1
        PRINT*,'To return, type 0'
        CALL LIENTIER('Your choice?',0,IREP)
      ENDIF
      IF (IREP.LT.-NCOURB) GOTO 3027
      IF (IREP.EQ.0) THEN
        WRITE(CHIFFRE,'(I4)') NCOURB
        IF (FRANCAIS) THEN
          IF (NCOURB.GT.1) THEN
            MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &      //CHIFFRE//' courbes'
          ELSE
            MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &      //CHIFFRE//' courbe '
          ENDIF
        ELSE
          IF (NCOURB.GT.1) THEN
            MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &      //CHIFFRE//' plots  '
          ELSE
            MEMO = DATE(5:6)//'/'//DATE(3:4)//'/'//DATE(1:2)//' '//MOI
     &      //CHIFFRE//' plot   '
          ENDIF
        ENDIF
        IDEB = 1
        JHELP = 0
        DO I=1,NCMAX
          NPREG(1,I) = 0
          NPREG(2,I) = 0
        ENDDO
        GOTO 1113
      ELSEIF(ABS(IREP).GT.MIN(NCOURB+1,NCMAX)
     &        .OR.IREP.EQ.-MIN(NCOURB+1,NCMAX)
     &        .OR.(IREP.LT.0.AND.NCOURB.EQ.1)) THEN
        GOTO 3027
      ELSEIF(IREP.LT.0) THEN
        IREP = -IREP
        IF (IREP.LT.NCOURB) THEN
          DO I=IREP+1,NCOURB
            IGR = 9 + I
            FICHIER(I-1) = FICHIER(I)(1:LONG(I))
            LONG(I-1) = LONG(I)
            CALL CHERCHE_COLONNES(FICHIER(I),LONG(I),LONGEFF
     &                           ,ICOL1,ICOL2)
            OPEN(10,FILE=FICHIER(I)(1:LONGEFF),STATUS='OLD')
            CALL LECTUR(IGR,NCOL,ICOL1,ICOL2)
          ENDDO
        ENDIF
        NCOURB = NCOURB-1
        GOTO 3027
      ELSEIF(IREP.GT.NCOURB.AND.IREP.LE.NCMAX) THEN
        NCOURB = NCOURB+1
        I = NCOURB
      ELSE
        I = IREP
      ENDIF
C
 4027 IF (I.LT.10) THEN
        WRITE(CHIFFRE,'(I2)') I
        IL = 2
      ELSEIF(I.LT.100) THEN
        WRITE(CHIFFRE,'(I3)') I
        IL = 3
      ELSE
        WRITE(CHIFFRE,'(I4)') I
        IL = 4
      ENDIF
      IF (FRANCAIS) THEN
 5027   CALL LIFICHTAB('Nom du fichier contenant la courbe'
     &       //CHIFFRE(1:IL)
     &                ,0,FICHIER(I),LONG(I),0)
        IF (LONG(I).LT.0) GOTO 5027
      ELSE
 5028   CALL LIFICHTAB('Name of the file containing plot no.'
     &       //CHIFFRE(1:IL)
     &                ,0,FICHIER(I),LONG(I),1)
        IF (LONG(I).LT.0) GOTO 5028
      ENDIF
      IGR = 10 + I
      OPEN(10,FILE=FICHIER(I)(1:LONG(I)),STATUS='OLD',IOSTAT=IERR)
      IF (IERR.NE.0) THEN
        IF (FRANCAIS) THEN
          PRINT*,'*** Ce fichier n''existe pas - recommencez'
        ELSE
          PRINT*,'*** This file doesn''t exist - type it again'
        ENDIF
        GOTO 4027
      ELSE
        CLOSE(10)
      ENDIF
      GOTO 3027
C
C Changement de types de lignes (s)
C
 2028 CALL FSTERM(1)
      CALL DEFMAN
      CALL FSINN(IPROX,IPROY,PROBIG,IDEBU,ITERMC)
      JHELP = 0
      GOTO 999
C
C Echelles initiales (t)
C
 2029 XMIN000 = XMIN
      XMAX000 = XMAX
      YMIN000 = YMIN
      YMAX000 = YMAX
      XMIN = XMIN00
      XMAX = XMAX00
      YMIN = YMIN00
      YMAX = YMAX00
      ITOUCX = 0
      ITOUCY = 0
      GOTO 99
C
C Echelles precedentes (u)
C
 2030 CALL ECHR(XMIN,XMIN000)
      CALL ECHR(XMAX,XMAX000)
      CALL ECHR(YMIN,YMIN000)
      CALL ECHR(YMAX,YMAX000)
      GOTO 99
C
C Types d'axes (v)
C
 2031 IAXES = IAXES+1
      IF (IAXES.EQ.3) IAXES=0
      GOTO 999
C
C bar chart (w)
C
 2032 IBAR = -IBAR
      GOTO 999
C
C Animation (x)
C
 2033 CALL FSTERM(1)
      IF (NCOURB.GT.1) THEN
        IF (FRANCAIS) THEN
          CALL LIENTIER(
     &         'Fichiers  la suite (0) ou ensemble bout par bout (1) ?'
     &         ,0,IREP)
        ELSE
          CALL LIENTIER('Successive files (0) or all-together (1)?'
     &                 ,0,IREP)
        ENDIF
        IF (IREP.EQ.0) THEN
          IFILM = 1
        ELSE
          IFILM = 2
        ENDIF
      ELSE
        IFILM = 2
      ENDIF
      IF (FRANCAIS) THEN
        IF (IFILM.EQ.2) THEN
          CALL LIENTIER(
     &'Nombre de points affichs  la fois (0 -> on garde la trace) ?'
     &                 ,0,NUMPT)
          CALL LIENTIER('Progression entre chaque image ?',0,NUMANI)
          IF (NUMPT.LE.1) NUMPT = 0
          NUMANI = MAX(1,NUMANI)
        ENDIF
        CALL LIENTIER(
     &'Pause entre chaque image (entier: 1/1000 secondes par unit) ?'
     &    ,0,NRALEN)
        CALL LIENTIER('Nombre de passages ?',0,NBTOUR)
        CALL LIENTIER('Sens des fichiers (0) ou "ping-pong" (1) ?'
     &               ,0,IBOUNCE)
      ELSE
        IF (IFILM.EQ.2) THEN
          CALL LIENTIER(
     &'Num. of points displayed on each frame (0: footprint displayed)?'
     &                 ,0,NUMPT)
          CALL LIENTIER('Progression between frames?',0,NUMANI)
          IF (NUMPT.LE.1) NUMPT = 0
          NUMANI = MAX(1,NUMANI)
        ENDIF
        CALL LIENTIER(
     &'Pause between images (integer: 1/1000 secondes per unit) ?'
     &    ,0,NRALEN)
        CALL LIENTIER('Number of passes?',0,NBTOUR)
        CALL LIENTIER('One way (0) or bounce (1)?',0,IBOUNCE)
      ENDIF
      NRALEN = MAX(0,NRALEN)
      FACWINS = FACWIN
      CALL FSINN(IPROX,IPROY,PROBIG,IDEBU,ITERMC)
      GOTO 999
C
C Sauvegarde des fct interp dans un fichier (y)
C
 2034 IF (INTERP.GT.0) THEN
        DO I=1,INTERP
          IF (I.LT.10) THEN
            LL = 3
          ELSEIF(I.LT.100) THEN
            LL = 2
          ELSE
            LL = 1
          ENDIF
          WRITE(CC,'(I3)') I
          CBID = 'graphic'//CC(LL:3)//'.g'
          LBID = 13-LL
          OPEN(31,FILE=CBID(1:LBID))
          CALL GSLSS(IFONT2)
          CALL GSCHAR(XCUR,YCUR,LBID,CBID)
          IF (FRANCAIS) THEN
            PRINT*,'Sauvegarde du fichier : '//CBID(1:LBID)
          ELSE
            PRINT*,'Saving in file: '//CBID(1:LBID)
          ENDIF
          II = NINTER(I)
          WRITE(31,'(A)') '# '//FICHIER(II)(1:LONG(II))
          DO J=1,NPOINT(II)
            K = NDEB(II)+J
            WRITE(31,*) XPOINT(K),YPOINT(K)
          ENDDO
          CLOSE(31)
        ENDDO
        GOTO 999
      ELSE
        GOTO 1000
      ENDIF
C
C Parametres de trace par defaut / defautbis (transparents coul) (z)
C
 2035 IF (IDEFT.GT.0) THEN
        DO I=1,NCMAX
          IEPL(I) = IDEFT+1
          IF (ICOL(I).EQ.5.OR.ICOL(I).EQ.13) ICOL(I) = 15
          IF (ICOL(I).EQ.4.AND.IDEFT.EQ.1) ICOL(I) = 3
          IF (ICOL(I).EQ.8) ICOL(I) = 4
        ENDDO
        IF (IDEFT.EQ.1) THEN
          IDEFT = 2
        ELSEIF(IDEFT.EQ.2) THEN
          IDEFT = 3
        ELSE
          IDEFT = -1
        ENDIF
      ELSE
        DO I=1,NCMAX
cc          ILT(I)  = ILT0(I)
          IEPL(I) = 1
          ICOL(I) = ICOL0(I)
        ENDDO
        IDEFT = 1
      ENDIF
      JHELP = 0
      GOTO 999
C
 9999 CALL FSTERM(0)
      END
C====================================
      SUBROUTINE ECHR(X,Y)
      XBID = X
      X = Y
      Y = XBID
      END
C====================================
      SUBROUTINE ECHI(I,J)
      IBID = I
      I = J
      J = IBID
      END
C====================================
      SUBROUTINE ECHD(X,Y)
      REAL*8 X,Y,XBID
      XBID = X
      X = Y
      Y = XBID
      END
C====================================
      SUBROUTINE ECHL(X,Y)
      LOGICAL*4 X,Y,XBID
      XBID = X
      X = Y
      Y = XBID
      END
C=========================================================================
      SUBROUTINE ECR16COUL(FRANCAIS)
      LOGICAL*4 FRANCAIS
C
Cgpr      PRINT*,'Couleurs disponibles :'
Cgpr      PRINT*,' 0 : Noir (Blanc) |  1 : Rouge        |  2 : Vert'
Cgpr      PRINT*,' 3 : Bleu         |  4 : Bleu ciel    |  5 : Jaune'
Cgpr      PRINT*,' 6 : Magenta      |  7 : Blanc (noir) |  8 : Paille'
Cgpr      PRINT*,' 9 : Vert fonce   | 10 : Rose pale    | 11 : Carmin'
Cgpr      PRINT*,
Cgpr     &'12 : Blanc        | 13 : Outremer     | 14 : Paille jaune'
Cgpr      PRINT*,'15 : Marron'
Cgpr
      IF (FRANCAIS) THEN
      PRINT*,'Couleurs disponibles :'
      PRINT*,' 0 : Noir (blanc) |  1 : Rouge        |  2 : Vert'
      PRINT*,' 3 : Bleu         |  4 : Cyan         |  5 : Jaune'
      PRINT*,' 6 : Magenta      |  7 : Blanc (noir) |  8 : Gris clair'
      PRINT*,' 9 : Framboise    | 10 : Vert ple    | 11 : Bleu gris'
      PRINT*,'12 : Bleu ple    | 13 : Cyan fonc   | 14 : Mauve'
      PRINT*,'15 : Gris fonc'
      ELSE
      PRINT*,'Available colors:'
      PRINT*,' 0 : Black (white) |  1 : Red           |  2 : Green'
      PRINT*,' 3 : Blue          |  4 : Cyan          |  5 : Yellow'
      PRINT*,' 6 : Magenta       |  7 : White (black) |  8 : Light gray'
      PRINT*,' 9 : Deep pink     | 10 : Light green   | 11 : Slate blue'
      PRINT*,'12 : Light blue    | 13 : Dark cyan     | 14 : Purple'
      PRINT*,'15 : Dark gray'
      ENDIF
      END
C=======================================================================
      LOGICAL*4 FUNCTION WILD(NOM,LONG)
      CHARACTER*(*) NOM
      WILD = .FALSE.
      DO I=1,LONG
        IF (NOM(I:I).EQ.'*'.OR.NOM(I:I).EQ.'{'.OR.NOM(I:I).EQ.'}'
     &  .OR.NOM(I:I).EQ.'?') THEN
          WILD = .TRUE.
          RETURN
        ENDIF
      ENDDO
      END
C=======================================================================
      SUBROUTINE DECAL(IR,FICH,LONG)
      CHARACTER*128 FICH(*)
      INTEGER       LONG(*)
      IR = IR-1
      IF (IR.GT.0) THEN
        DO I=1,IR
          FICH(I) = FICH(I+1)
          LONG(I) = LONG(I+1)
        ENDDO
      ENDIF
      END
C=======================================================================
      SUBROUTINE LOLO(XX,XMI,XMA,ILOLO)
C
      DIMENSION XX(*)
      INCLUDE 'param.f'
C
      XMI = 1.E30
      XMA = -1.E30
      DO I=1,NCOURB
        III = NDEB(I)
        DO K=1,NPOINT(I)
          J = K+III
          IF (ILOLO.GT.0) THEN
            IF (XX(J).EQ.-987654321.) THEN
              XX(J) = 0.
            ELSE
              XX(J) = 10.**XX(J)
            ENDIF
            XMA = MAX(XMA,XX(J))
            XMI = MIN(XMI,XX(J))
          ELSE
            IF (XX(J).EQ.0.) THEN
              XX(J) = -987654321.
            ELSE
              XX(J) = ALOG10(XX(J))
              XMA = MAX(XMA,XX(J))
              XMI = MIN(XMI,XX(J))
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      END
C----------------------------------------------------------------------
      SUBROUTINE CHERCHE_COLONNES(FICH,LONG,LONGEFF,ICOL1,ICOL2)
      CHARACTER*128 FICH
      CHARACTER*1 C
      INTEGER IPOS(2)
      DATA C /'#'/
C
      IERR = 0
      NC = 0
      DO I=LONG,1,-1
        IF (FICH(I:I).EQ.C) THEN
          IF (NC.LT.2) THEN
            NC = NC+1
            IPOS(NC) = I
          ENDIF
        ENDIF
      ENDDO
      ICOL1 = 1
      ICOL2 = 2
      LONGEFF = LONG
      IF (NC.GT.0.AND.IPOS(1).LT.LONG) THEN
        READ(FICH(IPOS(1)+1:LONG),*,ERR=10) ICOL2
        IF (NC.EQ.1) THEN
          LONGEFF = IPOS(1)-1
        ELSE
          READ(FICH(IPOS(2)+1:IPOS(1)-1),*,ERR=10) ICOL1
          LONGEFF = IPOS(2)-1
        ENDIF
      ENDIF
      RETURN
C
 10   ICOL2 = 2
      ICOL1 = 1
      LONGEFF = LONG
      END



