/****************************************************

		X De Block!
		
		     game Item programs.
		
  *******************************************************/
		
#include	"gameheader.h"

#include        "xpm/item1.xpm"
#include        "xpm/item2.xpm"
#include        "xpm/item3.xpm"
#include        "xpm/item4.xpm"
#include        "xpm/item5.xpm"
#include        "xpm/item6.xpm"
#include        "xpm/item7.xpm"
#include        "xpm/item8.xpm"
#include        "xpm/item9.xpm"
#include        "xpm/item10.xpm"
#include        "xpm/item11.xpm"
#include        "xpm/item12.xpm"
#include        "xpm/item13.xpm"
#include        "xpm/item14.xpm"
#include        "xpm/item15.xpm"
#include        "xpm/item16.xpm"
#include        "xpm/item17.xpm"
#include        "xpm/item18.xpm"


extern Display     *display;                   /* global display      */
extern Window      mWin;                       /* global main window  */
extern GC          gc;                         /* global gc           */
extern Pixmap      offPixmap,backPicPixmap;    /* global offscreen pixmaps */
extern XFontStruct *xfont;                     /* global font         */
extern Colormap    cmap;                       /* global cmap         */


extern allDataRec  nowDataRec;
extern mapFilePtr  nowMapFile;
extern flgs   	   gameMainFlg;


Pixmap             itemP[19];

void itemEffect();


void initItemPix(void)
{
  int             err;
  Pixmap          mask;
  XpmAttributes   attributes;

  attributes.valuemask = XpmColormap;
  attributes.colormap = cmap;

  err = XpmCreatePixmapFromData(display,mWin,item1_xpm,
				&itemP[1],&mask,&attributes);
  handleXPMError(err,"init item[1]");
  err = XpmCreatePixmapFromData(display,mWin,item2_xpm,
				&itemP[2],&mask,&attributes);
  handleXPMError(err,"init item[2]");
  err = XpmCreatePixmapFromData(display,mWin,item3_xpm,
				&itemP[3],&mask,&attributes);
  handleXPMError(err,"init item[3]");
  err = XpmCreatePixmapFromData(display,mWin,item4_xpm,
				&itemP[4],&mask,&attributes);
  handleXPMError(err,"init item[4]");
  err = XpmCreatePixmapFromData(display,mWin,item5_xpm,
				&itemP[5],&mask,&attributes);
  handleXPMError(err,"init item[5]");
  err = XpmCreatePixmapFromData(display,mWin,item6_xpm,
				&itemP[6],&mask,&attributes);
  handleXPMError(err,"init item[6]");
  err = XpmCreatePixmapFromData(display,mWin,item7_xpm,
				&itemP[7],&mask,&attributes);
  handleXPMError(err,"init item[7]");
  err = XpmCreatePixmapFromData(display,mWin,item8_xpm,
				&itemP[8],&mask,&attributes);
  handleXPMError(err,"init item[8]");
  err = XpmCreatePixmapFromData(display,mWin,item9_xpm,
				&itemP[9],&mask,&attributes);
  handleXPMError(err,"init item[9]");
  err = XpmCreatePixmapFromData(display,mWin,item10_xpm,
				&itemP[10],&mask,&attributes);
  handleXPMError(err,"init item[10]");
  err = XpmCreatePixmapFromData(display,mWin,item11_xpm,
				&itemP[11],&mask,&attributes);
  handleXPMError(err,"init item[11]");
  err = XpmCreatePixmapFromData(display,mWin,item12_xpm,
				&itemP[12],&mask,&attributes);
  handleXPMError(err,"init item[12]");
  err = XpmCreatePixmapFromData(display,mWin,item13_xpm,
				&itemP[13],&mask,&attributes);
  handleXPMError(err,"init item[13]");
  err = XpmCreatePixmapFromData(display,mWin,item14_xpm,
				&itemP[14],&mask,&attributes);
  handleXPMError(err,"init item[14]");
  err = XpmCreatePixmapFromData(display,mWin,item15_xpm,
				&itemP[15],&mask,&attributes);
  handleXPMError(err,"init item[15]");
  err = XpmCreatePixmapFromData(display,mWin,item16_xpm,
				&itemP[16],&mask,&attributes);
  handleXPMError(err,"init item[16]");
  err = XpmCreatePixmapFromData(display,mWin,item17_xpm,
				&itemP[17],&mask,&attributes);
  handleXPMError(err,"init item[17]");
  err = XpmCreatePixmapFromData(display,mWin,item18_xpm,
				&itemP[18],&mask,&attributes);
  handleXPMError(err,"init item[18]");
  
  XpmFreeAttributes(&attributes);
}

void freeItem(void)
{
  register i;

  for(i =18;i > 0;i--)
    XFreePixmap(display,itemP[i]);

}

void moveAndCheckItem(void)
{
  register iNum,box,itemMax;
	
  itemMax = nowDataRec.nowMap.itemNum;
	
  for(box ^=box ;box < itemMax ;box++)
    {
      iNum = nowDataRec.nowMap.mvItemBox[box];
      
      /*****	move Item !		*****/
      
      nowDataRec.nowItem[iNum].prevRect = nowDataRec.nowItem[iNum].nowRect;
      nowDataRec.nowItem[iNum].nowRect.y += 2;
      
      /******		draw Item !		******/
      
      drawItem(iNum);	
      
      /*****		item Check functions	*****/
      
      if(touchBarCheckItem(iNum,box))
	{
	  itemMax --;
	  box --;
	}
      if(lostCheckItem(iNum,box))
	{
	  itemMax --;
	  box --;
	}
    }	
}

int touchBarCheckItem(iNum ,box)
     register iNum,box;
{
  register itemRight,barRight;

  itemRight = nowDataRec.nowItem[iNum].nowRect.x + nowDataRec.nowItem[iNum].nowRect.width - 12;
  barRight = nowDataRec.nowBar.nowRect.x + nowDataRec.nowBar.nowRect.width;

  if((nowDataRec.nowItem[iNum].nowRect.y >= (dWinHeight - dBlockHeight*5/2))
     &&(nowDataRec.nowItem[iNum].nowRect.y <= (dWinHeight - dBlockHeight*3/2)))
    if(((nowDataRec.nowItem[iNum].nowRect.x+12) >=nowDataRec.nowBar.nowRect.x)
       &&(itemRight <= barRight))
	  {
	    drawBack_Off(&nowDataRec.nowItem[iNum].nowRect);
	    drawBar();
	    nowDataRec.nowItem[iNum].nowFlg.life = False;
	
	    nowDataRec.nowMap.mvItemBox[box] = nowDataRec.nowMap.mvItemBox[nowDataRec.nowMap.itemNum-1];
	
	    itemEffect(iNum);
	
	    nowDataRec.nowMap.itemNum --;
	    return(True);
	  }
  return(False);
}

void disposeItem(iNum,box)
     register iNum,box;
{
  nowDataRec.nowItem[iNum].nowFlg.life = False;
				
  nowDataRec.nowMap.mvItemBox[box] = nowDataRec.nowMap.mvItemBox[nowDataRec.nowMap.itemNum-1];
      									
  nowDataRec.nowMap.itemNum --;
}

int lostCheckItem(iNum,box)
     register iNum,box;
{
  if(nowDataRec.nowItem[iNum].nowRect.y >= dWinHeight)
    {
      disposeItem(iNum,box);	
      return(True);
    }
  return(False);
}


void serveItem(tempRect,kind)
     XRectangle *tempRect;
     register   kind;
{
  register i;
		
  if((++nowDataRec.nowMap.itemNum) >dItemMax)
    {
      nowDataRec.nowMap.itemNum --;
      return;
    }
  
  for(i ^=i; i < nowDataRec.nowMap.itemNum; i++)
    if(nowDataRec.nowItem[i].nowFlg.life == 0)
      {
	nowDataRec.nowMap.mvItemBox[nowDataRec.nowMap.itemNum-1]  = i;
	
	switch(kind)
	  {
	  case dScore100:			
	    nowDataRec.nowItem[i].itemKind = dScore100;
	    break;	
	  case dScore200:
	    nowDataRec.nowItem[i].itemKind = dScore200;
	    break;					
	  case dScore500:
	    nowDataRec.nowItem[i].itemKind = dScore500;
	    break;					
	  case dScoreM100:
	    nowDataRec.nowItem[i].itemKind = dScoreM100;
	    break;					
	  case dScoreM200:
	    nowDataRec.nowItem[i].itemKind = dScoreM200;
	    break;					
	  case dScoreM400:
	    nowDataRec.nowItem[i].itemKind = dScoreM400;
	    break;					
	  case dBarPlus:
	    nowDataRec.nowItem[i].itemKind = dBarPlus;
	    break;					
	  case dBarMinus:
	    nowDataRec.nowItem[i].itemKind = dBarMinus;
	    break;					
	  case dBallLPlus:
	    nowDataRec.nowItem[i].itemKind = dBallLPlus;
	    break;					
	  case dBallLMinus:
	    nowDataRec.nowItem[i].itemKind = dBallLMinus;
	    break;					
	  case dBallPlus1:
	    nowDataRec.nowItem[i].itemKind = dBallPlus1;
	    break;					
	  case dBallMinus1:
	    nowDataRec.nowItem[i].itemKind = dBallMinus1;
	    break;					
	  case dBallx2:
	    nowDataRec.nowItem[i].itemKind = dBallx2;
	    break;					
	  case dRevers:
	    nowDataRec.nowItem[i].itemKind = dRevers;
	    break;
	  case dSpeedUp:
	    nowDataRec.nowItem[i].itemKind = dSpeedUp;
	    break;
	  case dSpeedDown:
	    nowDataRec.nowItem[i].itemKind = dSpeedDown;
	    break;
	  case dWallThrough:
	    nowDataRec.nowItem[i].itemKind = dWallThrough;
	    break;
	  case dUseG:
	    nowDataRec.nowItem[i].itemKind = dUseG;
	    break;
	    
	  }
	
	nowDataRec.nowItem[i].nowRect.y      = tempRect->y + 16;
	nowDataRec.nowItem[i].nowRect.x      = tempRect->x + 6;
	nowDataRec.nowItem[i].nowRect.width  = dBlockWidth *2/3;
	nowDataRec.nowItem[i].nowRect.height = dBlockHeight;
	nowDataRec.nowItem[i].nowFlg.life    = True;
	nowDataRec.nowItem[i].nowPoint.x     = 0;
		
	break;
      }	
}

void randomItem(k)
     register k;
{
  register	    temp;  


  temp = g_random();

  if((temp>-1500)&&(temp<10000))
    if(temp > 3000)
      {
	if(temp > 5000)
	  if(temp > 6000)
	    if(temp > 8000)
		serveItem(&nowDataRec.nowBlock[k].nowRect,dScore100);
	    else
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dScoreM100);
	  else 
	    if(temp > 5500)
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dScore200);
	    else 
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dScoreM200);
	else 
	  if(temp > 4500)
	    if(temp > 4750)
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dScore500);
	    else 
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dScoreM400);
	  else
	    if(temp > 3500)
	      if(temp > 4000)
		serveItem(&nowDataRec.nowBlock[k].nowRect,dBarPlus);
	      else
		serveItem(&nowDataRec.nowBlock[k].nowRect,dBarMinus);
	    else
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dBallLPlus);
      }
    else 
      {
	if(temp > 1000)
	  if(temp > 2000)
	    if(temp > 2500)
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dBallLMinus);
	    else
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dBallPlus1);
	  else 
	    if(temp > 1500)
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dBallMinus1);
	    else 	
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dBallx2);
	
	else 
	  if(temp > 0)
	    if(temp > 500)
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dRevers);
	    else
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dSpeedUp);
	  else 
	    if(temp > -1000)
	      if(temp > -500)
		serveItem(&nowDataRec.nowBlock[k].nowRect,dSpeedDown);
	      else 
		serveItem(&nowDataRec.nowBlock[k].nowRect,dWallThrough);
	    else
	      serveItem(&nowDataRec.nowBlock[k].nowRect,dUseG);
      }
}		

void itemEffect(itemNum)
     register itemNum;
{
  register i,j,k,num;
	
  switch(nowDataRec.nowItem[itemNum].itemKind)
    {
    case dScore100:			
      nowDataRec.nowMap.myScore += 100;
      statScoreDraw();
      break;	
    case dScore200:
      nowDataRec.nowMap.myScore += 200;
      statScoreDraw();
      break;					
    case dScore500:
      nowDataRec.nowMap.myScore += 500;
      statScoreDraw();
      break;					
    case dScoreM100:
      nowDataRec.nowMap.myScore -= 100;
      statScoreDraw();
      break;					
    case dScoreM200:
      nowDataRec.nowMap.myScore -= 200;
      statScoreDraw();
      break;
    case dScoreM400:
      nowDataRec.nowMap.myScore -= 400;
      statScoreDraw();
      break;					
    case dBarPlus:
      nowDataRec.nowBar.nowRect.width += 24;
      touchWallCheckBar();
      drawBar();
      break;					
    case dBarMinus:
      nowDataRec.nowBar.nowRect.width -= 24;
      drawBar();
      break;					
    case dBallLPlus:
      for(i ^=i; i <nowDataRec.nowMap.mvBallNum; i++)
	{
	  j = nowDataRec.nowMap.mvBallBox[i];
	  nowDataRec.nowBall[j].nowRect.width *=2;
	  nowDataRec.nowBall[j].nowRect.height *=2;
	}
      break;
      
    case dBallLMinus:
      for(i ^=i; i <nowDataRec.nowMap.mvBallNum; i++)
	{
	  j = nowDataRec.nowMap.mvBallBox[i];
	  nowDataRec.nowBall[j].nowRect.width /=2;
	  nowDataRec.nowBall[j].nowRect.height /=2;
	}
      break;
      
    case dBallPlus1:
      nowDataRec.nowMap.allBallNum ++;
      if(nowDataRec.nowMap.allBallNum >dBallMax)
	nowDataRec.nowMap.allBallNum --;
      
      statBallDraw();
      break;
      
    case dBallMinus1:
      if((nowDataRec.nowMap.allBallNum -nowDataRec.nowMap.mvBallNum)>0)
	nowDataRec.nowMap.allBallNum --;
      statBallDraw();
      break;
      
    case dBallx2:
      num = nowDataRec.nowMap.mvBallNum;
      for(i ^=i; i < num; i++)
	{
	  nowDataRec.nowMap.allBallNum ++;
	  if( nowDataRec.nowMap.allBallNum >dBallMax)
	    {
	      nowDataRec.nowMap.allBallNum --;
	      break;
	    }
#ifdef DEBUG
	  printf("before serve i=%d\n",i);
#endif	  
	  serveBall();
	  
	  j = nowDataRec.nowMap.mvBallBox[i];
	  k = nowDataRec.nowMap.mvBallBox[num+i];

#ifdef DEBUG
	  printf("i=%d,src=%d,cpy=%d\n",i,j,k);
#endif
	  nowDataRec.nowBall[k].nowRect = nowDataRec.nowBall[j].nowRect;
	  nowDataRec.nowBall[k].prevRect = nowDataRec.nowBall[j].prevRect;
	  nowDataRec.nowBall[k].x_v = nowDataRec.nowBall[j].x_v;
	  nowDataRec.nowBall[k].y_v = nowDataRec.nowBall[j].y_v;
	  nowDataRec.nowBall[k].x_a = nowDataRec.nowBall[j].x_a;
	  nowDataRec.nowBall[k].y_a = nowDataRec.nowBall[j].y_a;
	  nowDataRec.nowBall[k].x_v += 1*dBallWeight;
	}
      break;					
      
    case dRevers:
      nowDataRec.nowMap.revFlg *= -1;
      break;					
      
    case dSpeedUp:
      for(i ^=i; i <nowDataRec.nowMap.mvBallNum; i++)
	{
	  j = nowDataRec.nowMap.mvBallBox[i];
	  nowDataRec.nowBall[j].x_v = nowDataRec.nowBall[j].x_v *3/2;
	  nowDataRec.nowBall[j].y_v = nowDataRec.nowBall[j].y_v *3/2;
	}
      break;
    case dSpeedDown:
      for(i ^=i; i <nowDataRec.nowMap.mvBallNum; i++)
	{
	  j = nowDataRec.nowMap.mvBallBox[i];
	  nowDataRec.nowBall[j].x_v = nowDataRec.nowBall[j].x_v *2/3;
	  nowDataRec.nowBall[j].y_v = nowDataRec.nowBall[j].y_v *2/3;
	}
      break;
      
    case dWallThrough:
      gameMainFlg.wallThrough = True;
      break;
      
    case dUseG:
      for(i ^=i; i <nowDataRec.nowMap.mvBallNum; i++)
	{
	  j = nowDataRec.nowMap.mvBallBox[i];
	  if(g_random() >0)
	    nowDataRec.nowBall[j].y_a += 1;
	  else if(g_random() >0)
	    nowDataRec.nowBall[j].x_a += 1;
	  else
	    nowDataRec.nowBall[j].x_a -= 1;
	}
      break;
      
    }
}

		
