/*****************************************

		X De Block!
		
		      gameMain programs.
		
  ************************************************/

#include	"gameheader.h"

extern Display     *display;                   /* global display      */
extern Window      mWin;                       /* global main window  */
extern GC          gc;                         /* global gc           */
extern Pixmap      offPixmap,backPicPixmap;    /* global offscreen pixmaps */
extern XFontStruct *xfont;                     /* global font         */
extern Colormap    cmap;                       /* global cmap         */

extern allDataRec  nowDataRec;
extern mapFilePtr  nowMapFile;
extern flgs   	   gameMainFlg;

extern XColor      black,white;


void checkHiScore(void)
{
  register 	i,j,tempScore;
  unsigned long	tempNum;
  
  for(i ^=i; i < 10;i++)
    {
      tempScore = nowMapFile->hiScore[i] & 0x00ffffff;
      if(tempScore <= nowDataRec.nowMap.myScore)
	{
	  for(j =8; j >= i;j--)
	    {
	      nowMapFile->hiScore[j+1] = nowMapFile->hiScore[j];
	      strcpy(nowMapFile->hiScoreName[j+1],nowMapFile->hiScoreName[j]);
	    }
	  
	  nowMapFile->hiScore[i] = nowDataRec.nowMap.myScore;
	  tempNum =nowDataRec.nowMap.mapNum+1;
	  if(nowDataRec.nowMap.nowFlg.clearAllMap)
	    tempNum++;
	  tempNum <<= 24;
	  nowMapFile->hiScore[i] |= tempNum;
	  
	  strcpy(nowMapFile->hiScoreName[i],nowDataRec.nowMap.playerName);
	  nowDataRec.nowMap.nowFlg.upData = True;
	  break;		
	}
    }
}

void gameOver(void)
{	
  register	i;

  
/******	Check High Score ******/
	
  if(gameMainFlg.demoFlg == False)
    checkHiScore();
	

  hiScoreDLG();
	
  if(nowDataRec.nowMap.nowFlg.upData)
    fileUpData();

  /*****   Title demo Set	******/

  nowDataRec.nowMap.nowTime.tv_sec  = 0;
  nowDataRec.nowMap.nowTime.tv_usec = 0;
  nowDataRec.nowMap.prevScore       = 0;
}

void clearAllMap()
{
  register	hig,wid,i;
  XRectangle   	box;

  /***	cannot use continue. next time	***/
  
  nowDataRec.nowMap.continueCount = -1;

	
  /***	draw clear pict		***/
	

  
  /***	draw clear text		***/
  
  
}


void pauseDrawString(void)
{
  drawUpData();
  drawShadowText(display,mWin,200,250,
		 "Game Pause...",white.pixel);
  drawShadowText(display,mWin,60,300,
		 "Press 'P' key or Press mousebutton on bar.",white.pixel);
}

void handlePauseMouse(event)
     XButtonEvent   *event;
{
  if(ptInRect(&nowDataRec.nowBar.nowRect,event->x,event->y))
    {
      /*****	time count Set	*****/ 	
      gameMainFlg.pauseFlg = False;
      gettimeofday(&nowDataRec.nowMap.prevTime,NULL);

      nowDataRec.nowBar.nowRect.x = event->x -20;
      nowDataRec.nowBar.nowMPoint.x = event->x_root;
      nowDataRec.nowBar.nowMPoint.y = event->y_root;

      drawUpData();
      drawBar();		
    }	
}

void handlePauseKey(event)
     XKeyEvent *event;
{
  char   ch;
  KeySym keysym;

  XLookupString(event,&ch,1,&keysym,NULL);
  switch(keysym)
    {
    case XK_P:
    case XK_p:
      drawUpData();
      drawBar();	
	      
      /*****	time count Set	*****/

      gameMainFlg.pauseFlg = False;
      gettimeofday(&nowDataRec.nowMap.prevTime,NULL);
      break;

    case XK_Q:
    case XK_q:
      gameMainFlg.pauseFlg = False;
      nowDataRec.nowMap.nowFlg.life = False;
      nowDataRec.nowMap.nowFlg.gameOverFlg = False;
      
    default:
      break;
    }
}

void gamePause(void)
{
  XEvent     event;
  int        evt_count;

#ifdef DEBUG
  printf("XDeBlock: game pause\n");
#endif

  pauseDrawString();
  drawBar();
  gameMainFlg.pauseFlg = True;

  while(gameMainFlg.pauseFlg)
    {
      if(!gameMainFlg.demoFlg)	
	XPeekEvent(display,&event);

      for(evt_count = XEventsQueued(display,QueuedAfterReading);
	  evt_count > 0;evt_count--)
	{
	  XNextEvent(display,&event);
	  switch(event.type)
	    {	  
	    case Expose:
#ifdef EVENT_DEBUG
	      printf("Pause:Expose :%d\n",evt_count);
#endif
	      reDraw(&event);
	      pauseDrawString();
	      drawBar();
	      break;

	    case ButtonPress:
#ifdef EVENT_DEBUG
	      printf("Pause:ButtonPress :%d\n",evt_count);
#endif
	      handlePauseMouse(&event);
	      break;
	      
	    case KeyPress:
#ifdef EVENT_DEBUG
	      printf("Pause:KeyPress :%d\n",evt_count);
#endif
	      handlePauseKey(&event);
	      break;

	    default:
#ifdef EVENT_DEBUG
	      printf("Pause:default :%d\n",evt_count);
#endif
	      break;
	    }
	}
    }
}
	      
void handleGameKey(event)
     XKeyEvent  *event;
{
  char   ch;
  KeySym keysym;

  XLookupString(event,&ch,1,&keysym,NULL);
  switch(keysym)
    {
    case XK_Q:
    case XK_q:	/* Set GameOver Flag ! */
      nowDataRec.nowMap.nowFlg.life = False;
      nowDataRec.nowMap.nowFlg.gameOverFlg = False;
      break;
    case XK_P:
    case XK_p:	/* Call Pause Fanction ! */
      if(nowDataRec.nowMap.nowFlg.timeFlg)
	gamePause();
      break;
      
    default:
      break;
    }
}

void handleGameMouseDown(event)
     XButtonEvent *event;
{
  switch(event->button)
    {
    case Button1:
      serveBall();
      break;

    case Button2:
      drawUpData();
      break;

    case Button3:
      if(nowDataRec.nowMap.nowFlg.timeFlg)
	gamePause();
      break;
    }
}

void takeMousePoint(event)
     XPointerMovedEvent *event;
{
  nowDataRec.nowBar.prevMPoint  = nowDataRec.nowBar.nowMPoint;

  /***  not move with mouse  ***/
/*  nowDataRec.nowBar.nowMPoint.x = event->x_root;*/
/*  nowDataRec.nowBar.nowMPoint.y = event->y_root;*/
/*  nowDataRec.nowBar.bar_v = event->x - nowDataRec.nowBar.prevMPoint.x;*/

  /***  move with mouse  ***/
  nowDataRec.nowBar.nowMPoint.x = event->x;
  nowDataRec.nowBar.nowMPoint.y = event->y;
  nowDataRec.nowBar.bar_v = event->x - nowDataRec.nowBar.prevMPoint.x;

  if(nowDataRec.nowBar.bar_v > 4)
    nowDataRec.nowBar.bar_v =4;
  else if(nowDataRec.nowBar.bar_v < -4)
    nowDataRec.nowBar.bar_v =-4;
  
}


void gameEvent(void)
{
  XEvent    event;
  int       evt_count,flg = False;


  nowDataRec.nowBar.bar_v = 0;   

  if(!gameMainFlg.demoFlg)	
    XPeekEvent(display,&event);
    
  for(evt_count = XEventsQueued(display,QueuedAfterReading);
      evt_count > 0;evt_count--)
    {
      XNextEvent(display,&event);

      switch(event.type)
	{
	case Expose:
#ifdef EVENT_DEBUG
	  printf("Expose :%d\n",evt_count);
#endif
	  reDraw(&event);
	  drawBar();

	  statScoreDraw();
	  statBallDraw();
	  statStageDraw();
	  statTimeDraw();

	  break;

	case UnmapNotify:
	  XSelectInput(display, mWin, StructureNotifyMask);
#ifdef EVENT_DEBUG
	  printf("UnmapNotify :%d\n",evt_count);
#endif
	  break;
	case MapNotify:
	  XSelectInput(display,mWin,
		       KeyPressMask | KeyReleaseMask | ButtonPressMask |
		       ButtonReleaseMask | ExposureMask | StructureNotifyMask |
		       ButtonMotionMask| PointerMotionMask);
#ifdef EVENT_DEBUG
	  printf("MapNotify :%d\n",evt_count);
#endif
	  break;
      
	case KeyPress:
	  handleGameKey(&event);
#ifdef EVENT_DEBUG
	  printf("KeyPress :%d\n",evt_count);
#endif
	  break;
	  
	case ButtonPress:
	  if(gameMainFlg.demoFlg)		
	    {
	      nowDataRec.nowMap.nowFlg.gameOverFlg = False;
	      nowDataRec.nowMap.nowFlg.life = False;
	    }
	  
	  handleGameMouseDown(&event);
#ifdef EVENT_DEBUG
	  printf("ButtonPress :%d\n",evt_count);
#endif
	  break;
	  
	case MotionNotify:
	  nowDataRec.nowBar.bar_v = 0;
	  takeMousePoint(&event);
#ifdef EVENT_DEBUG
	  printf("default :%d\n",evt_count);
#endif
	  break;

	default:
#ifdef EVENT_DEBUG
	  printf("default :%d\n",evt_count);
#endif
	  break;
	}
    }
}



void moveBar(void)
{
  XRectangle   	tempRect;
  register	i,j,flg;
		

  gameEvent();
  
  if(gameMainFlg.demoFlg)
    {
      /***	demo mode !!	***/
      
      flg = False;
      
      if(nowDataRec.nowMap.mvBallNum <= 1)
	{
	  nowDataRec.nowBar.bar_v = 3;
	  serveBall();
	  nowDataRec.nowBar.bar_v = 0;
	}
      
      for(i ^=i;i <nowDataRec.nowMap.mvBallNum; i++)
	{
	  j =nowDataRec.nowMap.mvBallBox[i];
	  
	  if(nowDataRec.nowBall[j].y_v > 0)
	    {
	      if(!flg)
		{
		  tempRect = nowDataRec.nowBall[j].nowRect;
		  flg = True;
		}
	      else if(tempRect.y < nowDataRec.nowBall[j].nowRect.y)
		tempRect = nowDataRec.nowBall[j].nowRect;
	    }		
	}				
      
	if(!flg)
	  {		
	    i =nowDataRec.nowMap.mvBallBox[0];
	    tempRect = nowDataRec.nowBall[i].nowRect;
	    
	    for(i ^=i;i <nowDataRec.nowMap.mvBallNum; i++)
	      {
		j =nowDataRec.nowMap.mvBallBox[i];
		
		if(tempRect.y > nowDataRec.nowBall[j].nowRect.y)
		  tempRect = nowDataRec.nowBall[j].nowRect;
	      }
	  }
      /***	move bar	***/
      
      if(tempRect.x - 16 > nowDataRec.nowBar.nowRect.x)
	nowDataRec.nowBar.nowAct = '6';
      else
	nowDataRec.nowBar.nowAct = '4';
      
      /***	check Time	***/
      
      if(nowDataRec.nowMap.nowTime.tv_sec > 60)
	{
	  nowDataRec.nowMap.nowFlg.gameOverFlg = False;
	  nowDataRec.nowMap.nowFlg.life = False;
	}	
    }
  
  nowDataRec.nowBar.nowFlg.reDraw = False;
  nowDataRec.nowBar.prevRect = nowDataRec.nowBar.nowRect;
  
  if((nowDataRec.nowBar.bar_v) != 0)
    {
      /***  not move with mouse  ***/
/*      nowDataRec.nowBar.bar_v *= nowDataRec.nowMap.revFlg;   */
/*      nowDataRec.nowBar.nowRect.x += nowDataRec.nowBar.bar_v;*/

      /***  move with mouse  ***/
      if(nowDataRec.nowMap.revFlg == 1)
	nowDataRec.nowBar.nowRect.x = nowDataRec.nowBar.nowMPoint.x - 40;
      else
	nowDataRec.nowBar.nowRect.x = dBackPmWidth+50 - nowDataRec.nowBar.nowMPoint.x;

      nowDataRec.nowBar.nowFlg.reDraw = True;
      nowDataRec.nowBar.nowAct = '0';
      return;
    }
  else if(nowDataRec.nowBar.nowAct == '5')
    {
      serveBall();
      nowDataRec.nowBar.nowFlg.reDraw = True;
      nowDataRec.nowBar.nowAct = '0';
      
      return;
    }
  else if(nowDataRec.nowBar.nowAct == '6')
    {
      nowDataRec.nowBar.nowRect.x +=8;
      nowDataRec.nowBar.bar_v = 3;
      nowDataRec.nowBar.nowFlg.reDraw = True;
      return;
    }
  else if(nowDataRec.nowBar.nowAct == '4')
    {
      nowDataRec.nowBar.nowRect.x -=8;
      nowDataRec.nowBar.bar_v = -3;
      nowDataRec.nowBar.nowFlg.reDraw = True;
      return;
    }
  
    nowDataRec.nowBar.nowFlg.reDraw = False;
}

void touchWallCheckBar(void)
{
  if(nowDataRec.nowBar.nowRect.x < dWallLeft)
    nowDataRec.nowBar.nowRect.x = dWallLeft;
  else if(nowDataRec.nowBar.nowRect.x >
	  (dWallRight - nowDataRec.nowBar.nowRect.width))
    nowDataRec.nowBar.nowRect.x = dWallRight-nowDataRec.nowBar.nowRect.width;
}

void countTime(void)
{
  struct timeval    temp;
  
  gettimeofday(&temp,NULL);
  if((temp.tv_sec - nowDataRec.nowMap.prevTime.tv_sec) >0)
    nowDataRec.nowMap.nowTime.tv_usec += (temp.tv_usec+1000000) - nowDataRec.nowMap.prevTime.tv_usec;
  else
    nowDataRec.nowMap.nowTime.tv_usec += temp.tv_usec - nowDataRec.nowMap.prevTime.tv_usec;
  
  
  if(nowDataRec.nowMap.nowTime.tv_usec > 1000000)
    {
      nowDataRec.nowMap.nowTime.tv_usec -= 1000000;
      nowDataRec.nowMap.nowTime.tv_sec += 1;
    }
  
  nowDataRec.nowMap.prevTime = temp;
}


void eventLoop(void)
{	
  while(nowDataRec.nowMap.nowFlg.life)
    {
      /*****		move bar	*****/

      moveBar();
      
      touchWallCheckBar();
      
      if(nowDataRec.nowBar.nowFlg.reDraw)
	drawBar();
      
      /*****		move ball	*****/
      
      moveAndCheckBall();
      
      /*****		check Blocks	*****/
      
      touchBallCheckBlock();
      
      
      /*****		check Items		*****/
      
      moveAndCheckItem();
      
      
      /*****		draw Time		*****/

      
      if(nowDataRec.nowMap.nowFlg.timeFlg)
	{
	  countTime();
	  statTimeDraw();
	}

      /*****            wait loop         *****/

      gameSleep(display,nowDataRec.nowMap.gameSpeed);
    }	
}


void copyStageData(stg)
     register stg;
{
  register	i;
  
  nowDataRec.nowMap.stageX_a =(signed char)nowMapFile->stageData[stg].stageX_a;
  nowDataRec.nowMap.stageY_a =(signed char)nowMapFile->stageData[stg].stageY_a;
  nowDataRec.nowMap.backPicID   = nowMapFile->stageData[stg].backPicID;
  nowDataRec.nowMap.allBlockNum = nowMapFile->stageData[stg].allBlockNum;
  nowDataRec.nowMap.nowBlockNum = nowMapFile->stageData[stg].canBreakBlockNum;
  nowDataRec.nowMap.canBreakBlockNum = nowMapFile->stageData[stg].canBreakBlockNum;
  
  for(i^=i; i < dBlockMax; i++)
    {
      nowDataRec.nowBlock[i] = nowMapFile->stageData[stg].blockData[i];
      nowDataRec.nowBlock[i].nowFlg.life      = True;
      nowDataRec.nowBlock[i].nowFlg.reDraw    = True;
      nowDataRec.nowBlock[i].nowFlg.blockLock = True;
    }
}

void stageParamSet(void)
{
  register	i;
  
  /*******	Set now MapData !!	*******/
  
  nowDataRec.nowMap.mapNum++;	
  nowDataRec.nowMap.mvBallNum = 0;	
  nowDataRec.nowMap.itemNum   = 0;
  nowDataRec.nowMap.nowTime.tv_sec  = 0;
  nowDataRec.nowMap.nowTime.tv_usec  = 0;
  
  
  if((nowDataRec.nowMap.allBallNum += nowMapFile->ballAdd) > 30)
    nowDataRec.nowMap.allBallNum = 30;
  
  nowDataRec.nowMap.revFlg           = 1;
  nowDataRec.nowMap.gameCount        = 0;
  nowDataRec.nowBar.nowRect.width    = 72;
  nowDataRec.nowMap.prevScore        = nowDataRec.nowMap.myScore;
  nowDataRec.nowMap.nowFlg.life      = True;   /**	now map play flg **/
  nowDataRec.nowMap.nowFlg.saveFlg   = False;  /** now map data save flg **/
  nowDataRec.nowMap.nowFlg.timeFlg   = False;  /** now map count time flg **/
  nowDataRec.nowMap.nowFlg.errPatch1 = False;  /** opening Picture Updata Err PatchFlg **/
  
  gameMainFlg.wallThrough = False;
  
  /*******	Copy Stage Data !!	*******/
  
  copyStageData(nowDataRec.nowMap.mapNum);
  
  
  /*******	Set	Item Params	!!	*******/
	
  for(i = 0;i < dItemMax; i++)
    nowDataRec.nowItem[i].nowFlg.life = False;
  
  /*******	Set Ball Params !! 	*******/
  
  for(i =0; i < dBallMax; i++)
    nowDataRec.nowBall[i].nowFlg.life = False;
}

void stageSndSet(void)
{	


}

void stageSndReSet(void)
{


}


void stageBarBallPicSet(void)
{
  register	i,num;
	
  num = nowDataRec.nowMap.mapNum;

  /****	Bar	Color PixPattern Init !!	****/
  
  
  /****	Ball Color PixPattern Init !!	****/
  
  
}

void stageBarBallPicReSet(void)
{
  register i,iNum;

  
  /****	dispose item params	****/
  
  if(nowDataRec.nowMap.itemNum)
    for(i = nowDataRec.nowMap.itemNum -1; i >= 0; i--)
      {
	iNum = nowDataRec.nowMap.mvItemBox[i];
	disposeItem(iNum,i);
      }
}


void paramInit(void)
{
  register	i,iNum;
	

  /****	     game main loop flag	****/
  nowDataRec.nowMap.nowFlg.gameOverFlg = True;
  
 /****	use game continue	****/
  if(!gameMainFlg.s_map)
    if(!gameMainFlg.useContinue)
      nowDataRec.nowMap.mapNum = -1;
    else
      nowDataRec.nowMap.mapNum--;
  else
    {
      if((nowDataRec.nowMap.mapNum < 1)&&
	 (nowDataRec.nowMap.mapNum > nowMapFile->allMapNumber))
	nowDataRec.nowMap.mapNum = -1;
      else
	nowDataRec.nowMap.mapNum = nowDataRec.nowMap.s_map - 2;
    }

  nowDataRec.nowMap.allBallNum = 10 - nowMapFile->ballAdd;
  nowDataRec.nowMap.myScore    = 0;

  nowDataRec.nowMap.nowFlg.life         = True;
  nowDataRec.nowMap.nowFlg.backPicDraw  = False;	
  nowDataRec.nowMap.nowFlg.upData       = False;
  nowDataRec.nowMap.nowFlg.clearAllMap  = False;
  nowDataRec.nowMap.nowFlg.reDraw	= True;	   /**  use opening Picture **/
  
  /****	Bar Rect Init !!	****/
  nowDataRec.nowBar.nowRect.y      = dWallTop+dBlockHeight*22;
  nowDataRec.nowBar.nowRect.x      = 100;
  nowDataRec.nowBar.nowRect.width  = dNormalBarWidth;
  nowDataRec.nowBar.nowRect.height = dBlockHeight;

  /****	if exist, clear item params.  	****/
	
  if(nowDataRec.nowMap.itemNum)
    for(i = nowDataRec.nowMap.itemNum -1; i >= 0; i--)
      {
	iNum = nowDataRec.nowMap.mvItemBox[i];
	disposeItem(iNum,i);
      }  

  /**** use game eventloop ****/

  XSelectInput(display,mWin,
	       KeyPressMask | KeyReleaseMask | ButtonPressMask |
	       ButtonReleaseMask | ExposureMask |
	       ButtonMotionMask| PointerMotionMask);
}


void paramReSet(void)
{
}

void countBallScore(void)
{
  register	i,j,k,saveBall,countBall;
	
  for(i ^=i; i <nowDataRec.nowMap.mvBallNum; i++)
    {
      j = nowDataRec.nowMap.mvBallBox[i];
      
      nowDataRec.nowMap.myScore += 10;
      drawBack_Off(&nowDataRec.nowBall[j].nowRect);			
      statScoreDraw();

      gameSleep(display,2500);
    }
  
  saveBall  = nowDataRec.nowMap.allBallNum;

  countBall = nowDataRec.nowMap.allBallNum - nowDataRec.nowMap.mvBallNum;
  nowDataRec.nowMap.allBallNum = countBall;
  nowDataRec.nowMap.mvBallNum  = 0;
  
  for(i ^=i; i < countBall; i++)
    {
      nowDataRec.nowMap.allBallNum --;
      nowDataRec.nowMap.myScore += 50;
      statBallDraw();
      statScoreDraw();

      gameSleep(display,4000);      
    }		
  
  nowDataRec.nowMap.allBallNum = saveBall;
}



void stageScoreCheck(void)
{
  register	i,num;
  unsigned long time;

  if(gameMainFlg.demoFlg)
    return;

  num = nowDataRec.nowMap.mapNum;

  if(nowDataRec.nowMap.nowFlg.saveFlg)
    {
      time = time2long(&nowDataRec.nowMap.nowTime);

      if((nowMapFile->stageData[num].minTime > time)
	 ||(nowMapFile->stageData[num].minTime == 0))
	{
	  nowMapFile->stageData[num].minTime = time;
	  strcpy(nowMapFile->stageData[num].minTimeName,
		 nowDataRec.nowMap.playerName);
	  nowDataRec.nowMap.nowFlg.upData = True;
	  
	  /** print "you make new record!" **/
	      
	  drawShadowText(display,mWin,135,300,
			 "You make new record !",white.pixel);
	  drawShadowText(display,offPixmap,135,300,
			 "You make new record !",white.pixel);
	}
    }
  
  nowDataRec.nowMap.nowFlg.saveFlg = False;

  if(nowDataRec.nowMap.canBreakBlockNum == 0)
    countBallScore();
 
}

void openingString(void)
{
  XRectangle   	tempRect;
  register	tempNum,maps,i,x;
  struct timeval    time;
  char          text[32];
    

  maps = nowDataRec.nowMap.mapNum;

  if(nowMapFile->stageData[maps].minTime == 0)
    {
      /**  not yet clear map  **/
      drawShadowText(display,mWin,120,300,
	       "You have not clear this map...",white.pixel);
    }
  else
    {
      /**  write fastest time  **/

      x = 120;
      drawShadowText(display,mWin,x,300,
		     nowMapFile->stageData[maps].minTimeName,white.pixel);

      x += XTextWidth(xfont,nowMapFile->stageData[maps].minTimeName,
		      strlen(nowMapFile->stageData[maps].minTimeName));
      drawShadowText(display,mWin,x,300,
		     " has the fastest time.",white.pixel);

	
      long2time(nowMapFile->stageData[maps].minTime,&time);

      x = 250;
      sprintf(text,"%d",time.tv_sec);
      drawShadowText(display,mWin,x,345,
		     text,white.pixel);

      x += XTextWidth(xfont,text,strlen(text));
      drawShadowText(display,mWin,x,345,".",white.pixel);

      x += XTextWidth(xfont,".",strlen("."));
      sprintf(text,"%d",time.tv_usec/1000);
      drawShadowText(display,mWin,x,345,text,white.pixel);

      x += XTextWidth(xfont,text,strlen(text));
      drawShadowText(display,mWin,x,345,
		     " second !!",white.pixel);
      }
  
  /*  write openning text */

  drawShadowText(display,mWin,120,500,
	   nowMapFile->stageData[nowDataRec.nowMap.mapNum].startText,
	   white.pixel);

  gameMainFlg.clearString = True;
}


void gameMain(void)
{

  if( !gameMainFlg.openMap)
    if(!loadMapData(True))
      return;
  
  if( !gameMainFlg.inputName)
    nameInputDLG();


  paramInit();
  
  while(nowDataRec.nowMap.nowFlg.gameOverFlg)
    {
      
      stageParamSet();
      backPicSet();
      stageBarBallPicSet();
      stageSndSet();
      
      statStageDraw();
      statBallDraw();
      statScoreDraw();
      
      openingString();
      
      /****  clear Event Que    ****/

      XSync(display,True);
      
      /****  game Main Loop	****/
      
      eventLoop();
      
      /***************************/
      
/*      paramReSet();*/
      stageScoreCheck();
			
      stageSndReSet();
      stageBarBallPicReSet();
    }

  if( !gameMainFlg.demoFlg)
    if(nowDataRec.nowMap.nowFlg.clearAllMap)
      clearAllMap();
		
  gameOver();
	
}
