/*********************************************************

  X De Block 

       main.c file

  *********************************************************/

#include "gameheader.h"

#include "xpm/playB.xpm"
#include "xpm/contB.xpm"
#include "xpm/mapB.xpm"
#include "xpm/nameB.xpm"
#include "xpm/scoreB.xpm"
#include "xpm/quitB.xpm"
#include "xpm/aboutB.xpm"

#include "xpm/back3.xpm"

#include "xpm/x.xpm"
#include "xpm/x.xbm"
#include "xpm/d.xpm" 
#include "xpm/d.xbm" 
#include "xpm/e.xpm"
#include "xpm/e.xbm"
#include "xpm/b.xpm"
#include "xpm/b.xbm"
#include "xpm/l.xpm"
#include "xpm/l.xbm"
#include "xpm/o.xpm"
#include "xpm/o.xbm"
#include "xpm/c.xpm"
#include "xpm/c.xbm"
#include "xpm/k.xpm"
#include "xpm/k.xbm"

Display     *display;                   /* global display      */
Window      mWin;                       /* global main window  */
GC          gc;                         /* global gc           */
Pixmap      offPixmap,backPicPixmap;    /* global offscreen pixmaps */
XFontStruct *xfont;                     /* global font         */
XFontStruct *minifont;                  /* global mini font    */
Colormap    cmap;                       /* global cmap         */


XColor      white,black,blue,yellow,red,green,skyblue,rgb;
Pixmap      xpms,xpmMs;

allDataRec  nowDataRec;
mapFilePtr  nowMapFile;
flgs        gameMainFlg;


int checkOption(argc,argv)
     int  argc;
     char *argv[];
{
  register i,j;
  int      flg = False;
  char     temp[256];

  void     initGame();
  void     freeGame();

  /***  set s_map  ***/
  gameMainFlg.s_map = False;
  nowDataRec.nowMap.gameSpeed = 90;
  nowDataRec.nowMap.dirname[0] == 0x00;

  for(i =1; i  < argc; i++)
    {
      if(!strcmp(argv[i], "-d"))
	{
	  i++;
	  strcpy(temp,argv[i]);
	  strcat(temp,":0.0");
	  if((display = XOpenDisplay(temp))==NULL)
	    {fprintf(stderr,"XDeBlock: cannot open display[%s]\n",temp);
	     exit(1);}
	  flg = True;
	}
      else if(!strcmp(argv[i],"-speed"))
	{
	  i++;
	  nowDataRec.nowMap.gameSpeed = atoi(argv[i]);
	}
      else if(!strcmp(argv[i],"-mdir"))
	{
	  i++;
	  strcpy(nowDataRec.nowMap.dirname,argv[i]);
	}
      else if(!((strcmp(argv[i],"-help"))&&(strcmp(argv[i],"-h"))
	      &&(strcmp(argv[i],"-?"))))
	{
	  i++;
	  printf("Usage: %s [option] [mapfile]\n",argv[0]);
	  printf("Option:\n\t-h ... help\n\t-d [display] ... display name\n");
	  printf("\t-speed [speed] ... game speed <0(fast) to 100(slow)>\n");
	  printf("\t-mdir [mapfile directry] ... input mapfile directory\n");
	  printf("\t-init [mapfile(binary)] ... initialize data in mapfile\n");
	  printf("\t-txt2bin [mapfile(text)] ... convert text to binary\n");
	  printf("\t-bin2txt [mapfile(binary)] ... convert binary to text\n");
	  printf("\nex: %s -mdir ./mapf -speed 3 standard.mapf &\n",argv[0]);

	  exit(0);
	}
      else if(!strcmp(argv[i],"-init"))
	{
	  i++;
	  initGame();
	  strcpy(nowDataRec.nowMap.filename,argv[i]);
	  if(!loadMapData(False))
	    {
	      fprintf(stderr,"XDeBlock:cannot open file [%s]\n",argv[i]);
	      exit(0);
	    }
	  clearHiScore();
	  freeGame();
	  exit(0);
	}
      else if(!strcmp(argv[i],"-bin2txt"))
	{
	  i++;
	  initGame();
	  strcpy(nowDataRec.nowMap.filename,argv[i]);
	  if(!loadMapData(False))
	    {
	      fprintf(stderr,"XDeBlock: cannot open file [%s]\n",argv[i]);
	      exit(0);
	    }

	  saveMapText();
	  freeGame();
	  exit(0);
	}
      else if(!strcmp(argv[i],"-txt2bin"))
	{
	  i++;
	  initGame();
	  strcpy(nowDataRec.nowMap.filename,argv[i]);
	  if(!loadMapData(False))
	    {
	      fprintf(stderr,"XDeBlock: cannot open file [%s]\n",argv[i]);
	      exit(0);
	    }

	  fileUpData();
	  freeGame();
	  exit(0);
	}
      else if(!strcmp(argv[i],"-stg"))
	{
	  i++;
	  nowDataRec.nowMap.s_map = atoi(argv[i]);
	  gameMainFlg.s_map = True;
	}
      else if(strstr(argv[i],".mapf")||strstr(argv[i],".mapf.txt"))
	{
	  strcpy(nowDataRec.nowMap.filename,argv[i]);
	  gameMainFlg.use_argv = True;
#ifdef DEBUG
	  printf("line : filename = %s\n",nowDataRec.nowMap.filename);
#endif
	}
      else
	{
	  printf("XDeBlock: Bad Option !\n");
	  printf("Usage: %s [option] [mapfile]\n",argv[0]);
	  printf("Option:\n\t-h ... help\n\t-d [display] ... display name\n");
	  printf("\t-speed [speed] ... game speed <0(fast) to 100(slow)>\n");
	  printf("\t-mdir [mapfile directry] ... input mapfile directory\n");
	  printf("\t-init [mapfile(binary)] ... initialize data in mapfile\n");
	  printf("\t-txt2bin [mapfile(text)] ... convert text to binary\n");
	  printf("\t-bin2txt [mapfile(binary)] ... convert binary to text\n");
	  printf("\nex: %s -mdir ./mapf -speed 3 standard.mapf &\n",argv[0]);

	  exit(0);
	}
    }
  
  if(!flg)
      display = XOpenDisplay(NULL);
  
}


void initResources()
{
  XpmAttributes   attributes;
  int             err;
  int             screen_num;
  XVisualInfo     v_info;
  XSizeHints      hints;
  int             useDefaultColourmap;

  /**** create main window ****/

  mWin = XCreateSimpleWindow(display,DefaultRootWindow(display),
			    0,0,dWinWidth,dWinHeight,2,
			    BlackPixel(display,DefaultScreen(display)),
			    WhitePixel(display,DefaultScreen(display)));
  XSelectInput(display,mWin,
	       KeyPressMask | KeyReleaseMask | ButtonPressMask |
	       ButtonReleaseMask | ExposureMask | ButtonMotionMask);

  hints.flags      = PMinSize | PMaxSize;  
  hints.min_width  = dWinWidth;
  hints.min_height = dWinHeight;
  hints.max_width  = dWinWidth;
  hints.max_height = dWinHeight;
     
  XSetNormalHints(display,mWin,&hints);

  XStoreName(display,mWin,"X De Block");
  XMapWindow(display,mWin);


  /**** create off-screen pixmap ****/

  offPixmap = XCreatePixmap(display,mWin,dWinWidth,dWinHeight,
			    DefaultDepth(display,DefaultScreen(display)));

  /**** wall paper screen pixmap ****/

  backPicPixmap = XCreatePixmap(display,mWin,dBackPmWidth,dBackPmHeight,
				DefaultDepth(display,DefaultScreen(display)));


  /**** create global gc ****/

  gc = XCreateGC(display,mWin, 0,0);

  XSetForeground(display,gc,WhitePixel(display,0));
  XFillRectangle(display,offPixmap,gc,0,0,dWinWidth,dWinHeight);
  
  XSetForeground(display,gc,BlackPixel(display,0));
  XSetBackground(display,gc,WhitePixel(display,0));

  /**** set global font ****/
  
  xfont = XLoadQueryFont(display,dDefaultFont);
  XSetFont(display,gc,xfont->fid);

  minifont = XLoadQueryFont(display,dMiniFont);


  /**** set global colormap ****/
  
  screen_num = DefaultScreen(display);

  if (!XMatchVisualInfo(display,screen_num,DefaultDepth(display,screen_num),
			PseudoColor,&v_info))
    if (!XMatchVisualInfo(display,screen_num, 
			  DefaultDepth(display,screen_num),
			  DirectColor,&v_info))
      if (!XMatchVisualInfo(display,screen_num, 
			    DefaultDepth(display,screen_num),
			    TrueColor,&v_info))
	{
	  fprintf(stderr,"Sorry, you must have a colour display.");
	  exit(1);
	}

#ifdef DEBUG
  printf("XDeBlock: depth = %d,cmap_size = %d\n",
	 v_info.depth,v_info.colormap_size);
#endif

  cmap = XCreateColormap(display,mWin,DefaultVisual(display,screen_num),
			 AllocNone);
  XInstallColormap(display,cmap);
  XSetWindowColormap(display,mWin,cmap);

  XAllocNamedColor(display,cmap,"black",&black,&rgb);
  XAllocNamedColor(display,cmap,"white",&white,&rgb);
  XAllocNamedColor(display,cmap,"blue",&blue,&rgb);
  XAllocNamedColor(display,cmap,"yellow",&yellow,&rgb);
  XAllocNamedColor(display,cmap,"green",&green,&rgb);
  XAllocNamedColor(display,cmap,"red",&red,&rgb);
  XAllocNamedColor(display,cmap,"skyblue",&skyblue,&rgb);
}

void initGameMainFlg(void)
{
  gameMainFlg.life      = True;		/**	can play game flg	****/
  gameMainFlg.openMap   = False;        /**     map file open flg	****/
  gameMainFlg.reDraw    = True;		/**		???		  **/
  gameMainFlg.hidePen   = True;		/**	cursor view mode 	****/
  gameMainFlg.saveFlg   = False;	/**     score .etc upData flg     **/
  gameMainFlg.inputName = False;	/**	player name input ?	****/
/*  gameMainFlg.useSound  = False;              play Game Sound	****/
  gameMainFlg.reDraw2   = True;		/**	osEvt cursor flg	****/
  gameMainFlg.errPatch1 = True;	        /**	active window flg	****/
  gameMainFlg.useEffect = False;	/**	use many kind effect     ***/
  gameMainFlg.useWinOut = True;	        /** use wait cursor out of Window **/
  gameMainFlg.demoFlg   = False;        /**     show game Demo !!	****/
  gameMainFlg.bloDlg    = False;       	/**	use block edit mode	****/
  gameMainFlg.getMode   = False;        /**     use title button	****/

}


void initGame(void)
{  
  nowMapFile = (mapFilePtr)malloc(sizeof(mapFileRec));
	
  nowDataRec.nowMap.nowTime.tv_sec = 0;	/** use Titel loop and Game loop */
  nowDataRec.nowMap.nowTime.tv_usec= 0;	/** use Titel loop and Game loop */
  nowDataRec.nowMap.itemNum   = 0;	/**    use Title item domo      **/
  nowDataRec.nowMap.prevScore = 0;	/**    demo insted of use	**/
  nowDataRec.nowMap.continueCount = -1;	/**	set continueCount	**/
  nowDataRec.nowMap.gameCount = 0;  	/**	use Title button	**/

  strcpy(nowDataRec.nowMap.playerName,getenv("USER"));
			
}

void freeGame(void)
{
  free(nowMapFile);
}

void setDemo(void)
{
  register    i,num;
  XRectangle  box;
  char	      saveFlg1;
  char        *text[20]={"Score +100","Score +200","Score +500",
			   "Score -100","Score -200","Score -400",
			   "Bar +","Bar -","Bigger Ball",
			   "Smaller Ball","Ball 1UP","Ball 1DOWN",
			   "Ball x2","Reverse","Ball Speed UP",
			   "Ball Speed DOWN","Wall Through","Weight Ball"};
  
  if(nowDataRec.nowMap.prevScore == 0)
    ;
  else if(nowDataRec.nowMap.prevScore <= 3)
    {
      XSetForeground(display,gc,blue.pixel);
      XDrawRectangle(display,mWin,gc,240,120,330,300);

      drawShadowText(display,mWin,300,95,
		     "****  items  ****",blue.pixel);
      
      for(i^=i; i < dItemMax; i++)
	{
	  num = i+1+(nowDataRec.nowMap.prevScore-1)*6;
	  setRect(&box,250,130+(45*i),24,24);
	  serveItem(&box,num);
      
          drawShadowText(display,mWin,310,145+(45*i),
		         text[num-1],blue.pixel);
	}
    }
  else
    {
      saveFlg1 = gameMainFlg.inputName;
      gameMainFlg.inputName = True;
      gameMain();
      gameMainFlg.inputName = saveFlg1;
      nowDataRec.nowMap.prevScore = 0;
      gameMainFlg.demoFlg = False;
    }				
}

void drawTitle(void)
{
  register        i;
  XpmAttributes   attributes;
  static Pixmap   tempXpm,tempXpmMs,tPix;
  int             err,pic_x,pic_y,x,y;
  long            color;


  /***  set attributes  ***/
  attributes.valuemask = XpmColormap;
  attributes.colormap = cmap;

  /***  set window background   ***/

  err = XpmCreatePixmapFromData(display,mWin,back3_xpm,
				&tempXpm,&tempXpmMs,&attributes);
  handleXPMError(err,"title back");

  XSetWindowBackgroundPixmap(display,mWin,tempXpm);
  XFreePixmap(display,tempXpm);

  putBackPattarn(offPixmap,dWinWidth,dWinHeight,303);

  /***  draw Title      ***/

  for(i^=i; i< 8;i++)
    {
      switch(i)
	{
	case 0:
	  sscanf(x_xpm[0],"%d%d",&pic_x,&pic_y);
	  err = XpmCreatePixmapFromData(display,mWin,x_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  tPix = XCreateBitmapFromData(display,mWin,x_bits,x_width,x_height);
	  x = 180; y = 70; color = blue.pixel;
	  break;
	case 1:
	  sscanf(d_xpm[0],"%d%d",&pic_x,&pic_y);
	  err = XpmCreatePixmapFromData(display,mWin,d_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  tPix = XCreateBitmapFromData(display,mWin,d_bits,d_width,d_height);
	  x = 360; y = 140; color = yellow.pixel;
	  break;
	case 2:
	  sscanf(e_xpm[0],"%d%d",&pic_x,&pic_y);
	  err = XpmCreatePixmapFromData(display,mWin,e_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  tPix = XCreateBitmapFromData(display,mWin,e_bits,e_width,e_height);
	  x = 450; y = 160; color = white.pixel;
	  break;
	case 3:
	  sscanf(b_xpm[0],"%d%d",&pic_x,&pic_y);
	  err = XpmCreatePixmapFromData(display,mWin,b_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  tPix = XCreateBitmapFromData(display,mWin,b_bits,b_width,b_height);
	  x = 220; y = 270; color = red.pixel;
	  break;
	case 4:
	  sscanf(l_xpm[0],"%d%d",&pic_x,&pic_y);
	  err = XpmCreatePixmapFromData(display,mWin,l_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  tPix = XCreateBitmapFromData(display,mWin,l_bits,l_width,l_height);
	  x = 300; y = 270; color = green.pixel;
	  break;
	case 5:
	  sscanf(o_xpm[0],"%d%d",&pic_x,&pic_y);
	  err = XpmCreatePixmapFromData(display,mWin,o_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  tPix = XCreateBitmapFromData(display,mWin,o_bits,o_width,o_height);
	  x = 355; y = 290; color = blue.pixel;
	  break;
	case 6:
	  sscanf(c_xpm[0],"%d%d",&pic_x,&pic_y);
	  err = XpmCreatePixmapFromData(display,mWin,c_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  tPix = XCreateBitmapFromData(display,mWin,c_bits,c_width,c_height);
	  x = 420; y = 290; color = yellow.pixel;
	  break;	  
	case 7:
	  sscanf(k_xpm[0],"%d%d",&pic_x,&pic_y);
	  err = XpmCreatePixmapFromData(display,mWin,k_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  tPix = XCreateBitmapFromData(display,mWin,k_bits,k_width,k_height);
	  x = 480; y = 270; color = skyblue.pixel;
	  break;	  

	}
      drawWithMask(display,offPixmap,tempXpm,tempXpmMs,x+10,y+10,pic_x,pic_y);

      XSetForeground(display,gc,color);
      XCopyPlane(display,tPix,tempXpm,gc,0,0,pic_x,pic_y,0,0,1);
      drawWithMask(display,offPixmap,tempXpm,tempXpmMs,x,y,pic_x,pic_y);

      XFreePixmap(display,tempXpm);
      XFreePixmap(display,tPix);
    }

  XSetForeground(display,gc,BlackPixel(display,0));
  XSetBackground(display,gc,WhitePixel(display,0));

  /***  title texts    ***/

  drawMiniText(display,offPixmap,170,360,
	       "XDeBlock ver.1.0 (C)CopyRight 1996 Takuto Okuno",
	       yellow.pixel,True);
  drawShadowText(display,offPixmap,170,420,
		 "Map Select:",green.pixel);

  /***  title button    ***/
  for(i^=i; i < 7; i++)
    {
      switch(i)
	{
	case 0:
	  err = XpmCreatePixmapFromData(display,mWin,playB_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  handleXPMError(err,"play button");
	  break;
	case 1:
	  err = XpmCreatePixmapFromData(display,mWin,contB_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  handleXPMError(err,"cont button");	  
	  break;
	case 2:
	  err = XpmCreatePixmapFromData(display,mWin,mapB_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  handleXPMError(err,"map button");
	  break;
	case 3:
	  err = XpmCreatePixmapFromData(display,mWin,nameB_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  handleXPMError(err,"name button");
	  break;
	case 4:
	  err = XpmCreatePixmapFromData(display,mWin,scoreB_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  handleXPMError(err,"score button");
	  break;
	case 5:
	  err = XpmCreatePixmapFromData(display,mWin,quitB_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  handleXPMError(err,"quit button");
	  break;
	case 6:
	  err = XpmCreatePixmapFromData(display,mWin,aboutB_xpm,
					&tempXpm,&tempXpmMs,&attributes);
	  handleXPMError(err,"quit button");
	  break;
	}

      drawWithMask(display,offPixmap,tempXpm,tempXpmMs,54+105*i,480,96,48);

      XFreePixmap(display,tempXpm);
    }

  XCopyArea(display,offPixmap,mWin,gc,0,0,dWinWidth,dWinHeight,0,0);
  XpmFreeAttributes(&attributes);
}

void titleLoop(void)
{
  register  i,iNum;

  if(!gameMainFlg.demoFlg)
    {
      if(nowDataRec.nowMap.itemNum)
	for(i = nowDataRec.nowMap.itemNum -1; i >= 0; i--)
	  {
	    iNum = nowDataRec.nowMap.mvItemBox[i];
	    disposeItem(iNum,i);
	  }

      drawTitle();

      gameMainFlg.demoFlg = True;

      nowDataRec.nowMap.nowTime.tv_sec  = 0;
      nowDataRec.nowMap.nowTime.tv_usec = 0;
      gettimeofday(&nowDataRec.nowMap.prevTime,NULL);

      setDemo();
    }

  for(i ^=i; i < nowDataRec.nowMap.itemNum;i++)
    {
      iNum = nowDataRec.nowMap.mvItemBox[i];
      nowDataRec.nowItem[iNum].prevRect = nowDataRec.nowItem[iNum].nowRect;
      drawItem(iNum);
    }

  gameSleep(display,10);
  countTime();

  if(nowDataRec.nowMap.nowTime.tv_sec > 5)
    {
      nowDataRec.nowMap.nowTime.tv_sec  = 0;
      nowDataRec.nowMap.nowTime.tv_usec = 0;
      gettimeofday(&nowDataRec.nowMap.prevTime,NULL);
      nowDataRec.nowMap.prevScore ++;
      gameMainFlg.demoFlg = False;
    }

}

int checkTitleButton(num)
     int num;
{
  switch(num)
    {
    case 0:		/****	game start     	****/
      gameMainFlg.demoFlg             = False;
      gameMainFlg.useContinue         = False;
      nowDataRec.nowMap.continueCount = 1;

      gameMain();
      drawTitle();
      break;
    case 1:		/****	game continue	****/
      if(nowDataRec.nowMap.continueCount < 0)
	return;
      gameMainFlg.demoFlg             = False;
      gameMainFlg.useContinue         = True;
      nowDataRec.nowMap.continueCount --;

      gameMain();
      drawTitle();
      break;

    case 2:
      loadMapData(True);
      break;

    case 3:
      nameInputDLG();
      break;

    case 4:
      if(!gameMainFlg.openMap)
	break;
      gameMainFlg.demoFlg = False;
      hiScoreDLG();
      break;
    
    case 5:        
    /*** quit game ***/
      return(True);

    case 6:
      aboutDLG();
      break;
    
    }
      
  nowDataRec.nowMap.prevScore = 0;
  gameMainFlg.demoFlg = False;

  return(False); 
}


int handleTitleButton(x,y,updown)
     short x,y;
     int   updown;
{
  register	i;
  XRectangle	buttonRect;
  int		flg = False;

  for(i^=i; i < 7; i++)
    {
      setRect(&buttonRect,54 +105*i,480,96,48);
      if(ptInRect(&buttonRect,x,y))
	{
	  flg                         = True;
	  gameMainFlg.demoFlg         = False;
	  nowDataRec.nowMap.prevScore = 0;

	  if(!gameMainFlg.getMode)
	    {
	      XClearArea(display,mWin,54+105*i,480,96,48,False);
	      XCopyArea(display,offPixmap,mWin,gc,54+105*i,480,96,48,
			57+105*i,483);
	      gameMainFlg.getMode = True;
	      nowDataRec.nowBar.nowAct = i;
	    }
	}
    }

  if(gameMainFlg.getMode)
    if(flg)
      {
	if(updown)
	  {
	    gameMainFlg.getMode = False;
	    XClearArea(display,mWin,57+105*nowDataRec.nowBar.nowAct,
		       483,96,48,False);
	    setRect(&buttonRect,54+105*nowDataRec.nowBar.nowAct,480,96,48);
	    drawBack_Off(&buttonRect);
	    return(checkTitleButton(nowDataRec.nowBar.nowAct));
	  }      
      }
    else
      {
	gameMainFlg.getMode = False;
	XClearArea(display,mWin,57+105*nowDataRec.nowBar.nowAct,
		   483,96,48,False);
	setRect(&buttonRect,54+105*nowDataRec.nowBar.nowAct,480,96,48);
	drawBack_Off(&buttonRect);
      }

  return(False);
}

int handleTitleMouseRelease(event)
     XButtonEvent *event;
{
  
  switch(event->button)
    {
    case Button1:
      return(handleTitleButton(event->x,event->y,True));
      break;
      
    case Button2:
      return(handleTitleButton(event->x,event->y,True));
      break;

    case Button3:
      break;
    }

  return(False);

}

void handleTitleMouseMotion(event)
     XPointerMovedEvent *event;
{

  handleTitleButton(event->x,event->y,False);

}

void handleTitleMouseDown(event)
     XButtonEvent *event;
{
  
  switch(event->button)
    {
    case Button1:
      handleTitleButton(event->x,event->y,False);
      break;
      
    case Button2:
      handleTitleButton(event->x,event->y,False);
      break;

    case Button3:
      break;
    }
}

void reDraw(event)
     XExposeEvent *event;
{
  /***    expose event ***/
  drawBack_Offs(event->x,event->y,event->width,event->height);

}

void titleText(void)
{
 
  if(gameMainFlg.openMap)
    drawShadowText(display,mWin,310,420,
		   nowDataRec.nowMap.filename,red.pixel);
  else
    drawShadowText(display,mWin,310,420,
		   "non select",red.pixel);
    
}


void handleTitleEventLoop()
{
  XEvent    event;
  int       flg,i,j,k,evt_count;
  str255    nowfile;

  while(True)
    {
      flg = True;
      if(gameMainFlg.use_argv)
	{
	  if(nowDataRec.nowMap.dirname[0] != 0x00)
	    {
	      strcpy(nowfile,nowDataRec.nowMap.dirname);
	      strcat(nowfile,"/");
	      strcat(nowfile,nowDataRec.nowMap.filename);
	      strcpy(nowDataRec.nowMap.filename,nowfile);
	    }
	      
	  if(!loadMapData(False))
	    {
	      fprintf(stderr,"XDeBlock: cannot open file [%s]\n",
		      nowDataRec.nowMap.filename);
	      exit(0);
	    }
	  gameMainFlg.openMap  = True;

	  gameMainFlg.demoFlg             = False;
	  gameMainFlg.useContinue         = False;
	  nowDataRec.nowMap.continueCount = 1;

	  gameMain();
	  gameMainFlg.use_argv = False;
	}

      while(flg)
	{
	  titleLoop();

	  for(evt_count = XEventsQueued(display,QueuedAfterReading);
	      evt_count > 0;evt_count--)
	    {
	      XNextEvent(display,&event);

	      switch(event.type)
		{
		case Expose:
#ifdef EVENT_DEBUG
		  printf("Title:Expose :%d\n",evt_count);
#endif
		  reDraw(&event);
		  titleText();
		  break;

		case ButtonRelease:
#ifdef EVENT_DEBUG
		  printf("Title:ButtonRelease :%d\n",evt_count);
#endif
		  if(handleTitleMouseRelease(&event))
		    return;
		  
		  XSelectInput(display,mWin,
			       KeyPressMask | KeyReleaseMask | 
			       ButtonPressMask | ButtonReleaseMask | 
			       ExposureMask | ButtonMotionMask);
		  break;
		  
		case ButtonPress:
#ifdef EVENT_DEBUG
		  printf("Title:ButtonPress :%d\n",evt_count);
#endif
		  handleTitleMouseDown(&event);
		  break;
		  
		case MotionNotify:
#ifdef EVENT_DEBUG
		  printf("Title:MotionNotify :%d\n",evt_count);
#endif
		  handleTitleMouseMotion(&event);
		  titleText();
		  break;

		default:
#ifdef EVENT_DEBUG
		  printf("Title:default :%d\n",evt_count);
#endif
		  break;

		}
	    }
	}
    }
}

void clearResources()
{
  XFreeColormap(display,cmap);
  XFreeFont(display,xfont);
  XFreeGC(display,gc);
  XFreePixmap(display,offPixmap);
  XFreePixmap(display,backPicPixmap);
  XDestroyWindow(display,mWin);
  XCloseDisplay(display);

}


void main(argc,argv)
     int   argc;
     char  *argv[];
{
/***   check option   ***/

  checkOption(argc,argv);

/***   initialize resources   ***/

  initResources();
  initGameMainFlg();
  initGame();
  initItemPix();
  initBlockPix();

/***   main loop   ***/

  handleTitleEventLoop();

/***   clear resources   ***/

  freeItem();
  freeBlock();
  freeGame();
  clearResources();
}

