/* $Id: xdgagrab.c,v 1.3 1999/02/23 01:16:38 taoka Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/extensions/xf86dga.h>

int
main(int argc, char *argv[])
{
	Display *display;
	Window	root;
	int	fb_width, fb_height, vp_width, vp_height, x, y;
	int	fd, depth, bpp, screen, flags, banksize, fbufsize;
	int		nformats;
	ScreenFormat	*pixmap_format;
	char	*adrs, *ppmbuf;
	char	ppm_header[256];
	uid_t	uid = getuid(), euid = geteuid();
	gid_t	gid = getgid();
	int	fb_off = 0;

	if(argc == 3){
		fb_off = atoi(argv[2]);
	}else if(argc != 2){
		printf("usage: %s output_file [frame_buffer_offset]\n", argv[0]);
		return 1;
	}

	display = XOpenDisplay(NULL);
	if(display ==  NULL){
		return 1;
	}
	screen = DefaultScreen(display);
	root = DefaultRootWindow(display);
	depth = DefaultDepth(display, screen);
	nformats = ((_XPrivDisplay)display)->nformats;
	pixmap_format = ((_XPrivDisplay)display)->pixmap_format;
	while(nformats){
		if(pixmap_format[nformats].depth == depth){
			bpp = pixmap_format[nformats].bits_per_pixel;
			break;
		}
		nformats--;
	}
	printf("depth is %d. bpp is %d.\n", depth, bpp);

	XF86DGAQueryDirectVideo(display, screen, &flags);
	if(flags & XF86DGADirectPresent){
		printf("DGA capable\n");
	}else{
		XCloseDisplay(display);
		return 1;
	}

	if(euid != 0){
		printf("You are not a super user or %s is not set uid root .\n", argv[0]);
		XCloseDisplay(display);
		return 1;
	}
//	setuid(geteuid());

	XF86DGAGetVideo(display, screen, &adrs, &fb_width, &banksize, &fbufsize);
	if(banksize != fbufsize*1024){
		printf("I cannot operate banked frame memory! Good-bye.\n");
		XCloseDisplay(display);
		return 1;
	}
	switch(bpp){
		case 16:
			fb_height = banksize/fb_width/2;
			break;
		case 24:
			fb_height = banksize/fb_width/3;
			break;
		case 32:
			fb_height = banksize/fb_width/4;
			break;
		default:
			printf("depth must be 16, 24 or 32.\n");
			XCloseDisplay(display);
			return 1;
	}
	printf("frame buffer start: %p\n", (void *)adrs);
	printf("frame buffer size: %d\n", (int)fbufsize);
	printf("frame buffer dimension: %d x %d\n", fb_width, fb_height);

	XF86DGAGetViewPortSize(display, screen, &vp_width, &vp_height);
	printf("view port dimension: %d x %d\n", vp_width, vp_height);
	XF86DGASetViewPort(display, screen, 0, 0);

	sprintf(ppm_header, "P6\n%d %d\n255\n", vp_width, vp_height);
	fd = open(argv[1], O_CREAT|O_TRUNC|O_RDWR, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
	if(fd < 0){
		printf("failed to open().\n");
		XCloseDisplay(display);
		return 1;
	}
	write(fd, ppm_header, strlen(ppm_header));
	ppmbuf = malloc(vp_width*3);
	if(ppmbuf == NULL){
		printf("failed to malloc().\n");
		close(fd);
		XCloseDisplay(display);
		return 1;
	}
	XF86DGADirectVideo(display, screen, XF86DGADirectGraphics);
	switch(bpp){
		case 16:
			for(y = 0; y < vp_height; y++){
				char *lb = adrs + (y*fb_width*2) + fb_off*2;
				unsigned short pixel;
				char	*ppm = ppmbuf;

				for(x = 0; x < vp_width; x++){
					pixel = *((unsigned short *)(lb + (x*2)));
					*ppm++ = (pixel & 0xF800) >> 8;
					*ppm++ = (pixel & 0x07E0) >> 3;
					*ppm++ = (pixel & 0x001F) << 3;
				}
				write(fd, ppmbuf, vp_width*3);
			}
			break;
		case 24:
			for(y = 0; y < vp_height; y++){
				char *lb = adrs + (y*fb_width*3) + fb_off*3;
				char	*ppm = ppmbuf;

				for(x = 0; x < vp_width; x++){
					*ppm++ = *(lb + x*3 + 2);
					*ppm++ = *(lb + x*3 + 1);
					*ppm++ = *(lb + x*3 + 0);
				}
				write(fd, ppmbuf, vp_width*3);
			}
			break;
		case 32:
			for(y = 0; y < vp_height; y++){
				char *lb = adrs + (y*fb_width*4) + fb_off*4;
				char	*ppm = ppmbuf;

				for(x = 0; x < vp_width; x++){
					*ppm++ = *(lb + x*4 + 2);
					*ppm++ = *(lb + x*4 + 1);
					*ppm++ = *(lb + x*4 + 0);
				}
				write(fd, ppmbuf, vp_width*3);
			}
			break;
	}
	XF86DGADirectVideo(display, screen, 0);
	free(ppmbuf);
	fchown(fd, uid, gid);
	close(fd);
	XCloseDisplay(display);
	return 0;
}

