.TH XDL 1 "21 Aug 1992"
.SH NAME
xdl \- display DL animations in an X window.
.SH SYNOPSIS
.B xdl
.RI [ \-v ]
.RI [ \-h ]
.RI [ \-z ]
.RI [ \-r\ frames/second ]
.RI [ \-d\ display ]
.RI [ file\ file...]
.SH DESCRIPTION
.I Xdl
reads files in DL format and displays the animations in those files in an X
window.  An animation can also be read from standard input by giving a '-' in
the file list or by not specifying any files at all on the command line.  The
program can be run on monochrome (1 bit per pixel), colormapped (8 bits per
pixel) and full color (24 bits per pixel) systems. On monochrome systems the
images is halftoned with the Floyd-Steinberg algorithm.
.SH OPTIONS
.TP
.B \-h
Write some help about how the program should be started.
.TP
.B \-v
Make the program talk a lot about what it thinks it is doing.
.TP
.B \-z
If the animation is in medium format (160 x 100) it will be zoomed
up to large format (320 x 200). If run on a color display the zoom
operation is simple nearest neighbour, on a monochrome display some
smoothing will be performed. If the animation is in large format
this switch will be ignored.
.TP
.B \-r frames/second
Determines the rate of the animation, ie how many frames per second
that should be displayed. The minimum is 2 and the default is 25. The
given rate is a maximum.
.TP
.B \-d display
Specify the name of the X display to connect to.
.SH INTERACTION
While the program is running, it handles the following events:
.TP
.B 'n', <space> or <left mousebutton>
Stop displaying the current animation and move on to the next file specifiad
on the command line. If it was the last file the program will exit.
.TP
.B 'q' or <right mousebutton>
End the animation and exit the program.
.SH EXAMPLES
Display the animation foo.dl at 25 frames per second.
.IP 
xdl foo.dl
.PP 
Display the animation fie.dl, zoomed to large format, at 12 frames
per second.
.IP 
xdl -z -r 12 fie.dl
.SH BUGS
.PP
There should be smoothing when zooming in color also.
.PP
The code is unreadable.
.PP
.SH AUTHOR
Jonas Yngvesson <jonas-y@isy.liu.se>
.PP
The program is derived from dltogl by George Phillips <phillips@cs.ubc.ca>
.PP
The suggestion (and code) to allow the user to set the animation
rate came from Per Beremark <per.beremark@telelogic.se>
.PP
Initial support for multi file view and click to exit, support for -v
(verbose) flag, port (sort of) to Interactive 386/ix (and others without
setitimer/getitimer) was done by Mats Lofstrom <mla@enea.se>
