#include <math.h>
//#include <signal.h>

#include <stdlib.h> /* for getenv.. (would be nice to remove this) */
#include <stdio.h>  /* For printf - again, nice to remove this */

#include "gfx-vgl.h"  /* essential - ish. */
#include "string.h" /* for ffs (find first set) */

//static int gfx_setup_ximage(Gfx *);
void gfx_setup_fps_timer(Gfx *);

int setup_back_buff(Gfx *g) {
  g->cbuffer=(unsigned char *)malloc(g->xres * g->yres * sizeof(unsigned char));
  memset((void *)g->cbuffer,0,g->xres*g->yres); /* unecessary */
  return (g->cbuffer!=0);
}

void check_buff(Gfx *g) {
  int left , right , y;
  /* This checks that neither the left or right extents in a buffer */
  /* have been set to anything other than zero! */
  for (y=0; y<g->yres; y++) {
    left  = *(g->cbuffer + (y * g->xres));
    right = *(g->cbuffer + (y * g->xres) + g->xres -1);
    if ( left !=0 )
      printf("Buffer %3d,%3d = %3d\n", 0, y, left);

    if ( right !=0 )
      printf("Buffer %3d,%3d = %3d\n", g->xres -1 ,y, right);
  }
  fprintf(stderr, "Did a full check of buffer extents\n");
}


void gfx_setup_fps_timer(Gfx *g) {
  /* Setup fps info stuff */
  g->tz.tz_minuteswest=g->tz.tz_dsttime=0;  /* Ignore timezone */
  gettimeofday(&(g->tp1),&(g->tz));
  gettimeofday(&(g->tp2),&(g->tz));
  gettimeofday(&(g->starttime), &(g->tz));
}

void gfx_display_image(Gfx *g) {
  static char screenstr[12];

  //  for (i=0; i<100; i++) 
  //    VGLLine(VGLDisplay, 0, i, 310, i, i/2 % 200);

  // FIXME could be xres,yres as the last two

  if (g->show_fps) {
    gettimeofday(&(g->tp1),&(g->tz));
    g->show_fps= 1000000.0/( (g->tp1.tv_sec - g->tp2.tv_sec)*1000000
  			     +(g->tp1.tv_usec - g->tp2.tv_usec));
    gettimeofday(&(g->tp2),&(g->tz));
    snprintf(screenstr,12, "fps: % 6f",g->show_fps);
    VGLBitmapString(g->vglim, 10, 0, screenstr, 200, 30, 1, 0);
  }
  VGLBitmapCopy(g->vglim , 0, 0, VGLDisplay, 0, 0, 320, 200);
}

void gfx_create_2cmap(Gfx *gf, unsigned col) {
  int i, red, green, blue;
  red = green = blue = 0;
  for (i = 1; i < 256; i++) {
    if (!(i%4)) red++;
    if ((i>128) && (!(i%7))) green++;
    if ((i>196) && (!(i%21))) blue++;
    VGLSetPaletteIndex(i, red, green, blue);
  }
}


void gfx_create_cmap(Gfx *gf, unsigned col) {
  int R_max, G_max,  B_max,  ent;
  double aimr, aimg, aimb, nr, ng, nb;
  
  R_max = 64; //gf->xim->red_mask   >> (R_shft = ffs(gf->xim->red_mask)   - 1);
  G_max = 64; //gf->xim->green_mask >> (G_shft = ffs(gf->xim->green_mask) - 1);
  B_max = 64; //gf->xim->blue_mask  >> (B_shft = ffs(gf->xim->blue_mask)  - 1);

  aimr = ((col & 0xFF0000) >> 16)/255.0;
  aimg = ((col & 0x00FF00) >> 8)/255.0;
  aimb =  (col & 0x0000FF)/255.0;
  
  nr = 10 * (1-aimr) + 1;
  ng = 10 * (1-aimg) + 1;
  nb = 10 * (1-aimb) + 1;
   
  for (ent=0; ent<256; ent++) {
    int r,g,b;
    double entp=ent/256.0;
    r = (int)(R_max * pow(entp,nr));
    g = (int)(G_max * pow(entp,ng));
    b = (int)(B_max * pow(entp,nb));
    VGLSetPaletteIndex(ent, r, g, b);
  }
}

void gfx_add_pixel(Gfx *g, int x, int y, unsigned char pixval) {
    int px =  pixval + g->cbuffer[x+y*g->xres];
    /* FIXME: This shouldn't be needed, but it might be worth trying
       if ( (x<1) || (x>=319) ) printf("add pixel called with stupid args\n"); */
    if (px >255) px=255;
    if (px <0)   px=0;
    g->cbuffer[x+y*g->xres]=(unsigned char) px;
}

void gfx_cleanup(Gfx *g) {
  printf("Not cleaning up anything... ! Yikes!\n");
  //  XDestroyImage(g->xim);

  VGLKeyboardEnd();
  VGLEnd();

  //  XFreeGC(g->dpy, g->gc);
  //  XCloseDisplay(g->dpy);
  /* put back final fps details */
  gettimeofday(&(g->tp1),&(g->tz));
  /* For this to be average frames/second of application a frame counter
     would need to be stored with the graphics routines. but it's not */
  g->show_fps= 1000000.0/((g->tp1.tv_sec-g->starttime.tv_sec)*1000000
				  + (g->tp1.tv_usec - g->starttime.tv_usec));
}

int gfx_setup_vglimage(Gfx *g) {
  // alloc a new bitmap
  g->vglim = VGLBitmapCreate(MEMBUF, 320, 200, NULL);
  VGLBitmapAllocateBits(g->vglim);
  VGLClear(g->vglim, 0);
  //  image=imj->Bitmap;
  return ((int)g->vglim);
}

int gfx_SetupGfx(Gfx *g, int inwindow, unsigned long col) {

  /* check resolution is okay */
  if ( (g->xres !=320) || (g->yres !=200) ) {
    fprintf(stderr,"Resolution %d by %d is unsupported (320x240 is though)\n",g->xres, g->yres);
    return 0;
  }

  if (VGLInit(SW_VGA_CG320) <0) {
    fprintf(stderr, "Unable to start 320x200 mode\n");
    return 0;
  }

  VGLKeyboardInit(VGL_XLATEKEYS);
  //  if (VGLKeyboardInit(VGL_XLATEKEYS)==1) {
  //    VGLEnd();
  //    printf("Unable to init keyboard\n");
  //    return 0;
  //  }

  gfx_setup_vglimage(g);
  gfx_create_cmap(g,col);  
  gfx_setup_fps_timer(g);
  setup_back_buff(g);
  return 1;
}

int gfx_getkey(Gfx *g) {
  //  XEvent xev;
  return (VGLKeyboardGetCh());
}
