#ifndef BLOBS_GFX_VGL_H_INCLUDED
#define BLOBS_GFX_VGL_H_INCLUDED

/* not in xwin.c as things using this need to know about Displays etc. */

#include <sys/types.h>
#include <sys/fbio.h>
#include <sys/consio.h>
#include <sys/kbio.h>
#include <vgl.h>

/* required for fps details */
#include <sys/time.h>

typedef struct {
  char *windowname;
  //  Display *dpy;
  int xres,yres; /* Display resolutions - fixed at 320x200 currently! */
  //  XVisualInfo xvs;
  //  Window win;
  //  GC gc;
  //  XImage *xim;            /* screen / front buffer   */
  VGLBitmap *vglim;
  unsigned char *cbuffer; /* char (8bit) back buffer */
  // unsigned long simple_map[256]; /* A simple colour map. */

  float show_fps; /* 0 or current frames per second value */
  struct timeval tp1,tp2, starttime;
  struct timezone tz;
} Gfx;

//int  gfx_get_best_truecolor(Gfx *g);

int  gfx_SetupGfx(Gfx *g,int inwindow, unsigned long col);
// inwindow is ignored

int  gfx_getkey(Gfx *g);
void gfx_create_cmap(Gfx *gf, unsigned col);
// void gfx_Print_Visual_Info(XVisualInfo *v);
void gfx_display_image(Gfx *g);
void gfx_cleanup(Gfx *g);
void gfx_add_pixel(Gfx *g, int x, int y, unsigned char pixval);
#endif /* BLOBS_GFX_VGL_H_INCLUDED */
