#include <math.h>
#include <signal.h>

#include <stdlib.h> /* for getenv.. (would be nice to remove this) */
#include <stdio.h>  /* For printf - again, nice to remove this */
#include "gfx-x.h"  /* essential - ish. */
#include "string.h" /* for ffs (find first set) */

#ifdef DEBUG
static void xdbg_Dump_Ximage_Struct(XImage *);
static void xdbg_Print_Visual_Info(XVisualInfo *v);
#endif /* DEBUG */

static int gfx_setup_ximage(Gfx *);
void gfx_setup_fps_timer(Gfx *);


int setup_back_buff(Gfx *g) {
  g->cbuffer=(unsigned char *)malloc(g->xres * g->yres * sizeof(unsigned char));
  memset((void *)g->cbuffer,0,g->xres*g->yres); /* unecessary */
  return (g->cbuffer!=0);
}

void check_buff(Gfx *g) {
  int left , right , y;
  /* This checks that neither the left or right extents in a buffer */
  /* have been set to anything other than zero! */
  for (y=0; y<g->yres; y++) {
    left  = *(g->cbuffer + (y * g->xres));
    right = *(g->cbuffer + (y * g->xres) + g->xres -1);
    if ( left !=0 )
      printf("Buffer %3d,%3d = %3d\n", 0, y, left);

    if ( right !=0 )
      printf("Buffer %3d,%3d = %3d\n", g->xres -1 ,y, right);
  }
  fprintf(stderr, "Did a full check of buffer extents\n");
}


void gfx_setup_fps_timer(Gfx *g) {
  /* Setup fps info stuff */
  g->tz.tz_minuteswest=g->tz.tz_dsttime=0;  /* Ignore timezone */
  gettimeofday(&(g->tp1),&(g->tz));
  gettimeofday(&(g->tp2),&(g->tz));
  gettimeofday(&(g->starttime), &(g->tz));
}

void gfx_display_image(Gfx *g) {
  static char screenstr[12];
#ifdef USE_XSHM_EXT
  XShmPutImage(g->dpy,g->win,g->gc,g->xim,0,0,0,0,g->xres,g->yres, False);
#else
  XPutImage(g->dpy,g->win,g->gc,g->xim,0,0,0,0,g->xres,g->yres);
#endif
  if (g->show_fps) {
    gettimeofday(&(g->tp1),&(g->tz));
    g->show_fps= 1000000.0/( (g->tp1.tv_sec - g->tp2.tv_sec)*1000000
			     +(g->tp1.tv_usec - g->tp2.tv_usec));
    gettimeofday(&(g->tp2),&(g->tz));
    snprintf(screenstr,12, "fps: % 6f",g->show_fps);
    XSetForeground(g->dpy,g->gc, 
		   g->simple_map[255]); /* why calculate white pixel it's mapped! */
    XDrawString(g->dpy,g->win,g->gc,0,g->yres,screenstr,11);
  }	
  XSync(g->dpy,False);
}

void gfx_create_cmap(Gfx *gf, unsigned col) {
  int R_max, R_shft, G_max, G_shft, B_max, B_shft, ent;
  double aimr, aimg, aimb, nr, ng, nb;
  
  R_max = gf->xim->red_mask   >> (R_shft = ffs(gf->xim->red_mask)   - 1);
  G_max = gf->xim->green_mask >> (G_shft = ffs(gf->xim->green_mask) - 1);
  B_max = gf->xim->blue_mask  >> (B_shft = ffs(gf->xim->blue_mask)  - 1);

  aimr = ((col & 0xFF0000) >> 16)/255.0;
  aimg = ((col & 0x00FF00) >> 8)/255.0;
  aimb =  (col & 0x0000FF)/255.0;
  
  nr = 10 * (1-aimr) + 1;
  ng = 10 * (1-aimg) + 1;
  nb = 10 * (1-aimb) + 1;
   
  for (ent=0; ent<256; ent++) {
    int r,g,b;
    double entp=ent/255.0;
    r = (int)(R_max * pow(entp,nr));
    g = (int)(G_max * pow(entp,ng));
    b = (int)(B_max * pow(entp,nb));
    gf->simple_map[ent] = ( (r<<R_shft) |
    			    (g<<G_shft) |
    			    (b<<B_shft) );
  }
}

void gfx_add_pixel(Gfx *g, int x, int y, unsigned char pixval) {
    int px =  pixval + g->cbuffer[x+y*g->xres];
    /* FIXME: This shouldn't be needed, but it might be worth trying
       if ( (x<1) || (x>=319) ) printf("add pixel called with stupid args\n"); */
    if (px >255) px=255;
    if (px <0)   px=0;
    g->cbuffer[x+y*g->xres]=(unsigned char) px;
}

static Bool WaitForNotify(Display *d, XEvent *e, XPointer arg) {
  return ( (e->type == MapNotify) && (e->xmap.window == (Window)arg) );
}

void gfx_cleanup(Gfx *g) {
#ifdef USE_XSHM_EXT
  XShmDetach (g->dpy, &(g->shminfo));
  XDestroyImage (g->xim);
  shmdt (g->shminfo.shmaddr);
  shmctl (g->shminfo.shmid, IPC_RMID, 0);
#else
  printf("Not cleaning up anything... ! Yikes!\n");
  XDestroyImage(g->xim);
#endif

  if ( g->win != RootWindow(g->dpy, g->xvs.screen) )
    XFreeGC(g->dpy, g->gc);

  /* Only free the GC if it wasn't the default GC on the root window */

  XCloseDisplay(g->dpy);
  /* put back final fps details */
  gettimeofday(&(g->tp1),&(g->tz));
  /* For this to be average frames/second of application a frame counter
     would need to be stored with the graphics routines. but it's not */
  g->show_fps= 1000000.0/((g->tp1.tv_sec-g->starttime.tv_sec)*1000000
				  + (g->tp1.tv_usec - g->starttime.tv_usec));
}

int gfx_setup_ximage(Gfx *g) {
#ifdef USE_XSHM_EXT
  g->xim=
    XShmCreateImage(g->dpy, g->xvs.visual, g->xvs.depth, ZPixmap, 
		    (char *)NULL , &(g->shminfo), g->xres, g->yres);

  if (!g->xim) return 0;
  /* FIXME SHOULD CLEAN UP AND FALL BACK TO NORMAL IMAGES */

  g->shminfo.shmid=shmget(IPC_PRIVATE,g->xim->bytes_per_line * g->xim->height, IPC_CREAT|0777);

  if (g->shminfo.shmid == -1) {
    fprintf(stderr, "Could not create a shared memory segment\n");
    /* FIXME SHOULD CLEAN UP AND FALL BACK TO NORMAL IMAGES */
    return 0;
  }
  
  fprintf(stderr, "Created Shared memory segment ID: %d\n", g->shminfo.shmid);

  g->shminfo.shmaddr = g->xim->data = shmat (g->shminfo.shmid, 0, 0);
  /* FIXME: THIS COULD RETURN -1 fail code-  SHOULD FALL BACK TO NORMAL IMAGES */
  fprintf(stderr, "Have attached shm segment at %p\n", g->shminfo.shmaddr);

  g->shminfo.readOnly = False;
  if (!XShmAttach (g->dpy, &(g->shminfo))) {
    fprintf(stderr,"XServer failed to attache to shared memory segment\n");
    /* FIXME SHOULD CLEAN UP AND FALL BACK TO NORMAL IMAGES */
    return 0;
  }
#else
  g->xim = XCreateImage (g->dpy, g->xvs.visual, g->xvs.depth, ZPixmap,
			 0, (char *) NULL, g->xres, g->yres, 32, 0);
  g->xim->data = (char *) calloc(g->xim->height, g->xim->bytes_per_line);
#endif
  return (g->xim && g->xim->data && setup_back_buff(g));
}

int gfx_SetupGfx(Gfx *g, int inwindow, unsigned long col) {
  char *displayname;
  XEvent xev;

  /* check resolution is okay */
  if ( (g->xres < 10) || (g->xres > 4096) || (g->yres < 10) || (g->yres > 4096) ) {
    fprintf(stderr,"Resolution %d by %d is unsupported (max range is 10->4096)\n",g->xres, g->yres);
    return 0;
  }

  displayname = getenv("DISPLAY");

  if (!(g->dpy = XOpenDisplay(displayname))) {
    fprintf(stderr,"Unable to open display %s\n",displayname);
    return 0;
  }

  
  if ( !(XMatchVisualInfo(g->dpy, DefaultScreen(g->dpy), 32, TrueColor, &(g->xvs)) || 
	 XMatchVisualInfo(g->dpy, DefaultScreen(g->dpy), 24, TrueColor, &(g->xvs)) ||
	 XMatchVisualInfo(g->dpy, DefaultScreen(g->dpy), 16, TrueColor, &(g->xvs)) ||
	 XMatchVisualInfo(g->dpy, DefaultScreen(g->dpy),  8, TrueColor, &(g->xvs)) )) {
    fprintf(stderr,"Unable to get a suitable visual\n");
    fprintf(stderr,"A 32,24,16 or 8 bit TrueColor display is required.\n");
    return 0;
  }

#ifdef DEBUG
  xdbg_Print_Visual_Info(&(g->xvs));
#endif

  g->win= RootWindow(g->dpy, g->xvs.screen);

  if (inwindow) {
    XSetWindowAttributes swa;
    swa.event_mask    = StructureNotifyMask | KeyPressMask | ButtonPressMask | PointerMotionMask;
    swa.backing_store = False;
    swa.background_pixel = swa.border_pixel = BlackPixel(g->dpy, g->xvs.screen ) ;
    swa.save_under    = False;
    /* Added a colormap so that it still works in 8bpp modes.
       for some reason without it it was always getting a BadMatch.. hmm! */
    swa.colormap = XCreateColormap( g->dpy , g->win , g->xvs.visual, AllocNone );
    
    g->win = XCreateWindow(g->dpy, g->win, 0, 0, g->xres, g->yres,
			   0, g->xvs.depth, InputOutput, g->xvs.visual,
			   CWBackPixel | CWEventMask | CWBorderPixel |
                           CWColormap | CWBackingStore | CWSaveUnder, &swa);

    if (!g->win) {fprintf(stderr,"Unable to create window\n"); return 0; }
    if (!XMapWindow(g->dpy, g->win)) {fprintf(stderr,"Unable to map windows\n"); return 0; }
    
    XSync(g->dpy,0);
    XStoreName(g->dpy, g->win, g->windowname?g->windowname:"glurbules" );
    XIfEvent(g->dpy, &xev, WaitForNotify, (XPointer)(g->win));

    /* Hello Houston, this is Xlib calling, we have got somewhere at last */
    g->gc = XCreateGC(g->dpy,g->win, 0, 0);
  }
  else {
    g->gc = DefaultGC(g->dpy,DefaultScreen(g->dpy));
  }

  gfx_setup_ximage(g);

  gfx_create_cmap(g,col);  
  /* This doesn't work in certain bitdepths */
  /*  memset((void *)g->xim->data,0,g->xres*g->yres*4); erase the image */
#ifdef DEBUG
  xdbg_Dump_Ximage_Struct(g->xim);
#endif
  gfx_setup_fps_timer(g);
  return 1;
}

int gfx_getkey(Gfx *g) {
  XEvent xev;
  char c;
  // Just return keypresses.
  if (XCheckWindowEvent(g->dpy, g->win, KeyPressMask, &xev)) {
    XLookupString((XKeyEvent *)&xev, &c, 1, NULL , NULL);
    return c;
  }
  return 0;
}

/* The rest of the file is unexciting debug routines.
   or dumping structures out etc. */

#ifdef DEBUG
static void xdbg_Print_Visual_Info(XVisualInfo *v) {
  printf("Visual Information:\n");
  printf("Depth        :  %d\n", v->depth);
  printf("bits per rgb :  %d\n", v->bits_per_rgb);
  printf("VisualID     :  %ld\n", v->visualid);
  printf("Screen       :  %d\n", v->screen);
  printf("Class        :  ");

  switch(v->class) {
  case (TrueColor) : printf ("TrueColor\n"); break;
  case (DirectColor) : printf ("DirectColor\n"); break;
  case (PseudoColor) : printf ("PsuedoColor\n"); break;
  case (GrayScale)   : printf ("GrayScale\n"); break;
  default : printf(" %d (unknown type)\n", v->class);
  }

  printf("Red mask     :  %03lx\n", v->red_mask);
  printf("Green mask   :  %lx\n", v->green_mask);
  printf("Blue mask    :  %lx\n", v->blue_mask);
  printf("Colormap Size:  %d\n", v->colormap_size);
}

static void xdbg_Dump_Ximage_Struct(XImage *xim) {
  printf("---DUMP OF XImage Structure %p\n", xim);
  printf("width = %d\n",xim->width);
  printf("height = %d\n",xim->height);
  printf("xoffset = %d\n",xim->xoffset);
  printf("format = %d\n",xim->format);
  printf("data = %p\n",xim->data);
  printf("byte_order = %d\n",xim->byte_order);
  printf("bitmap_unit = %d\n",xim->bitmap_unit);
  printf("bitmap_bit_order = %d\n",xim->bitmap_bit_order);
  printf("bitmap_pad = %d\n",xim->bitmap_pad);
  printf("depth = %d\n",xim->depth);
  printf("bytes_per_line = %d\n",xim->bytes_per_line);
  printf("bits_per_pixel = %d\n",xim->bits_per_pixel);
  printf("red_mask   = %06lx\n",xim->red_mask);
  printf("green_mask = %06lx\n",xim->green_mask);
  printf("blue_mask  = %06lx\n",xim->blue_mask);
  printf("obdata = %p\n",xim->obdata);
  printf("f.create_image = %p\n",xim->f.create_image);
  printf("f.destroy_image = %p\n",xim->f.destroy_image);
  printf("f.get_pixel = %p\n",xim->f.get_pixel);
  printf("f.put_pixel = %p\n",xim->f.put_pixel);
  printf("f.sub_image = %p\n",xim->f.sub_image);
  printf("f.add_pixel = %p\n",xim->f.add_pixel);

  /* Useful to have for debugging : */
  printf ("Size of unsigned long %d\n", sizeof(unsigned long));
  printf ("Size of long %d\n", sizeof(long));
  printf ("Size of int %d\n", sizeof(int));
  printf ("Size of unsigned int %d\n", sizeof(unsigned int));
  /* on an Intel machine these are all 4 bytes long (32bit cpu) */
  /* but given a different architecture they may be different ? */
}
#endif /* DEBUG */



