#ifndef BLOBS_GFX_X_H_INCLUDED
#define BLOBS_GFX_X_H_INCLUDED

/* not in xwin.c as things using this need to know about Displays etc. */
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/*#include "vroot.h" */

#ifdef USE_XSHM_EXT
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

/* required for fps details */
#include <sys/time.h>

typedef struct {
  char *windowname;
  Display *dpy;
  int xres,yres; /* Display resolutions */
  XVisualInfo xvs;
  Window win;
  GC gc;
  XImage *xim;            /* screen / front buffer   */
  unsigned char *cbuffer; /* char (8bit) back buffer */
  unsigned long simple_map[256]; /* A simple colour map. */

#ifdef USE_XSHM_EXT
  XShmSegmentInfo shminfo;
#endif

  float show_fps; /* 0 or current frames per second value */
  struct timeval tp1,tp2, starttime;
  struct timezone tz;
} Gfx;

int  gfx_get_best_truecolor(Gfx *g);
int  gfx_SetupGfx(Gfx *g,int inwindow, unsigned long col);
int  gfx_getkey(Gfx *g);

void gfx_create_cmap(Gfx *gf, unsigned col);
void gfx_Print_Visual_Info(XVisualInfo *v);
void gfx_display_image(Gfx *g);
void gfx_cleanup(Gfx *g);
void gfx_add_pixel(Gfx *g, int x, int y, unsigned char pixval);
#endif /* BLOBS_GFX_X_H_INCLUDED */
