#include <stdlib.h>
#include <math.h>

typedef struct {
  char *control_name;
  double cval; /* current value */
  double dflt; /* default value */
  double min;
  double max;
  double delta; /* delta to change by */
} Cset;

typedef struct {
  double x,y;   /* x and y positions, confined between 0 and 1 */
  double xv,yv; /* and velocities */
} Particle;

typedef struct Particle_Sys {
  Particle *p;
  int n_particles;

  /* current force system */
  void (*frc)(struct Particle_Sys *, Particle *, Particle *);
  /* force values */
  Cset *cvar[4];

  int xpos, ypos; /* centre-point for explosions */
  int follow;
 
  /* Region used for creation of particles */
  int reg_xmin, reg_xmax, reg_ymin, reg_ymax;

  /* Particle system smudge factors */
  double friction; /* particle velocity is multiplied by this each frame */
  double xgrav, ygrav; /* x,y axis gravities */
  double xcent, ycent; /* x,y centering tend */

  /* Booleans to turn on things */
  int tend_to_centpt;
  int use_friction;
  int use_gravity;
} Particle_Sys;
  
void psys_dec_var(Particle_Sys *psys, int vnum);
void psys_inc_var(Particle_Sys *psys, int vnum);
void psys_reset_defaults(Particle_Sys *p);
void psys_toggle_gravity(Particle_Sys *psys);

 
void psys_stick(Particle *p1, Particle *p2);
void psys_frc_stf(Particle_Sys *psys, Particle *p1, Particle *p2);
void psys_frc_ang(Particle_Sys *psys, Particle *p1, Particle *p2);
void psys_frc_oth(Particle_Sys *psys, Particle *p1, Particle *p2);
void psys_frc_gra(Particle_Sys *psys, Particle *p1, Particle *p2);
void psys_frc_spr(Particle_Sys *psys, Particle *p1, Particle *p2);

/* Set particle system to use a particlar force system */
void psys_set_gra(Particle_Sys *psys);
void psys_set_ang(Particle_Sys *psys);
void psys_set_oth(Particle_Sys *psys);
void psys_set_spr(Particle_Sys *psys);
void psys_set_stf(Particle_Sys *psys);
void psys_set_rnd(Particle_Sys *psys);

/**********************************************************************/
/**********************************************************************/
/**********************************************************************/

void psys_set_region(Particle_Sys *psys, double xmin, double xmax, double ymin, double ymax);
void psys_rand_edge_starts(Particle_Sys *psys);
void psys_rand_burstpt(Particle_Sys *psys);
void psys_set_defaults(Particle_Sys *psys);
void psys_resetparticle(Particle_Sys *psys, Particle *d);
void psys_reset_all_particles(Particle_Sys *psys);
int psys_create_particles(Particle_Sys *psys);
void psys_set_spr_forces(Particle_Sys *psys, double springlen, double konstant);
void psys_frc_to_all(Particle_Sys *psys);
void psys_frc_to_lead(Particle_Sys *psys);
void psys_frc_to_next(Particle_Sys *psys);
void psys_move(Particle_Sys *psys);
void psys_automovep(Particle_Sys *psys);



