/*-
 * Copyright (c) 2001
 * Tatsuya Kudoh(CDR/TK),ROYALPANDA.    All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
** Falling Tower KAI
**	Copyright (c) 2000	ROYALPANDA	All rights reserved
**
**	May 25, 2000 Ver 1.0
**	May 27, 2000 Ver 1.1
*/

#include<stdio.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/Xaw/Form.h>
#include<X11/Xaw/Viewport.h>
#include<X11/Xaw/Label.h>
#include<X11/Shell.h>
#include<X11/xpm.h>

#include"xjump.h"
#include"key.h"

static int T_speed,T_count;
static int T_min;
static int T_dir;
static int T_level;

static hero_t Hero;


void GAME_init( void )
{
	T_level = 0;
	T_speed = 4000;
	T_min = (50000+T_speed*7)/8;
	T_count = 0;
	T_dir = 1;

	FLOOR_init();
	HERO_init(&Hero);
}


int GAME_main( int move )
{
	int scroll;
	int floor;
	int fl;

	scroll = 0;

	if( T_dir ){
		T_speed += (T_speed+1499)/1500;
		if( T_speed > 50000 ){
			T_speed = 50000;
			T_dir = 0;
		}
	}else{
		T_speed -= (T_speed+99) / 100;
		if( T_speed < T_min ){
			T_speed = T_min;
			T_min = (50000+T_min*7)/8;
			if( T_min > 20000 )
				T_min = 20000;
			T_dir = 1;
			if( T_level < 8 )
				T_level++;
		}
	}

	T_count += T_speed;
	if( T_count > 200000 ){
		T_count -= 200000;
		scroll = 1;
	}

	if( move ){
		if( Hero.y < 48 )
			scroll = 1;

		FLOOR_move_all(scroll,T_level);
		floor = HERO_move(&Hero,scroll,KEY_read());
		fl = (floor-1) / 50;
		HERO_delete(&Hero);
		HERO_draw(&Hero);
		FLOOR_refresh();
		if( Hero.y > HEIGHT*16 ){
			return -1;
		}else{
			return floor;
		}
	}else{
		FLOOR_move_all(scroll,T_level);
		FLOOR_refresh();
		return -1;
	}
}


void GAME_redraw( void )
{
	HERO_draw(&Hero);
	FLOOR_refresh();
}
