/*-
 * Copyright (c) 2001
 * Tatsuya Kudoh(CDR/TK),ROYALPANDA.    All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/**********************************
*
* key.c -- ver 1.0
*
*	Mar 25,2000 ROYALPANDA
*
**********************************/

#include<stdio.h>
#include<X11/Xlib.h>
#include"key.h"

static int KeyTable[256];
static int KeyState;


void KEY_init( void )
{
	int i;

	for( i = 0 ; i < 256 ; i++ )
		KeyTable[i] = 0;

	for( i = 0 ; i < NUM_KEYS ; i++ )
		KeyState = 0;
}


static void add( Display *d, int key, char *keysym_name )
{
	KeySym sym;
	KeyCode code;

	sym = XStringToKeysym(keysym_name);
	if( sym == NoSymbol ){
		fprintf(stderr,"KeySym '%s' does not exist.\n");
		return;
	}
	code = XKeysymToKeycode(d,sym);
	if( code == 0 ){
		fprintf(stderr,"KeySym '%s' is not defined for any KeyCode.\n");
		return;
	}
	KeyTable[code] |= key;
}


void KEY_add( Display *d, int key, char *str )
{
	char buf[256];
	char *p;
	int i;

	if( str == NULL )
		return;

	do{
		p = buf;
		i = 0;
		while( *str && *str != ',' && i < 255 ){
			*p++ = *str++;
			i++;
		}
		*p = '\0';
		add(d,key,buf);
	}while( *str++ );
}


int KEY_change( int keycode, int state )
{
	int key;

	key = KeyTable[keycode];

	if( state )
		KeyState |= key;
	else
		KeyState &= ~key;

	return key;
}


int KEY_read( void )
{
	return KeyState;
}
