/*-
 * Copyright (c) 2001
 * Tatsuya Kudoh(CDR/TK),ROYALPANDA.    All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
** Falling Tower KAI
**	Copyright (c) 2000	ROYALPANDA	All rights reserved
**
**	May 25, 2000 Ver 1.0
*/

#include<stdio.h>
#include<stdlib.h>
#include<errno.h>
#include<sys/types.h>
#include<pwd.h>

static long Seed;


int rnd( int range )
{
	long tmp,hi,lo;

	hi = Seed / 127773;
	lo = Seed % 127773;
	Seed = 16807 * lo - 2836 * hi;
	if( Seed <= 0 )
		Seed += 0x7fffffff;

	return Seed % range;
}


void srnd( int seed )
{
	Seed = seed;
}


void get_name( char *buf, int bufsiz, int uid )
{
	struct passwd *pw;
	int i;
	char *q,*r;
	char b[80];

	bufsiz--;

	if( ( pw = getpwuid(uid) ) == NULL ){
		sprintf(b,"noname(UID=%-5.5d)",uid);
		strncpy(buf,b,bufsiz);
	}else{
		i = 0;
		q = buf;
		r = pw->pw_gecos;
		while( i < bufsiz && *r != '\0' && *r != ',' ){
			*q++ = iscntrl(*r) ? ' ' : *r;
			r++;
			i++;
		}
		if( i > 0 )
			*q = '\0';
		else
			strncpy(buf,pw->pw_name,bufsiz);
	}
}
