/*-
 * Copyright (c) 2001
 * Tatsuya Kudoh(CDR/TK),ROYALPANDA.    All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#ifndef _XJUMP_H_
#define _XJUMP_H_

typedef struct{
	int x;
	int y;
	int vx;
	int vy;
	int dir;
	int jump;

	int pic;
	int g_count;

	int erase_x;
	int erase_y;
}hero_t;


typedef struct{
	int graphic;
	int graphic_base;

	int floor;

	int y;

	int left;
	int right;

	int left_prev;

	int erase_x;
	int erase_y;
	int erase_width;

	int left_src;
	int right_src;

	int mu;

	/* moving */

	int move_vector;

	/* blink */

	int blink_interval;
	int blink_count;

	/* force */

	int force_vector;

	/* graphic phase */

	int phase;
}floor_t;


#define FLOOR_CLEAR	0
#define FLOOR_NORMAL	1
#define FLOOR_ICE	2
#define FLOOR_FORCE	3

#define WIDTH		32
#define HEIGHT		24
#define FLOOR_HEIGHT	5

void message( char *str );

void FLOOR_draw( floor_t *fp );
void FLOOR_refresh( void );
void FLOOR_create( int y, int level );
void FLOOR_move( floor_t *fp, int scroll );
void FLOOR_move_all( int scroll,int level );
floor_t *FLOOR_check(int hx, int hy);
void FLOOR_init( void );


void GAME_init( void );
int GAME_main( int move );
void GAME_redraw( void );
int GAME_key_press( int key );
int GAME_key_release( int key );

extern char *Myname;

#endif
