/* XLINES game (c) Gene Soudlenkov (Franky)
   You are free to modify and distribute this code
   as long as you keep my name here :)
   
   This is just a one-day hack written on my wife's request
   after I had erased her game for DOS. So this code is pretty ugly.
*/   
   
#include "lines.h"
#include <qapp.h>
#include <qmsgbox.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>

QColor colors[]={red,darkBlue,green,yellow,darkCyan,darkMagenta};
#define NOCOLOR -1
#define RED 0
#define BLUE 1
#define GREEN 2
#define YELLOW 3
#define CYAN 4
#define MAGENTA 5


/******************** Stack definitions ************************/

Stack::Stack()
{
   array=(int *)calloc(10,sizeof(int));
   arraySize=10;
   stackSize=0;
}

Stack::~Stack()
{
   if(array) free(array);
}

void Stack::push(int num)
{
   if(stackSize+1>=arraySize)
   {
      arraySize+=10;
      array=(int *)realloc(array,arraySize*sizeof(int));
   }
   array[stackSize++]=num;
}

int Stack::pop()
{
   if(!stackSize) return 0;
   return array[--stackSize];
}

/**********************************************************************/

CBall::CBall(QWidget *parent, QRect _rect,int _index):QFrame(parent),index(_index)
{
   rect=_rect;
   setGeometry(rect);
   setFrameStyle(Panel|Raised);
   setColor=-1;
   isActive=0;
   timer=NULL;
   ballRect.setRect(3,3,rect.width()-6,rect.height()-6);
}

CBall::~CBall()
{
}

void CBall::SetActive(int actFlag)
{
   if(isActive==actFlag) return;
   isActive=actFlag;
   if(!isActive)
   {
      if(timer) 
      {
         timer->stop();
         delete timer;
         timer=NULL;
      }
      ballRect.setRect(3,3,rect.width()-6,rect.height()-6);
      repaint();
   }
   else
   {
      timer=new QTimer(this);
      connect(timer,SIGNAL(timeout()),this,SLOT(timeOut()));
      timer->start(200);
   }
}

void CBall::timeOut()
{
    static signed int dx=3,dy=3;
    
    if((ballRect.width()<=12 && dx>0) || (ballRect.width()>=rect.width()-6 && dx<0))
    {
       dx=-dx;
       dy=-dy;
    }
    ballRect.moveBy(dx,dy);
    ballRect.setWidth(ballRect.width()-dx*2);
    ballRect.setHeight(ballRect.height()-dy*2);
    repaint();    
}

void CBall::paintEvent(QPaintEvent *e)
{
    QPainter paint;
    paint.begin(this);
    drawFrame(&paint);
    if(setColor!=-1)
    {
       paint.setPen(colors[setColor]);
       paint.setBrush(colors[setColor]);
       paint.drawPie(ballRect,0,5760);
    }
    paint.end();
}

void CBall::mousePressEvent(QMouseEvent *event)
{
   if(event->button()==LeftButton)
   {
      emit SendRequest(index);
   }
}


CGameField::CGameField(QWidget *parent,QRect _rect):QFrame(parent)
{
   rect=_rect;
   for(int i=0;i<DIMALL;i++)
      cells[i].ball=NULL;
   ClearField(1);
   curActiveBall=-1;
   setGeometry(rect);
}

CGameField::~CGameField()
{
}

void CGameField::BallRequest(int num)
{
   if(num==curActiveBall) return;
   if(cells[num].ball->setColor!=NOCOLOR)
   {
      /* Set new active ball */
      if(curActiveBall!=-1)
      {
         /* stop current active ball */
         cells[curActiveBall].ball->SetActive(0);
      }
      curActiveBall=num;
      cells[num].ball->SetActive(1);
   }
   else if(curActiveBall!=-1) 
   {
      /* move ball */
      Stack *stack=new Stack;
      
      clearPath();
      buildPath(curActiveBall,num,stack);

      if(stack && stack->count())
      {
         /* move is enabled */
         cells[curActiveBall].ball->SetActive(0);
         moveBall(stack);
         cells[num].ball->SetActive(0);
         curActiveBall=-1;
         if(!checkLine(num))
         {
            //Generate new balls
            genNewBalls(freeNum>3?3:freeNum);
         }
      }
      if(stack) delete stack;
   }
}

void CGameField::genNewBalls(int num)
{
    //Generate num random balls
    for(int i=0;i<num;i++)
    {
       int rnd=random()%freeNum;
       for(int j=0;j<DIMALL;j++)
       {
          if(cells[j].ball->setColor==NOCOLOR)
          {
             if(rnd) 
             {
                rnd--;
                continue;
             }
             cells[j].ball->setColor=random()%6;
             cells[j].ball->repaint();
             freeNum--;
             checkLine(j);
             break;
          }
       }
    }
}

int CGameField::checkLine(int to)
{
    int color=cells[to].ball->setColor;
    int point=to;
    int num=0;
    
    //******************** Check horiz line ***********************
    while(point%DIMX>=0) 
    {
       if(cells[point].ball->setColor!=color)
       {
          point++;
          break;
       }
       if(point%DIMX>0) point--;
       else break;
    }   
    int tmpPoint=point;
    while(point%DIMX<=DIMX-1)
    {
       if(cells[point].ball->setColor!=color)
       {
          point--;
          break;
       }
       if(point%DIMX<DIMX-1) point++;
       else break; 
    }
    if(point-tmpPoint>=4)
    {
       emit removeBalls(point-tmpPoint+1);
       for(;tmpPoint<=point;tmpPoint++)
       {
          freeNum++;
          cells[tmpPoint].ball->setColor=NOCOLOR;
          cells[tmpPoint].ball->repaint();
       }   
       return 1;
    }
    //***************************** Horizontal checked ******************
  
    //**************** Check vertical line ***********************
    while(point/DIMX>=0)
    {
       if(cells[point].ball->setColor!=color)
       {
          point+=DIMX;
          break;
       }
       if(point/DIMX) point-=DIMX;
       else break;
    }
    tmpPoint=point;
    while(point<DIMALL)
    {
       if(cells[point].ball->setColor!=color) 
       {
          point-=DIMX;
          break;
       }
       if(point+DIMX<DIMALL) point+=DIMX;
       else break;
    }
    if((point-tmpPoint)/DIMX>=4)
    {
       emit removeBalls((point-tmpPoint)/DIMX+1);
       for(;tmpPoint<=point;tmpPoint+=DIMX)
       {
          freeNum++;
          cells[tmpPoint].ball->setColor=NOCOLOR;
          cells[tmpPoint].ball->repaint();
       }
       return 1;
    }
    //************************** Vertical checked ***********************
    
    //************************** Check right diagonal *******************
    while(point%DIMX>=0 && point/DIMX>=0) 
    {
       if(cells[point].ball->setColor!=color)
       {
          point+=DIMX+1;
          break;
       }
       if(point%DIMX>0 && point/DIMX>0) point-=DIMX+1;
       else break;
    }   
    tmpPoint=point;
    int cNum=0;
    while(point%DIMX<DIMX && point/DIMX<DIMY)
    {
       if(cells[point].ball->setColor!=color)
       {
          point-=DIMX+1;
          break;
       }
       cNum++;
       if(point%DIMX<DIMX-1 && point/DIMX<DIMY-1) point+=DIMX+1;
       else break;
    }
    if(cNum>4)
    {
       emit removeBalls(cNum);
       for(;tmpPoint<=point;tmpPoint+=DIMX+1)
       {
          freeNum++;
          cells[tmpPoint].ball->setColor=NOCOLOR;
          cells[tmpPoint].ball->repaint();
       }   
       return 1;
    }
    
    //************************** Right diag checked ********************
    
    //************************** Check left diagonal *******************

    while(point%DIMX<DIMX && point/DIMX>=0) 
    {
       if(cells[point].ball->setColor!=color)
       {
          point+=DIMX-1;
          break;
       }
       if(point%DIMX<DIMX-1 && point/DIMX>0) point-=DIMX-1;
       else break;
    }   
    tmpPoint=point;
    cNum=0;
    while(point%DIMX>=0 && point/DIMX<DIMY)
    {
       if(cells[point].ball->setColor!=color)
       {
          point-=DIMX-1;
          break;
       }
       cNum++;
       if(point%DIMX>0 && point/DIMX<DIMY-1) point+=DIMX-1;
       else break;
    }
    if(cNum>4)
    {
       emit removeBalls(cNum);
       for(;tmpPoint<=point;tmpPoint+=DIMX-1)
       {
          freeNum++;
          cells[tmpPoint].ball->setColor=NOCOLOR;
          cells[tmpPoint].ball->repaint();
       }   
       return 1;
    }
    
    //************************* Left diag checked **********************
    return 0;    
}

void CGameField::clearPath()
{
   for(int i=0;i<DIMALL;i++)
   {
      cells[i].prevInPath=-1;
      cells[i].minLen=0x8000;
   }
}

void CGameField::buildPath(int from,int to,Stack *path)
{
   int flag=0;
   
   path->push(from);
   cells[from].minLen=0;
   while(path->count())
   {
      int point=path->pop();
      if(point%DIMX>0 && cells[point-1].ball->setColor==NOCOLOR) 
      {
         if(cells[point-1].minLen>cells[point].minLen+1)
         {
            cells[point-1].prevInPath=point;
            cells[point-1].minLen=cells[point].minLen+1;
            path->push(point-1);
         }
      }
      if(point%DIMX<DIMX-1 && cells[point+1].ball->setColor==NOCOLOR) 
      {
         if(cells[point+1].minLen>cells[point].minLen+1)
         {
            cells[point+1].prevInPath=point;
            cells[point+1].minLen=cells[point].minLen+1;
            path->push(point+1);
         }
      }
      if(point/DIMX<DIMY-1 && cells[point+DIMX].ball->setColor==NOCOLOR) 
      {
         if(cells[point+DIMX].minLen>cells[point].minLen+1)
         {
            cells[point+DIMX].prevInPath=point;
            cells[point+DIMX].minLen=cells[point].minLen+1;
            path->push(point+DIMX);
         }
      }
      if(point/DIMY>=1 && cells[point-DIMX].ball->setColor==NOCOLOR) 
      {
         if(cells[point-DIMX].minLen>cells[point].minLen+1)
         {
            cells[point-DIMX].prevInPath=point;
            cells[point-DIMX].minLen=cells[point].minLen+1;
            path->push(point-DIMX);
         }
      }
   }
   
   if(cells[to].prevInPath!=-1)
   {
      path->push(to);
      int point=to;
      while(point!=from)
      {
         point=cells[point].prevInPath;
         path->push(point);
      }
   }
   else path->clear();
}

void CGameField::moveBall(Stack *stack)
{
   int color;
   
   if(!stack || !stack->count()) return;
   int point=stack->pop();
   color=cells[point].ball->setColor;
   while(stack->count())
   {
      cells[point].ball->SetActive(1);
      qApp->processEvents();
      usleep(8000);
      cells[point].ball->setColor=NOCOLOR;
      cells[point].ball->SetActive(0);
      point=stack->pop();
      cells[point].ball->setColor=color;
      cells[point].ball->repaint();
   }
}

void CGameField::startOver()
{
   ClearField(1);
   emit removeBalls(-1);
}

void CGameField::ClearField(int clearBalls)
{
   int i;
   
   freeNum=DIMALL;
   int ballWidth=(rect.width()-2)/DIMX;
   int ballHeight=(rect.height()-2)/DIMY;
   for(i=0;i<DIMALL;i++)
   {
      cells[i].prevInPath=-1;
      cells[i].minLen=0xffff;
      if(clearBalls && cells[i].ball) delete cells[i].ball;
      QRect rect;
      rect.setLeft((i%DIMX)*ballWidth);
      rect.setRight(rect.left()+ballWidth);
      rect.setTop((i/DIMY)*ballHeight);
      rect.setBottom(rect.top()+ballHeight); 
      cells[i].ball=new CBall(this,rect,i);
      cells[i].ball->show();
      connect(cells[i].ball,SIGNAL(SendRequest(int)),SLOT(BallRequest(int)));
   }
   genNewBalls(3);
}

void CMainWnd::addScore(int num)
{
   if(num==-1) curScore=0;
   else curScore+=num;
   score->display(curScore);
}

CMainWnd::CMainWnd():QWidget()
{
   quitButton=new QPushButton(this,"quit");
   quitButton->setText("&Quit");
   clearButton=new QPushButton(this,"clear");
   clearButton->setText("&Clear");
   quitButton->setGeometry(310,20,65,30);
   clearButton->setGeometry(310,60,65,30);
   score=new QLCDNumber(this,"lcd");
   score->setGeometry(300,120,85,45);
   curScore=0;
   score->display(0);
   movie=new QMovie("trolltech.gif");
   label=new QLabel(this,"label");
   label->setFrameStyle(QFrame::Box|QFrame::Plain);
   label->setMovie(*movie);
   label->setGeometry(300,220,100,70);
   
   QRect rect(5,5,290,290);
   field=new CGameField(this,rect);
   connect(field,SIGNAL(removeBalls(int)),SLOT(addScore(int)));
   connect(clearButton,SIGNAL(clicked()),field,SLOT(startOver()));
   field->show();
}

CMainWnd::~CMainWnd()
{
}

void CMainWnd::clear()
{
}

void main(int argc,char *argv[])
{
   QApplication app(argc,argv);
   
   srandom(time(NULL));
   CMainWnd *mainWnd=new CMainWnd();
   mainWnd->resize(400,300);
   mainWnd->setCaption("XBalls :) game (c) Franky");
   mainWnd->show();
   app.setMainWidget(mainWnd);
   mainWnd->connect(mainWnd->quitButton,SIGNAL(clicked()),&app,SLOT(quit()));
   app.exec();
}


#include "lines.moc"
