#ifndef LINES_HPP
#define LINES_HPP
#include <qwidget.h>
#include <qframe.h>
#include <qpushbt.h>
#include <qpainter.h>
#include <qlcdnum.h>
#include <qtimer.h>
#include <stdlib.h>
#include <qmovie.h>
#include <qlabel.h>

#define DIMX	9
#define DIMY	9
#define DIMALL	DIMX*DIMY

class Stack
{
   public:
      Stack();
      ~Stack();
      int count() {return stackSize;};
      void push(int num);
      int pop();
      void clear() {stackSize=0;};
      
   protected:
      int *array;
      int arraySize;
      int stackSize;   
};

class CBall:public QFrame
{
     Q_OBJECT
   public:
      CBall(QWidget *parent,QRect _rect,int _index);
      ~CBall();
      void SetActive(int actFlag=1);
      
      int setColor;
      int isActive;
      int index;

   private slots:
      void timeOut();

   signals:
      void SendRequest(int num);

   protected:
      void paintEvent(QPaintEvent *event);
      QRect rect;   
      void mousePressEvent(QMouseEvent *);
      QRect ballRect;

      QTimer *timer;
};

struct Cell
{
   int prevInPath;
   int minLen;
   CBall *ball;
};

class CGameField:public QFrame
{
      Q_OBJECT
   public:
      CGameField(QWidget *parent,QRect _rect);
      ~CGameField();
   
   private slots:
      void BallRequest(int num);   
      void startOver();
      
   protected:
      void ClearField(int clearBalls=0);
      void clearPath();
      void buildPath(int from,int to,Stack *stack);
      void moveBall(Stack *stack);
      int checkLine(int to);
      void genNewBalls(int num);
      
   signals:
      void removeBalls(int num);   
 
   public:      
      int freeNum;
      Cell cells[DIMALL];
      QRect rect;
      int curActiveBall;
};

class CMainWnd:public QWidget
{
    Q_OBJECT
   public:
      CMainWnd();
      ~CMainWnd();
      
   public slots:
      void clear();
      void addScore(int num);
      
   public:
      QPushButton *quitButton;
      QPushButton *clearButton;
      QLCDNumber *score;
      
      CGameField *field;     
      int curScore;
      QMovie *movie;
      QLabel *label; 
};

#endif
