/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include "graph.h"

/*****************************************************************************/
/* Get Color.                                                                */
/*****************************************************************************/

unsigned long int GetColor(Display * display, Colormap colormap, char * color)
{
  XColor c0, c1;
  XAllocNamedColor(display, colormap, color, &c0, &c1);
  return (c0.pixel);
}

/*****************************************************************************/
/* Make Pixmap from Data.                                                    */
/*****************************************************************************/

Pixmap MakePixmapFromData(Display * display, Window w, char ** string,
                          int * width, int * height)
{
  XpmAttributes attributes;
  Pixmap pix, mask;

  attributes.colormap = DefaultColormap(display, DefaultScreen(display));
  attributes.closeness = 40000;
  attributes.valuemask = XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;
  XpmCreatePixmapFromData(display, w, string, &pix, &mask, &attributes);
  *width  = attributes.width;
  *height = attributes.height;
  return (pix);
}

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
