/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

#ifndef _XMANGEKYOU_INIT_H_INCLUDED_
#define _XMANGEKYOU_INIT_H_INCLUDED_

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/xpm.h>
#include <X11/Xaw/Label.h>

#include "configure.h"
#include "xmangekyou.h"
#include "graph.h"

/*****************************************************************************/
/* Set Default Values.                                                       */
/*****************************************************************************/

void SetDefaultValues();

/*****************************************************************************/
/* Read Command Line Parameters.                                             */
/*****************************************************************************/

void help();
void ReadCommandParameter(int * argc, char ** argv);

/*****************************************************************************/
/* Initializing Display.                                                     */
/*****************************************************************************/

void CreateCanvas(int * argc, char ** argv);
void CreateGC();
void InitializeDisplay(int * argc, char ** argv);

/*****************************************************************************/
/* Initializing Mangekyou.                                                   */
/*****************************************************************************/

int MakeHexCopyData(int r);
void InitializeDrawRoutine1(int r);
void InitializeDrawRoutine2(double canvas_size);
void InitializeMangekyou();

/*****************************************************************************/
/* Initializing Pieces.                                                      */
/*****************************************************************************/

void InitializeLines();
void InitializeCircles();
void InitializePieces();

/*****************************************************************************/
/* Addition of EventHandler                                                  */
/*****************************************************************************/

void PushKey(Widget w, XtPointer p, XEvent * event, Boolean * dispatch);
void ExposeCanvas(Widget w, XtPointer p, XEvent * event, Boolean * dispatch);
void ResizeCanvas();
void CanvasEvent(Widget w, XtPointer p, XEvent * event, Boolean * dispatch);
void AddEvent();

/*****************************************************************************/
/* Setting Icon.                                                             */
/*****************************************************************************/

void SetIcon();

/*****************************************************************************/
/* Setting Window Attributes.                                                */
/*****************************************************************************/

void SetWindowAttributes();

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
