/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include "xmangekyou.h"

/*****************************************************************************/
/* Static Data.                                                              */
/*****************************************************************************/

char * (color_name[COLORS_NUMBER]) = {
  "black", "white", "blue", "red", "green", "yellow", "orange",
  "pink", "magenta", "cyan", "brown", "gray", "SkyBlue", "GreenYellow",
  "purple", "SeaGreen", "gold", "plum"};

DoublePoint clear_points[CLEAR_POINTS_NUMBER] = {
  { 0.0,-1.0},              {-0.5*SQRT_3, -0.5},     {-0.5*SQRT_3,  0.5},
  { 0.0, 1.0},              { 0.5*SQRT_3,  0.5},     { 0.5*SQRT_3, -0.5},
  { 0.0,-1.0},
  { 0.0,-2.0*SQRT_2/SQRT_3},{-SQRT_2,-SQRT_2/SQRT_3},{-SQRT_2, SQRT_2/SQRT_3},
  { 0.0, 2.0*SQRT_2/SQRT_3},{ SQRT_2, SQRT_2/SQRT_3},{ SQRT_2,-SQRT_2/SQRT_3},
  { 0.0,-2.0*SQRT_2/SQRT_3}
};

DoublePoint clear_points_offset[CLEAR_POINTS_NUMBER] = {
  { 0.0, -OFFSET}, 
  {-0.5*SQRT_3*OFFSET, -0.5*OFFSET}, {-0.5*SQRT_3*OFFSET, 0.5*OFFSET},
  { 0.0,  OFFSET},
  { 0.5*SQRT_3*OFFSET,  0.5*OFFSET}, { 0.5*SQRT_3*OFFSET,-0.5*OFFSET},
  { 0.0, -OFFSET},
  { 0.0, -OFFSET},
  {-0.5*SQRT_3*OFFSET, -0.5*OFFSET}, {-0.5*SQRT_3*OFFSET, 0.5*OFFSET},
  { 0.0,  OFFSET},
  { 0.5*SQRT_3*OFFSET,  0.5*OFFSET}, { 0.5*SQRT_3*OFFSET,-0.5*OFFSET},
  { 0.0, -OFFSET}
};

/*****************************************************************************/
/* XMangekyou Structure.                                                     */
/*****************************************************************************/

XMangekyou xmangekyou;

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
