/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

#ifndef _XMANGEKYOU_XMANGEKYOU_H_INCLUDED_
#define _XMANGEKYOU_XMANGEKYOU_H_INCLUDED_

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/xpm.h>
#include <X11/Xaw/Label.h>

#include "configure.h"

/*****************************************************************************/
/* Structures for XMangekyou.                                                */
/*****************************************************************************/

typedef struct DoublePoint {
  double x;
  double y;
} DoublePoint;

typedef struct CharPoint {
  signed char x;
  signed char y;
} CharPoint;

typedef struct Line {
  DoublePoint point_1;
  DoublePoint point_2;
  GC gc;
} Line;

typedef struct Circle {
  DoublePoint center;
  int r;
  GC gc;
} Circle;

typedef struct PictureLine {
  CharPoint point_1;
  CharPoint point_2;
} PictureLine;

typedef struct PictureCircle {
  CharPoint center;
} PictureCircle;

typedef struct SixPoints {
  DoublePoint point[6];
} SixPoints;

typedef struct Picture {
  unsigned long int count;
  int lines_number;
  int circles_number;
  PictureLine * lines;
  PictureCircle * circles;
} Picture;

typedef struct Animation {
  int pictures_number;
  Picture * pictures;
} Animation;

typedef struct SourcePixmap {
  Pixmap pixmap;
  XPoint center;
  XPoint width;
  int size;
} SourcePixmap;

/*****************************************************************************/
/* Static Data.                                                              */
/*****************************************************************************/

#define COLORS_NUMBER 18
extern char * (color_name[COLORS_NUMBER]);

#define CLEAR_POINTS_NUMBER 14
extern DoublePoint clear_points[CLEAR_POINTS_NUMBER];

#define OFFSET 1.4
extern DoublePoint clear_points_offset[CLEAR_POINTS_NUMBER];

/*****************************************************************************/
/* XMangekyou Structure.                                                     */
/*****************************************************************************/

typedef struct struct_xmangekyou {
  XtAppContext app_context;
  Display * display;
  int screen;
  Colormap colormap;
  Widget toplevel, canvas;
  Window toplevel_window, root_window, canvas_window;
  Atom atom_1, atom_2;
  unsigned long int foreground_color;
  unsigned long int background_color;
  GC gc_source_clear, gc_source_hex_clear, gc_canvas_clear;
  GC gc_copy_source_canvas, gc_copy_canvas_canvas;
  int icon_width, icon_height;
  Pixmap icon_pixmap;

  int x, y, width, height, depth;
  int root_flag, quit_flag;
  int lines_number, circles_number, line_thickness, circle_size;
  int size, speed, change, wait;
  int degree;
  Line * lines;
  Circle * circles;

  SourcePixmap * source_pixmaps;
  DoublePoint clear_points_rotated[CLEAR_POINTS_NUMBER];
  DoublePoint clear_points_offset_rotated[CLEAR_POINTS_NUMBER];
  XPoint clear_points_rotated_int[CLEAR_POINTS_NUMBER];
  int copy_max, copy_end, copy_number;
  DoublePoint * copy_points;
  DoublePoint * copy_points_rotated;

  char * animation_data_filename;
  int animations_number;
  int animation_flag;
  Animation * animations;
  unsigned long int animation_picture_start_time;
  int animation_type, animation_picture;
  int animation_fix_number;
} XMangekyou;

extern XMangekyou xmangekyou;

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
