/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include "anime.h"

/*****************************************************************************/
/* Functions for Animation.                                                  */
/*****************************************************************************/

void AnimationPictureStart()
{
  if (xmangekyou.animation_flag == ON) {
    xmangekyou.animation_picture_start_time = GetTime();
    if (++(xmangekyou.animation_picture) ==
	xmangekyou.animations[xmangekyou.animation_type].pictures_number)
      xmangekyou.animation_flag = OFF;
  }
}

void SetAnimation()
{
  if (xmangekyou.animations_number > 0) {
    if (xmangekyou.animation_fix_number == NO_ANIMATION_FIX)
      xmangekyou.animation_type = rand() % xmangekyou.animations_number;
    else
      xmangekyou.animation_type = xmangekyou.animation_fix_number;
    xmangekyou.animation_flag = ON;
    xmangekyou.animation_picture = 0;
    xmangekyou.animation_picture_start_time = GetTime();
  }
}

/*****************************************************************************/
/* Free Animation's Data.                                                    */
/*****************************************************************************/

void FreeAnimationData()
{
  int i, j, k;

  if (xmangekyou.animations_number > 0) {
    for (i = 0; i < xmangekyou.animations_number; i++) {
      for (j = 0; j < xmangekyou.animations[i].pictures_number; j++) {
	free(xmangekyou.animations[i].pictures[j].lines);
	free(xmangekyou.animations[i].pictures[j].circles);
      }
      free(xmangekyou.animations[i].pictures);
    }
    free(xmangekyou.animations);
  }
}

/*****************************************************************************/
/* Dump Animation's Data.                                                    */
/*****************************************************************************/

void DumpAnimationData()
{
  int i, j, k;

  printf("animations_number = %d\n\n", xmangekyou.animations_number);
  for (i = 0; i < xmangekyou.animations_number; i++) {
    printf("animations[%d].pictures_number = %d\n\n", i,
	   xmangekyou.animations[i].pictures_number);
    for (j = 0; j < xmangekyou.animations[i].pictures_number; j++) {
      printf("animations[%d].pictures[%d].count = %ld\n", i, j,
	     xmangekyou.animations[i].pictures[j].count);
      printf("animations[%d].pictures[%d].lines_number = %d\n", i, j,
	     xmangekyou.animations[i].pictures[j].lines_number);
      printf("animations[%d].pictures[%d].circles_number = %d\n", i, j,
	     xmangekyou.animations[i].pictures[j].circles_number);
      printf("Line Data : ");
      for (k = 0; k < xmangekyou.animations[i].pictures[j].lines_number; k++)
	printf("%d %d %d %d   ",
	       (int)(xmangekyou.animations[i].pictures[j].lines[k].point_1.x),
	       (int)(xmangekyou.animations[i].pictures[j].lines[k].point_1.y),
	       (int)(xmangekyou.animations[i].pictures[j].lines[k].point_2.x),
	       (int)(xmangekyou.animations[i].pictures[j].lines[k].point_2.y));
      printf("\nCircle Data : ");
      for (k = 0; k < xmangekyou.animations[i].pictures[j].circles_number; k++)
	printf("%d %d   ",
	       (int)(xmangekyou.animations[i].pictures[j].circles[k].center.x),
	       (int)(xmangekyou.animations[i].pictures[j].circles[k].center.y)
	       );
      printf("\n\n");
    }
  }
  fflush(stdout);
}

/*****************************************************************************/
/* Make Animation's Data.                                                    */
/*****************************************************************************/

void ReadAnimationData(FILE * fp)
{
  int i, j, k;
  Picture * p;

  xmangekyou.animations_number = ReadInt(fp);
  xmangekyou.animations =
    (Animation *)malloc(sizeof(Animation) * xmangekyou.animations_number);
  for (i = 0; i < xmangekyou.animations_number; i++) {
    xmangekyou.animations[i].pictures_number = ReadInt(fp);
    xmangekyou.animations[i].pictures =
      (Picture *)malloc(sizeof(Picture) *
			xmangekyou.animations[i].pictures_number);
    for (j = 0; j < xmangekyou.animations[i].pictures_number; j++) {
      p = &(xmangekyou.animations[i].pictures[j]);
      p->count          = (unsigned long int)ReadInt(fp);
      p->lines_number   = ReadInt(fp);
      p->circles_number = ReadInt(fp);
      if (p->lines_number == 0) {
	p->lines_number = 1;
	p->lines = (PictureLine *)malloc(sizeof(PictureLine));
	p->lines[0].point_1.x = p->lines[0].point_1.y = 0.0;
	p->lines[0].point_2.x = p->lines[0].point_2.y = 0.0;
      } else {
	p->lines =
	  (PictureLine *)malloc(sizeof(PictureLine) * p->lines_number);
	for (k = 0; k < p->lines_number; k++) {
	  p->lines[k].point_1.x = ReadChar(fp);
	  p->lines[k].point_1.y = ReadChar(fp);
	  p->lines[k].point_2.x = ReadChar(fp);
	  p->lines[k].point_2.y = ReadChar(fp);
	}
      }
      if (p->circles_number == 0) {
	p->circles_number = 1;
	p->circles = (PictureCircle *)malloc(sizeof(PictureCircle));
	p->circles[0].center.x = p->circles[0].center.y = 0.0;
      } else {
	p->circles =
	  (PictureCircle *)malloc(sizeof(PictureCircle) * p->circles_number);
	for (k = 0; k < p->circles_number; k++) {
	  p->circles[k].center.x = ReadChar(fp);
	  p->circles[k].center.y = ReadChar(fp);
	}
      }
    }
  }
}

void MakeAnimationData()
{
  FILE * fp;
  char filename[512];

  strcpy(filename, XMANGEKYOU_LIB);
  strcat(filename, xmangekyou.animation_data_filename);
  if ((fp = fopen(xmangekyou.animation_data_filename, "rt")) != NULL) {
    ReadAnimationData(fp);
    fclose(fp);
  } else if ((fp = fopen(filename, "rt")) != NULL) {
    ReadAnimationData(fp);
    fclose(fp);
  } else xmangekyou.animations_number = 0;
}

/*****************************************************************************/
/* Moving Pieces in Animation.                                               */
/*****************************************************************************/

void AnimationPoint(CharPoint * p1, DoublePoint * p2)
{
  double move_r, move_speed;
  DoublePoint move;

  move.x = 0.01 * xmangekyou.size * (double)((*p1).x) - (*p2).x;
  move.y = 0.01 * xmangekyou.size * (double)((*p1).y) - (*p2).y;
  move_r = sqrt(move.x * move.x + move.y * move.y);
  if (ANIMATION_SPEED * xmangekyou.size < move_r)
    move_speed = ANIMATION_SPEED * xmangekyou.size / move_r;
  else move_speed = 1.0;
  (*p2).x += move.x * move_speed;
  (*p2).y += move.y * move_speed;
}

void AnimationLines()
{
  int i, a;
  Picture * p;

  p = &(xmangekyou.animations[xmangekyou.animation_type].pictures[xmangekyou.animation_picture]);
  for (i = 0; i < xmangekyou.lines_number; i++) {
    a = i % p->lines_number;
    AnimationPoint(&(p->lines[a].point_1),&(xmangekyou.lines[i].point_1));
    AnimationPoint(&(p->lines[a].point_2),&(xmangekyou.lines[i].point_2));
  }
}

void AnimationCircles()
{
  int i, a;
  Picture * p;

  p = &(xmangekyou.animations[xmangekyou.animation_type].pictures[xmangekyou.animation_picture]);
  for (i = 0; i < xmangekyou.circles_number; i++) {
    a = i % p->circles_number;
    AnimationPoint(&(p->circles[a].center), &(xmangekyou.circles[i].center));
  }
}

void AnimationPieces()
{
  AnimationLines();
  AnimationCircles();
}

/*****************************************************************************/
/* Check Animation.                                                          */
/*****************************************************************************/

void CheckAnimation()
{
  if (xmangekyou.animation_flag == ON) {
    if (GetTime() - xmangekyou.animation_picture_start_time >
	xmangekyou.animations[xmangekyou.animation_type].pictures[xmangekyou.animation_picture].count)
      AnimationPictureStart();
  }
  else if ((GetMinute() % 30) == 0) SetAnimation();
}

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
