/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

#ifndef _XMANGEKYOU_ANIME_H_INCLUDED_
#define _XMANGEKYOU_ANIME_H_INCLUDED_

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "configure.h"
#include "xmangekyou.h"
#include "string.h"

/*****************************************************************************/
/* Functions for Animation.                                                  */
/*****************************************************************************/

void AnimationPictureStart();
void SetAnimation();

/*****************************************************************************/
/* Free Animation's Data.                                                    */
/*****************************************************************************/

void FreeAnimationData();

/*****************************************************************************/
/* Dump Animation's Data.                                                    */
/*****************************************************************************/

void DumpAnimationData();

/*****************************************************************************/
/* Make Animation's Data.                                                    */
/*****************************************************************************/

void ReadAnimationData(FILE * fp);
void MakeAnimationData();

/*****************************************************************************/
/* Moving Pieces in Animation.                                               */
/*****************************************************************************/

void AnimationPoint(CharPoint * p1, DoublePoint * p2);
void AnimationLines();
void AnimationCircles();
void AnimationPieces();

/*****************************************************************************/
/* Check Animation.                                                          */
/*****************************************************************************/

void CheckAnimation();

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
