/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include "argument.h"

/*****************************************************************************/
/* Difinitions of Some Parameters.                                           */
/*****************************************************************************/

#define FLAG     0
#define FLAG_ON  1
#define FLAG_OFF 2
#define INTEGER  3
#define STRING   4
#define FUNCTION 5

/*****************************************************************************/
/* Static Data.                                                              */
/*****************************************************************************/

char * help_string =
"\n" VERSION "\n\n"
"XMangekyou - a kaleidoscope for X\n"
"\n"
"XMangekyou is a kaleidoscope. You can see many, many, many patterns,\n"
"but, care for yourself from 'trip' filling!\n"
"\n"
"You can use all of the standard X-Toolkit options.\n"
"(x) is default value.\n"
"-display [displayname]\n"
"                This option specifies the name of the X server to use.\n"
"-geometry [geometry]\n"
"                This option specifies the placement of the window\n"
"                on the screen.\n"
"-background [color], -bg [color]\n"
"                This option specifies the background color.\n"
"-h, -help       Output this message.\n"
"-root           Draw a mangekyou on the root window.\n"
"-noroot         Open a new window and draw a mangekyou on it. (Default)\n"
"-quit           Draw a mangekyou once and quit.\n"
"-noquit         Draw a mangekyou and repeat it. (Default)\n"
"-lines [x]      This option specifies the number of lines to draw.\n"
"                (Default value is 50)\n"
"-circles [x]    This option specifies the number of circles to draw.\n"
"                (Default value is 20)\n"
"-line-thickness [x]\n"
"                This option specifies the maximum thickness of lines.\n"
"                (Default value is 5)\n"
"-circle-size [x]\n"
"                This option specifies the maximum size of circles.\n"
"                (Default value is 10)\n"
"-size [x]       This option specifies the size of the center of\n"
"                a mangekyou. (80)\n"
"-speed [x]      This option specifies the speed of the rotation. (128)\n"
"-change [x]     This option specifies the speed of the change. (1000)\n"
"-wait [x]       This option specifies the wait. (0)\n"
"-animation-file [filename]\n"
"                This option specifies the filename for the animation.\n"
"                (animation.dat)\n"
"\n"
"Programed by Sakai Hiroaki.\n"
"E-Mail : sakai@miya.ee.kagu.sut.ac.jp\n"
"Web : http://wwwmiya.ee.kagu.sut.ac.jp/~sakai/myfreesoft.html\n"
"Thank Tanaka Makoto, Watanabe Takahiro, Umehara Taro, and Masuda Keiko\n"
"for drawing many animations.\n"
"\n"
"Copyright (c) 1998 Sakai Hiroaki.\n"
"\n"
"XMangekyou is a free software. You may copy or distribute the original\n"
"XMangekyou freely. But, you may not modify or distribute the original\n"
"XMangekyou without permission of the author.\n"
"\n"
;

/*****************************************************************************/
/* Help.                                                                     */
/*****************************************************************************/

void help()
{
  printf("%s", help_string);
  exit (0);
}

/*****************************************************************************/
/* Structure for Arguments.                                                  */
/*****************************************************************************/

struct {
  char * name;
  short int flag;
  void * value;
} arguments[] = {
  {"-h"             , FUNCTION, help},
  {"-help"          , FUNCTION, help},
  {"-root"          , FLAG_ON , &(xmangekyou.root_flag)},
  {"-noroot"        , FLAG_OFF, &(xmangekyou.root_flag)},
  {"-quit"          , FLAG_ON , &(xmangekyou.quit_flag)},
  {"-noquit"        , FLAG_OFF, &(xmangekyou.quit_flag)},
  {"-lines"         , INTEGER , &(xmangekyou.lines_number)},
  {"-circles"       , INTEGER , &(xmangekyou.circles_number)},
  {"-line-thickness", INTEGER , &(xmangekyou.line_thickness)},
  {"-circle-size"   , INTEGER , &(xmangekyou.circle_size)},
  {"-size"          , INTEGER , &(xmangekyou.size)},
  {"-speed"         , INTEGER , &(xmangekyou.speed)},
  {"-change"        , INTEGER , &(xmangekyou.change)},
  {"-wait"          , INTEGER , &(xmangekyou.wait)},
  {"-animation-fix" , INTEGER , &(xmangekyou.animation_fix_number)},
  {"-animation-file", STRING  , &(xmangekyou.animation_data_filename)},
  {NULL             , 0       , NULL}
};

/*****************************************************************************/
/* Read Command Line Parameters.                                             */
/*****************************************************************************/

void DeleteParameter(int * argc, char ** argv, int i)
{
  (*argc)--;
  for (; i < (*argc); i++)
    argv[i] = argv[i + 1];
}

int CheckParameters(int * argc, char ** argv, char * s)
{
  int i, r = OFF;

  for (i = 1; i < *argc; i++) {
    if (!strcmp(s, argv[i])) {
      DeleteParameter(argc, argv, i);
      r = ON;
    }
  }
  return (r);
}

char * GetStringFromParameters(int * argc, char ** argv, char * s)
{
  int i;
  char * p = (char *)NULL;

  for (i = 1; i < *argc; i++) {
    if (!strcmp(s, argv[i])) {
      if (i == *argc - 1) {
        DeleteParameter(argc, argv, i);
      } else {
        DeleteParameter(argc, argv, i);
        p = argv[i];
        DeleteParameter(argc, argv, i);
      }
    }
  }
  return (p);
}

void ReadParameters(int * argc, char ** argv)
{
  int i = 0;
  char * p;
  void (*funcp)();
  while (arguments[i].name != NULL) {
    if (arguments[i].flag == FUNCTION) {
      if (CheckParameters(argc, argv, arguments[i].name) == ON) {
	funcp = arguments[i].value;
	(*funcp)();
      }
    } else if (arguments[i].flag == FLAG) {
      if ((p = GetStringFromParameters(argc, argv, arguments[i].name))!=NULL) {
        if      (!strcmp(p, "off")) *((short int *)(arguments[i].value)) = OFF;
        else if (!strcmp(p, "OFF")) *((short int *)(arguments[i].value)) = OFF;
        else if (!strcmp(p, "on" )) *((short int *)(arguments[i].value)) = ON;
        else if (!strcmp(p, "ON" )) *((short int *)(arguments[i].value)) = ON;
      }
    } else if (arguments[i].flag == FLAG_ON) {
      if (CheckParameters(argc, argv, arguments[i].name) == ON)
	*((short int *)(arguments[i].value)) = ON;
    } else if (arguments[i].flag == FLAG_OFF) {
      if (CheckParameters(argc, argv, arguments[i].name) == ON)
	*((short int *)(arguments[i].value)) = OFF;
    } else if (arguments[i].flag == INTEGER) {
      if ((p = GetStringFromParameters(argc, argv, arguments[i].name)) != NULL)
        *((int *)(arguments[i].value)) = atoi(p);
    } else if (arguments[i].flag == STRING) {
      if ((p = GetStringFromParameters(argc, argv, arguments[i].name)) != NULL)
        *((char **)(arguments[i].value)) = p;
    }
    i++;        
  }
  /*
  while (*argc > 1) {
    fprintf(stderr, "ERROR : Unknown Parameter : %s\n", argv[1]);
    DeleteParameter(argc, argv, 1);
  }
  */
}

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
