/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include "cal.h"

/*****************************************************************************/
/* Functions for Calculation.                                                */
/*****************************************************************************/

void CalCosSin(int d0, DoublePoint * p)
{
  double d1;
  d1 = (M_PI / 64 / 180) * d0;
  p->x = cos(d1);
  p->y = sin(d1);
}

void CalRotate(DoublePoint p0, DoublePoint p1, DoublePoint * p)
{
  p->x = p0.x * p1.x - p0.y * p1.y;
  p->y = p0.x * p1.y + p0.y * p1.x;
}

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
