/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

#ifndef _XMANGEKYOU_CONFIGURE_H_INCLUDED_
#define _XMANGEKYOU_CONFIGURE_H_INCLUDED_

/*****************************************************************************/
/* XMangekyou's Version.                                                     */
/*****************************************************************************/

#ifndef VERSION
#define VERSION "XMangekyou-unknown-version"
#endif

/*****************************************************************************/
/* If you DEBUG XMangekyou, Define "XMANGEKYOU_DEBUG".                       */
/*****************************************************************************/

/* #define XMANGEKYOU_DEBUG */

/*****************************************************************************/
/* Definition of XMangekyou's Directry.                                      */
/*****************************************************************************/

#ifndef XMANGEKYOU_LIB
#define XMANGEKYOU_LIB "/usr/X11R6/lib/X11/XMangekyou/"
#endif

/*****************************************************************************/
/* Definitions of Parameters.                                                */
/*****************************************************************************/

#define ON  1
#define OFF 0
#define NO_ANIMATION_FIX -1
#define ANIMATION_SPEED (1.0 / 80.0)
#define DEFAULT_ANIMATION_DATA_FILENAME "animation.dat"
#define SQRT_2 1.414213562373095
#define SQRT_3 1.732050807568877
#define XMANGEKYOU_ICON icon

/*****************************************************************************/
/* Default Values.                                                           */
/*****************************************************************************/

#define DEFAULT_WIDTH  400
#define DEFAULT_HEIGHT 400
#define DEFAULT_ROOT_FLAG OFF
#define DEFAULT_QUIT_FLAG OFF
#define DEFAULT_LINES_NUMBER 50
#define DEFAULT_CIRCLES_NUMBER 20
#define DEFAULT_LINE_THICKNESS 5
#define DEFAULT_CIRCLE_SIZE 10
#define DEFAULT_SIZE 80
#define DEFAULT_SPEED 128
#define DEFAULT_CHANGE 1000
#define DEFAULT_WAIT 0

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
