/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

#ifndef _XMANGEKYOU_GRAPH_H_INCLUDED_
#define _XMANGEKYOU_GRAPH_H_INCLUDED_

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/xpm.h>
#include <X11/Xaw/Label.h>

#include "configure.h"
#include "xmangekyou.h"

/*****************************************************************************/
/* Get Color.                                                                */
/*****************************************************************************/

unsigned long int GetColor(Display * display, Colormap colormap, char * color);

/*****************************************************************************/
/* Make Pixmap from Data.                                                    */
/*****************************************************************************/

Pixmap MakePixmapFromData(Display * display, Window w, char ** string,
                          int * width, int * height);

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
