/*****************************************************************************/
/* XMangekyou - a kaleidoscope for X                                         */
/* Programed by Sakai Hiroaki.                                               */
/*                                                                           */
/* Copyright (c) 1998 Sakai Hiroaki.                                         */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* XMangekyou is a kaleidoscope. You can see many, many, many patterns,      */
/* but, care for yourself from 'trip' filling!                               */
/*                                                                           */
/* XMangekyou is a free software. You may copy or distribute the original    */
/* XMangekyou freely. But, you may not modify or distribute the original     */
/* XMangekyou without permission of the author.                              */
/*****************************************************************************/

/*****************************************************************************/
/* Include Header Files.                                                     */
/*****************************************************************************/

#include "string.h"

/*****************************************************************************/
/* Reading String.                                                           */
/*****************************************************************************/

int GetCharFromPointer(void * p, int flag)
{
  int c;
  char ** cpp;
  FILE * fp;

  if (flag == READ_FROM_FILE) {
    fp = (FILE *)p;
    c = fgetc(fp);
  } else if (flag == READ_FROM_STRING) {
    cpp = (char **)p;
    c = **cpp;
    if (c == '\0') c = EOF;
    else (*cpp)++;
  }
  return (c);
}

int CheckWord(int c, char * s)
{
  while (*s != '\0') {
    if (c == *s) return (1);
    s++;
  }
  return (0);
}

int ReadString(void * p, int type, char * string, int size,
	       char * split, char * comment, char * lineend, char * quotation)
{
  int c, i = EOF;
  c = GetCharFromPointer(p, type);
  while (CheckWord(c, split) || CheckWord(c, comment)) {
    if (CheckWord(c, split)) c = GetCharFromPointer(p, type);
    else if (CheckWord(c, comment)) {
      while ((!CheckWord(c = GetCharFromPointer(p, type), lineend)) &&
	     (c != EOF));
      c = GetCharFromPointer(p, type);
    }
  }
  if (c == EOF);
  else if (CheckWord(c, quotation)) {
    i = 0;
    while ((!CheckWord(c = GetCharFromPointer(p, type), quotation)) &&
	   (!CheckWord(c, lineend)) && (c != EOF))
      if (i < size - 1) string[i++] = (char)c;
    string[i] = '\0';
  } else {
    i = 0;
    do {
      if (i < size - 1) string[i++] = (char)c;
      c = GetCharFromPointer(p, type);
    } while ((!CheckWord(c, split)) && (!CheckWord(c, comment)) &&
	     (!CheckWord(c, lineend)) && (!CheckWord(c, quotation)) &&
	     (c != EOF));
    string[i] = '\0';
  }
  if (CheckWord(c, comment))
    while ((!CheckWord(c = GetCharFromPointer(p, type), lineend)) &&
	   (c != EOF));
  return (i);
}

int ReadInt(FILE * fp)
{
  char string[128];
  ReadString(fp, READ_FROM_FILE, string, 128,
	     " ,:;\t\n", "#%$!", "\n", "'\"");
  return (atoi(string));
}

signed char ReadChar(FILE * fp)
{
  char string[128];
  ReadString(fp, READ_FROM_FILE, string, 128,
	     " ,:;\t\n", "#%$!", "\n", "'\"");
  return ((signed char)atoi(string));
}

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
