/*
 Copyright (C) 2000-2004

 Code contributed by Greg Collecutt, Joseph Hope and Paul Cochrane

 This file is part of xmds.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmdsglobals.cc,v 1.13 2004/07/13 05:29:38 paultcochrane Exp $
*/

/*! @file xmdsglobals.cc
  @brief Globals element parsing classes and methods

  More detailed explanation...
*/

#include<xmlbasics.h>
#include<dom3.h>
#include<xmdsutils.h>
#include<xmdsclasses.h>

// ******************************************************************************
// ******************************************************************************
//                              xmdsGlobals public
// ******************************************************************************
// ******************************************************************************

extern bool debugFlag;

long nxmdsGlobals=0;   //!< Number of xmds global objects

// ******************************************************************************
xmdsGlobals::xmdsGlobals(
			 const xmdsSimulation *const yourSimulation,
			 const bool& yourVerboseMode) :
  xmdsElement(yourSimulation,yourVerboseMode) {
  if(debugFlag) {
    nxmdsGlobals++;
    printf("xmdsGlobals::xmdsGlobals\n");
    printf("nxmdsGlobals=%li\n",nxmdsGlobals);
  }
};

// ******************************************************************************
xmdsGlobals::~xmdsGlobals() {
  if(debugFlag) {
    nxmdsGlobals--;
    printf("xmdsGlobals::~xmdsGlobals\n");
    printf("nxmdsGlobals=%li\n",nxmdsGlobals);
  }
};

// ******************************************************************************
void xmdsGlobals::processElement(
				 const Element *const yourElement) {
  if(debugFlag) {
    printf("xmdsGlobals::processXMLElement\n");
  }

  if(verbose()) {
    printf("Processing constants element ...\n");
  }
  myGlobalsCode = *yourElement->textContent(0);

  if(verbose()) {
    if(myGlobalsCode.isAllWhiteSpace()) {
      printf("No globals found\n");
    }
    else {
      printf("Globals code loaded\n");
    }
  }

};

// ******************************************************************************
// ******************************************************************************
//                              xmdsGlobals private
// ******************************************************************************
// ******************************************************************************

// ******************************************************************************
void xmdsGlobals::writeGlobals(
			       FILE *const outfile) const {
  if(debugFlag) {
    printf("xmdsGlobals::writeGlobals\n");
  }

  if (simulation()->argStruct()->nameList.size() != 0) {
    fprintf(outfile,"\n// *********** Command line argument global variables *********\n");
    list<string>::const_iterator inameList = simulation()->argStruct()->nameList.begin();
    list<string>::const_iterator itypeList = simulation()->argStruct()->typeList.begin();
    list<string>::const_iterator idefaultValueList = simulation()->argStruct()->defaultValueList.begin();
    for (long unsigned int i=0; i<simulation()->argStruct()->nameList.size(); i++) {
      fprintf(outfile,"%s %s = %s;\n",itypeList->c_str(),inameList->c_str(),idefaultValueList->c_str());
      itypeList++;
      inameList++;
      idefaultValueList++;
    }

    fprintf(outfile,"// **********************************************\n");
    fprintf(outfile,"\n");
  }

  fprintf(outfile,"\n// ********** Code from globals element *********\n");
  fprintf(outfile,"%s\n",myGlobalsCode.c_str());
  fprintf(outfile,"// **********************************************\n");
  fprintf(outfile,"\n");

};
