/*
 Copyright (C) 2000-2004

 Code contributed by Greg Collecutt, Joseph Hope and Paul Cochrane

 This file is part of xmds.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmdsutils.h,v 1.14 2004/07/13 06:16:49 paultcochrane Exp $
*/

/*! @file xmdsutils.h
  @brief Header for various xmds utility classes
*/


#ifndef LIST
#include<list>
#define LIST
#endif

// ******************************************************************************
// ******************************************************************************
//                              xmdsException
// ******************************************************************************
// ******************************************************************************

//! xmdsException class
class xmdsException {

public :

  //! Constructor of xmdsException object
  xmdsException();

  //! Constructor of xmdsException object
  xmdsException(
      		const char *const yourErrorMessage);

  //! Constructor of xmdsException object
  xmdsException(
      		const Node *const yourNode,
      		const char *const yourErrorMessage);
    
  //! Gets xmds error
  const char* getError();

private :

  char                  s[2048];        //!< Character array to hold a temporary string, probably some version of the error text
  const Node *const	myNode;         //!< The current node
  const char *const	myErrorMessage; //!< The error message to print
};

// ******************************************************************************
// ******************************************************************************
//                              domain
// ******************************************************************************
// ******************************************************************************

//! Structure defining the beginning and the end of an xmds simulation (I think)
struct domainStruct {

  double begin;  //!< Beginning of domain
  double end;    //!< End of domain
};

// ******************************************************************************
// ******************************************************************************
//                              xmdsUtility
// ******************************************************************************
// ******************************************************************************

//! xmdsUtility class
class xmdsUtility {

public :

  //! Constructor of xmdsUtility object
  xmdsUtility();

  //! Destructor
  virtual ~xmdsUtility();

  //! Processes the element yourElement
  virtual void processElement(
			      const Element *const yourElement) = 0;

  enum {
    REQD = 1,
    NOT_REQD = 0,
    DEEP = 1,
    NOT_DEEP = 0
  };

protected :

  //! Returns the error message
  char* errorMessage() const;

  //! Gets the assignment strings
  void getAssignmentStrings(
			    const Element *const inElement,
			    const XMLString& ofName,
			    const bool& required,
			    const unsigned long& n2get,
			    list<XMLString>&  outList);

  //! Gets the assignment booleans
  void getAssignmentBools(
			  const Element *const inElement,
			  const XMLString& ofName,
			  const bool& required,
			  const unsigned long& n2get,
			  list<bool>&  outList);

  //! Gets the assignment unsigned longs
  void getAssignmentULongs(
			   const Element *const inElement,
			   const XMLString& ofName,
			   const bool& required,
			   const unsigned long& n2get,
			   list<unsigned long>&  outList);

  //! Gets the assignment doubles
  void getAssignmentDoubles(
			    const Element *const inElement,
			    const XMLString& ofName,
			    const bool& required,
			    const unsigned long& n2get,
			    list<double>&  outList);

  //! Gets the assignment domains
  void getAssignmentDomains(
			    const Element *const inElement,
			    const XMLString& ofName,
			    const bool& required,
			    const unsigned long& n2get,
			    list<domainStruct>&  outList);

  //! Gets the attribute strings
  void getAttributeStrings(
			   const Element *const inElement,
			   const XMLString& ofElementName,
			   const XMLString& ofAttrName,
			   const bool& required,
			   XMLString& outString);

  //! Gets the attribute booleans
  void getAttributeBools(
			 const Element *const inElement,
			 const XMLString& ofElementName,
			 const XMLString& ofAttrName,
			 const bool& required,
			 bool& outBool);
  
  //! Converts a space list to unsigned long
  unsigned long spaceList2ULong(
				const list<bool>& spaceList) const;

private :

  mutable char myErrorMessage[2048]; //!< Error message string

  //! Parse an XML string inString at node inNode generating the output XML string list outXMLStringList
  void parseXMLString(
		      const Node *const inNode,
		      const XMLString *const inString,
		      list<XMLString>& outXMLStringList);
};

