/*
 Copyright (C) 2000-2004

 Code contributed by Greg Collecutt, Joseph Hope and Paul Cochrane

 This file is part of xmds.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmdsarg.cc,v 1.10 2004/07/13 05:29:38 paultcochrane Exp $
*/

/*! @file xmdsarg.cc
  @brief Command line argument parsing classes and methods

  More detailed explanation...
*/

#include<xmlbasics.h>
#include<dom3.h>
#include<xmdsutils.h>
#include<xmdsclasses.h>

// ******************************************************************************
// ******************************************************************************
//                              xmdsArg public
// ******************************************************************************
// ******************************************************************************

extern bool debugFlag;

long nxmdsArgs=0;  //!< Number of xmds argument objects

// ******************************************************************************
xmdsArg::xmdsArg(
		       const xmdsArgv *const yourArgv) :
  myArgv(yourArgv) {
  if(debugFlag) {
    nxmdsArgs++;
    printf("xmdsArg::xmdsArg\n");
    printf("nxmdsArgs=%li\n",nxmdsArgs);
  }
};

// ******************************************************************************
xmdsArg::~xmdsArg() {
  if(debugFlag) {
    nxmdsArgs--;
    printf("xmdsArg::~xmdsArg\n");
    printf("nxmdsArgs=%li\n",nxmdsArgs);
  }
};

// ******************************************************************************
const XMLString* xmdsArg::name() const {
  if(debugFlag) {
    printf("xmdsArg::name\n");
  }

  return &myName;
};

// ******************************************************************************
void xmdsArg::setName(
		      const XMLString& yourName) {
  if(debugFlag) {
    printf("xmdsArg::setName\n");
  }

  myName = yourName;
};

// ******************************************************************************
// ******************************************************************************
//                              xmdsArg protected
// ******************************************************************************
// ******************************************************************************

// ******************************************************************************
const xmdsArgv* xmdsArg::argv() const {
  if(debugFlag) {
    printf("xmdsArg::argv\n");
  }

  return myArgv;
};

