/******************************************************************************
Copyright (c) 1994, 1997 by Jin Yu.
All rights reserved.

The software provided hereunder is on an "AS IS" basis. Permission to
use, copy, modify, and distribute this software and its documentation
for any non-commercial purpose, without fee, and without written
agreement is hereby granted, provided that the above copyright notice
appears in all copies of this software.
******************************************************************************/

#include "xminehunter.h"
#include <X11/xpm.h>


#include "bitmaps/bomb"
#include "bitmaps/openbomb"
#include "bitmaps/empty"
#include "bitmaps/near1"
#include "bitmaps/near2"
#include "bitmaps/near3"
#include "bitmaps/near4"
#include "bitmaps/near5"
#include "bitmaps/near6"
#include "bitmaps/near7"
#include "bitmaps/near8"
#include "bitmaps/flag"
#include "bitmaps/wrongflag"
#include "bitmaps/question"
#include "bitmaps/cover"

#include "bitmaps/normal.xpm"
#include "bitmaps/smile.xpm"
#include "bitmaps/cry.xpm"


void mine_hunter_T::create_pixmaps(void)
{
  Arg args[2];
  XColor color;
  unsigned long fgpix, bgpix;
  Pixmap shapemask_pmap;

  Display* dpy = XtDisplay(gui_part->MainShellW);
  int scr = DefaultScreen(dpy);
  Window root_win = DefaultRootWindow(dpy);
  Colormap default_cmap = DefaultColormap(dpy, scr);

  if ( XpmCreatePixmapFromData(dpy, root_win,
			       normal_xpm, &gui_part->normal_pmap,
			       &shapemask_pmap, NULL) != XpmSuccess )
    gui_part->normal_pmap = XtUnspecifiedPixmap;

  if ( XpmCreatePixmapFromData(dpy, root_win,
			       smile_xpm, &gui_part->smile_pmap,
			       &shapemask_pmap, NULL) != XpmSuccess )
    gui_part->smile_pmap = XtUnspecifiedPixmap;

  if ( XpmCreatePixmapFromData(dpy, root_win,
			       cry_xpm, &gui_part->cry_pmap,
			       &shapemask_pmap, NULL) != XpmSuccess )
    gui_part->cry_pmap = XtUnspecifiedPixmap;


  gui_part->bomb_bmap = XCreatePixmapFromBitmapData(
	dpy,
	DefaultRootWindow(dpy),
	bomb_bits, bomb_width, bomb_height,
	BlackPixel(dpy, scr),
	WhitePixel(dpy, scr),
	DefaultDepth(dpy, scr));

  gui_part->openbomb_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        openbomb_bits, openbomb_width, openbomb_height,
        BlackPixel(dpy, scr),
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  gui_part->empty_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        empty_bits, empty_width, empty_height,
        BlackPixel(dpy, scr),
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  if ( XParseColor(dpy, default_cmap, "red", &color) == 0 ||
       XAllocColor(dpy, default_cmap, &color) == 0)
    fgpix = BlackPixel(dpy, scr);
  else
    fgpix = color.pixel;

  gui_part->near1_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        near1_bits, near1_width, near1_height,
        fgpix,
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  if ( XParseColor(dpy, default_cmap, "green3", &color) == 0 ||
       XAllocColor(dpy, default_cmap, &color) == 0)
    fgpix = BlackPixel(dpy, scr);
  else
    fgpix = color.pixel;

  gui_part->near2_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        near2_bits, near2_width, near2_height,
        fgpix,
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  if ( XParseColor(dpy, default_cmap, "blue", &color) == 0 ||
       XAllocColor(dpy, default_cmap, &color) == 0)
    fgpix = BlackPixel(dpy, scr);
  else
    fgpix = color.pixel;

  gui_part->near3_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        near3_bits, near3_width, near3_height,
        fgpix,
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  if ( XParseColor(dpy, default_cmap, "purple", &color) == 0 ||
       XAllocColor(dpy, default_cmap, &color) == 0)
    fgpix = BlackPixel(dpy, scr);
  else
    fgpix = color.pixel;

  gui_part->near4_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        near4_bits, near4_width, near4_height,
        fgpix,
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  if ( XParseColor(dpy, default_cmap, "brown", &color) == 0 ||
       XAllocColor(dpy, default_cmap, &color) == 0)
    fgpix = BlackPixel(dpy, scr);
  else
    fgpix = color.pixel;

  gui_part->near5_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        near5_bits, near5_width, near5_height,
        fgpix,
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  if ( XParseColor(dpy, default_cmap, "magenta", &color) == 0 ||
       XAllocColor(dpy, default_cmap, &color) == 0)
    fgpix = BlackPixel(dpy, scr);
  else
    fgpix = color.pixel;

  gui_part->near6_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        near6_bits, near6_width, near6_height,
        fgpix,
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  if ( XParseColor(dpy, default_cmap, "cyan", &color) == 0 ||
       XAllocColor(dpy, default_cmap, &color) == 0)
    fgpix = BlackPixel(dpy, scr);
  else
    fgpix = color.pixel;

  gui_part->near7_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        near7_bits, near7_width, near7_height,
        fgpix,
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  if ( XParseColor(dpy, default_cmap, "yellow", &color) == 0 ||
       XAllocColor(dpy, default_cmap, &color) == 0)
    fgpix = BlackPixel(dpy, scr);
  else
    fgpix = color.pixel;

  gui_part->near8_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        near8_bits, near8_width, near8_height,
        fgpix,
        WhitePixel(dpy, scr),
        DefaultDepth(dpy, scr));

  XtSetArg(args[0], XmNforeground, &fgpix);
  XtSetArg(args[1], XmNbackground, &bgpix);
  XtGetValues(gui_part->MainWinW, args, 2);

  gui_part->flag_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        flag_bits, flag_width, flag_height,
        fgpix,
        bgpix,
        DefaultDepth(dpy, scr));

  gui_part->wrongflag_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        wrongflag_bits, wrongflag_width, wrongflag_height,
        fgpix,
        bgpix,
        DefaultDepth(dpy, scr));

  gui_part->question_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        question_bits, question_width, question_height,
        fgpix,
        bgpix,
        DefaultDepth(dpy, scr));

  gui_part->cover_bmap = XCreatePixmapFromBitmapData(
        dpy,
        DefaultRootWindow(dpy),
        cover_bits, cover_width, cover_height,
        fgpix,
        bgpix,
        DefaultDepth(dpy, scr));

}
