#include <glib.h>

#include "ahx/ahx.h"
extern "C" int usleep(int);

class AHXSimpleOut : public AHXOutput {
public:
    int StartBackgroundPlay() {return 0;}
    int StopBackgroundPlay() {return 0;}
    int Play(AHXPlayer* Player) {
	this->Player = Player;
	while (1) {
	    MixBuffer();
	    usleep(5000);
	}
    }
    int CopyBuffer(void* lpBuffer, int* lpValid) {return 0;}
    int Pause() {return 0;}
    int Resume() {return 0;}
    int Stop() {return 0;}
    int SetVolume(int Volume) {return 0;}
    int Init(int Frequency = 44100, int Bits = 16, int Frames = 2, int NrBlocks = 16, float Boost = 1.f, int Hz = 50) {
	if(!AHXOutput::Init(Frequency, Bits, Frames, Boost, Hz))
	    return 0;
	else
	    return 1;
    }
};

int main (int argc, char **argv)
{
    AHXPlayer MyPlayer;
    AHXSimpleOut MyOutput;

    if (argc < 2)
    {
	g_print("Usage: testahx <file>\n");
	return 0;
    }

    MyPlayer.Init();
    MyPlayer.LoadSong(argv[1]);
    MyPlayer.InitSubsong(0);

    MyOutput.Init();
    MyOutput.Play(&MyPlayer);
}
