#include <xmms_ahx.h>
#include <logo_ahx.xpm>

void ip_about(void);

static gchar *credits_txt =
	" xmms plugin by David Le Corfec\n"
" dlecorfec@users.sourceforge.net\n"
" See http://xmms-ahx.sourceforge.net/\n"
"\n"
" AHX informations follow ...\n"
"\n"
"* Copyright\n"
" WinAHX and the AHX Replayer, although copyrighted\n"
" by Abyss, are Freeware! You may spread them as you\n"
" like - as long as you don't charge any money for it!\n"
"\n"
" AHX = Abyss' Highest eXperience\n"
"\n"
"* Code\n"
" Bartman\n"
"		\n"
"* Quality Assurance\n"
" Pink\n"
"		\n"
"* Original Amiga Code\n"
" Dexter\n"
"		\n"
"* Original Concept\n"
" Pink\n"
"		\n"
"* Beta testing\n"
" Pink, Grace, Poet\n"
"		\n"
"	\n"	
"* Features\n"
" > 100% accurate playback of all AHX 1.x/2.x tunes\n"
" > quality approved by Pink && Dexter, the AHX creators\n"
" > 100% C++ code, thus easily portable\n"
" > very low CPU usage (<4% on P200)\n"
" > Player available for use in own productions\n"
" > Small && intuitive user interface\n"
" > Coded by Bartman/Abyss\n"
" > It's free! It's small!\n"
"		\n"
"	\n"	
"contact me for anything EXCEPT support for the sources: barto@gmx.net\n"
"\n"
"Bartman/Abyss\n"
"19/09/2000\n"
"new Abyss homepage: www.abyss-online.de";


class AHXAboutWin
{
public:
    // create/destroy dialog window.
    AHXAboutWin(AHXAboutWin **ptr);
    ~AHXAboutWin();

    void Show (void);

protected:
    static void Close(GtkWidget *widget, gpointer data);
    static void Destroy (GtkWidget *widget, GdkEvent *ev, gpointer data);

private:
    GtkWidget *_dialog;       // the dialog widget
};

AHXAboutWin::AHXAboutWin(AHXAboutWin **ptr)
{
    GtkWidget *vbox;
    GtkWidget *scrolled_win, *credits, *about_logo, *ok;
    GdkPixmap *logo_pmap = NULL;
    GdkBitmap *logo_mask = NULL;
    
    _dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(_dialog), "About AHX plugin");
//      gtk_window_set_position(GTK_WINDOW(_dialog), GTK_WIN_POS_MOUSE);
    gtk_signal_connect(GTK_OBJECT(_dialog), "delete_event",
		       GTK_SIGNAL_FUNC(Destroy), ptr);
    gtk_container_set_border_width(GTK_CONTAINER(_dialog), 10);
    gtk_widget_show(_dialog);

    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_add(GTK_CONTAINER(_dialog), vbox);

    logo_pmap = gdk_pixmap_create_from_xpm_d(_dialog->window, &logo_mask,
					     NULL, logo_xpm);
    about_logo = gtk_pixmap_new(logo_pmap, logo_mask);
    gtk_box_pack_start(GTK_BOX(vbox),
		       about_logo,
		       FALSE, FALSE, 0);

    gtk_box_pack_start(GTK_BOX(vbox),
		       gtk_label_new("AHX plugin for xmms, based on WinAHX 1.0\n"
				     "WinAHX 1.0 is copyright  1998 Abyss"),
		       FALSE, FALSE, 0);

    scrolled_win = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(vbox), scrolled_win, TRUE, TRUE, 0);

    credits = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(credits), FALSE);

    gtk_text_insert(GTK_TEXT(credits), NULL, NULL, NULL, credits_txt, -1);

//      gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrolled_win),
//  					   credits);
    gtk_container_add(GTK_CONTAINER(scrolled_win), credits);
    gtk_widget_set_usize(credits, 300, 100);

    ok = gtk_button_new_with_label("Ok");
    gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(Close), ptr);
    GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(vbox), ok, FALSE, FALSE, 0);    
    gtk_widget_grab_default(ok);

    gtk_widget_show_all(vbox);
}

AHXAboutWin::~AHXAboutWin()
{
    gtk_widget_destroy(_dialog);
    _dialog = NULL;
}

static int idle_destroy (gpointer data)
{
    AHXAboutWin **ptr = static_cast<AHXAboutWin **>(data);
//    AHXAboutWin **ptr = (AHXAboutWin **)data;
    delete *ptr;
    *ptr = 0;    
    return FALSE;
}


void 
AHXAboutWin::Destroy(GtkWidget *widget, GdkEvent *ev, gpointer data)
{
    AHXAboutWin **ptr = static_cast<AHXAboutWin **>(data);
//    AHXAboutWin **ptr = (AHXAboutWin **)data;
    delete *ptr;
    *ptr = 0;    
}

void 
AHXAboutWin::Close(GtkWidget *widget, gpointer data)
{
    AHXAboutWin **ptr = static_cast<AHXAboutWin **>(data);

//    AHXAboutWin **ptr = (AHXAboutWin **)data;
    gtk_widget_hide((*ptr)->_dialog);
    gtk_idle_add(idle_destroy, data);
}

void
AHXAboutWin::Show (void)
{
    if (! GTK_WIDGET_VISIBLE (_dialog))
	gtk_widget_show_all(_dialog);
    else
	gdk_window_raise(_dialog->window);
    gtk_widget_queue_draw(_dialog);    
}

void ip_about(void)
{
    static AHXAboutWin *AboutWin = 0;

    if (!AboutWin)
	AboutWin = new AHXAboutWin(&AboutWin);
    AboutWin->Show();    
}

