/* Glue between xmms and the AHX core
 */

#include <xmms_ahx.h>
#include <cstring>

AHXXmmsPlayer MyPlayer;
AHXXmmsOut MyOutput;
MyAHXConfig player_cfg;

static int CurrentPos;
static int CurrentSubsong;

AHXWaves *
plugin_get_waves()
{
    static AHXWaves Waves;

    return &Waves;
}

static void ip_init(void)
{
//      g_print("ip_init\n");
    player_cfg.load();
}

static int ip_is_our_file(char *filename)
{
    char *ext;
    char *base;

    g_return_val_if_fail(filename != NULL, FALSE);
//      g_print("ip_is_our_file\n");

    base = g_basename(filename);
    if (!base)
      return FALSE;

    if (!strncasecmp(base, "ahx.", 4) ||
	!strncasecmp(base, "thx.", 4))
      return TRUE;

    ext = strrchr(filename, '.');

    if (ext)
    {
	if (!strncasecmp(ext, ".thx", 4) ||
	    !strncasecmp(ext, ".ahx", 4))
	  {
	    return TRUE;
	  }
    }

    return FALSE;
}

static void ip_get_song_info(char *filename, char **title_real, int *len_real)
{
//      g_print("ip_get_song_info\n");

    // without the 2 following lines, v0.5 crashed !!!
    *len_real = -1;
    *title_real = NULL;
}

static void ip_play_file(char *filename)
{
    CurrentPos = 0;
    CurrentSubsong = 0;

    MyPlayer.Init(plugin_get_waves());
    int loaded = MyPlayer.LoadSong(filename);
    MyPlayer.InitSubsong(0);

    iplugin.set_info(MyPlayer.Song.Name,
		     0, 125000,
		     player_cfg.freq, 1);

    MyOutput.SetChans(player_cfg.chans);
    MyOutput.Init(player_cfg.freq, player_cfg.bits, 2, 16, player_cfg.boost, player_cfg.hz);
    MyOutput.SetOption(AHXOI_OVERSAMPLING, player_cfg.oversampling);
    MyOutput.StartBackgroundPlay();

    if (loaded)
	MyOutput.Play(&MyPlayer);
}

static void ip_stop(void)
{
//      g_print("ip_stop\n");
    MyOutput.Stop();
    MyOutput.StopBackgroundPlay();
    MyOutput.Free();
}

static void ip_seek(int time)
{
//      g_print("ip_seek\n");
}

static void ip_do_pause(short p)
{
//      g_print("ip_do_pause\n");
    iplugin.output->pause(p);
}

// get called even when xmms is paused (does it make sense ?)
static int ip_get_time(void)
{
//      g_print("ip_get_time\n");
//      if (audio_error)
//  	return -2;
//      if ( !iplugin.output || !iplugin.output->buffer_playing())
//  	return -1;
//      return iplugin.output->output_time();
    if (MyPlayer.GetCurrentPos() != CurrentPos)
    {
//  	g_print("pos: %d\n", MyPlayer.GetCurrentPos());
    }

    if (MyPlayer.GetCurrentPos() < CurrentPos)
    {
	CurrentPos = MyPlayer.GetCurrentPos();
	if (!player_cfg.loop_subsong)
	{
	    CurrentSubsong++;
	    if (CurrentSubsong > MyPlayer.Song.SubsongNr)
		return -1;
	    MyOutput.Stop();
	    MyPlayer.InitSubsong(CurrentSubsong);
	    MyOutput.Play(&MyPlayer);
	}
    }
    CurrentPos = MyPlayer.GetCurrentPos();
    if (iplugin.output)
	return iplugin.output->output_time();
    else
	return 0;
}

extern void ip_file_info_box(char *filename);
extern void ip_configure(void);
extern void ip_about(void);

InputPlugin iplugin =
{
	NULL,
	NULL,
	"AHX Player " VERSION,
	ip_init,
	ip_about,
	ip_configure,
	ip_is_our_file,
	NULL,
	ip_play_file,
	ip_stop,
	ip_do_pause,
	ip_seek,
	NULL,
	ip_get_time,
	NULL, NULL,
	NULL, NULL, NULL, NULL, NULL,
	ip_get_song_info,
	ip_file_info_box,	/* file_info_box */
	NULL
};

InputPlugin *get_iplugin_info(void)
{
	return &iplugin;
}

int
MyAHXConfig::load()
{
	ConfigFile *cfg;
	gchar *filename;

	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	if ((cfg = xmms_cfg_open_file(filename)))
	{
		xmms_cfg_read_int(cfg, "AHX", "mixing_freq", &freq);
		xmms_cfg_read_int(cfg, "AHX", "bits", &bits);
		xmms_cfg_read_int(cfg, "AHX", "channels", &chans);
		xmms_cfg_read_float(cfg, "AHX", "boost", &boost);
		xmms_cfg_read_int(cfg, "AHX", "hz", &hz);
		xmms_cfg_read_int(cfg, "AHX", "oversampling", &oversampling);
		xmms_cfg_read_int(cfg, "AHX", "loop_subsong", &loop_subsong);
	}
	g_free(filename);
	return TRUE;
}

int
MyAHXConfig::save()
{
	ConfigFile *cfg;
	gchar *filename;

	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	cfg = xmms_cfg_open_file(filename);
	if (!cfg)
		cfg = xmms_cfg_new();

	xmms_cfg_write_int(cfg, "AHX", "mixing_freq", freq);
	xmms_cfg_write_int(cfg, "AHX", "bits", bits);
	xmms_cfg_write_int(cfg, "AHX", "channels", chans);
	xmms_cfg_write_float(cfg, "AHX", "boost", boost);
	xmms_cfg_write_int(cfg, "AHX", "hz", hz);
	xmms_cfg_write_int(cfg, "AHX", "oversampling", oversampling);
	xmms_cfg_write_int(cfg, "AHX", "loop_subsong", loop_subsong);

	xmms_cfg_write_file(cfg, filename);
	xmms_cfg_free(cfg);
	g_free(filename);
	return TRUE;
}


