#ifndef __XMMS_AHX_H__
#define __XMMS_AHX_H__

// protect xmms header files
extern "C" {
#include <xmms/plugin.h>
#include <xmms/configfile.h>
#include <xmms/util.h>
}

#include <glib.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <ahx/ahx.h>

// xmms input plugin entry point
extern "C" InputPlugin *get_iplugin_info(void);

// global variables
extern InputPlugin iplugin;

struct MyAHXConfig {
    int freq;
    int bits;
    int chans;
    float boost;
    int hz;
    int oversampling;
    int loop_subsong;

    MyAHXConfig() {
	freq = 44100;
	bits = 16;
	chans = 1;
	boost = 1.f;
	hz = 50;
	oversampling = 0;
	loop_subsong = 0;
    }

    int load();
    int save();
};

extern MyAHXConfig player_cfg;

class AHXWaves;

AHXWaves *plugin_get_waves();
GtkWidget *ahx_info_tree_create(AHXPlayer *player);

class  AHXXmmsPlayer : public AHXPlayer {
  public:
    int GetCurrentPos() const { return PosNr; }
};

class AHXXmmsOut : public AHXOutput {
public:
	 AHXXmmsOut();
	~AHXXmmsOut();

	int Init(int Frequency = 44100, int Bits = 16, int Frames = 2, int NrBlocks = 16, float Boost = 1.f, int Hz = 50);
	int Free();
	int StartBackgroundPlay();
	int StopBackgroundPlay();
	int Play(AHXPlayer* Player);
	int Pause();
	int Resume();
	int Stop();
	int SetVolume(int Volume);
	int CopyBuffer(void* lpBuffer, int* lpValid);

	void SetChans(int nchans) { Chans = nchans; }

protected:
	void MixChunkStereo(int NrSamples, int** mb);
	void MixBuffer();
	void PlayIt();
	void OutputBuffer(int num);
	void EventLoop();

	void *MixedBlock;
	bool AudioOpen;
	int Chans;

	int NrBlocks, Frames, BlockLen;
	volatile int StopPlaying;

	int Oversample;

	pthread_t decode_thread;

	static void *ThreadEntry(void* pArg);

	friend class AHXDisplay;
};

#endif /* __XMMS_AHX_H__ */
