#include <xmms_ahx.h>

class AHXConfigWin
{
public:
    // create/destroy dialog window.
    AHXConfigWin(AHXConfigWin **ptr, MyAHXConfig *cfg);
    ~AHXConfigWin();

protected:
    void GadgetsToConfig (void);

    static void Destroy (GtkWidget *widget, GdkEvent *ev, gpointer data);
    static void Ok (GtkWidget *widget, gpointer data);
    static void Apply (GtkWidget *widget, gpointer data);
    static void Cancel (GtkWidget *widget, gpointer data);

private:
    MyAHXConfig *cfg;
    GtkWidget *_dialog;       // the dialog widget
    GtkWidget *Res_16, *Res_8;
    GtkWidget *Chan_ST, *Chan_MO;
    GtkWidget *Sample_44, *Sample_22, *Sample_11;
    GtkWidget *Oversampling_Check;
    GtkWidget *LoopSubsong_Check;
    GtkObject *Boost_Adj;
};

AHXConfigWin::AHXConfigWin(AHXConfigWin **ptr, MyAHXConfig *cfg)
{
    GSList *sample_group = NULL, *resolution_group = NULL, *vbox5_group = NULL;
    
    this->cfg = cfg;
    _dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(_dialog), "AHX Configuration");
    gtk_window_set_position(GTK_WINDOW(_dialog), GTK_WIN_POS_MOUSE);
    gtk_signal_connect(GTK_OBJECT(_dialog), "delete_event",
		       GTK_SIGNAL_FUNC(Destroy), ptr);
    gtk_container_set_border_width(GTK_CONTAINER(_dialog), 10);

    GtkWidget *vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_add(GTK_CONTAINER(_dialog), vbox);

    GtkWidget *notebook1 = gtk_notebook_new();
    gtk_box_pack_start(GTK_BOX(vbox), notebook1, TRUE, TRUE, 0);
    gtk_container_border_width(GTK_CONTAINER(notebook1), 3);

    /** quality page **/
    GtkWidget *quality_page = gtk_vbox_new(FALSE, 0);

    GtkWidget *hbox1 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(quality_page), hbox1, TRUE, TRUE, 0);

    /* resolution */
    GtkWidget *Resolution_Frame = gtk_frame_new("Resolution:");
    gtk_box_pack_start(GTK_BOX(hbox1), Resolution_Frame, TRUE, TRUE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(Resolution_Frame), 5);

    GtkWidget *vbox4 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(Resolution_Frame), vbox4);

    Res_16 = gtk_radio_button_new_with_label(resolution_group, "16 bit");
    resolution_group = gtk_radio_button_group(GTK_RADIO_BUTTON(Res_16));
    gtk_box_pack_start(GTK_BOX(vbox4), Res_16, TRUE, TRUE, 0);
    if (cfg->bits == 16)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Res_16), TRUE);

    Res_8 = gtk_radio_button_new_with_label(resolution_group, "8 bit");
    resolution_group = gtk_radio_button_group(GTK_RADIO_BUTTON(Res_8));
    gtk_box_pack_start(GTK_BOX(vbox4), Res_8, TRUE, TRUE, 0);
    if (cfg->bits == 8)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Res_8), TRUE);

    /* channels */
    GtkWidget *Channels_Frame = gtk_frame_new("Channels:");
    gtk_box_pack_start(GTK_BOX(hbox1), Channels_Frame, TRUE, TRUE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(Channels_Frame), 5);

    GtkWidget *vbox5 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(Channels_Frame), vbox5);

    Chan_ST = gtk_radio_button_new_with_label(vbox5_group, "Stereo");
    vbox5_group = gtk_radio_button_group(GTK_RADIO_BUTTON(Chan_ST));
    gtk_box_pack_start(GTK_BOX(vbox5), Chan_ST, TRUE, TRUE, 0);
    if (cfg->chans == 2)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Chan_ST), TRUE);

    Chan_MO = gtk_radio_button_new_with_label(vbox5_group, "Mono");
    vbox5_group = gtk_radio_button_group(GTK_RADIO_BUTTON(Chan_MO));
    gtk_box_pack_start(GTK_BOX(vbox5), Chan_MO, TRUE, TRUE, 0);
    if (cfg->chans == 1)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Chan_MO), TRUE);

    /* freq */
    GtkWidget *Downsample_Frame = gtk_frame_new("Down sample:");
    gtk_box_pack_start(GTK_BOX(quality_page), Downsample_Frame, TRUE, TRUE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(Downsample_Frame), 5);

    GtkWidget *vbox3 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(Downsample_Frame), vbox3);

    Sample_44 = gtk_radio_button_new_with_label(sample_group, "1:1 (44 kHz)");
    sample_group = gtk_radio_button_group(GTK_RADIO_BUTTON(Sample_44));
    gtk_box_pack_start(GTK_BOX(vbox3), Sample_44, TRUE, TRUE, 0);

    if (cfg->freq == 44100)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Sample_44), TRUE);

    Sample_22 = gtk_radio_button_new_with_label(sample_group, "1:2 (22 kHz)");
    sample_group = gtk_radio_button_group(GTK_RADIO_BUTTON(Sample_22));
    gtk_box_pack_start(GTK_BOX(vbox3), Sample_22, TRUE, TRUE, 0);
    if (cfg->freq == 22050)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Sample_22), TRUE);

    Sample_11 = gtk_radio_button_new_with_label(sample_group, "1:4 (11 kHz)");
    sample_group = gtk_radio_button_group(GTK_RADIO_BUTTON(Sample_11));
    gtk_box_pack_start(GTK_BOX(vbox3), Sample_11, TRUE, TRUE, 0);
    if (cfg->freq == 11025)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Sample_11), TRUE);

    GtkWidget *Quality_Label = gtk_label_new("Quality");
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook1), quality_page, Quality_Label);

    /** options page **/
    GtkWidget *options_page = gtk_vbox_new(FALSE, 0);
    
    /* oversampling */
    Oversampling_Check = gtk_check_button_new_with_label("Oversampling");
    gtk_box_pack_start(GTK_BOX(options_page), Oversampling_Check, TRUE, TRUE, 0);
    if (cfg->oversampling)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Oversampling_Check), TRUE);

    /* loop subsong */
    LoopSubsong_Check = gtk_check_button_new_with_label("Loop on current subsong");
    gtk_box_pack_start(GTK_BOX(options_page), LoopSubsong_Check, TRUE, TRUE, 0);
    if (cfg->loop_subsong)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(LoopSubsong_Check), TRUE);

    /* boost */
    GtkWidget *boost_hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(options_page), boost_hbox, TRUE, TRUE, 0);

    gtk_box_pack_start(GTK_BOX(boost_hbox),
		       gtk_label_new("Boost"), FALSE, FALSE, 5);

    Boost_Adj = gtk_adjustment_new(cfg->boost, 0.1, 5, 0.1, 1, 0);

    GtkWidget *Boost_Slider = gtk_hscale_new(GTK_ADJUSTMENT (Boost_Adj));
    gtk_box_pack_start(GTK_BOX(boost_hbox), Boost_Slider, TRUE, TRUE, 0);

    GtkWidget *Options_Label = gtk_label_new("Options");
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook1), options_page, Options_Label);

    /** button box **/
    GtkWidget *bbox = gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
    gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

    GtkWidget *ok = gtk_button_new_with_label("Ok");
    gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(Ok), ptr);
    GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);

    GtkWidget *cancel = gtk_button_new_with_label("Cancel");
    gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
		       GTK_SIGNAL_FUNC(Cancel), ptr);
    GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
    
    GtkWidget *apply = gtk_button_new_with_label("Apply");
    gtk_signal_connect(GTK_OBJECT(apply), "clicked",
		       GTK_SIGNAL_FUNC(Apply), ptr);
    GTK_WIDGET_SET_FLAGS(apply, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(bbox), apply, TRUE, TRUE, 0);

    gtk_widget_show_all(_dialog);
    gtk_widget_grab_default(ok);
}


AHXConfigWin::~AHXConfigWin()
{
    if (_dialog)
	gtk_widget_destroy(_dialog);
    _dialog = NULL;
}

// called from buttons
static int idle_destroy (gpointer data)
{
    AHXConfigWin **ptr = static_cast<AHXConfigWin **>(data);
    delete *ptr;
    *ptr = 0;    
    return FALSE;
}


void 
AHXConfigWin::Destroy(GtkWidget *widget, GdkEvent *ev, gpointer data)
{
    AHXConfigWin **ptr = static_cast<AHXConfigWin **>(data);
//    AHXConfigWin **ptr = (AHXConfigWin **)data;
    delete *ptr;
    *ptr = 0;    
}

void 
AHXConfigWin::Cancel(GtkWidget *widget, gpointer data)
{
    AHXConfigWin **ptr = static_cast<AHXConfigWin **>(data);
//    AHXConfigWin **ptr = (AHXConfigWin **)data;
    gtk_widget_hide((*ptr)->_dialog);
    gtk_idle_add(idle_destroy, data);
}

void 
AHXConfigWin::GadgetsToConfig()
{
    if (GTK_TOGGLE_BUTTON(Res_16)->active)
	cfg->bits = 16;
    if (GTK_TOGGLE_BUTTON(Res_8)->active)
	cfg->bits = 8;

    if (GTK_TOGGLE_BUTTON(Chan_ST)->active)
	cfg->chans = 2;
    if (GTK_TOGGLE_BUTTON(Chan_MO)->active)
	cfg->chans = 1;

    if (GTK_TOGGLE_BUTTON(Sample_44)->active)
	cfg->freq = 44100;
    if (GTK_TOGGLE_BUTTON(Sample_22)->active)
	cfg->freq = 22050;
    if (GTK_TOGGLE_BUTTON(Sample_11)->active)
	cfg->freq = 11025;

    if (GTK_TOGGLE_BUTTON(Oversampling_Check)->active)
	cfg->oversampling = 1;
    else
	cfg->oversampling = 0;

    if (GTK_TOGGLE_BUTTON(LoopSubsong_Check)->active)
	cfg->loop_subsong = 1;
    else
	cfg->loop_subsong = 0;

    cfg->boost = GTK_ADJUSTMENT (Boost_Adj)->value;

}

void 
AHXConfigWin::Ok(GtkWidget *widget, gpointer data)
{
    AHXConfigWin *win = *static_cast<AHXConfigWin **>(data);
//    AHXConfigWin **ptr = (AHXConfigWin **)data;

    win->GadgetsToConfig();
    win->cfg->save();

    gtk_widget_hide(win->_dialog);
    gtk_idle_add(idle_destroy, data);
}

void 
AHXConfigWin::Apply(GtkWidget *widget, gpointer data)
{
    AHXConfigWin *win = *static_cast<AHXConfigWin **>(data);
//    AHXConfigWin **ptr = (AHXConfigWin **)data;

    win->GadgetsToConfig();
}


void ip_configure(void)
{
    static AHXConfigWin *ConfigWin = 0;

    if (!ConfigWin)
	ConfigWin = new AHXConfigWin(&ConfigWin, &player_cfg);
}

