#include <xmms_ahx.h>
#include <cstring>

// defined in this file
void ip_file_info_box(char *filename);
GtkWidget *ahx_info_tree_create(AHXPlayer *player);


class AHXInfoWin
{
public:
    // create/destroy dialog window.
    AHXInfoWin(AHXInfoWin **ptr);
    ~AHXInfoWin();

    // Refresh window with this file's infos.
    void Load(char *filename);

protected:
    // Destroy dialog content before creating new content
    void Clear ();
    static void Close(GtkWidget *widget, gpointer data);
    static void Destroy (GtkWidget *widget, GdkEvent *ev, gpointer data);

private:
    GtkWidget *_dialog;       // the dialog widget
    GtkWidget *_scrolled_win; // tree container
    GtkWidget *_tree;
};

AHXInfoWin::AHXInfoWin(AHXInfoWin **ptr)
{
    GtkWidget *vbox, *ok;
    
    _dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_signal_connect(GTK_OBJECT(_dialog), "delete_event",
		       GTK_SIGNAL_FUNC(Destroy), ptr);
    gtk_container_set_border_width(GTK_CONTAINER(_dialog), 10);
    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_add(GTK_CONTAINER(_dialog), vbox);

    _scrolled_win = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (_scrolled_win),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(vbox), _scrolled_win, TRUE, TRUE, 0);
    gtk_widget_set_usize(_scrolled_win, 200, 200);

    ok = gtk_button_new_with_label("Ok");
    gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(Close), ptr);
    GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(vbox), ok, FALSE, FALSE, 0);    
    gtk_widget_grab_default(ok);

    _tree = NULL;
}

AHXInfoWin::~AHXInfoWin()
{
    gtk_widget_destroy(_dialog);
    _tree = _dialog = NULL;
}

static int idle_destroy (gpointer data)
{
    AHXInfoWin **ptr = static_cast<AHXInfoWin **>(data);
//    AHXInfoWin **ptr = (AHXInfoWin **)data;
    delete *ptr;
    *ptr = 0;    
    return FALSE;
}


void 
AHXInfoWin::Destroy(GtkWidget *widget, GdkEvent *ev, gpointer data)
{
    AHXInfoWin **ptr = static_cast<AHXInfoWin **>(data);
//    AHXInfoWin **ptr = (AHXInfoWin **)data;
    delete *ptr;
    *ptr = 0;    
}

void 
AHXInfoWin::Close(GtkWidget *widget, gpointer data)
{
    AHXInfoWin **ptr = static_cast<AHXInfoWin **>(data);

//    AHXInfoWin **ptr = (AHXInfoWin **)data;
    gtk_widget_hide((*ptr)->_dialog);
    gtk_idle_add(idle_destroy, data);
}

void
AHXInfoWin::Clear()
{
    if (_tree)
    {
	gtk_widget_destroy(_tree);
	_tree = NULL;
    }
}

void
AHXInfoWin::Load(char *filename)
{
    AHXPlayer player;
    char *title;
    char *name;

    Clear();

  /* Add it to the scrolled window */

    player.Init(plugin_get_waves());
    player.LoadSong(filename);

    name = strrchr(filename, '/');
    if (name)
	name++;
    else
	name = filename;

    title = g_strdup_printf("File Info - %s", name);
    gtk_window_set_title(GTK_WINDOW(_dialog), title);
    g_free(title);

    _tree = ahx_info_tree_create(&player);
  /* Add it to the scrolled window */
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(_scrolled_win),
					   _tree);

    gtk_widget_show_all(_dialog);    
    gtk_widget_queue_draw(_dialog);
}


void ip_file_info_box(char *filename)
{
    static AHXInfoWin *InfoWin = 0;

    if (!InfoWin)
	InfoWin = new AHXInfoWin(&InfoWin);

    InfoWin->Load(filename);
}

GtkWidget *
ahx_info_tree_create(AHXPlayer *player)
{
    GtkWidget *tree;
    char temp[256];
    GtkWidget *inst_subtree, *inst_item, *item;

    tree = gtk_tree_new();

    g_snprintf(temp, 256, "%s (AHX%d)", player->Song.Name, player->Song.Revision);
    gtk_tree_append(GTK_TREE(tree), gtk_tree_item_new_with_label(temp));

    g_snprintf(temp, 256, "%dx-Speed, %d Subsong%s",
	       player->Song.SpeedMultiplier, player->Song.SubsongNr,
	       player->Song.SubsongNr!=1?"s":"");
    gtk_tree_append(GTK_TREE(tree), gtk_tree_item_new_with_label(temp));

    g_snprintf(temp, 256, "%d Position%s, %d Track%s",
	       player->Song.PositionNr, player->Song.PositionNr!=1?"s":"",
	       player->Song.TrackNr, player->Song.TrackNr!=1?"s":"");
    gtk_tree_append(GTK_TREE(tree), gtk_tree_item_new_with_label(temp));

    g_snprintf(temp, 256, "%d Instrument%s",
	       player->Song.InstrumentNr, player->Song.InstrumentNr!=1?"s":"");

    inst_item = gtk_tree_item_new_with_label(temp);
    gtk_tree_append(GTK_TREE(tree), inst_item);

    inst_subtree = gtk_tree_new();

    gtk_tree_item_set_subtree(GTK_TREE_ITEM(inst_item), inst_subtree);
    gtk_tree_item_expand(GTK_TREE_ITEM(inst_item));

    for(int i = 1; i < player->Song.InstrumentNr+1; i++) {
	g_snprintf(temp, 256, "%02d: %s", i, player->Song.Instruments[i].Name);
	item = gtk_tree_item_new_with_label(temp);
	gtk_tree_append(GTK_TREE(inst_subtree), item);
	gtk_widget_show(item);
    }    
    return tree;
}



