/* xmms output for AHX core
 * adapted for xmms 0.9.5, Nov 23, 1999.
 */

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <xmms_ahx.h>

AHXXmmsOut::AHXXmmsOut()
{
    Chans = 2;
    NrBlocks = BlockLen = Frames = 0;
    AudioOpen = false;
    StopPlaying = 1;
}

AHXXmmsOut::~AHXXmmsOut()
{
    Free();
}

int AHXXmmsOut::Init(int Frequency, int Bits, int Frames, int NrBlocks, float Boost, int Hz)
{
    if(NrBlocks < 1 || NrBlocks > 32 || Frames < 1) return 0;

    Oversample = Playing = 0;
    this->Frames = Frames;
    this->NrBlocks = NrBlocks;

    if(!AHXOutput::Init(Frequency, Bits, Frames, Boost, Hz)) return 0;
    delete MixingBuffer;
    MixingBuffer = new int [Chans*MixLen*Frequency/Hz];

    BlockLen = Chans * Frequency * Bits / 8 * Frames /Hz;

    if (AudioOpen)
	iplugin.output->close_audio();

    // Open the playback device
    if (iplugin.output->open_audio((Bits == 16) ? FMT_S16_LE : FMT_S8,
				  Frequency,
				  Chans) == 0)
    {
//  	audio_error = TRUE;
	return 0;
    }
    AudioOpen = true;

    MixedBlock = g_malloc(BlockLen);

    return 1;
}

int AHXXmmsOut::Free()
{
    if (iplugin.output && AudioOpen)
    {
	iplugin.output->close_audio();
	AudioOpen = FALSE;
    }
    if (MixedBlock)
    {
	g_free(MixedBlock);
	MixedBlock = NULL;
    }
    return 1;
}

int AHXXmmsOut::StartBackgroundPlay()
{
    StopPlaying = 0;
    pthread_create(&decode_thread, NULL, ThreadEntry, this);
    return true;
}

int AHXXmmsOut::StopBackgroundPlay()
{
    if (!StopPlaying)
    {
	StopPlaying = 1;
	while(StopPlaying)
	    xmms_usleep(1000 * Frames*(1000/Hz)/2);
	pthread_join(decode_thread, NULL);
	return 1;
    }
    return 0;
}

// thread is already started
int AHXXmmsOut::Play(AHXPlayer* Player)
{
	if(!Stop() || !Player) return 0;
	this->Player = Player;
	Playing = 1;
	return 1;
}

int AHXXmmsOut::Pause()
{
	Paused = 1;
	return 1;
}

int AHXXmmsOut::Resume()
{
	Paused = 0;
	return 1;
}

int AHXXmmsOut::Stop()
{
	Playing = 0;
	return 1;
}

int AHXXmmsOut::SetVolume(int Volume)
{
	Volume = Volume * 63 / 64;
	return 1;
}

void *AHXXmmsOut::ThreadEntry(void* pArg)
{
	AHXXmmsOut* This = (AHXXmmsOut*)pArg;

	This->EventLoop();
	return NULL;
}

void AHXXmmsOut::EventLoop()
{
	// Main message loop
	while(StopPlaying == 0) {
		if (Playing)
		    PlayIt();
		xmms_usleep(1000);
	}
	StopPlaying = 0;
}

void AHXXmmsOut::PlayIt()
{
    for(int i = 0; i < NrBlocks; i++)
    {
	if (StopPlaying == 0)
	{
	// mix a new block (size: Frames frames = BlockLen)
	    MixBuffer();

	// prepare it for XmmsOut
	    OutputBuffer(i);
	}
	else
	    break;
    }
}

void AHXXmmsOut::OutputBuffer(int num)
{
#define LOW_CLIP16     -0x8000
#define HI_CLIP16       0x7FFF
#define LOW_CLIP8      -0x80
#define HI_CLIP8        0x7F

    void* lpChunkData = MixedBlock;
    int thissample;

    if(Bits == 16)
    {
	for(int s = 0; s < BlockLen/(Bits/8); s++)
	{
	    thissample = MixingBuffer[s] << 6; // 16 bit
	    ((short*)lpChunkData)[s] = CLAMP(thissample, LOW_CLIP16, HI_CLIP16);
	}
    }
    else if(Bits == 8)
    {
	for(int s = 0; s < BlockLen/(Bits/8); s++)
	{
	    thissample = MixingBuffer[s] >> 2; // 8 bit
	    ((char*)lpChunkData)[s] = CLAMP(thissample, LOW_CLIP8, HI_CLIP8) + 128;
	}
    }

    iplugin.add_vis_pcm(iplugin.output->written_time(),
			player_cfg.bits == 8 ? FMT_U8 : FMT_S16_NE,
			player_cfg.chans, BlockLen, lpChunkData);

//      if (effects_enabled())
//      {
//  	get_current_effect_plugin()->mod_samples(
//  	    &lpChunkData, BlockLen,
//  	    player_cfg.bits,
//  	    player_cfg.freq,
//  	    player_cfg.chans);
//      }

    while(iplugin.output->buffer_free() < BlockLen
	  && !StopPlaying)
	xmms_usleep(10000);
    iplugin.output->write_audio(lpChunkData, BlockLen);
}

int AHXXmmsOut::CopyBuffer(void* lpBuffer, int* lpValid)
{
	return 0;
}

void AHXXmmsOut::MixChunkStereo(int NrSamples, int** mb)
{
    static int pos[4] = { 0, 0, 0, 0 };

    for(int v = 0; v < 4; v++)
    {
	if(Player->Voices[v].VoiceVolume == 0) continue;

	float freq = Period2Freq(Player->Voices[v].VoicePeriod);
	int delta = (int)(freq * (1 << 16) / Frequency);
	int samples_to_mix = NrSamples;
	int mixpos = (v == 0 || v == 3) ? 0 : 1;

	while(samples_to_mix)
	{
	    if (pos[v] > (0x280 << 16))
		pos[v] -= 0x280 << 16;

	    int thiscount = MIN(samples_to_mix, ((0x280 << 16)-pos[v]-1) / delta + 1);
	    samples_to_mix -= thiscount;
	    int* VolTab = &VolumeTable[Player->Voices[v].VoiceVolume][128];

	    //INNER LOOP
	    if(Oversampling) {
		for(int i = 0; i < thiscount; i++)
		{
		    int offset = pos[v] >> 16;
		    int sample1 = VolTab[Player->Voices[v].VoiceBuffer[offset]];
		    int sample2 = VolTab[Player->Voices[v].VoiceBuffer[offset+1]];
		    int frac1 = pos[v] & ((1 << 16) - 1);
		    int frac2 = (1 << 16) - frac1;
		    (*mb)[mixpos] += ((sample1 * frac2) + (sample2 * frac1)) >> 16;
		    mixpos += 2;
		    pos[v] += delta;
		}
	    } else {
		for(int i = 0; i < thiscount; i++)
		{
		    (*mb)[mixpos] += VolTab[Player->Voices[v].VoiceBuffer[pos[v] >> 16]];
		    mixpos += 2;
		    pos[v] += delta;
		}
	    }
	} // while
    } // v = 0-3
    *mb += NrSamples * Chans;
}

void AHXXmmsOut::MixBuffer()
{
    if (!Hz || !Player->Song.SpeedMultiplier)
	return;

    int NrSamples = Frequency / Hz / Player->Song.SpeedMultiplier;
    int* mb = MixingBuffer;
	
    memset(MixingBuffer, 0, Chans*MixLen*Frequency/Hz*sizeof(int));
    for(int f = 0; f < MixLen*Player->Song.SpeedMultiplier /* MixLen = # frames */; f++) {
	Player->PlayIRQ();
	if (Chans == 1)
	    AHXOutput::MixChunk(NrSamples, &mb);
	else
	    MixChunkStereo(NrSamples, &mb);
    } // frames
}
