#ifndef _bitstream_decode_h_
#define _bitstream_decode_h_

#include "resort.h"

#define MEMSIZE   8192			// Anzahl an gepufferten 32bit-Worten (muss 2er-Potenz sein)
#define MEMSIZE2 (MEMSIZE/2)
#define MEMMASK  (MEMSIZE-1)

/* V A R I A B L E N */
extern unsigned int Speicher[MEMSIZE];	// enthaelt den Lese-Puffer
extern unsigned int dword;				// 32Bit-Wort fuer Bitstrom-I/O
extern unsigned int pos;				// Position im aktuell decodierten 32Bit-Wort
extern unsigned int Zaehler;			// aktuelle Position im Lese-Puffer

/* P R O Z E D U R E N */
void Reset_BitstreamDecode(void);
unsigned int BitsRead(void);
unsigned int Bitstream_read(const unsigned int);
int Huffman_Decode       (const HuffmanTyp*);	// works with maximum lengths up to 14
int Huffman_Decode_fast  (const HuffmanTyp*);	// works with maximum lengths up to 10
int Huffman_Decode_faster(const HuffmanTyp*);	// works with maximum lengths up to  5
void SCFI_Bundle_read(const HuffmanTyp*, int*, int*);

#endif
