#include "resort.h"

// sort huffman-tables by codeword
// offset resulting value
void Resort_HuffTables(const unsigned int elements, HuffmanTyp *Table, const int offset)
{
	unsigned int c[LARGEST_TABLE];
	unsigned int v[LARGEST_TABLE];
	unsigned int l[LARGEST_TABLE];
	unsigned int i;
	int sorted=0;

	for (i=0; i<elements; ++i)
	{
		Table[i].Value = i;
		c[i] = Table[i].Code<<(32-Table[i].Length);
		v[i] = Table[i].Value;
		l[i] = Table[i].Length;
	}
	
	//bubble sort
	while (!sorted)
	{
		sorted = 1;
		for (i=1; i<elements; ++i)
		{
			if (c[i]>c[i-1])
			{
				unsigned int tmp;
				tmp = v[i]; v[i] = v[i-1]; v[i-1] = tmp;
				tmp = c[i]; c[i] = c[i-1]; c[i-1] = tmp;
				tmp = l[i];	l[i] = l[i-1]; l[i-1] = tmp;
				sorted = 0;
			}
		}
	}
	for (i=0; i<elements; ++i)
	{
		Table[i].Code =   c[i];
		Table[i].Length = l[i];
		Table[i].Value =  v[i] - offset;
	}
}
