#include <string.h>
#include "synth_filter.h"

/* K O N S T A N T E N */
const float Di_opt[512] = 
{0.0000000000f, -0.0004425050f,  0.0032501221f, -0.0070037842f,
 0.0310821533f, -0.0786285400f,  0.1003112793f, -0.5720367432f,
 1.1449890137f,  0.5720367432f,  0.1003112793f,  0.0786285400f,
 0.0310821533f,  0.0070037842f,  0.0032501221f,  0.0004425050f,
-0.0000152590f, -0.0004730220f,  0.0033264160f, -0.0079193125f,
 0.0305175781f, -0.0841827393f,  0.0909271240f, -0.6002197266f,
 1.1442871094f,  0.5438232422f,  0.1088562012f,  0.0730590820f,
 0.0314788818f,  0.0061187739f,  0.0031738279f,  0.0003967290f,
-0.0000152590f, -0.0005340580f,  0.0033874509f, -0.0088653564f,
 0.0297851563f, -0.0897064209f,  0.0806884766f, -0.6282958984f,
 1.1422119141f,  0.5156097412f,  0.1165771484f,  0.0675201416f,
 0.0317382813f,  0.0052947998f,  0.0030822749f,  0.0003662110f,
-0.0000152590f, -0.0005798340f,  0.0034332280f, -0.0098419189f,
 0.0288848877f, -0.0951690674f,  0.0695953369f, -0.6562194824f,
 1.1387634277f,  0.4874725342f,  0.1234741211f,  0.0619964600f,
 0.0318450928f,  0.0044860840f,  0.0029907229f,  0.0003204350f,
-0.0000152590f, -0.0006256100f,  0.0034637449f, -0.0108489990f,
 0.0278015137f, -0.1005401611f,  0.0576171875f, -0.6839141846f,
 1.1339263916f,  0.4594726563f,  0.1295776367f,  0.0565338135f,
 0.0318145752f,  0.0037231450f,  0.0028991699f,  0.0002899170f,
-0.0000152590f, -0.0006866460f,  0.0034790039f, -0.0118865967f,
 0.0265350342f, -0.1058197021f,  0.0447845459f, -0.7113189697f,
 1.1277465820f,  0.4316558838f,  0.1348876953f,  0.0511322021f,
 0.0316619873f,  0.0030059810f,  0.0027923579f,  0.0002593990f,
-0.0000152590f, -0.0007476810f,  0.0034790039f, -0.0129394531f,
 0.0250854492f, -0.1109466553f,  0.0310821533f, -0.7383728027f,
 1.1202239990f,  0.4040832520f,  0.1394500732f,  0.0458374023f,
 0.0313873291f,  0.0023345950f,  0.0026855471f,  0.0002441410f,
-0.0000305180f, -0.0008087160f,  0.0034637449f, -0.0140228271f,
 0.0234222412f, -0.1159210205f,  0.0165100098f, -0.7650299072f,
 1.1113739014f,  0.3768005371f,  0.1432647705f,  0.0406341553f,
 0.0310058594f,  0.0016937261f,  0.0025787349f,  0.0002136230f,
-0.0000305180f, -0.0008850100f,  0.0034179690f, -0.0151214600f,
 0.0215759277f, -0.1206970215f,  0.0010681150f, -0.7912139893f,
 1.1012115479f,  0.3498687744f,  0.1463623047f,  0.0355529785f,
 0.0305328369f,  0.0010986330f,  0.0024566650f,  0.0001983640f,
-0.0000305180f, -0.0009613040f,  0.0033721919f, -0.0162353516f,
 0.0195312500f, -0.1252593994f, -0.0152282706f, -0.8168640137f,
 1.0897827148f,  0.3233184814f,  0.1487731934f,  0.0306091309f,
 0.0299377441f,  0.0005493160f,  0.0023498540f,  0.0001678470f,
-0.0000305180f, -0.0010375980f,  0.0032806401f, -0.0173492432f,
 0.0172576904f, -0.1295623779f, -0.0323791504f, -0.8419494629f,
 1.0771179199f,  0.2972106934f,  0.1504974365f,  0.0258178711f,
 0.0292816162f,  0.0000305180f,  0.0022430420f,  0.0001525880f,
-0.0000457760f, -0.0011138920f,  0.0031738279f, -0.0184631348f,
 0.0148010254f, -0.1335906982f, -0.0503540039f, -0.8663635254f,
 1.0632171631f,  0.2715911865f,  0.1515960693f,  0.0211791992f,
 0.0285339355f, -0.0004425050f,  0.0021209719f,  0.0001373290f,
-0.0000457760f, -0.0012054440f,  0.0030517580f, -0.0195770264f,
 0.0121154794f, -0.1372985840f, -0.0691680908f, -0.8900909424f,
 1.0481567383f,  0.2465057373f,  0.1520690918f,  0.0167083740f,
 0.0277252197f, -0.0008697510f,  0.0020141599f,  0.0001220700f,
-0.0000610350f, -0.0012969970f,  0.0028839109f, -0.0206909180f,
 0.0092315674f, -0.1406707764f, -0.0887756348f, -0.9130554199f,
 1.0319366455f,  0.2219848633f,  0.1519622803f,  0.0124206543f,
 0.0268402100f, -0.0012664790f,  0.0019073490f,  0.0001068120f,
-0.0000610350f, -0.0013885500f,  0.0027008059f, -0.0217895508f,
 0.0061340332f, -0.1436767578f, -0.1091613770f, -0.9351959229f,
 1.0146179199f,  0.1980590820f,  0.1513061523f,  0.0083160400f,
 0.0259094238f, -0.0016174320f,  0.0017852780f,  0.0001068120f,
-0.0000762940f, -0.0014801030f,  0.0024871831f, -0.0228576660f,
 0.0028228760f, -0.1462554932f, -0.1303100586f, -0.9564819336f,
 0.9962463379f,  0.1747894287f,  0.1501159668f,  0.0043945308f,
 0.0249328613f, -0.0019378660f,  0.0016937261f,  0.0000915530f,
-0.0000762940f, -0.0015869139f,  0.0022277830f, -0.0239105225f,
-0.0006866460f, -0.1484222412f, -0.1522064209f, -0.9768524170f,
 0.9768524170f,  0.1522064209f,  0.1484222412f,  0.0006866460f,
 0.0239105225f, -0.0022277830f,  0.0015869139f,  0.0000762940f,
-0.0000915530f, -0.0016937261f,  0.0019378660f, -0.0249328613f,
-0.0043945308f, -0.1501159668f, -0.1747894287f, -0.9962463379f,
 0.9564819336f,  0.1303100586f,  0.1462554932f, -0.0028228760f,
 0.0228576660f, -0.0024871831f,  0.0014801030f,  0.0000762940f,
-0.0001068120f, -0.0017852780f,  0.0016174320f, -0.0259094238f,
-0.0083160400f, -0.1513061523f, -0.1980590820f, -1.0146179199f,
 0.9351959229f,  0.1091613770f,  0.1436767578f, -0.0061340332f,
 0.0217895508f, -0.0027008059f,  0.0013885500f,  0.0000610350f,
-0.0001068120f, -0.0019073490f,  0.0012664790f, -0.0268402100f,
-0.0124206543f, -0.1519622803f, -0.2219848633f, -1.0319366455f,
 0.9130554199f,  0.0887756348f,  0.1406707764f, -0.0092315674f,
 0.0206909180f, -0.0028839109f,  0.0012969970f,  0.0000610350f,
-0.0001220700f, -0.0020141599f,  0.0008697510f, -0.0277252197f,
-0.0167083740f, -0.1520690918f, -0.2465057373f, -1.0481567383f,
 0.8900909424f,  0.0691680908f,  0.1372985840f, -0.0121154794f,
 0.0195770264f, -0.0030517580f,  0.0012054440f,  0.0000457760f,
-0.0001373290f, -0.0021209719f,  0.0004425050f, -0.0285339355f,
-0.0211791992f, -0.1515960693f, -0.2715911865f, -1.0632171631f,
 0.8663635254f,  0.0503540039f,  0.1335906982f, -0.0148010254f,
 0.0184631348f, -0.0031738279f,  0.0011138920f,  0.0000457760f,
-0.0001525880f, -0.0022430420f, -0.0000305180f, -0.0292816162f,
-0.0258178711f, -0.1504974365f, -0.2972106934f, -1.0771179199f,
 0.8419494629f,  0.0323791504f,  0.1295623779f, -0.0172576904f,
 0.0173492432f, -0.0032806401f,  0.0010375980f,  0.0000305180f,
-0.0001678470f, -0.0023498540f, -0.0005493160f, -0.0299377441f,
-0.0306091309f, -0.1487731934f, -0.3233184814f, -1.0897827148f,
 0.8168640137f,  0.0152282706f,  0.1252593994f, -0.0195312500f,
 0.0162353516f, -0.0033721919f,  0.0009613040f,  0.0000305180f,
-0.0001983640f, -0.0024566650f, -0.0010986330f, -0.0305328369f,
-0.0355529785f, -0.1463623047f, -0.3498687744f, -1.1012115479f,
 0.7912139893f, -0.0010681150f,  0.1206970215f, -0.0215759277f,
 0.0151214600f, -0.0034179690f,  0.0008850100f,  0.0000305180f,
-0.0002136230f, -0.0025787349f, -0.0016937261f, -0.0310058594f,
-0.0406341553f, -0.1432647705f, -0.3768005371f, -1.1113739014f,
 0.7650299072f, -0.0165100098f,  0.1159210205f, -0.0234222412f,
 0.0140228271f, -0.0034637449f,  0.0008087160f,  0.0000305180f,
-0.0002441410f, -0.0026855471f, -0.0023345950f, -0.0313873291f,
-0.0458374023f, -0.1394500732f, -0.4040832520f, -1.1202239990f,
 0.7383728027f, -0.0310821533f,  0.1109466553f, -0.0250854492f,
 0.0129394531f, -0.0034790039f,  0.0007476810f,  0.0000152590f,
-0.0002593990f, -0.0027923579f, -0.0030059810f, -0.0316619873f,
-0.0511322021f, -0.1348876953f, -0.4316558838f, -1.1277465820f,
 0.7113189697f, -0.0447845459f,  0.1058197021f, -0.0265350342f,
 0.0118865967f, -0.0034790039f,  0.0006866460f,  0.0000152590f,
-0.0002899170f, -0.0028991699f, -0.0037231450f, -0.0318145752f,
-0.0565338135f, -0.1295776367f, -0.4594726563f, -1.1339263916f,
 0.6839141846f, -0.0576171875f,  0.1005401611f, -0.0278015137f,
 0.0108489990f, -0.0034637449f,  0.0006256100f,  0.0000152590f,
-0.0003204350f, -0.0029907229f, -0.0044860840f, -0.0318450928f,
-0.0619964600f, -0.1234741211f, -0.4874725342f, -1.1387634277f,
 0.6562194824f, -0.0695953369f,  0.0951690674f, -0.0288848877f,
 0.0098419189f, -0.0034332280f,  0.0005798340f,  0.0000152590f,
-0.0003662110f, -0.0030822749f, -0.0052947998f, -0.0317382813f,
-0.0675201416f, -0.1165771484f, -0.5156097412f, -1.1422119141f,
 0.6282958984f, -0.0806884766f,  0.0897064209f, -0.0297851563f,
 0.0088653564f, -0.0033874509f,  0.0005340580f,  0.0000152590f,
-0.0003967290f, -0.0031738279f, -0.0061187739f, -0.0314788818f,
-0.0730590820f, -0.1088562012f, -0.5438232422f, -1.1442871094f,
 0.6002197266f, -0.0909271240f,  0.0841827393f, -0.0305175781f,
 0.0079193125f, -0.0033264160f,  0.0004730220f,  0.0000152590f};

/* D E F I N E S */
#define   V_MEM 2304

/* V A R I A B L E N */
float V_L[V_MEM+960];
float V_R[V_MEM+960];

float Y_L[36][32];
float Y_R[36][32];

/* F U N K T I O N E N */
void Reset_V(void)
{
	memset(V_L, 0, sizeof(V_L));
	memset(V_R, 0, sizeof(V_R));
}

void Calculate_New_V(const float *Sample, float *V)
{
    // Calculating new V-buffer values for left channel
    // Berechnen neuer V-Werte (s. ISO-11172-3, S. 39)
    // basierend auf dem Algorithmus von Byeong Gi Lee

	static float A00, A01, A02, A03, A04, A05, A06, A07, A08, A09, A10, A11, A12, A13, A14, A15;
    static float B00, B01, B02, B03, B04, B05, B06, B07, B08, B09, B10, B11, B12, B13, B14, B15;
    float        tmp;

    A00 = Sample[ 0] + Sample[31];
    A01 = Sample[ 1] + Sample[30];
    A02 = Sample[ 2] + Sample[29];
    A03 = Sample[ 3] + Sample[28];
    A04 = Sample[ 4] + Sample[27];
    A05 = Sample[ 5] + Sample[26];
    A06 = Sample[ 6] + Sample[25];
    A07 = Sample[ 7] + Sample[24];
    A08 = Sample[ 8] + Sample[23];
    A09 = Sample[ 9] + Sample[22];
    A10 = Sample[10] + Sample[21];
    A11 = Sample[11] + Sample[20];
    A12 = Sample[12] + Sample[19];
    A13 = Sample[13] + Sample[18];
    A14 = Sample[14] + Sample[17];
    A15 = Sample[15] + Sample[16];

    B00 =  A00 + A15;
    B01 =  A01 + A14;
    B02 =  A02 + A13;
    B03 =  A03 + A12;
    B04 =  A04 + A11;
    B05 =  A05 + A10;
    B06 =  A06 + A09;
    B07 =  A07 + A08;
    B08 = (A00 - A15) * 0.5024192929f;
    B09 = (A01 - A14) * 0.5224986076f;
    B10 = (A02 - A13) * 0.5669440627f;
    B11 = (A03 - A12) * 0.6468217969f;
    B12 = (A04 - A11) * 0.7881546021f;
    B13 = (A05 - A10) * 1.0606776476f;
    B14 = (A06 - A09) * 1.7224471569f;
    B15 = (A07 - A08) * 5.1011486053f;
   
    A00 =  B00 + B07;
    A01 =  B01 + B06;
    A02 =  B02 + B05;
    A03 =  B03 + B04;
    A04 = (B00 - B07) * 0.5097956061f;
    A05 = (B01 - B06) * 0.6013448834f;
    A06 = (B02 - B05) * 0.8999761939f;
    A07 = (B03 - B04) * 2.5629155636f;
    A08 =  B08 + B15;
    A09 =  B09 + B14;
    A10 =  B10 + B13;
    A11 =  B11 + B12;
    A12 = (B08 - B15) * 0.5097956061f;
    A13 = (B09 - B14) * 0.6013448834f;
    A14 = (B10 - B13) * 0.8999761939f;
    A15 = (B11 - B12) * 2.5629155636f;

    B00 =  A00 + A03;
    B01 =  A01 + A02;
    B02 = (A00 - A03) * 0.5411961079f;
    B03 = (A01 - A02) * 1.3065630198f;
    B04 =  A04 + A07;
    B05 =  A05 + A06;
    B06 = (A04 - A07) * 0.5411961079f;
    B07 = (A05 - A06) * 1.3065630198f;
    B08 =  A08 + A11;
    B09 =  A09 + A10;
    B10 = (A08 - A11) * 0.5411961079f;
    B11 = (A09 - A10) * 1.3065630198f;
    B12 =  A12 + A15;
    B13 =  A13 + A14;
    B14 = (A12 - A15) * 0.5411961079f;
    B15 = (A13 - A14) * 1.3065630198f;

    A00 =  B00 + B01;
    A01 = (B00 - B01) * 0.7071067691f;
    A02 =  B02 + B03;
    A03 = (B02 - B03) * 0.7071067691f;
    A04 =  B04 + B05;
    A05 = (B04 - B05) * 0.7071067691f;
    A06 =  B06 + B07;
    A07 = (B06 - B07) * 0.7071067691f;
    A08 =  B08 + B09;
    A09 = (B08 - B09) * 0.7071067691f;
    A10 =  B10 + B11;
    A11 = (B10 - B11) * 0.7071067691f;
    A12 =  B12 + B13;
    A13 = (B12 - B13) * 0.7071067691f;
    A14 =  B14 + B15;
    A15 = (B14 - B15) * 0.7071067691f;

	V[48] = -A00;
    V[ 0] =  A01;
    V[40] = -A02 - (V[ 8] = A03);
    V[36] = -((V[ 4] = A05 + (V[12] = A07)) + A06);
    V[44] = - A04 - A06 - A07;
    V[ 6] = (V[10] = A11 + (V[14] = A15)) + A13;
    V[38] = (V[34] = -(V[ 2] = A09 + A13 + A15) - A14) + A09 - A10 - A11;
    V[46] = (tmp = -(A12 + A14 + A15)) - A08;
    V[42] = tmp - A10 - A11;                     
   
    A00 = (Sample[ 0] - Sample[31]) * 0.5006030202f;
    A01 = (Sample[ 1] - Sample[30]) * 0.5054709315f;
    A02 = (Sample[ 2] - Sample[29]) * 0.5154473186f;
    A03 = (Sample[ 3] - Sample[28]) * 0.5310425758f;
    A04 = (Sample[ 4] - Sample[27]) * 0.5531039238f;
    A05 = (Sample[ 5] - Sample[26]) * 0.5829349756f;
    A06 = (Sample[ 6] - Sample[25]) * 0.6225041151f;
    A07 = (Sample[ 7] - Sample[24]) * 0.6748083234f;
    A08 = (Sample[ 8] - Sample[23]) * 0.7445362806f;
    A09 = (Sample[ 9] - Sample[22]) * 0.8393496275f;
    A10 = (Sample[10] - Sample[21]) * 0.9725682139f;
    A11 = (Sample[11] - Sample[20]) * 1.1694399118f;
    A12 = (Sample[12] - Sample[19]) * 1.4841645956f;
    A13 = (Sample[13] - Sample[18]) * 2.0577809811f;
    A14 = (Sample[14] - Sample[17]) * 3.4076085091f;
    A15 = (Sample[15] - Sample[16]) *10.1900081635f;

    B00 =  A00 + A15;
    B01 =  A01 + A14;
    B02 =  A02 + A13;
    B03 =  A03 + A12;
    B04 =  A04 + A11;
    B05 =  A05 + A10;
    B06 =  A06 + A09;
    B07 =  A07 + A08;
    B08 = (A00 - A15) * 0.5024192929f;
    B09 = (A01 - A14) * 0.5224986076f;
    B10 = (A02 - A13) * 0.5669440627f;
    B11 = (A03 - A12) * 0.6468217969f;
    B12 = (A04 - A11) * 0.7881546021f;
    B13 = (A05 - A10) * 1.0606776476f;
    B14 = (A06 - A09) * 1.7224471569f;
    B15 = (A07 - A08) * 5.1011486053f;

    A00 =  B00 + B07;
    A01 =  B01 + B06;
    A02 =  B02 + B05;
    A03 =  B03 + B04;
    A04 = (B00 - B07) * 0.5097956061f;
    A05 = (B01 - B06) * 0.6013448834f;
    A06 = (B02 - B05) * 0.8999761939f;
    A07 = (B03 - B04) * 2.5629155636f;
    A08 =  B08 + B15;
    A09 =  B09 + B14;
    A10 =  B10 + B13;
    A11 =  B11 + B12;
    A12 = (B08 - B15) * 0.5097956061f;
    A13 = (B09 - B14) * 0.6013448834f;
    A14 = (B10 - B13) * 0.8999761939f;
    A15 = (B11 - B12) * 2.5629155636f;

    B00 =  A00 + A03;
    B01 =  A01 + A02;
    B02 = (A00 - A03) * 0.5411961079f;
    B03 = (A01 - A02) * 1.3065630198f;
    B04 =  A04 + A07;
    B05 =  A05 + A06;
    B06 = (A04 - A07) * 0.5411961079f;
    B07 = (A05 - A06) * 1.3065630198f;
    B08 =  A08 + A11;
    B09 =  A09 + A10;
    B10 = (A08 - A11) * 0.5411961079f;
    B11 = (A09 - A10) * 1.3065630198f;
    B12 =  A12 + A15;
    B13 =  A13 + A14;
    B14 = (A12 - A15) * 0.5411961079f;
    B15 = (A13 - A14) * 1.3065630198f;

    A00 =  B00 + B01;
    A01 = (B00 - B01) * 0.7071067691f;
    A02 =  B02 + B03;
    A03 = (B02 - B03) * 0.7071067691f;
    A04 =  B04 + B05;
    A05 = (B04 - B05) * 0.7071067691f;
    A06 =  B06 + B07;
    A07 = (B06 - B07) * 0.7071067691f;
    A08 =  B08 + B09;
    A09 = (B08 - B09) * 0.7071067691f;
    A10 =  B10 + B11;
    A11 = (B10 - B11) * 0.7071067691f;
    A12 =  B12 + B13;
    A13 = (B12 - B13) * 0.7071067691f;
    A14 =  B14 + B15;
    A15 = (B14 - B15) * 0.7071067691f;

	// mehrfach verwendete Ausdrcke: A04+A06+A07, A09+A13+A15
    V[ 5] = (V[11] = (V[13] = A07 + (V[15] = A15)) + A11) + A05 + A13;
    V[ 7] = (V[ 9] = A03 + A11 + A15) + A13;
    V[33] = -(V[ 1] = A01 + A09 + A13 + A15) - A14;
    V[35] = -(V[ 3] = A05 + A07 + A09 + A13 + A15) - A06 - A14;
    V[37] = (tmp = -(A10 + A11 + A13 + A14 + A15)) - A05 - A06 - A07;
    V[39] = tmp - A02 - A03;                      // abhngig vom Befehl drber
    V[41] = (tmp += A13 - A12) - A02 - A03;       // abhngig vom Befehl 2 drber
    V[43] = tmp - A04 - A06 - A07;                // abhngig von Befehlen 1 und 3 drber
    V[47] = (tmp = -(A08 + A12 + A14 + A15)) - A00;
    V[45] = tmp - A04 - A06 - A07;                // abhngig vom Befehl drber

    V[32] = -V[ 0];
    V[31] = -V[ 1];
    V[30] = -V[ 2];
    V[29] = -V[ 3];
    V[28] = -V[ 4];
    V[27] = -V[ 5];
    V[26] = -V[ 6];
    V[25] = -V[ 7];
    V[24] = -V[ 8];
    V[23] = -V[ 9];
    V[22] = -V[10];
    V[21] = -V[11];
    V[20] = -V[12];
    V[19] = -V[13];
    V[18] = -V[14];
    V[17] = -V[15];

    V[63] =  V[33];
    V[62] =  V[34];
    V[61] =  V[35];
    V[60] =  V[36];
    V[59] =  V[37];
    V[58] =  V[38];
    V[57] =  V[39];
    V[56] =  V[40];
    V[55] =  V[41];
    V[54] =  V[42];
    V[53] =  V[43];
    V[52] =  V[44];
    V[51] =  V[45];
    V[50] =  V[46];
    V[49] =  V[47];
}

void Vectoring(short *Data, const float *V)
{
	const float *D = Di_opt;
	float Sum0,Sum1;
	float Sum2,Sum3;
	int k,tmp;

	for (k=0; k<8; ++k, D+=64, V+=4)
	{
		// k = 0 -----------------------------------------------------
		Sum0 = V[  0]*D[ 0] + V[ 96]*D[ 1] + V[128]*D[ 2] + V[224]*D[ 3]
			 + V[256]*D[ 4] + V[352]*D[ 5] + V[384]*D[ 6] + V[480]*D[ 7]
			 + V[512]*D[ 8] + V[608]*D[ 9] + V[640]*D[10] + V[736]*D[11]
			 + V[768]*D[12] + V[864]*D[13] + V[896]*D[14] + V[992]*D[15] + 0xFF8000;

		// k = 1 -----------------------------------------------------
		Sum1 = V[  1]*D[16] + V[ 97]*D[17] + V[129]*D[18] + V[225]*D[19]
			 + V[257]*D[20] + V[353]*D[21] + V[385]*D[22] + V[481]*D[23]
			 + V[513]*D[24] + V[609]*D[25] + V[641]*D[26] + V[737]*D[27]
			 + V[769]*D[28] + V[865]*D[29] + V[897]*D[30] + V[993]*D[31] + 0xFF8000;

		// k = 2 -----------------------------------------------------
		Sum2 = V[  2]*D[32] + V[ 98]*D[33] + V[130]*D[34] + V[226]*D[35]
			 + V[258]*D[36] + V[354]*D[37] + V[386]*D[38] + V[482]*D[39]
			 + V[514]*D[40] + V[610]*D[41] + V[642]*D[42] + V[738]*D[43]
			 + V[770]*D[44] + V[866]*D[45] + V[898]*D[46] + V[994]*D[47] + 0xFF8000;

		// k = 3 -----------------------------------------------------
		Sum3 = V[  3]*D[48] + V[ 99]*D[49] + V[131]*D[50] + V[227]*D[51]
			 + V[259]*D[52] + V[355]*D[53] + V[387]*D[54] + V[483]*D[55]
			 + V[515]*D[56] + V[611]*D[57] + V[643]*D[58] + V[739]*D[59]
			 + V[771]*D[60] + V[867]*D[61] + V[899]*D[62] + V[995]*D[63] + 0xFF8000;

		// copy to PCM (ftol mit saettigung, +0xFF8000 gehoert bereits dazu)
		ftol(Sum0, *(Data   ));
		ftol(Sum1, *(Data+=2));
		ftol(Sum2, *(Data+=2));
		ftol(Sum3, *(Data+=2));
		Data += 2;
	}
}

void Synthese_Filter_opt(short *OutData)
{
	int n;
	float *V;
	const float *Y;

	/********* left channel ********/
	memmove(V_L + V_MEM, V_L, 960*sizeof(float));
	V =     V_L + V_MEM;
	Y =     Y_L[0];
	for (n=0; n<36; ++n, OutData+=64, Y+=32)
	{
		V -= 64;
		Calculate_New_V(Y, V);
		Vectoring(OutData, V);
	}
	// set pointer to OutData[1] for filling right channel
	OutData -= 2303; 

	/******** right channel ********/
	memmove(V_R + V_MEM, V_R, 960*sizeof(float));
	V =     V_R + V_MEM;
	Y =     Y_R[0];
	for (n=0; n<36; ++n, OutData+=64, Y+=32)
	{
		V -= 64;
		Calculate_New_V(Y, V);
		Vectoring(OutData, V);
	}
}

